/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.charon3.core.protocol.endpoints;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.charon3.core.attributes.Attribute;
import org.wso2.charon3.core.encoder.JSONDecoder;
import org.wso2.charon3.core.encoder.JSONEncoder;
import org.wso2.charon3.core.exceptions.BadRequestException;
import org.wso2.charon3.core.exceptions.CharonException;
import org.wso2.charon3.core.exceptions.ConflictException;
import org.wso2.charon3.core.exceptions.InternalErrorException;
import org.wso2.charon3.core.exceptions.NotFoundException;
import org.wso2.charon3.core.exceptions.NotImplementedException;
import org.wso2.charon3.core.extensions.UserManager;
import org.wso2.charon3.core.objects.ListedResource;
import org.wso2.charon3.core.objects.User;
import org.wso2.charon3.core.protocol.SCIMResponse;
import org.wso2.charon3.core.protocol.endpoints.AbstractResourceManager;
import org.wso2.charon3.core.schema.SCIMResourceSchemaManager;
import org.wso2.charon3.core.schema.SCIMResourceTypeSchema;
import org.wso2.charon3.core.schema.ServerSideValidator;
import org.wso2.charon3.core.utils.CopyUtil;
import org.wso2.charon3.core.utils.PatchOperationUtil;
import org.wso2.charon3.core.utils.ResourceManagerUtil;
import org.wso2.charon3.core.utils.codeutils.FilterTreeManager;
import org.wso2.charon3.core.utils.codeutils.Node;
import org.wso2.charon3.core.utils.codeutils.PatchOperation;
import org.wso2.charon3.core.utils.codeutils.SearchRequest;

public class UserResourceManager
extends AbstractResourceManager {
    private static final Logger logger = LoggerFactory.getLogger(UserResourceManager.class);

    @Override
    public SCIMResponse get(String id, UserManager userManager, String attributes, String excludeAttributes) {
        JSONEncoder encoder = null;
        try {
            encoder = UserResourceManager.getEncoder();
            SCIMResourceTypeSchema schema = SCIMResourceSchemaManager.getInstance().getUserResourceSchema();
            Map<String, Boolean> requiredAttributes = ResourceManagerUtil.getOnlyRequiredAttributesURIs((SCIMResourceTypeSchema)CopyUtil.deepCopy(schema), attributes, excludeAttributes);
            User user = userManager.getUser(id, requiredAttributes);
            if (user == null) {
                String error = "User not found in the user store.";
                throw new NotFoundException(error);
            }
            ServerSideValidator.validateRetrievedSCIMObject(user, schema, attributes, excludeAttributes);
            String encodedUser = encoder.encodeSCIMObject(user);
            HashMap<String, String> responseHeaders = new HashMap<String, String>();
            responseHeaders.put("Content-Type", "application/scim+json");
            responseHeaders.put("Location", UserResourceManager.getResourceEndpointURL("/Users") + "/" + user.getId());
            return new SCIMResponse(200, encodedUser, responseHeaders);
        }
        catch (NotFoundException e) {
            return AbstractResourceManager.encodeSCIMException(e);
        }
        catch (CharonException e) {
            return AbstractResourceManager.encodeSCIMException(e);
        }
        catch (BadRequestException e) {
            return AbstractResourceManager.encodeSCIMException(e);
        }
    }

    @Override
    public SCIMResponse create(String scimObjectString, UserManager userManager, String attributes, String excludeAttributes) {
        JSONEncoder encoder = null;
        try {
            encoder = UserResourceManager.getEncoder();
            JSONDecoder decoder = UserResourceManager.getDecoder();
            SCIMResourceTypeSchema schema = SCIMResourceSchemaManager.getInstance().getUserResourceSchema();
            User user = decoder.decodeResource(scimObjectString, schema, new User());
            ServerSideValidator.validateCreatedSCIMObject(user, schema);
            Map<String, Boolean> requiredAttributes = ResourceManagerUtil.getOnlyRequiredAttributesURIs((SCIMResourceTypeSchema)CopyUtil.deepCopy(schema), attributes, excludeAttributes);
            if (userManager == null) {
                String error = "Provided user manager handler is null.";
                throw new InternalErrorException(error);
            }
            User createdUser = userManager.createUser(user, requiredAttributes);
            HashMap<String, String> responseHeaders = new HashMap<String, String>();
            if (createdUser == null) {
                String error = "Newly created User resource is null.";
                throw new InternalErrorException(error);
            }
            User copiedUser = (User)CopyUtil.deepCopy(createdUser);
            ServerSideValidator.validateReturnedAttributes(copiedUser, attributes, excludeAttributes);
            String encodedUser = encoder.encodeSCIMObject(copiedUser);
            responseHeaders.put("Location", UserResourceManager.getResourceEndpointURL("/Users") + "/" + createdUser.getId());
            responseHeaders.put("Content-Type", "application/scim+json");
            return new SCIMResponse(201, encodedUser, responseHeaders);
        }
        catch (CharonException e) {
            if (e.getStatus() == -1) {
                e.setStatus(500);
            }
            return AbstractResourceManager.encodeSCIMException(e);
        }
        catch (BadRequestException e) {
            return AbstractResourceManager.encodeSCIMException(e);
        }
        catch (ConflictException e) {
            return AbstractResourceManager.encodeSCIMException(e);
        }
        catch (InternalErrorException e) {
            return AbstractResourceManager.encodeSCIMException(e);
        }
        catch (NotFoundException e) {
            return AbstractResourceManager.encodeSCIMException(e);
        }
    }

    @Override
    public SCIMResponse delete(String id, UserManager userManager) {
        Object encoder = null;
        try {
            if (userManager != null) {
                userManager.deleteUser(id);
                return new SCIMResponse(204, null, null);
            }
            String error = "Provided user manager handler is null.";
            throw new InternalErrorException(error);
        }
        catch (NotFoundException e) {
            return AbstractResourceManager.encodeSCIMException(e);
        }
        catch (CharonException e) {
            return AbstractResourceManager.encodeSCIMException(e);
        }
        catch (InternalErrorException e) {
            return AbstractResourceManager.encodeSCIMException(e);
        }
        catch (NotImplementedException e) {
            return AbstractResourceManager.encodeSCIMException(e);
        }
        catch (BadRequestException e) {
            return AbstractResourceManager.encodeSCIMException(e);
        }
    }

    @Override
    public SCIMResponse listWithGET(UserManager userManager, String filter, int startIndex, int count, String sortBy, String sortOrder, String domainName, String attributes, String excludeAttributes) {
        try {
            if (count < 0) {
                count = 0;
            }
            if (startIndex < 1) {
                startIndex = 1;
            }
            sortOrder = this.resolveSortOrder(sortOrder, sortBy);
            SCIMResourceTypeSchema schema = SCIMResourceSchemaManager.getInstance().getUserResourceSchema();
            Node rootNode = this.buildNode(filter, schema);
            JSONEncoder encoder = UserResourceManager.getEncoder();
            Map<String, Boolean> requiredAttributes = ResourceManagerUtil.getOnlyRequiredAttributesURIs((SCIMResourceTypeSchema)CopyUtil.deepCopy(schema), attributes, excludeAttributes);
            if (userManager != null) {
                List<Object> tempList = userManager.listUsersWithGET(rootNode, startIndex, count, sortBy, sortOrder, domainName, requiredAttributes);
                return this.processUserList(tempList, encoder, schema, attributes, excludeAttributes, startIndex);
            }
            String error = "Provided user manager handler is null.";
            throw new InternalErrorException(error);
        }
        catch (BadRequestException | CharonException | InternalErrorException | NotFoundException | NotImplementedException e) {
            return AbstractResourceManager.encodeSCIMException(e);
        }
        catch (IOException e) {
            String error = "Error in tokenization of the input filter";
            CharonException charonException = new CharonException(error);
            return AbstractResourceManager.encodeSCIMException(charonException);
        }
    }

    @Override
    public SCIMResponse listWithGET(UserManager userManager, String filter, Integer startIndexInt, Integer countInt, String sortBy, String sortOrder, String domainName, String attributes, String excludeAttributes) {
        try {
            Integer count = ResourceManagerUtil.processCount(countInt);
            Integer startIndex = ResourceManagerUtil.processStartIndex(startIndexInt);
            sortOrder = this.resolveSortOrder(sortOrder, sortBy);
            SCIMResourceTypeSchema schema = SCIMResourceSchemaManager.getInstance().getUserResourceSchema();
            Node rootNode = this.buildNode(filter, schema);
            JSONEncoder encoder = UserResourceManager.getEncoder();
            Map<String, Boolean> requiredAttributes = ResourceManagerUtil.getOnlyRequiredAttributesURIs((SCIMResourceTypeSchema)CopyUtil.deepCopy(schema), attributes, excludeAttributes);
            if (userManager != null) {
                List<Object> tempList = userManager.listUsersWithGET(rootNode, startIndex, count, sortBy, sortOrder, domainName, requiredAttributes);
                return this.processUserList(tempList, encoder, schema, attributes, excludeAttributes, startIndex);
            }
            String error = "Provided user manager handler is null.";
            throw new InternalErrorException(error);
        }
        catch (BadRequestException | CharonException | InternalErrorException | NotFoundException | NotImplementedException e) {
            return AbstractResourceManager.encodeSCIMException(e);
        }
        catch (IOException e) {
            String error = "Error in tokenization of the input filter";
            CharonException charonException = new CharonException(error);
            return AbstractResourceManager.encodeSCIMException(charonException);
        }
    }

    private Node buildNode(String filter, SCIMResourceTypeSchema schema) throws BadRequestException, IOException {
        if (filter != null) {
            FilterTreeManager filterTreeManager = new FilterTreeManager(filter, schema);
            return filterTreeManager.buildTree();
        }
        return null;
    }

    private String resolveSortOrder(String sortOrder, String sortBy) throws BadRequestException {
        if (sortOrder != null && !sortOrder.equalsIgnoreCase("ascending") && !sortOrder.equalsIgnoreCase("descending")) {
            String error = " Invalid sortOrder value is specified";
            throw new BadRequestException(error, "invalidValue");
        }
        if (sortOrder == null && sortBy != null) {
            return "ascending";
        }
        return sortOrder;
    }

    private SCIMResponse processUserList(List<Object> tempList, JSONEncoder encoder, SCIMResourceTypeSchema schema, String attributes, String excludeAttributes, int startIndex) throws NotFoundException, CharonException, BadRequestException {
        int totalResults = 0;
        if (tempList == null) {
            tempList = Collections.emptyList();
        }
        try {
            totalResults = (Integer)tempList.get(0);
            tempList.remove(0);
        }
        catch (IndexOutOfBoundsException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Group result list is empty.");
            }
            totalResults = tempList.size();
        }
        catch (ClassCastException ex) {
            logger.debug("Parse error while getting the user result count. Setting result count as: " + tempList.size(), (Throwable)ex);
            totalResults = tempList.size();
        }
        List<Object> returnedUsers = tempList;
        for (Object user : returnedUsers) {
            ServerSideValidator.validateRetrievedSCIMObjectInList((User)user, schema, attributes, excludeAttributes);
        }
        ListedResource listedResource = this.createListedResource(returnedUsers, startIndex, totalResults);
        String encodedListedResource = encoder.encodeSCIMObject(listedResource);
        HashMap<String, String> responseHeaders = new HashMap<String, String>();
        responseHeaders.put("Content-Type", "application/scim+json");
        return new SCIMResponse(200, encodedListedResource, responseHeaders);
    }

    @Override
    public SCIMResponse listWithPOST(String resourceString, UserManager userManager) {
        JSONEncoder encoder = null;
        JSONDecoder decoder = null;
        try {
            encoder = UserResourceManager.getEncoder();
            decoder = UserResourceManager.getDecoder();
            SCIMResourceTypeSchema schema = SCIMResourceSchemaManager.getInstance().getUserResourceSchema();
            SearchRequest searchRequest = decoder.decodeSearchRequestBody(resourceString, schema);
            searchRequest.setCount(ResourceManagerUtil.processCount(searchRequest.getCountStr()));
            searchRequest.setStartIndex(ResourceManagerUtil.processStartIndex(searchRequest.getStartIndexStr()));
            if (searchRequest.getSortOder() != null && !searchRequest.getSortOder().equalsIgnoreCase("ascending") && !searchRequest.getSortOder().equalsIgnoreCase("descending")) {
                String error = " Invalid sortOrder value is specified";
                throw new BadRequestException(error, "invalidValue");
            }
            if (searchRequest.getSortOder() == null && searchRequest.getSortBy() != null) {
                searchRequest.setSortOder("ascending");
            }
            Map<String, Boolean> requiredAttributes = ResourceManagerUtil.getOnlyRequiredAttributesURIs((SCIMResourceTypeSchema)CopyUtil.deepCopy(schema), searchRequest.getAttributesAsString(), searchRequest.getExcludedAttributesAsString());
            int totalResults = 0;
            if (userManager != null) {
                List<Object> tempList = userManager.listUsersWithPost(searchRequest, requiredAttributes);
                totalResults = (Integer)tempList.get(0);
                tempList.remove(0);
                List<Object> returnedUsers = tempList;
                for (Object user : returnedUsers) {
                    ServerSideValidator.validateRetrievedSCIMObjectInList((User)user, schema, searchRequest.getAttributesAsString(), searchRequest.getExcludedAttributesAsString());
                }
                ListedResource listedResource = this.createListedResource(returnedUsers, searchRequest.getStartIndex(), totalResults);
                String encodedListedResource = encoder.encodeSCIMObject(listedResource);
                HashMap<String, String> responseHeaders = new HashMap<String, String>();
                responseHeaders.put("Content-Type", "application/scim+json");
                return new SCIMResponse(200, encodedListedResource, responseHeaders);
            }
            String error = "Provided user manager handler is null.";
            throw new InternalErrorException(error);
        }
        catch (CharonException e) {
            return AbstractResourceManager.encodeSCIMException(e);
        }
        catch (NotFoundException e) {
            return AbstractResourceManager.encodeSCIMException(e);
        }
        catch (InternalErrorException e) {
            return AbstractResourceManager.encodeSCIMException(e);
        }
        catch (BadRequestException e) {
            return AbstractResourceManager.encodeSCIMException(e);
        }
        catch (NotImplementedException e) {
            return AbstractResourceManager.encodeSCIMException(e);
        }
    }

    @Override
    public SCIMResponse updateWithPUT(String existingId, String scimObjectString, UserManager userManager, String attributes, String excludeAttributes) {
        JSONEncoder encoder = null;
        JSONDecoder decoder = null;
        try {
            User oldUser;
            encoder = UserResourceManager.getEncoder();
            decoder = UserResourceManager.getDecoder();
            SCIMResourceTypeSchema schema = SCIMResourceSchemaManager.getInstance().getUserResourceSchema();
            Map<String, Boolean> requiredAttributes = ResourceManagerUtil.getOnlyRequiredAttributesURIs((SCIMResourceTypeSchema)CopyUtil.deepCopy(schema), attributes, excludeAttributes);
            User user = decoder.decodeResource(scimObjectString, schema, new User());
            User updatedUser = null;
            if (userManager != null) {
                oldUser = userManager.getUser(existingId, ResourceManagerUtil.getAllAttributeURIs(schema));
                if (oldUser == null) {
                    String error = "No user exists with the given id: " + existingId;
                    throw new NotFoundException(error);
                }
            } else {
                String error = "Provided user manager handler is null.";
                throw new InternalErrorException(error);
            }
            User validatedUser = (User)ServerSideValidator.validateUpdatedSCIMObject(oldUser, user, schema);
            updatedUser = userManager.updateUser(validatedUser, requiredAttributes);
            HashMap<String, String> httpHeaders = new HashMap<String, String>();
            if (updatedUser == null) {
                String error = "Updated User resource is null.";
                throw new CharonException(error);
            }
            User copiedUser = (User)CopyUtil.deepCopy(updatedUser);
            ServerSideValidator.validateReturnedAttributes(copiedUser, attributes, excludeAttributes);
            String encodedUser = encoder.encodeSCIMObject(copiedUser);
            httpHeaders.put("Location", UserResourceManager.getResourceEndpointURL("/Users") + "/" + updatedUser.getId());
            httpHeaders.put("Content-Type", "application/scim+json");
            return new SCIMResponse(200, encodedUser, httpHeaders);
        }
        catch (NotFoundException e) {
            return AbstractResourceManager.encodeSCIMException(e);
        }
        catch (BadRequestException e) {
            return AbstractResourceManager.encodeSCIMException(e);
        }
        catch (CharonException e) {
            return AbstractResourceManager.encodeSCIMException(e);
        }
        catch (InternalErrorException e) {
            return AbstractResourceManager.encodeSCIMException(e);
        }
        catch (NotImplementedException e) {
            return AbstractResourceManager.encodeSCIMException(e);
        }
    }

    @Override
    public SCIMResponse updateWithPATCH(String existingId, String scimObjectString, UserManager userManager, String attributes, String excludeAttributes) {
        try {
            if (userManager == null) {
                String error = "Provided user manager handler is null.";
                throw new InternalErrorException(error);
            }
            JSONDecoder decoder = UserResourceManager.getDecoder();
            ArrayList<PatchOperation> opList = decoder.decodeRequest(scimObjectString);
            SCIMResourceTypeSchema schema = SCIMResourceSchemaManager.getInstance().getUserResourceSchema();
            User oldUser = userManager.getUser(existingId, ResourceManagerUtil.getAllAttributeURIs(schema));
            if (oldUser == null) {
                throw new NotFoundException("No user with the id : " + existingId + " in the user store.");
            }
            User copyOfOldUser = (User)CopyUtil.deepCopy(oldUser);
            User originalUser = (User)CopyUtil.deepCopy(copyOfOldUser);
            User newUser = null;
            for (PatchOperation operation : opList) {
                if (operation.getOperation().equals("add")) {
                    if (newUser == null) {
                        newUser = (User)PatchOperationUtil.doPatchAdd(operation, UserResourceManager.getDecoder(), oldUser, copyOfOldUser, schema);
                        copyOfOldUser = (User)CopyUtil.deepCopy(newUser);
                        continue;
                    }
                    newUser = (User)PatchOperationUtil.doPatchAdd(operation, UserResourceManager.getDecoder(), newUser, copyOfOldUser, schema);
                    copyOfOldUser = (User)CopyUtil.deepCopy(newUser);
                    continue;
                }
                if (operation.getOperation().equals("remove")) {
                    if (newUser == null) {
                        newUser = (User)PatchOperationUtil.doPatchRemove(operation, oldUser, copyOfOldUser, schema);
                        copyOfOldUser = (User)CopyUtil.deepCopy(newUser);
                        continue;
                    }
                    newUser = (User)PatchOperationUtil.doPatchRemove(operation, newUser, copyOfOldUser, schema);
                    copyOfOldUser = (User)CopyUtil.deepCopy(newUser);
                    continue;
                }
                if (operation.getOperation().equals("replace")) {
                    if (newUser == null) {
                        newUser = (User)PatchOperationUtil.doPatchReplace(operation, UserResourceManager.getDecoder(), oldUser, copyOfOldUser, schema);
                        copyOfOldUser = (User)CopyUtil.deepCopy(newUser);
                        continue;
                    }
                    newUser = (User)PatchOperationUtil.doPatchReplace(operation, UserResourceManager.getDecoder(), newUser, copyOfOldUser, schema);
                    copyOfOldUser = (User)CopyUtil.deepCopy(newUser);
                    continue;
                }
                throw new BadRequestException("Unknown operation.", "invalidSyntax");
            }
            Map<String, Boolean> requiredAttributes = ResourceManagerUtil.getOnlyRequiredAttributesURIs((SCIMResourceTypeSchema)CopyUtil.deepCopy(schema), attributes, excludeAttributes);
            User validatedUser = (User)ServerSideValidator.validateUpdatedSCIMObject(originalUser, newUser, schema);
            newUser = userManager.updateUser(validatedUser, requiredAttributes);
            HashMap<String, String> httpHeaders = new HashMap<String, String>();
            if (newUser == null) {
                String error = "Updated User resource is null.";
                throw new CharonException(error);
            }
            User copiedUser = (User)CopyUtil.deepCopy(newUser);
            ServerSideValidator.validateReturnedAttributes(copiedUser, attributes, excludeAttributes);
            String encodedUser = UserResourceManager.getEncoder().encodeSCIMObject(copiedUser);
            httpHeaders.put("Location", UserResourceManager.getResourceEndpointURL("/Users") + "/" + newUser.getId());
            httpHeaders.put("Content-Type", "application/scim+json");
            return new SCIMResponse(200, encodedUser, httpHeaders);
        }
        catch (NotFoundException e) {
            return AbstractResourceManager.encodeSCIMException(e);
        }
        catch (BadRequestException e) {
            return AbstractResourceManager.encodeSCIMException(e);
        }
        catch (NotImplementedException e) {
            return AbstractResourceManager.encodeSCIMException(e);
        }
        catch (CharonException e) {
            return AbstractResourceManager.encodeSCIMException(e);
        }
        catch (InternalErrorException e) {
            return AbstractResourceManager.encodeSCIMException(e);
        }
        catch (RuntimeException e) {
            CharonException e1 = new CharonException("Error in performing the patch operation on user resource.", e);
            return AbstractResourceManager.encodeSCIMException(e1);
        }
    }

    protected ListedResource createListedResource(List<Object> users, int startIndex, int totalResults) throws CharonException, NotFoundException {
        ListedResource listedResource = new ListedResource();
        listedResource.setSchema("urn:ietf:params:scim:api:messages:2.0:ListResponse");
        listedResource.setTotalResults(totalResults);
        listedResource.setStartIndex(startIndex);
        listedResource.setItemsPerPage(users.size());
        for (Object user : users) {
            Map<String, Attribute> userAttributes = ((User)user).getAttributeList();
            listedResource.setResources(userAttributes);
        }
        return listedResource;
    }
}

