/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.charon3.core.objects;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.wso2.charon3.core.attributes.Attribute;
import org.wso2.charon3.core.attributes.ComplexAttribute;
import org.wso2.charon3.core.attributes.DefaultAttributeFactory;
import org.wso2.charon3.core.attributes.MultiValuedAttribute;
import org.wso2.charon3.core.attributes.SimpleAttribute;
import org.wso2.charon3.core.exceptions.BadRequestException;
import org.wso2.charon3.core.exceptions.CharonException;
import org.wso2.charon3.core.objects.AbstractSCIMObject;
import org.wso2.charon3.core.schema.SCIMResourceSchemaManager;
import org.wso2.charon3.core.schema.SCIMResourceTypeSchema;
import org.wso2.charon3.core.schema.SCIMSchemaDefinitions;
import org.wso2.charon3.core.utils.LambdaExceptionUtils;

public class Group
extends AbstractSCIMObject {
    private static final long serialVersionUID = 6106269076155338045L;

    public String getDisplayName() {
        if (this.isAttributeExist("displayName")) {
            return LambdaExceptionUtils.rethrowSupplier(() -> ((SimpleAttribute)this.attributeList.get("displayName")).getStringValue()).get();
        }
        return null;
    }

    public void setDisplayName(String displayName) throws CharonException, BadRequestException {
        if (this.isAttributeExist("displayName")) {
            ((SimpleAttribute)this.attributeList.get("displayName")).updateValue(displayName);
        } else {
            SimpleAttribute displayAttribute = new SimpleAttribute("displayName", displayName);
            displayAttribute = (SimpleAttribute)DefaultAttributeFactory.createAttribute(SCIMSchemaDefinitions.SCIMGroupSchemaDefinition.DISPLAY_NAME, displayAttribute);
            this.attributeList.put("displayName", displayAttribute);
        }
    }

    public void replaceDisplayName(String displayname) {
        this.replaceSimpleAttribute(SCIMSchemaDefinitions.SCIMGroupSchemaDefinition.DISPLAY_NAME, displayname);
    }

    public List<Object> getMembers() {
        ArrayList<Object> memberList = new ArrayList<Object>();
        if (this.isAttributeExist("members")) {
            MultiValuedAttribute members = (MultiValuedAttribute)this.attributeList.get("members");
            List<Attribute> subValuesList = members.getAttributeValues();
            for (Attribute subValue : subValuesList) {
                ComplexAttribute complexAttribute = (ComplexAttribute)subValue;
                Map<String, Attribute> subAttributesList = complexAttribute.getSubAttributesList();
                if (subAttributesList == null || !subAttributesList.containsKey("value")) continue;
                memberList.add(((SimpleAttribute)subAttributesList.get("value")).getValue());
            }
            return memberList;
        }
        return null;
    }

    public List<String> getMembersWithDisplayName() {
        MultiValuedAttribute members;
        List<Attribute> values;
        ArrayList<String> displayNames = new ArrayList<String>();
        if (this.isAttributeExist("members") && (values = (members = (MultiValuedAttribute)this.attributeList.get("members")).getAttributeValues()) != null) {
            List<Attribute> subValuesList = members.getAttributeValues();
            for (Attribute subValue : subValuesList) {
                ComplexAttribute complexAttribute = (ComplexAttribute)subValue;
                Map<String, Attribute> subAttributesList = complexAttribute.getSubAttributesList();
                if (subAttributesList == null || !subAttributesList.containsKey("display")) continue;
                displayNames.add((String)((SimpleAttribute)subAttributesList.get("display")).getValue());
            }
            return displayNames;
        }
        return displayNames;
    }

    public void setMember(String value, String display) throws BadRequestException, CharonException {
        this.setMember(value, display, null, null);
    }

    public void setMember(String value, String display, String ref, String type) throws BadRequestException, CharonException {
        MultiValuedAttribute members;
        if (!this.isAttributeExist("members")) {
            members = new MultiValuedAttribute("members");
            DefaultAttributeFactory.createAttribute(SCIMSchemaDefinitions.SCIMGroupSchemaDefinition.MEMBERS, members);
            this.setAttribute(members);
        }
        members = (MultiValuedAttribute)this.getAttribute("members");
        ComplexAttribute complexAttribute = this.setMemberCommon(value, display, ref, type);
        members.setAttributeValue(complexAttribute);
    }

    private ComplexAttribute setMemberCommon(String userId, String userName, String ref, String type) throws BadRequestException, CharonException {
        ComplexAttribute complexAttribute = new ComplexAttribute();
        complexAttribute.setName("members_" + userId + "default");
        SimpleAttribute valueSimpleAttribute = new SimpleAttribute("value", userId);
        DefaultAttributeFactory.createAttribute(SCIMSchemaDefinitions.SCIMGroupSchemaDefinition.VALUE, valueSimpleAttribute);
        SimpleAttribute displaySimpleAttribute = new SimpleAttribute("display", userName);
        DefaultAttributeFactory.createAttribute(SCIMSchemaDefinitions.SCIMGroupSchemaDefinition.DISPLAY, displaySimpleAttribute);
        SimpleAttribute refSimpleAttribute = new SimpleAttribute("$ref", ref);
        DefaultAttributeFactory.createAttribute(SCIMSchemaDefinitions.SCIMGroupSchemaDefinition.REF, refSimpleAttribute);
        SimpleAttribute typeSimpleAttribute = new SimpleAttribute("type", type);
        DefaultAttributeFactory.createAttribute(SCIMSchemaDefinitions.SCIMGroupSchemaDefinition.TYPE, typeSimpleAttribute);
        complexAttribute.setSubAttribute(valueSimpleAttribute);
        complexAttribute.setSubAttribute(displaySimpleAttribute);
        complexAttribute.setSubAttribute(refSimpleAttribute);
        complexAttribute.setSubAttribute(typeSimpleAttribute);
        DefaultAttributeFactory.createAttribute(SCIMSchemaDefinitions.SCIMGroupSchemaDefinition.MEMBERS, complexAttribute);
        return complexAttribute;
    }

    public void setSchemas() {
        SCIMResourceTypeSchema schema = SCIMResourceSchemaManager.getInstance().getGroupResourceSchema();
        List<String> schemasList = schema.getSchemasList();
        for (String scheme : schemasList) {
            this.setSchema(scheme);
        }
    }
}

