/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.charon3.core.objects;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.TimeZone;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.wso2.charon3.core.attributes.Attribute;
import org.wso2.charon3.core.attributes.ComplexAttribute;
import org.wso2.charon3.core.attributes.DefaultAttributeFactory;
import org.wso2.charon3.core.attributes.MultiValuedAttribute;
import org.wso2.charon3.core.attributes.SimpleAttribute;
import org.wso2.charon3.core.objects.AbstractSCIMObject;
import org.wso2.charon3.core.objects.plainobjects.MultiValuedComplexType;
import org.wso2.charon3.core.schema.SCIMAttributeSchema;
import org.wso2.charon3.core.schema.SCIMDefinitions;
import org.wso2.charon3.core.schema.SCIMSchemaDefinitions;
import org.wso2.charon3.core.utils.LambdaExceptionUtils;

public abstract class ScimAttributeAware {
    public String getId() {
        SCIMAttributeSchema idDefinition = SCIMSchemaDefinitions.ID;
        return this.getSimpleAttribute(idDefinition).map(LambdaExceptionUtils.rethrowFunction(SimpleAttribute::getStringValue)).orElse(null);
    }

    public void replaceId(String id) {
        SCIMAttributeSchema externalIdDefinition = SCIMSchemaDefinitions.ID;
        this.replaceSimpleAttribute(externalIdDefinition, id);
    }

    public String getExternalId() {
        SCIMAttributeSchema idDefinition = SCIMSchemaDefinitions.EXTERNAL_ID;
        return this.getSimpleAttribute(idDefinition).map(LambdaExceptionUtils.rethrowFunction(SimpleAttribute::getStringValue)).orElse(null);
    }

    public void replaceExternalId(String externalId) {
        SCIMAttributeSchema externalIdDefinition = SCIMSchemaDefinitions.EXTERNAL_ID;
        this.replaceSimpleAttribute(externalIdDefinition, externalId);
    }

    public String getResourceType() {
        SCIMAttributeSchema metaDefinition = SCIMSchemaDefinitions.META;
        SCIMAttributeSchema resourceTypeDefinition = SCIMSchemaDefinitions.RESOURCE_TYPE;
        return this.getComplexAttribute(metaDefinition).map(meta -> this.getSimpleAttribute(resourceTypeDefinition, (ComplexAttribute)meta).map(LambdaExceptionUtils.rethrowFunction(SimpleAttribute::getStringValue)).orElse(null)).orElse(null);
    }

    public void replaceResourceType(String resourceType) {
        SCIMAttributeSchema metaDefinition = SCIMSchemaDefinitions.META;
        SCIMAttributeSchema resourceTypeDefinition = SCIMSchemaDefinitions.RESOURCE_TYPE;
        ComplexAttribute meta = this.getOrCrateComplexAttribute(metaDefinition);
        this.getSetSubAttributeConsumer(meta).accept(resourceTypeDefinition, () -> resourceType);
    }

    public String getLocation() {
        SCIMAttributeSchema metaDefinition = SCIMSchemaDefinitions.META;
        SCIMAttributeSchema resourceTypeDefinition = SCIMSchemaDefinitions.LOCATION;
        return this.getComplexAttribute(metaDefinition).map(meta -> this.getSimpleAttribute(resourceTypeDefinition, (ComplexAttribute)meta).map(LambdaExceptionUtils.rethrowFunction(SimpleAttribute::getStringValue)).orElse(null)).orElse(null);
    }

    public void replaceLocation(String resourceType) {
        SCIMAttributeSchema metaDefinition = SCIMSchemaDefinitions.META;
        SCIMAttributeSchema locationDefinition = SCIMSchemaDefinitions.LOCATION;
        ComplexAttribute meta = this.getOrCrateComplexAttribute(metaDefinition);
        this.getSetSubAttributeConsumer(meta).accept(locationDefinition, () -> resourceType);
    }

    public Long getCreatedLong() {
        SCIMAttributeSchema metaDefinition = SCIMSchemaDefinitions.META;
        SCIMAttributeSchema resourceTypeDefinition = SCIMSchemaDefinitions.CREATED;
        return this.getComplexAttribute(metaDefinition).map(meta -> this.getSimpleAttribute(resourceTypeDefinition, (ComplexAttribute)meta).map(LambdaExceptionUtils.rethrowFunction(simpleAttribute -> simpleAttribute.getDateValue().getTime())).orElse(null)).orElse(null);
    }

    public LocalDateTime getCreatedDateTime() {
        SCIMAttributeSchema metaDefinition = SCIMSchemaDefinitions.META;
        SCIMAttributeSchema createdDefinition = SCIMSchemaDefinitions.CREATED;
        return this.getComplexAttribute(metaDefinition).map(meta -> this.getSimpleAttribute(createdDefinition, (ComplexAttribute)meta).map(LambdaExceptionUtils.rethrowFunction(SimpleAttribute::getInstantValue)).map(instant -> LocalDateTime.ofInstant(instant, TimeZone.getDefault().toZoneId())).orElse(null)).orElse(null);
    }

    public Instant getCreatedInstant() {
        SCIMAttributeSchema metaDefinition = SCIMSchemaDefinitions.META;
        SCIMAttributeSchema createdDefinition = SCIMSchemaDefinitions.CREATED;
        return this.getComplexAttribute(metaDefinition).map(meta -> this.getSimpleAttribute(createdDefinition, (ComplexAttribute)meta).map(LambdaExceptionUtils.rethrowFunction(SimpleAttribute::getInstantValue)).orElse(null)).orElse(null);
    }

    public void replaceCreated(LocalDateTime createdDate) {
        SCIMAttributeSchema metaDefinition = SCIMSchemaDefinitions.META;
        SCIMAttributeSchema createdDefinition = SCIMSchemaDefinitions.CREATED;
        ComplexAttribute meta = this.getOrCrateComplexAttribute(metaDefinition);
        this.getSetSubAttributeConsumer(meta).accept(createdDefinition, () -> createdDate.atZone(ZoneId.systemDefault()).toInstant());
    }

    public void replaceCreated(Instant createdDate) {
        SCIMAttributeSchema metaDefinition = SCIMSchemaDefinitions.META;
        SCIMAttributeSchema createdDefinition = SCIMSchemaDefinitions.CREATED;
        ComplexAttribute meta = this.getOrCrateComplexAttribute(metaDefinition);
        this.getSetSubAttributeConsumer(meta).accept(createdDefinition, () -> createdDate);
    }

    public void replaceCreated(Long createdTimestamp) {
        SCIMAttributeSchema metaDefinition = SCIMSchemaDefinitions.META;
        SCIMAttributeSchema createdDefinition = SCIMSchemaDefinitions.CREATED;
        ComplexAttribute meta = this.getOrCrateComplexAttribute(metaDefinition);
        Instant created = Instant.ofEpochMilli(createdTimestamp);
        this.getSetSubAttributeConsumer(meta).accept(createdDefinition, () -> created);
    }

    public LocalDateTime getLastModifiedDateTime() {
        SCIMAttributeSchema metaDefinition = SCIMSchemaDefinitions.META;
        SCIMAttributeSchema lastModifiedDefinition = SCIMSchemaDefinitions.LAST_MODIFIED;
        return this.getComplexAttribute(metaDefinition).map(meta -> this.getSimpleAttribute(lastModifiedDefinition, (ComplexAttribute)meta).map(LambdaExceptionUtils.rethrowFunction(SimpleAttribute::getInstantValue)).map(instant -> LocalDateTime.ofInstant(instant, TimeZone.getDefault().toZoneId())).orElse(null)).orElse(null);
    }

    public Instant getLastModifiedInstant() {
        SCIMAttributeSchema metaDefinition = SCIMSchemaDefinitions.META;
        SCIMAttributeSchema lastModifiedDefinition = SCIMSchemaDefinitions.LAST_MODIFIED;
        return this.getComplexAttribute(metaDefinition).map(meta -> this.getSimpleAttribute(lastModifiedDefinition, (ComplexAttribute)meta).map(LambdaExceptionUtils.rethrowFunction(SimpleAttribute::getInstantValue)).orElse(null)).orElse(null);
    }

    public Long getLastModifiedLong() {
        SCIMAttributeSchema metaDefinition = SCIMSchemaDefinitions.META;
        SCIMAttributeSchema lastModifiedDefinition = SCIMSchemaDefinitions.LAST_MODIFIED;
        return this.getComplexAttribute(metaDefinition).map(meta -> this.getSimpleAttribute(lastModifiedDefinition, (ComplexAttribute)meta).map(LambdaExceptionUtils.rethrowFunction(simpleAttribute -> simpleAttribute.getInstantValue().toEpochMilli())).orElse(null)).orElse(null);
    }

    public void replaceLastModified(LocalDateTime lastModifiedDateTime) {
        SCIMAttributeSchema metaDefinition = SCIMSchemaDefinitions.META;
        SCIMAttributeSchema lastModifiedDefinition = SCIMSchemaDefinitions.LAST_MODIFIED;
        ComplexAttribute meta = this.getOrCrateComplexAttribute(metaDefinition);
        this.getSetSubAttributeConsumer(meta).accept(lastModifiedDefinition, () -> lastModifiedDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public void replaceLastModified(Instant lastModifiedInstant) {
        SCIMAttributeSchema metaDefinition = SCIMSchemaDefinitions.META;
        SCIMAttributeSchema lastModifiedDefinition = SCIMSchemaDefinitions.LAST_MODIFIED;
        ComplexAttribute meta = this.getOrCrateComplexAttribute(metaDefinition);
        this.getSetSubAttributeConsumer(meta).accept(lastModifiedDefinition, () -> lastModifiedInstant);
    }

    public void replaceLastModified(Long lastModifiedTimestamp) {
        SCIMAttributeSchema metaDefinition = SCIMSchemaDefinitions.META;
        SCIMAttributeSchema lastModifiedDefinition = SCIMSchemaDefinitions.LAST_MODIFIED;
        ComplexAttribute meta = this.getOrCrateComplexAttribute(metaDefinition);
        this.getSetSubAttributeConsumer(meta).accept(lastModifiedDefinition, () -> Instant.ofEpochMilli(lastModifiedTimestamp));
    }

    public Optional<SimpleAttribute> getSimpleAttribute(SCIMAttributeSchema scimAttributeSchema) {
        if (scimAttributeSchema == null) {
            return Optional.empty();
        }
        return Optional.ofNullable((SimpleAttribute)this.getResource().getAttribute(scimAttributeSchema.getName()));
    }

    public Optional<SimpleAttribute> getSimpleAttribute(SCIMAttributeSchema scimAttributeSchema, ComplexAttribute complexAttribute) {
        if (scimAttributeSchema == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(LambdaExceptionUtils.rethrowSupplier(() -> (SimpleAttribute)complexAttribute.getSubAttribute(scimAttributeSchema.getName())).get());
    }

    public Optional<String> getSimpleAttributeValue(SCIMAttributeSchema scimAttributeSchema, ComplexAttribute complexAttribute) {
        if (scimAttributeSchema == null || complexAttribute == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(LambdaExceptionUtils.rethrowSupplier(() -> (SimpleAttribute)complexAttribute.getSubAttribute(scimAttributeSchema.getName())).get()).map(simpleAttribute -> LambdaExceptionUtils.rethrowFunction(sa -> {
            if (SCIMDefinitions.DataType.REFERENCE.equals((Object)scimAttributeSchema.getType())) {
                return (String)simpleAttribute.getValue();
            }
            return simpleAttribute.getStringValue();
        }).apply(simpleAttribute)).map(s -> s.trim().isEmpty() ? null : s);
    }

    public Optional<ComplexAttribute> getComplexAttribute(SCIMAttributeSchema scimAttributeSchema) {
        return Optional.ofNullable((ComplexAttribute)this.getResource().getAttribute(scimAttributeSchema.getName()));
    }

    public ComplexAttribute getOrCrateComplexAttribute(SCIMAttributeSchema scimAttributeSchema) {
        Optional<ComplexAttribute> attribute = Optional.ofNullable((ComplexAttribute)this.getResource().getAttribute(scimAttributeSchema.getName()));
        if (attribute.isPresent()) {
            return attribute.get();
        }
        ComplexAttribute complexAttribute = new ComplexAttribute(scimAttributeSchema.getName());
        LambdaExceptionUtils.rethrowBiConsumer(DefaultAttributeFactory::createAttribute).accept(scimAttributeSchema, complexAttribute);
        this.getResource().setAttribute(complexAttribute);
        return complexAttribute;
    }

    public Optional<MultiValuedAttribute> getMultiValuedAttribute(SCIMAttributeSchema scimAttributeSchema) {
        return Optional.ofNullable((MultiValuedAttribute)this.getResource().getAttribute(scimAttributeSchema.getName()));
    }

    public void replaceSimpleAttribute(SCIMAttributeSchema scimAttributeSchema, Object value) {
        if (scimAttributeSchema == null || value == null) {
            if (scimAttributeSchema != null) {
                this.getResource().deleteAttribute(scimAttributeSchema.getName());
            }
            return;
        }
        SimpleAttribute simpleAttribute = new SimpleAttribute(scimAttributeSchema.getName(), value);
        LambdaExceptionUtils.rethrowBiConsumer(DefaultAttributeFactory::createAttribute).accept(scimAttributeSchema, simpleAttribute);
        this.getResource().deleteAttribute(scimAttributeSchema.getName());
        this.getResource().setAttribute(simpleAttribute);
    }

    protected void addMultivaluedComplexAtribute(List<MultiValuedComplexType> multiValuedComplexTypeList, SCIMAttributeSchema complexDefinition, SCIMAttributeSchema valueDefinition, SCIMAttributeSchema displayDefinition, SCIMAttributeSchema typeDefinition, SCIMAttributeSchema primaryDefinition, SCIMAttributeSchema referenceDefinition) {
        this.getResource().deleteAttribute(complexDefinition.getName());
        MultiValuedAttribute multiValuedList = new MultiValuedAttribute(complexDefinition.getName());
        LambdaExceptionUtils.rethrowBiConsumer(DefaultAttributeFactory::createAttribute).accept(complexDefinition, multiValuedList);
        multiValuedComplexTypeList.forEach(complexObject -> {
            ComplexAttribute complexAttribute = new ComplexAttribute(complexDefinition.getName());
            BiConsumer<SCIMAttributeSchema, Supplier<Object>> setSubAttribute = this.getSetSubAttributeConsumer(complexAttribute);
            setSubAttribute.accept(valueDefinition, complexObject::getValue);
            setSubAttribute.accept(displayDefinition, complexObject::getDisplay);
            setSubAttribute.accept(typeDefinition, complexObject::getType);
            setSubAttribute.accept(primaryDefinition, () -> complexObject.isPrimary() ? Boolean.valueOf(true) : null);
            setSubAttribute.accept(referenceDefinition, complexObject::getReference);
            multiValuedList.setAttributeValue(complexAttribute);
        });
        this.getResource().setAttribute(multiValuedList);
    }

    protected BiConsumer<SCIMAttributeSchema, Supplier<Object>> getSetSubAttributeConsumer(ComplexAttribute complexAttribute) {
        return (scimAttributeSchema, objectSupplier) -> Optional.ofNullable(scimAttributeSchema).ifPresent(arg_0 -> ScimAttributeAware.lambda$null$32((Supplier)objectSupplier, complexAttribute, arg_0));
    }

    protected Optional<List<MultiValuedComplexType>> getMultivaluedComplexType(SCIMAttributeSchema multiValuedDefinition, SCIMAttributeSchema valueDefinition, SCIMAttributeSchema displayDefinition, SCIMAttributeSchema typeDefinition, SCIMAttributeSchema primaryDefinition, SCIMAttributeSchema referenceDefinition) {
        return this.getMultiValuedAttribute(multiValuedDefinition).map(multiValuedAttribute -> {
            ArrayList<MultiValuedComplexType> multiValuedComplexTypes = new ArrayList<MultiValuedComplexType>();
            for (Attribute attributeValue : multiValuedAttribute.getAttributeValues()) {
                ComplexAttribute complexAttribute = (ComplexAttribute)attributeValue;
                MultiValuedComplexType multiValuedComplexType = new MultiValuedComplexType();
                this.getSimpleAttributeValue(valueDefinition, complexAttribute).ifPresent(multiValuedComplexType::setValue);
                this.getSimpleAttributeValue(displayDefinition, complexAttribute).ifPresent(multiValuedComplexType::setDisplay);
                this.getSimpleAttributeValue(typeDefinition, complexAttribute).ifPresent(multiValuedComplexType::setType);
                this.getSimpleAttribute(primaryDefinition, complexAttribute).map(LambdaExceptionUtils.rethrowFunction(SimpleAttribute::getBooleanValue)).ifPresent(multiValuedComplexType::setPrimary);
                this.getSimpleAttribute(referenceDefinition, complexAttribute).map(simpleAttribute -> (String)simpleAttribute.getValue()).ifPresent(multiValuedComplexType::setReference);
                if (this.isBlank(multiValuedComplexType.getValue()) && this.isBlank(multiValuedComplexType.getDisplay()) && this.isBlank(multiValuedComplexType.getType()) && this.isBlank(multiValuedComplexType.getReference()) && !multiValuedComplexType.isPrimary()) continue;
                multiValuedComplexTypes.add(multiValuedComplexType);
            }
            return multiValuedComplexTypes;
        });
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!ScimAttributeAware.class.isAssignableFrom(object.getClass())) {
            return false;
        }
        ScimAttributeAware scimAttributeAware = (ScimAttributeAware)object;
        if (!this.getResource().getSchemaList().equals(scimAttributeAware.getResource().getSchemaList())) {
            return false;
        }
        if (!this.getResource().getAttributeList().keySet().equals(scimAttributeAware.getResource().getAttributeList().keySet())) {
            return false;
        }
        return this.getResource().getAttributeList().keySet().stream().allMatch(attributeName -> ScimAttributeAware.attributesEquals(this.getResource().getAttribute((String)attributeName), scimAttributeAware.getResource().getAttribute((String)attributeName)));
    }

    public static boolean attributesEquals(Attribute attribute, Attribute attributeOther) {
        if (!attribute.getClass().equals(attributeOther.getClass())) {
            return false;
        }
        if (!ScimAttributeAware.attributeMetaEquals(attribute, attributeOther)) {
            return false;
        }
        if (attribute instanceof SimpleAttribute && attributeOther instanceof SimpleAttribute) {
            return ScimAttributeAware.simpleAttributeEquals((SimpleAttribute)attribute, (SimpleAttribute)attributeOther);
        }
        if (attribute instanceof MultiValuedAttribute && attributeOther instanceof MultiValuedAttribute) {
            return ScimAttributeAware.multiValuedAttributeEquals((MultiValuedAttribute)attribute, (MultiValuedAttribute)attributeOther);
        }
        if (attribute instanceof ComplexAttribute && attributeOther instanceof ComplexAttribute) {
            return ScimAttributeAware.complexAttributeEquals((ComplexAttribute)attribute, (ComplexAttribute)attributeOther);
        }
        return false;
    }

    public static boolean attributeMetaEquals(Attribute attribute, Attribute attributeOther) {
        if (!attribute.getMultiValued().equals(attributeOther.getMultiValued())) {
            return false;
        }
        if (!attribute.getCaseExact().equals(attributeOther.getCaseExact())) {
            return false;
        }
        if (!attribute.getRequired().equals(attributeOther.getRequired())) {
            return false;
        }
        if (!attribute.getMutability().equals((Object)attributeOther.getMutability())) {
            return false;
        }
        if (!attribute.getReturned().equals((Object)attributeOther.getReturned())) {
            return false;
        }
        if (!attribute.getUniqueness().equals((Object)attributeOther.getUniqueness())) {
            return false;
        }
        if (!attribute.getURI().equals(attributeOther.getURI())) {
            return false;
        }
        return attribute.getType().equals((Object)attributeOther.getType());
    }

    public static boolean simpleAttributeEquals(SimpleAttribute attribute1, SimpleAttribute attribute2) {
        if (!attribute1.getValue().equals(attribute2.getValue())) {
            return false;
        }
        return ScimAttributeAware.attributeMetaEquals(attribute1, attribute2);
    }

    public static boolean multiValuedAttributeEquals(MultiValuedAttribute attribute, MultiValuedAttribute otherAttribute) {
        boolean metaEquals = ScimAttributeAware.attributeMetaEquals(attribute, otherAttribute);
        if (!metaEquals) {
            return false;
        }
        if (attribute.getAttributePrimitiveValues().isEmpty()) {
            if (attribute.getAttributeValues().size() != otherAttribute.getAttributeValues().size()) {
                return false;
            }
            return attribute.getAttributeValues().stream().allMatch(innerAttribute -> otherAttribute.getAttributeValues().stream().anyMatch(otherInnerAttribute -> ScimAttributeAware.attributesEquals(innerAttribute, otherInnerAttribute)));
        }
        return attribute.getAttributePrimitiveValues().containsAll(otherAttribute.getAttributePrimitiveValues());
    }

    public static boolean complexAttributeEquals(ComplexAttribute attribute, ComplexAttribute otherAttribute) {
        boolean metaDataEquals = ScimAttributeAware.attributeMetaEquals(attribute, otherAttribute);
        if (!metaDataEquals) {
            return false;
        }
        return attribute.getSubAttributesList().keySet().stream().allMatch(attributeName -> otherAttribute.getSubAttributesList().keySet().stream().anyMatch(oAttributeName -> LambdaExceptionUtils.rethrowFunction(otherAttributeName -> ScimAttributeAware.attributesEquals(attribute.getSubAttribute((String)attributeName), otherAttribute.getSubAttribute((String)otherAttributeName))).apply(oAttributeName)));
    }

    public int hashCode() {
        return this.getResource().getAttributeList().hashCode();
    }

    protected boolean isBlank(String s) {
        return s == null || s.trim().isEmpty();
    }

    protected boolean isNotBlank(String s) {
        return s != null && !s.trim().isEmpty();
    }

    protected String stripToNull(String s) {
        return this.isBlank(s) ? null : s.trim();
    }

    public abstract AbstractSCIMObject getResource();

    private static /* synthetic */ void lambda$null$32(Supplier supplier, ComplexAttribute complexAttribute, SCIMAttributeSchema schema) {
        Optional.ofNullable(supplier.get()).ifPresent(arg_0 -> ScimAttributeAware.lambda$null$31(schema, (Supplier)supplier, complexAttribute, arg_0));
    }

    private static /* synthetic */ void lambda$null$31(SCIMAttributeSchema sCIMAttributeSchema, Supplier supplier, ComplexAttribute complexAttribute, Object value) {
        SimpleAttribute valueAttribute = new SimpleAttribute(sCIMAttributeSchema.getName(), supplier.get());
        LambdaExceptionUtils.rethrowBiConsumer(DefaultAttributeFactory::createAttribute).accept(sCIMAttributeSchema, valueAttribute);
        LambdaExceptionUtils.rethrowConsumer(complexAttribute::setSubAttribute).accept(valueAttribute);
    }
}

