/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.charon3.core.protocol.endpoints;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.wso2.charon3.core.encoder.JSONDecoder;
import org.wso2.charon3.core.encoder.JSONEncoder;
import org.wso2.charon3.core.exceptions.BadRequestException;
import org.wso2.charon3.core.exceptions.CharonException;
import org.wso2.charon3.core.exceptions.ConflictException;
import org.wso2.charon3.core.exceptions.InternalErrorException;
import org.wso2.charon3.core.exceptions.NotFoundException;
import org.wso2.charon3.core.exceptions.NotImplementedException;
import org.wso2.charon3.core.extensions.UserManager;
import org.wso2.charon3.core.objects.User;
import org.wso2.charon3.core.protocol.SCIMResponse;
import org.wso2.charon3.core.protocol.endpoints.AbstractResourceManager;
import org.wso2.charon3.core.schema.SCIMResourceSchemaManager;
import org.wso2.charon3.core.schema.SCIMResourceTypeSchema;
import org.wso2.charon3.core.schema.ServerSideValidator;
import org.wso2.charon3.core.utils.CopyUtil;
import org.wso2.charon3.core.utils.PatchOperationUtil;
import org.wso2.charon3.core.utils.ResourceManagerUtil;
import org.wso2.charon3.core.utils.codeutils.PatchOperation;

public class MeResourceManager
extends AbstractResourceManager {
    @Override
    public SCIMResponse get(String userName, UserManager userManager, String attributes, String excludeAttributes) {
        JSONEncoder encoder = null;
        try {
            encoder = MeResourceManager.getEncoder();
            SCIMResourceTypeSchema schema = SCIMResourceSchemaManager.getInstance().getUserResourceSchema();
            Map<String, Boolean> requiredAttributes = ResourceManagerUtil.getOnlyRequiredAttributesURIs((SCIMResourceTypeSchema)CopyUtil.deepCopy(schema), attributes, excludeAttributes);
            User user = userManager.getMe(userName, requiredAttributes);
            if (user == null) {
                String error = "User not found in the user store.";
                throw new NotFoundException(error);
            }
            ServerSideValidator.validateRetrievedSCIMObject(user, schema, attributes, excludeAttributes);
            String encodedUser = encoder.encodeSCIMObject(user);
            HashMap<String, String> responseHeaders = new HashMap<String, String>();
            responseHeaders.put("Content-Type", "application/scim+json");
            responseHeaders.put("Location", MeResourceManager.getResourceEndpointURL("/Users") + "/" + user.getId());
            return new SCIMResponse(200, encodedUser, responseHeaders);
        }
        catch (NotFoundException e) {
            return MeResourceManager.encodeSCIMException(e);
        }
        catch (CharonException e) {
            return MeResourceManager.encodeSCIMException(e);
        }
        catch (BadRequestException e) {
            return MeResourceManager.encodeSCIMException(e);
        }
    }

    @Override
    public SCIMResponse create(String scimObjectString, UserManager userManager, String attributes, String excludeAttributes) {
        JSONEncoder encoder = null;
        try {
            encoder = MeResourceManager.getEncoder();
            JSONDecoder decoder = MeResourceManager.getDecoder();
            SCIMResourceTypeSchema schema = SCIMResourceSchemaManager.getInstance().getUserResourceSchema();
            Map<String, Boolean> requiredAttributes = ResourceManagerUtil.getOnlyRequiredAttributesURIs((SCIMResourceTypeSchema)CopyUtil.deepCopy(schema), attributes, excludeAttributes);
            User user = decoder.decodeResource(scimObjectString, schema, new User());
            ServerSideValidator.validateCreatedSCIMObject(user, schema);
            if (userManager == null) {
                String error = "Provided user manager handler is null.";
                throw new InternalErrorException(error);
            }
            User createdUser = userManager.createMe(user, requiredAttributes);
            HashMap<String, String> responseHeaders = new HashMap<String, String>();
            if (createdUser == null) {
                String error = "Newly created User resource is null.";
                throw new InternalErrorException(error);
            }
            User copiedUser = (User)CopyUtil.deepCopy(createdUser);
            ServerSideValidator.validateReturnedAttributes(copiedUser, attributes, excludeAttributes);
            String encodedUser = encoder.encodeSCIMObject(copiedUser);
            responseHeaders.put("Location", MeResourceManager.getResourceEndpointURL("/Users") + "/" + createdUser.getId());
            responseHeaders.put("Content-Type", "application/scim+json");
            return new SCIMResponse(201, encodedUser, responseHeaders);
        }
        catch (CharonException e) {
            return MeResourceManager.encodeSCIMException(e);
        }
        catch (BadRequestException e) {
            return MeResourceManager.encodeSCIMException(e);
        }
        catch (ConflictException e) {
            return MeResourceManager.encodeSCIMException(e);
        }
        catch (InternalErrorException e) {
            return MeResourceManager.encodeSCIMException(e);
        }
        catch (NotFoundException e) {
            return MeResourceManager.encodeSCIMException(e);
        }
    }

    @Override
    public SCIMResponse delete(String userName, UserManager userManager) {
        Object encoder = null;
        try {
            if (userManager != null) {
                userManager.deleteMe(userName);
                return new SCIMResponse(204, null, null);
            }
            String error = "Provided user manager handler is null.";
            throw new InternalErrorException(error);
        }
        catch (NotFoundException e) {
            return MeResourceManager.encodeSCIMException(e);
        }
        catch (CharonException e) {
            return MeResourceManager.encodeSCIMException(e);
        }
        catch (InternalErrorException e) {
            return MeResourceManager.encodeSCIMException(e);
        }
        catch (NotImplementedException e) {
            return MeResourceManager.encodeSCIMException(e);
        }
        catch (BadRequestException e) {
            return MeResourceManager.encodeSCIMException(e);
        }
    }

    @Override
    public SCIMResponse listWithGET(UserManager userManager, String filter, int startIndex, int count, String sortBy, String sortOrder, String domainName, String attributes, String excludeAttributes) {
        return null;
    }

    @Override
    public SCIMResponse listWithPOST(String resourceString, UserManager userManager) {
        return null;
    }

    @Override
    public SCIMResponse updateWithPUT(String userName, String scimObjectString, UserManager userManager, String attributes, String excludeAttributes) {
        JSONEncoder encoder = null;
        JSONDecoder decoder = null;
        try {
            User oldUser;
            encoder = MeResourceManager.getEncoder();
            decoder = MeResourceManager.getDecoder();
            SCIMResourceTypeSchema schema = SCIMResourceSchemaManager.getInstance().getUserResourceSchema();
            Map<String, Boolean> requiredAttributes = ResourceManagerUtil.getOnlyRequiredAttributesURIs((SCIMResourceTypeSchema)CopyUtil.deepCopy(schema), attributes, excludeAttributes);
            User user = decoder.decodeResource(scimObjectString, schema, new User());
            User updatedUser = null;
            if (userManager != null) {
                oldUser = userManager.getMe(userName, ResourceManagerUtil.getAllAttributeURIs(schema));
                if (oldUser == null) {
                    String error = "No user exists with the given userName: " + userName;
                    throw new NotFoundException(error);
                }
            } else {
                String error = "Provided user manager handler is null.";
                throw new InternalErrorException(error);
            }
            User validatedUser = (User)ServerSideValidator.validateUpdatedSCIMObject(oldUser, user, schema);
            updatedUser = userManager.updateMe(validatedUser, requiredAttributes);
            HashMap<String, String> httpHeaders = new HashMap<String, String>();
            if (updatedUser == null) {
                String error = "Updated User resource is null.";
                throw new CharonException(error);
            }
            User copiedUser = (User)CopyUtil.deepCopy(updatedUser);
            ServerSideValidator.validateReturnedAttributes(copiedUser, attributes, excludeAttributes);
            String encodedUser = encoder.encodeSCIMObject(copiedUser);
            httpHeaders.put("Location", MeResourceManager.getResourceEndpointURL("/Users") + "/" + updatedUser.getId());
            httpHeaders.put("Content-Type", "application/scim+json");
            return new SCIMResponse(200, encodedUser, httpHeaders);
        }
        catch (NotFoundException e) {
            return MeResourceManager.encodeSCIMException(e);
        }
        catch (BadRequestException e) {
            return MeResourceManager.encodeSCIMException(e);
        }
        catch (CharonException e) {
            return MeResourceManager.encodeSCIMException(e);
        }
        catch (InternalErrorException e) {
            return MeResourceManager.encodeSCIMException(e);
        }
        catch (NotImplementedException e) {
            return MeResourceManager.encodeSCIMException(e);
        }
    }

    @Override
    public SCIMResponse updateWithPATCH(String existingId, String scimObjectString, UserManager userManager, String attributes, String excludeAttributes) {
        try {
            if (userManager == null) {
                String error = "Provided user manager handler is null.";
                throw new InternalErrorException(error);
            }
            JSONDecoder decoder = MeResourceManager.getDecoder();
            ArrayList<PatchOperation> opList = decoder.decodeRequest(scimObjectString);
            SCIMResourceTypeSchema schema = SCIMResourceSchemaManager.getInstance().getUserResourceSchema();
            User oldUser = userManager.getMe(existingId, ResourceManagerUtil.getAllAttributeURIs(schema));
            if (oldUser == null) {
                throw new NotFoundException("No associated user exits in the user store.");
            }
            User copyOfOldUser = (User)CopyUtil.deepCopy(oldUser);
            User originalUser = (User)CopyUtil.deepCopy(copyOfOldUser);
            User newUser = null;
            for (PatchOperation operation : opList) {
                if (operation.getOperation().equals("add")) {
                    if (newUser == null) {
                        newUser = (User)PatchOperationUtil.doPatchAdd(operation, MeResourceManager.getDecoder(), oldUser, copyOfOldUser, schema);
                        copyOfOldUser = (User)CopyUtil.deepCopy(newUser);
                        continue;
                    }
                    newUser = (User)PatchOperationUtil.doPatchAdd(operation, MeResourceManager.getDecoder(), newUser, copyOfOldUser, schema);
                    copyOfOldUser = (User)CopyUtil.deepCopy(newUser);
                    continue;
                }
                if (operation.getOperation().equals("remove")) {
                    if (newUser == null) {
                        newUser = (User)PatchOperationUtil.doPatchRemove(operation, oldUser, copyOfOldUser, schema);
                        copyOfOldUser = (User)CopyUtil.deepCopy(newUser);
                        continue;
                    }
                    newUser = (User)PatchOperationUtil.doPatchRemove(operation, newUser, copyOfOldUser, schema);
                    copyOfOldUser = (User)CopyUtil.deepCopy(newUser);
                    continue;
                }
                if (operation.getOperation().equals("replace")) {
                    if (newUser == null) {
                        newUser = (User)PatchOperationUtil.doPatchReplace(operation, MeResourceManager.getDecoder(), oldUser, copyOfOldUser, schema);
                        copyOfOldUser = (User)CopyUtil.deepCopy(newUser);
                        continue;
                    }
                    newUser = (User)PatchOperationUtil.doPatchReplace(operation, MeResourceManager.getDecoder(), newUser, copyOfOldUser, schema);
                    copyOfOldUser = (User)CopyUtil.deepCopy(newUser);
                    continue;
                }
                throw new BadRequestException("Unknown operation.", "invalidSyntax");
            }
            Map<String, Boolean> requiredAttributes = ResourceManagerUtil.getOnlyRequiredAttributesURIs((SCIMResourceTypeSchema)CopyUtil.deepCopy(schema), attributes, excludeAttributes);
            User validatedUser = (User)ServerSideValidator.validateUpdatedSCIMObject(originalUser, newUser, schema);
            newUser = userManager.updateMe(validatedUser, requiredAttributes);
            HashMap<String, String> httpHeaders = new HashMap<String, String>();
            if (newUser == null) {
                String error = "Updated User resource is null.";
                throw new CharonException(error);
            }
            User copiedUser = (User)CopyUtil.deepCopy(newUser);
            ServerSideValidator.validateReturnedAttributes(copiedUser, attributes, excludeAttributes);
            String encodedUser = MeResourceManager.getEncoder().encodeSCIMObject(copiedUser);
            httpHeaders.put("Location", MeResourceManager.getResourceEndpointURL("/Users") + "/" + newUser.getId());
            httpHeaders.put("Content-Type", "application/scim+json");
            return new SCIMResponse(200, encodedUser, httpHeaders);
        }
        catch (NotFoundException e) {
            return MeResourceManager.encodeSCIMException(e);
        }
        catch (BadRequestException e) {
            return MeResourceManager.encodeSCIMException(e);
        }
        catch (NotImplementedException e) {
            return MeResourceManager.encodeSCIMException(e);
        }
        catch (CharonException e) {
            return MeResourceManager.encodeSCIMException(e);
        }
        catch (InternalErrorException e) {
            return MeResourceManager.encodeSCIMException(e);
        }
        catch (RuntimeException e) {
            CharonException e1 = new CharonException("Error in performing the patch operation on user resource.", e);
            return MeResourceManager.encodeSCIMException(e1);
        }
    }

    public String getUserName(String scimObjectString) throws CharonException {
        try {
            JSONDecoder decoder = MeResourceManager.getDecoder();
            SCIMResourceTypeSchema schema = SCIMResourceSchemaManager.getInstance().getUserResourceSchema();
            User user = decoder.decodeResource(scimObjectString, schema, new User());
            return user.getUserName();
        }
        catch (BadRequestException | CharonException | InternalErrorException e) {
            throw new CharonException("Error in getting the username from the anonymous request");
        }
    }
}

