/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.charon3.core.utils;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.wso2.charon3.core.attributes.Attribute;
import org.wso2.charon3.core.attributes.ComplexAttribute;
import org.wso2.charon3.core.attributes.DefaultAttributeFactory;
import org.wso2.charon3.core.attributes.MultiValuedAttribute;
import org.wso2.charon3.core.attributes.SimpleAttribute;
import org.wso2.charon3.core.encoder.JSONDecoder;
import org.wso2.charon3.core.exceptions.BadRequestException;
import org.wso2.charon3.core.exceptions.CharonException;
import org.wso2.charon3.core.exceptions.InternalErrorException;
import org.wso2.charon3.core.exceptions.NotImplementedException;
import org.wso2.charon3.core.objects.AbstractSCIMObject;
import org.wso2.charon3.core.schema.AttributeSchema;
import org.wso2.charon3.core.schema.SCIMDefinitions;
import org.wso2.charon3.core.schema.SCIMResourceTypeSchema;
import org.wso2.charon3.core.schema.ServerSideValidator;
import org.wso2.charon3.core.utils.CopyUtil;
import org.wso2.charon3.core.utils.SchemaUtil;
import org.wso2.charon3.core.utils.codeutils.ExpressionNode;
import org.wso2.charon3.core.utils.codeutils.PatchOperation;

public class PatchOperationUtil {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AbstractSCIMObject doPatchRemove(PatchOperation operation, AbstractSCIMObject oldResource, AbstractSCIMObject copyOfOldResource, SCIMResourceTypeSchema schema) throws BadRequestException, NotImplementedException, CharonException {
        if (operation.getPath() == null) {
            throw new BadRequestException("No path value specified for remove operation", "noTarget");
        }
        String path = operation.getPath();
        String[] parts = path.split("[\\[\\]]");
        if (parts.length != 1) {
            String[] filterParts = parts[1].split(" ");
            ExpressionNode expressionNode = new ExpressionNode();
            expressionNode.setAttributeValue(filterParts[0]);
            expressionNode.setOperation(filterParts[1]);
            expressionNode.setValue(filterParts[2]);
            if (!expressionNode.getOperation().equalsIgnoreCase(" eq ".trim())) throw new NotImplementedException("Only Eq filter is supported");
            PatchOperationUtil.doPatchRemoveWithFilters(parts, oldResource, expressionNode);
            return ServerSideValidator.validateUpdatedSCIMObject(copyOfOldResource, oldResource, schema);
        } else {
            PatchOperationUtil.doPatchRemoveWithoutFilters(parts, oldResource);
        }
        return ServerSideValidator.validateUpdatedSCIMObject(copyOfOldResource, oldResource, schema);
    }

    private static AbstractSCIMObject doPatchRemoveWithFilters(String[] parts, AbstractSCIMObject oldResource, ExpressionNode expressionNode) throws BadRequestException, CharonException {
        String[] attributeParts;
        if (parts.length == 3) {
            parts[0] = parts[0] + parts[2];
        }
        if ((attributeParts = parts[0].split("[\\.]")).length == 1) {
            PatchOperationUtil.doPatchRemoveWithFiltersForLevelOne(oldResource, attributeParts, expressionNode);
        } else if (attributeParts.length == 2) {
            PatchOperationUtil.doPatchRemoveWithFiltersForLevelTwo(oldResource, attributeParts, expressionNode);
        } else if (attributeParts.length == 3) {
            PatchOperationUtil.doPatchRemoveWithFiltersForLevelThree(oldResource, attributeParts, expressionNode);
        }
        return oldResource;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static AbstractSCIMObject doPatchRemoveWithFiltersForLevelThree(AbstractSCIMObject oldResource, String[] attributeParts, ExpressionNode expressionNode) throws BadRequestException, CharonException {
        Attribute attribute = oldResource.getAttribute(attributeParts[0]);
        if (attribute == null) throw new BadRequestException("No such attribute with the name : " + attributeParts[0] + " " + "in the current resource", "invalidPath");
        Attribute subAttribute = attribute.getSubAttribute(attributeParts[1]);
        if (subAttribute == null) throw new BadRequestException("No such sub attribute with the name : " + attributeParts[1] + " " + "within the attribute " + attributeParts[0], "invalidPath");
        if (!subAttribute.getMultiValued().booleanValue()) throw new BadRequestException("Attribute : " + attributeParts[1] + " " + "is not a multivalued attribute.", "invalidPath");
        List<Attribute> subValues = ((MultiValuedAttribute)subAttribute).getAttributeValues();
        if (subValues == null) return oldResource;
        for (Attribute subValue : subValues) {
            Map<String, Attribute> subSubAttributes = ((ComplexAttribute)subValue).getSubAttributesList();
            Map tempSubSubAttributes = (Map)CopyUtil.deepCopy(subSubAttributes);
            for (Attribute subSubAttribute : tempSubSubAttributes.values()) {
                if (!subSubAttribute.getName().equals(expressionNode.getAttributeValue())) continue;
                Attribute removingAttribute = subSubAttributes.get(attributeParts[2]);
                if (removingAttribute == null) {
                    throw new BadRequestException("No such sub attribute with the name : " + attributeParts[2] + " " + "within the attribute " + attributeParts[1], "invalidPath");
                }
                if (removingAttribute.getMutability().equals((Object)SCIMDefinitions.Mutability.READ_ONLY) || removingAttribute.getRequired().equals(true)) {
                    throw new BadRequestException("Can not remove a required attribute or a read-only attribute", "mutability");
                }
                ((ComplexAttribute)subValue).removeSubAttribute(removingAttribute.getName());
            }
        }
        if (subValues.size() != 0) return oldResource;
        ((ComplexAttribute)attribute).removeSubAttribute(subAttribute.getName());
        return oldResource;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static AbstractSCIMObject doPatchRemoveWithFiltersForLevelTwo(AbstractSCIMObject oldResource, String[] attributeParts, ExpressionNode expressionNode) throws BadRequestException, CharonException {
        Attribute attribute = oldResource.getAttribute(attributeParts[0]);
        if (attribute == null) throw new BadRequestException("No such attribute with the name : " + attributeParts[0] + " " + "in the current resource", "invalidPath");
        if (attribute.getMultiValued().booleanValue()) {
            List<Attribute> subValues = ((MultiValuedAttribute)attribute).getAttributeValues();
            if (subValues == null) return oldResource;
            for (Attribute subValue : subValues) {
                Map<String, Attribute> subAttributes = ((ComplexAttribute)subValue).getSubAttributesList();
                Map tempSubAttributes = (Map)CopyUtil.deepCopy(subAttributes);
                for (Attribute subAttribute : tempSubAttributes.values()) {
                    if (!subAttribute.getName().equals(expressionNode.getAttributeValue()) || !((SimpleAttribute)subAttribute).getValue().equals(expressionNode.getValue())) continue;
                    Attribute removingAttribute = subAttributes.get(attributeParts[1]);
                    if (removingAttribute == null) {
                        throw new BadRequestException("No such sub attribute with the name : " + attributeParts[1] + " " + "within the attribute " + attributeParts[0], "invalidPath");
                    }
                    if (removingAttribute.getMutability().equals((Object)SCIMDefinitions.Mutability.READ_ONLY) || removingAttribute.getRequired().equals(true)) {
                        throw new BadRequestException("Can not remove a required attribute or a read-only attribute", "mutability");
                    }
                    ((ComplexAttribute)subValue).removeSubAttribute(removingAttribute.getName());
                }
            }
            if (subValues.size() != 0) return oldResource;
            oldResource.deleteAttribute(attribute.getName());
            return oldResource;
        } else {
            if (!attribute.getType().equals((Object)SCIMDefinitions.DataType.COMPLEX)) throw new BadRequestException("Attribute : " + expressionNode.getAttributeValue() + " " + "is not a multivalued attribute.", "invalidPath");
            Attribute subAttribute = attribute.getSubAttribute(attributeParts[1]);
            if (subAttribute == null) {
                throw new BadRequestException("No such sub attribute with the name : " + attributeParts[1] + " " + "within the attribute " + attributeParts[0], "invalidPath");
            }
            List<Attribute> subValues = ((MultiValuedAttribute)subAttribute).getAttributeValues();
            if (subValues == null) return oldResource;
            Iterator<Attribute> subValueIterator = subValues.iterator();
            while (subValueIterator.hasNext()) {
                Attribute subValue = subValueIterator.next();
                Map<String, Attribute> subValuesSubAttribute = ((ComplexAttribute)subValue).getSubAttributesList();
                for (Attribute subSubAttribute : subValuesSubAttribute.values()) {
                    if (!subSubAttribute.getName().equals(expressionNode.getAttributeValue()) || !((SimpleAttribute)subSubAttribute).getValue().equals(expressionNode.getValue())) continue;
                    if (subValue.getMutability().equals((Object)SCIMDefinitions.Mutability.READ_ONLY) || subValue.getRequired().equals(true)) {
                        throw new BadRequestException("Can not remove a required attribute or a read-only attribute", "mutability");
                    }
                    subValueIterator.remove();
                }
            }
            if (((MultiValuedAttribute)subAttribute).getAttributeValues().size() != 0) return oldResource;
            ((ComplexAttribute)attribute).removeSubAttribute(subAttribute.getName());
        }
        return oldResource;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static AbstractSCIMObject doPatchRemoveWithFiltersForLevelOne(AbstractSCIMObject oldResource, String[] attributeParts, ExpressionNode expressionNode) throws BadRequestException, CharonException {
        Attribute attribute = oldResource.getAttribute(attributeParts[0]);
        if (attribute == null) throw new BadRequestException("No such attribute with the name : " + attributeParts[0] + " " + "in the current resource", "invalidPath");
        if (!attribute.getType().equals((Object)SCIMDefinitions.DataType.COMPLEX)) {
            if (!attribute.getMultiValued().booleanValue()) throw new BadRequestException("Attribute : " + expressionNode.getAttributeValue() + " " + "is not a multivalued attribute.", "invalidPath");
            List<Object> valuesList = ((MultiValuedAttribute)attribute).getAttributePrimitiveValues();
            Iterator<Object> iterator = valuesList.iterator();
            while (iterator.hasNext()) {
                Object item = iterator.next();
                if (!item.equals(expressionNode.getValue())) continue;
                if (attribute.getMutability().equals((Object)SCIMDefinitions.Mutability.READ_ONLY) || attribute.getRequired().equals(true)) {
                    throw new BadRequestException("Can not remove a required attribute or a read-only attribute", "mutability");
                }
                iterator.remove();
            }
            if (((MultiValuedAttribute)attribute).getAttributePrimitiveValues().size() != 0) return oldResource;
            oldResource.deleteAttribute(attribute.getName());
            return oldResource;
        } else if (attribute.getMultiValued().booleanValue()) {
            List<Attribute> subValues = ((MultiValuedAttribute)attribute).getAttributeValues();
            if (subValues == null) return oldResource;
            Iterator<Attribute> subValueIterator = subValues.iterator();
            while (subValueIterator.hasNext()) {
                Attribute subValue = subValueIterator.next();
                Map<String, Attribute> subValuesSubAttribute = ((ComplexAttribute)subValue).getSubAttributesList();
                for (Attribute subAttribute : subValuesSubAttribute.values()) {
                    if (!subAttribute.getName().equals(expressionNode.getAttributeValue()) || !((SimpleAttribute)subAttribute).getValue().equals(expressionNode.getValue())) continue;
                    if (subValue.getMutability().equals((Object)SCIMDefinitions.Mutability.READ_ONLY) || subValue.getRequired().equals(true)) {
                        throw new BadRequestException("Can not remove a required attribute or a read-only attribute", "mutability");
                    }
                    subValueIterator.remove();
                }
            }
            if (((MultiValuedAttribute)attribute).getAttributeValues().size() != 0) return oldResource;
            oldResource.deleteAttribute(attribute.getName());
            return oldResource;
        } else {
            Attribute subAttribute = attribute.getSubAttribute(expressionNode.getAttributeValue());
            if (subAttribute == null) throw new BadRequestException("No sub attribute with the name : " + expressionNode.getAttributeValue() + " " + "in the attribute : " + attributeParts[0], "invalidPath");
            if (!subAttribute.getMultiValued().booleanValue() || subAttribute.getType().equals((Object)SCIMDefinitions.DataType.COMPLEX)) throw new BadRequestException("Sub attribute : " + expressionNode.getAttributeValue() + " " + "is not a primitive multivalued attribute.", "invalidPath");
            List<Object> valuesList = ((MultiValuedAttribute)subAttribute).getAttributePrimitiveValues();
            Iterator<Object> iterator = valuesList.iterator();
            while (iterator.hasNext()) {
                Object item = iterator.next();
                if (!item.equals(expressionNode.getValue())) continue;
                if (subAttribute.getMutability().equals((Object)SCIMDefinitions.Mutability.READ_ONLY) || subAttribute.getRequired().equals(true)) {
                    throw new BadRequestException("Can not remove a required attribute or a read-only attribute", "mutability");
                }
                iterator.remove();
            }
            if (((MultiValuedAttribute)subAttribute).getAttributePrimitiveValues().size() != 0) return oldResource;
            ((ComplexAttribute)attribute).removeSubAttribute(subAttribute.getName());
        }
        return oldResource;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static AbstractSCIMObject doPatchRemoveWithoutFilters(String[] parts, AbstractSCIMObject oldResource) throws BadRequestException, CharonException {
        String[] attributeParts = parts[0].split("[\\.]");
        if (attributeParts.length == 1) {
            Attribute attribute = oldResource.getAttribute(parts[0]);
            if (attribute == null) throw new BadRequestException("No such attribute with the name : " + attributeParts[0] + " " + "in the current resource", "invalidPath");
            if (attribute.getMutability().equals((Object)SCIMDefinitions.Mutability.READ_ONLY) || attribute.getRequired().equals(true)) {
                throw new BadRequestException("Can not remove a required attribute or a read-only attribute", "mutability");
            }
            String attributeName = attribute.getName();
            oldResource.deleteAttribute(attributeName);
            return oldResource;
        } else {
            Attribute attribute = oldResource.getAttribute(attributeParts[0]);
            if (attribute == null) throw new BadRequestException("No such attribute with the name : " + attributeParts[0] + " " + "in the current resource", "invalidPath");
            if (attribute.getMultiValued().booleanValue()) {
                List<Attribute> subValuesList = ((MultiValuedAttribute)attribute).getAttributeValues();
                if (subValuesList == null) return oldResource;
                for (Attribute subValue : subValuesList) {
                    Map<String, Attribute> subSubAttributeList = ((ComplexAttribute)subValue).getSubAttributesList();
                    Iterator<Attribute> iterator = subSubAttributeList.values().iterator();
                    while (iterator.hasNext()) {
                        Attribute subSubAttribute = iterator.next();
                        if (!subSubAttribute.getName().equals(attributeParts[1])) continue;
                        if (subSubAttribute.getMutability().equals((Object)SCIMDefinitions.Mutability.READ_ONLY) || subSubAttribute.getRequired().equals(true)) {
                            throw new BadRequestException("Can not remove a required attribute or a read-only attribute", "mutability");
                        }
                        iterator.remove();
                    }
                }
                return oldResource;
            } else {
                Attribute subAttribute = attribute.getSubAttribute(attributeParts[1]);
                if (subAttribute == null) throw new BadRequestException("No such sub attribute with the name : " + attributeParts[1] + " " + "in the attribute : " + attributeParts[0], "invalidPath");
                if (attributeParts.length == 3) {
                    if (subAttribute.getMultiValued().booleanValue()) {
                        List<Attribute> subSubValuesList = ((MultiValuedAttribute)subAttribute).getAttributeValues();
                        if (subSubValuesList == null) return oldResource;
                        for (Attribute subSubValue : subSubValuesList) {
                            Map<String, Attribute> subSubAttributeList = ((ComplexAttribute)subSubValue).getSubAttributesList();
                            Iterator<Attribute> iterator = subSubAttributeList.values().iterator();
                            while (iterator.hasNext()) {
                                Attribute subSubAttribute = iterator.next();
                                if (!subSubAttribute.getName().equals(attributeParts[2])) continue;
                                if (subSubAttribute.getMutability().equals((Object)SCIMDefinitions.Mutability.READ_ONLY) || subSubAttribute.getRequired().equals(true)) {
                                    throw new BadRequestException("Can not remove a required attribute or a read-only attribute", "mutability");
                                }
                                iterator.remove();
                            }
                        }
                        return oldResource;
                    } else {
                        Attribute subSubAttribute = subAttribute.getSubAttribute(attributeParts[2]);
                        if (subSubAttribute.getMutability().equals((Object)SCIMDefinitions.Mutability.READ_ONLY) || subSubAttribute.getRequired().equals(true)) {
                            throw new BadRequestException("Can not remove a required attribute or a read-only attribute", "mutability");
                        }
                        String subSubAttributeName = subSubAttribute.getName();
                        ((ComplexAttribute)subAttribute).removeSubAttribute(subSubAttributeName);
                    }
                    return oldResource;
                } else {
                    if (subAttribute.getMutability().equals((Object)SCIMDefinitions.Mutability.READ_ONLY) || subAttribute.getRequired().equals(true)) {
                        throw new BadRequestException("Can not remove a required attribute or a read-only attribute", "mutability");
                    }
                    String subAttributeName = subAttribute.getName();
                    ((ComplexAttribute)attribute).removeSubAttribute(subAttributeName);
                }
            }
        }
        return oldResource;
    }

    public static AbstractSCIMObject doPatchAdd(PatchOperation operation, JSONDecoder decoder, AbstractSCIMObject oldResource, AbstractSCIMObject copyOfOldResource, SCIMResourceTypeSchema schema) throws CharonException, BadRequestException {
        try {
            AbstractSCIMObject attributeHoldingSCIMObject = decoder.decode(operation.getValues().toString(), schema);
            if (oldResource != null) {
                for (String attributeName : attributeHoldingSCIMObject.getAttributeList().keySet()) {
                    Attribute oldAttribute = oldResource.getAttribute(attributeName);
                    if (oldAttribute != null) {
                        MultiValuedAttribute attributeValue;
                        if (oldAttribute.getMultiValued().booleanValue() && oldAttribute.getType().equals((Object)SCIMDefinitions.DataType.COMPLEX)) {
                            attributeValue = (MultiValuedAttribute)attributeHoldingSCIMObject.getAttribute(attributeName);
                            for (Attribute attribute : attributeValue.getAttributeValues()) {
                                ((MultiValuedAttribute)oldAttribute).setAttributeValue(attribute);
                            }
                            continue;
                        }
                        if (oldAttribute.getMultiValued().booleanValue()) {
                            attributeValue = (MultiValuedAttribute)attributeHoldingSCIMObject.getAttribute(attributeName);
                            for (Object object : attributeValue.getAttributePrimitiveValues()) {
                                ((MultiValuedAttribute)oldAttribute).setAttributePrimitiveValue(object);
                            }
                            continue;
                        }
                        if (oldAttribute.getType().equals((Object)SCIMDefinitions.DataType.COMPLEX)) {
                            Map<String, Attribute> subAttributeList = ((ComplexAttribute)attributeHoldingSCIMObject.getAttribute(attributeName)).getSubAttributesList();
                            for (Map.Entry entry : subAttributeList.entrySet()) {
                                Attribute subAttribute = oldAttribute.getSubAttribute((String)entry.getKey());
                                if (subAttribute != null) {
                                    if (subAttribute.getType().equals((Object)SCIMDefinitions.DataType.COMPLEX)) {
                                        if (subAttribute.getMultiValued().booleanValue()) {
                                            MultiValuedAttribute attributeSubValue = (MultiValuedAttribute)((ComplexAttribute)attributeHoldingSCIMObject.getAttribute(attributeName)).getSubAttribute((String)entry.getKey());
                                            for (Attribute attribute : attributeSubValue.getAttributeValues()) {
                                                ((MultiValuedAttribute)subAttribute).setAttributeValue(attribute);
                                            }
                                            continue;
                                        }
                                        Map<String, Attribute> subSubAttributeList = ((ComplexAttribute)attributeHoldingSCIMObject.getAttribute(attributeName).getSubAttribute((String)entry.getKey())).getSubAttributesList();
                                        for (Map.Entry entry2 : subSubAttributeList.entrySet()) {
                                            Attribute subSubAttribute = oldAttribute.getSubAttribute((String)entry.getKey()).getSubAttribute((String)entry2.getKey());
                                            if (subSubAttribute != null) {
                                                if (subSubAttribute.getMultiValued().booleanValue()) {
                                                    List<Object> items = ((MultiValuedAttribute)entry2.getValue()).getAttributePrimitiveValues();
                                                    for (Object item : items) {
                                                        ((MultiValuedAttribute)subSubAttribute).setAttributePrimitiveValue(item);
                                                    }
                                                    continue;
                                                }
                                                ((SimpleAttribute)subSubAttribute).setValue(((SimpleAttribute)entry2.getValue()).getValue());
                                                continue;
                                            }
                                            if (entry2.getValue() != null) {
                                                ((ComplexAttribute)subAttribute).setSubAttribute((Attribute)entry2.getValue());
                                                continue;
                                            }
                                            throw new BadRequestException("Not a valid attribute.", "invalidSyntax");
                                        }
                                        continue;
                                    }
                                    if (subAttribute.getMultiValued().booleanValue()) {
                                        List<Object> items = ((MultiValuedAttribute)entry.getValue()).getAttributePrimitiveValues();
                                        for (Object object : items) {
                                            ((MultiValuedAttribute)subAttribute).setAttributePrimitiveValue(object);
                                        }
                                        continue;
                                    }
                                    ((SimpleAttribute)subAttribute).setValue(((SimpleAttribute)entry.getValue()).getValue());
                                    continue;
                                }
                                if (entry.getValue() != null) {
                                    ((ComplexAttribute)oldAttribute).setSubAttribute((Attribute)entry.getValue());
                                    continue;
                                }
                                throw new BadRequestException("Not a valid attribute.", "invalidSyntax");
                            }
                            continue;
                        }
                        ((SimpleAttribute)oldAttribute).setValue(((SimpleAttribute)attributeHoldingSCIMObject.getAttribute(oldAttribute.getName())).getValue());
                        continue;
                    }
                    if (attributeHoldingSCIMObject.getAttribute(attributeName) != null) {
                        oldResource.setAttribute(attributeHoldingSCIMObject.getAttribute(attributeName));
                        continue;
                    }
                    throw new BadRequestException("Not a valid attribute.", "invalidSyntax");
                }
                AbstractSCIMObject validatedResource = ServerSideValidator.validateUpdatedSCIMObject(copyOfOldResource, oldResource, schema);
                return validatedResource;
            }
            throw new CharonException("Error in getting the old resource.");
        }
        catch (BadRequestException e) {
            throw new BadRequestException("invalidSyntax");
        }
    }

    public static AbstractSCIMObject doPatchReplace(PatchOperation operation, JSONDecoder decoder, AbstractSCIMObject oldResource, AbstractSCIMObject copyOfOldResource, SCIMResourceTypeSchema schema) throws CharonException, NotImplementedException, BadRequestException, InternalErrorException {
        if (operation.getPath() != null) {
            String path = operation.getPath();
            String[] parts = path.split("[\\[\\]]");
            if (operation.getPath().contains("[")) {
                try {
                    PatchOperationUtil.doPatchReplaceOnPathWithFilters(oldResource, schema, decoder, operation, parts);
                }
                catch (JSONException e) {
                    throw new BadRequestException("invalidSyntax");
                }
            } else {
                PatchOperationUtil.doPatchReplaceOnPathWithoutFilters(oldResource, schema, decoder, operation, parts);
            }
        } else {
            PatchOperationUtil.doPatchReplaceOnResource(oldResource, copyOfOldResource, schema, decoder, operation);
        }
        AbstractSCIMObject validatedResource = ServerSideValidator.validateUpdatedSCIMObject(copyOfOldResource, oldResource, schema);
        return validatedResource;
    }

    private static AbstractSCIMObject doPatchReplaceOnPathWithoutFilters(AbstractSCIMObject oldResource, SCIMResourceTypeSchema schema, JSONDecoder decoder, PatchOperation operation, String[] parts) throws BadRequestException, CharonException, InternalErrorException {
        String[] attributeParts = parts[0].split("[\\.]");
        if (attributeParts.length == 1) {
            PatchOperationUtil.doPatchReplaceOnPathWithoutFiltersForLevelOne(oldResource, schema, decoder, operation, attributeParts);
        } else if (attributeParts.length == 2) {
            PatchOperationUtil.doPatchReplaceOnPathWithoutFiltersForLevelTwo(oldResource, schema, decoder, operation, attributeParts);
        } else if (attributeParts.length == 3) {
            PatchOperationUtil.doPatchReplaceOnPathWithoutFiltersForLevelThree(oldResource, schema, decoder, operation, attributeParts);
        }
        return oldResource;
    }

    private static void doPatchReplaceOnPathWithoutFiltersForLevelOne(AbstractSCIMObject oldResource, SCIMResourceTypeSchema schema, JSONDecoder decoder, PatchOperation operation, String[] attributeParts) throws BadRequestException, CharonException, InternalErrorException {
        Attribute attribute = oldResource.getAttribute(attributeParts[0]);
        if (attribute != null) {
            if (!attribute.getType().equals((Object)SCIMDefinitions.DataType.COMPLEX)) {
                if (!attribute.getMultiValued().booleanValue()) {
                    if (attribute.getMutability().equals((Object)SCIMDefinitions.Mutability.READ_ONLY) || attribute.getMutability().equals((Object)SCIMDefinitions.Mutability.IMMUTABLE)) {
                        throw new BadRequestException("Can not replace a immutable attribute or a read-only attribute", "mutability");
                    }
                    ((SimpleAttribute)attribute).setValue(operation.getValues().toString());
                } else {
                    if (attribute.getMutability().equals((Object)SCIMDefinitions.Mutability.READ_ONLY) || attribute.getMutability().equals((Object)SCIMDefinitions.Mutability.IMMUTABLE)) {
                        throw new BadRequestException("Can not replace a immutable attribute or a read-only attribute", "mutability");
                    }
                    ((MultiValuedAttribute)attribute).deletePrimitiveValues();
                    JSONArray jsonArray = null;
                    try {
                        jsonArray = new JSONArray(operation.getValues());
                    }
                    catch (JSONException e) {
                        throw new BadRequestException("invalidSyntax");
                    }
                    for (int i = 0; i < jsonArray.length(); ++i) {
                        try {
                            ((MultiValuedAttribute)attribute).setAttributePrimitiveValue(jsonArray.get(i));
                            continue;
                        }
                        catch (JSONException e) {
                            throw new BadRequestException("invalidSyntax");
                        }
                    }
                }
            } else if (attribute.getMultiValued().booleanValue()) {
                if (attribute.getMutability().equals((Object)SCIMDefinitions.Mutability.READ_ONLY) || attribute.getMutability().equals((Object)SCIMDefinitions.Mutability.IMMUTABLE)) {
                    throw new BadRequestException("Can not replace a immutable attribute or a read-only attribute", "mutability");
                }
                JSONArray jsonArray = null;
                try {
                    jsonArray = new JSONArray(new JSONTokener(operation.getValues().toString()));
                }
                catch (JSONException e) {
                    throw new BadRequestException("invalidSyntax");
                }
                AttributeSchema attributeSchema = SchemaUtil.getAttributeSchema(attribute.getName(), schema);
                MultiValuedAttribute newMultiValuedAttribute = decoder.buildComplexMultiValuedAttribute(attributeSchema, jsonArray);
                oldResource.deleteAttribute(attribute.getName());
                oldResource.setAttribute(newMultiValuedAttribute);
            } else {
                if (attribute.getMutability().equals((Object)SCIMDefinitions.Mutability.READ_ONLY) || attribute.getMutability().equals((Object)SCIMDefinitions.Mutability.IMMUTABLE)) {
                    throw new BadRequestException("Can not replace a immutable attribute or a read-only attribute", "mutability");
                }
                JSONObject jsonObject = null;
                try {
                    jsonObject = new JSONObject(new JSONTokener(operation.getValues().toString()));
                }
                catch (JSONException e) {
                    throw new BadRequestException("invalidSyntax");
                }
                AttributeSchema attributeSchema = SchemaUtil.getAttributeSchema(attribute.getName(), schema);
                ComplexAttribute newComplexAttribute = null;
                try {
                    newComplexAttribute = decoder.buildComplexAttribute(attributeSchema, jsonObject);
                }
                catch (JSONException e) {
                    throw new BadRequestException("invalidSyntax");
                }
                oldResource.deleteAttribute(attribute.getName());
                oldResource.setAttribute(newComplexAttribute);
            }
        } else {
            AttributeSchema attributeSchema = SchemaUtil.getAttributeSchema(attributeParts[0], schema);
            if (attributeSchema != null) {
                if (attributeSchema.getType().equals((Object)SCIMDefinitions.DataType.COMPLEX)) {
                    if (attributeSchema.getMultiValued()) {
                        JSONArray jsonArray = null;
                        try {
                            jsonArray = new JSONArray(new JSONTokener(operation.getValues().toString()));
                        }
                        catch (JSONException e) {
                            throw new BadRequestException("invalidSyntax");
                        }
                        MultiValuedAttribute newMultiValuedAttribute = decoder.buildComplexMultiValuedAttribute(attributeSchema, jsonArray);
                        oldResource.setAttribute(newMultiValuedAttribute);
                    } else {
                        JSONObject jsonObject = null;
                        try {
                            jsonObject = new JSONObject(new JSONTokener(operation.getValues().toString()));
                        }
                        catch (JSONException e) {
                            throw new BadRequestException("invalidSyntax");
                        }
                        ComplexAttribute newComplexAttribute = null;
                        try {
                            newComplexAttribute = decoder.buildComplexAttribute(attributeSchema, jsonObject);
                        }
                        catch (JSONException e) {
                            throw new BadRequestException("invalidSyntax");
                        }
                        oldResource.setAttribute(newComplexAttribute);
                    }
                } else if (attributeSchema.getMultiValued()) {
                    JSONArray jsonArray = null;
                    try {
                        jsonArray = new JSONArray(new JSONTokener(operation.getValues().toString()));
                    }
                    catch (JSONException e) {
                        throw new BadRequestException("invalidSyntax");
                    }
                    MultiValuedAttribute newMultiValuedAttribute = decoder.buildPrimitiveMultiValuedAttribute(attributeSchema, jsonArray);
                    oldResource.setAttribute(newMultiValuedAttribute);
                } else {
                    SimpleAttribute simpleAttribute = decoder.buildSimpleAttribute(attributeSchema, operation.getValues());
                    oldResource.setAttribute(simpleAttribute);
                }
            } else {
                throw new BadRequestException("No attribute with the name : " + attributeParts[0]);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void doPatchReplaceOnPathWithoutFiltersForLevelTwo(AbstractSCIMObject oldResource, SCIMResourceTypeSchema schema, JSONDecoder decoder, PatchOperation operation, String[] attributeParts) throws BadRequestException, CharonException, InternalErrorException {
        Attribute attribute = oldResource.getAttribute(attributeParts[0]);
        if (attribute != null) {
            if (attribute.getMultiValued().booleanValue()) {
                List<Attribute> subValues = ((MultiValuedAttribute)attribute).getAttributeValues();
                for (Attribute subValue : subValues) {
                    Attribute subAttribute = ((ComplexAttribute)subValue).getSubAttribute(attributeParts[1]);
                    if (subAttribute != null) {
                        if (subAttribute.getMutability().equals((Object)SCIMDefinitions.Mutability.READ_ONLY) || subAttribute.getMutability().equals((Object)SCIMDefinitions.Mutability.IMMUTABLE)) {
                            throw new BadRequestException("Can not replace a immutable attribute or a read-only attribute", "mutability");
                        }
                        if (subAttribute.getMultiValued().booleanValue()) {
                            ((MultiValuedAttribute)subAttribute).deletePrimitiveValues();
                            JSONArray jsonArray = null;
                            try {
                                jsonArray = new JSONArray(operation.getValues());
                            }
                            catch (JSONException e) {
                                throw new BadRequestException("invalidSyntax");
                            }
                            for (int i = 0; i < jsonArray.length(); ++i) {
                                try {
                                    ((MultiValuedAttribute)subAttribute).setAttributePrimitiveValue(jsonArray.get(i));
                                    continue;
                                }
                                catch (JSONException e) {
                                    throw new BadRequestException("invalidSyntax");
                                }
                            }
                            continue;
                        }
                        ((SimpleAttribute)subAttribute).setValue(operation.getValues());
                        continue;
                    }
                    AttributeSchema subAttributeSchema = SchemaUtil.getAttributeSchema(attributeParts[0] + "." + attributeParts[1], schema);
                    if (subAttributeSchema.getMultiValued()) {
                        JSONArray jsonArray = null;
                        try {
                            jsonArray = new JSONArray(new JSONTokener(operation.getValues().toString()));
                        }
                        catch (JSONException e) {
                            throw new BadRequestException("invalidSyntax");
                        }
                        MultiValuedAttribute newMultiValuedAttribute = decoder.buildPrimitiveMultiValuedAttribute(subAttributeSchema, jsonArray);
                        ((ComplexAttribute)subValue).setSubAttribute(newMultiValuedAttribute);
                        continue;
                    }
                    SimpleAttribute simpleAttribute = decoder.buildSimpleAttribute(subAttributeSchema, operation.getValues());
                    ((ComplexAttribute)subValue).setSubAttribute(simpleAttribute);
                }
                return;
            }
            Attribute subAttribute = attribute.getSubAttribute(attributeParts[1]);
            AttributeSchema subAttributeSchema = SchemaUtil.getAttributeSchema(attributeParts[0] + "." + attributeParts[1], schema);
            if (subAttributeSchema == null) throw new BadRequestException("No such attribute with the name : " + attributeParts[1], "noTarget");
            if (subAttributeSchema.getType().equals((Object)SCIMDefinitions.DataType.COMPLEX)) {
                if (subAttribute != null) {
                    if (!subAttribute.getMultiValued().booleanValue()) {
                        if (subAttribute.getMutability().equals((Object)SCIMDefinitions.Mutability.READ_ONLY) || subAttribute.getMutability().equals((Object)SCIMDefinitions.Mutability.IMMUTABLE)) {
                            throw new BadRequestException("Can not replace a immutable attribute or a read-only attribute", "mutability");
                        }
                        ComplexAttribute newComplexAttribute = null;
                        try {
                            newComplexAttribute = decoder.buildComplexAttribute(subAttributeSchema, (JSONObject)operation.getValues());
                        }
                        catch (JSONException e) {
                            throw new BadRequestException("invalidSyntax");
                        }
                        ((ComplexAttribute)attribute).removeSubAttribute(attributeParts[1]);
                        ((ComplexAttribute)attribute).setSubAttribute(newComplexAttribute);
                        return;
                    }
                    if (subAttribute.getMutability().equals((Object)SCIMDefinitions.Mutability.READ_ONLY) || subAttribute.getMutability().equals((Object)SCIMDefinitions.Mutability.IMMUTABLE)) {
                        throw new BadRequestException("Can not replace a immutable attribute or a read-only attribute", "mutability");
                    }
                    JSONArray jsonArray = null;
                    try {
                        jsonArray = new JSONArray(new JSONTokener(operation.getValues().toString()));
                    }
                    catch (JSONException e) {
                        throw new BadRequestException("invalidSyntax");
                    }
                    MultiValuedAttribute newMultiValuesAttribute = decoder.buildComplexMultiValuedAttribute(subAttributeSchema, jsonArray);
                    ((ComplexAttribute)attribute).removeSubAttribute(attributeParts[1]);
                    ((ComplexAttribute)attribute).setSubAttribute(newMultiValuesAttribute);
                    return;
                }
                if (subAttributeSchema.getMultiValued()) {
                    JSONArray jsonArray = null;
                    try {
                        jsonArray = new JSONArray(new JSONTokener(operation.getValues().toString()));
                    }
                    catch (JSONException e) {
                        throw new BadRequestException("invalidSyntax");
                    }
                    MultiValuedAttribute newMultiValuesAttribute = decoder.buildComplexMultiValuedAttribute(subAttributeSchema, jsonArray);
                    ((ComplexAttribute)attribute).setSubAttribute(newMultiValuesAttribute);
                    return;
                }
                ComplexAttribute newComplexAttribute = null;
                try {
                    newComplexAttribute = decoder.buildComplexAttribute(subAttributeSchema, (JSONObject)operation.getValues());
                }
                catch (JSONException e) {
                    throw new BadRequestException("invalidSyntax");
                }
                ((ComplexAttribute)attribute).setSubAttribute(newComplexAttribute);
                return;
            }
            if (subAttribute != null) {
                if (subAttribute.getMutability().equals((Object)SCIMDefinitions.Mutability.READ_ONLY) || subAttribute.getMutability().equals((Object)SCIMDefinitions.Mutability.IMMUTABLE)) {
                    throw new BadRequestException("Can not replace a immutable attribute or a read-only attribute", "mutability");
                }
                AttributeSchema attributeSchema = SchemaUtil.getAttributeSchema(attributeParts[0] + "." + attributeParts[1], schema);
                if (subAttribute.getMultiValued().booleanValue()) {
                    JSONArray jsonArray = null;
                    try {
                        jsonArray = new JSONArray(new JSONTokener(operation.getValues().toString()));
                    }
                    catch (JSONException e) {
                        throw new BadRequestException("invalidSyntax");
                    }
                    MultiValuedAttribute newMultiValuedAttribute = decoder.buildPrimitiveMultiValuedAttribute(attributeSchema, jsonArray);
                    ((ComplexAttribute)attribute).removeSubAttribute(attributeParts[1]);
                    ((ComplexAttribute)attribute).setSubAttribute(newMultiValuedAttribute);
                    return;
                }
                SimpleAttribute simpleAttribute = decoder.buildSimpleAttribute(attributeSchema, operation.getValues());
                ((ComplexAttribute)attribute).removeSubAttribute(attributeParts[1]);
                ((ComplexAttribute)attribute).setSubAttribute(simpleAttribute);
                return;
            }
            AttributeSchema attributeSchema = SchemaUtil.getAttributeSchema(attributeParts[0] + "." + attributeParts[1], schema);
            if (attributeSchema.getMultiValued()) {
                JSONArray jsonArray = null;
                try {
                    jsonArray = new JSONArray(new JSONTokener(operation.getValues().toString()));
                }
                catch (JSONException e) {
                    throw new BadRequestException("invalidSyntax");
                }
                MultiValuedAttribute newMultiValuedAttribute = decoder.buildPrimitiveMultiValuedAttribute(attributeSchema, jsonArray);
                ((ComplexAttribute)attribute).setSubAttribute(newMultiValuedAttribute);
                return;
            }
            SimpleAttribute simpleAttribute = decoder.buildSimpleAttribute(attributeSchema, operation.getValues());
            ((ComplexAttribute)attribute).setSubAttribute(simpleAttribute);
            return;
        }
        AttributeSchema attributeSchema = SchemaUtil.getAttributeSchema(attributeParts[0], schema);
        if (attributeSchema == null) throw new BadRequestException("No such attribute with the name : " + attributeParts[0], "noTarget");
        if (attributeSchema.getMultiValued()) {
            MultiValuedAttribute multiValuedAttribute = new MultiValuedAttribute(attributeSchema.getName());
            DefaultAttributeFactory.createAttribute(attributeSchema, multiValuedAttribute);
            AttributeSchema subAttributeSchema = SchemaUtil.getAttributeSchema(attributeParts[0] + "." + attributeParts[1], schema);
            if (subAttributeSchema == null) throw new BadRequestException("No such attribute with the name : " + attributeParts[1], "noTarget");
            SimpleAttribute simpleAttribute = new SimpleAttribute(subAttributeSchema.getName(), operation.getValues());
            DefaultAttributeFactory.createAttribute(subAttributeSchema, simpleAttribute);
            String complexAttributeName = attributeSchema.getName() + "_" + operation.getValues() + "_" + "default";
            ComplexAttribute complexAttribute = new ComplexAttribute(complexAttributeName);
            DefaultAttributeFactory.createAttribute(attributeSchema, complexAttribute);
            complexAttribute.setSubAttribute(simpleAttribute);
            multiValuedAttribute.setAttributeValue(complexAttribute);
            oldResource.setAttribute(multiValuedAttribute);
            return;
        }
        ComplexAttribute complexAttribute = new ComplexAttribute(attributeSchema.getName());
        DefaultAttributeFactory.createAttribute(attributeSchema, complexAttribute);
        AttributeSchema subAttributeSchema = SchemaUtil.getAttributeSchema(attributeParts[0] + "." + attributeParts[1], schema);
        if (subAttributeSchema == null) throw new BadRequestException("No such attribute with the name : " + attributeParts[1], "noTarget");
        if (subAttributeSchema.getType().equals((Object)SCIMDefinitions.DataType.COMPLEX)) {
            if (subAttributeSchema.getMultiValued()) {
                JSONArray jsonArray = null;
                try {
                    jsonArray = new JSONArray(new JSONTokener(operation.getValues().toString()));
                }
                catch (JSONException e) {
                    throw new BadRequestException("invalidSyntax");
                }
                MultiValuedAttribute multiValuedAttribute = decoder.buildComplexMultiValuedAttribute(subAttributeSchema, jsonArray);
                complexAttribute.setSubAttribute(multiValuedAttribute);
            } else {
                ComplexAttribute subComplexAttribute = null;
                try {
                    subComplexAttribute = decoder.buildComplexAttribute(subAttributeSchema, (JSONObject)operation.getValues());
                }
                catch (JSONException e) {
                    throw new BadRequestException("invalidSyntax");
                }
                complexAttribute.setSubAttribute(subComplexAttribute);
            }
        } else {
            SimpleAttribute simpleAttribute = new SimpleAttribute(subAttributeSchema.getName(), operation.getValues());
            DefaultAttributeFactory.createAttribute(subAttributeSchema, simpleAttribute);
            complexAttribute.setSubAttribute(simpleAttribute);
        }
        oldResource.setAttribute(complexAttribute);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void doPatchReplaceOnPathWithoutFiltersForLevelThree(AbstractSCIMObject oldResource, SCIMResourceTypeSchema schema, JSONDecoder decoder, PatchOperation operation, String[] attributeParts) throws BadRequestException, CharonException {
        Attribute attribute = oldResource.getAttribute(attributeParts[0]);
        if (attribute != null) {
            Attribute subAttribute = ((ComplexAttribute)attribute).getSubAttribute(attributeParts[1]);
            if (subAttribute != null) {
                if (subAttribute.getMultiValued().booleanValue()) {
                    List<Attribute> subValues = ((MultiValuedAttribute)subAttribute).getAttributeValues();
                    if (subValues == null) return;
                    for (Attribute subValue : subValues) {
                        SimpleAttribute simpleAttribute;
                        MultiValuedAttribute multiValuedAttribute;
                        JSONArray jsonArray;
                        AttributeSchema subSubAttributeSchema;
                        Attribute subSubAttribute = subValue.getSubAttribute(attributeParts[2]);
                        if (subSubAttribute != null) {
                            subSubAttributeSchema = SchemaUtil.getAttributeSchema(attributeParts[0] + "." + attributeParts[1] + "." + attributeParts[2], schema);
                            if (subSubAttributeSchema == null) throw new BadRequestException("No such attribute with the name : " + attributeParts[2], "noTarget");
                            if (subSubAttribute.getMutability().equals((Object)SCIMDefinitions.Mutability.READ_ONLY) || subSubAttribute.getMutability().equals((Object)SCIMDefinitions.Mutability.IMMUTABLE)) {
                                throw new BadRequestException("Can not replace a immutable attribute or a read-only attribute", "mutability");
                            }
                            if (subSubAttribute.getMultiValued().booleanValue()) {
                                jsonArray = null;
                                try {
                                    jsonArray = new JSONArray(new JSONTokener(operation.getValues().toString()));
                                }
                                catch (JSONException e) {
                                    throw new BadRequestException("invalidSyntax");
                                }
                                multiValuedAttribute = decoder.buildPrimitiveMultiValuedAttribute(subSubAttributeSchema, jsonArray);
                                ((ComplexAttribute)subValue).removeSubAttribute(attributeParts[2]);
                                ((ComplexAttribute)subValue).setSubAttribute(multiValuedAttribute);
                                continue;
                            }
                            simpleAttribute = decoder.buildSimpleAttribute(subSubAttributeSchema, operation.getValues());
                            ((ComplexAttribute)subValue).removeSubAttribute(attributeParts[2]);
                            ((ComplexAttribute)subValue).setSubAttribute(simpleAttribute);
                            continue;
                        }
                        subSubAttributeSchema = SchemaUtil.getAttributeSchema(attributeParts[0] + "." + attributeParts[1] + "." + attributeParts[2], schema);
                        if (subSubAttributeSchema == null) throw new BadRequestException("No such attribute with the name : " + attributeParts[2], "noTarget");
                        if (subSubAttributeSchema.getMultiValued()) {
                            jsonArray = null;
                            try {
                                jsonArray = new JSONArray(new JSONTokener(operation.getValues().toString()));
                            }
                            catch (JSONException e) {
                                throw new BadRequestException("invalidSyntax");
                            }
                            multiValuedAttribute = decoder.buildPrimitiveMultiValuedAttribute(subSubAttributeSchema, jsonArray);
                            ((ComplexAttribute)subValue).setSubAttribute(multiValuedAttribute);
                            continue;
                        }
                        simpleAttribute = decoder.buildSimpleAttribute(subSubAttributeSchema, operation.getValues());
                        ((ComplexAttribute)subValue).setSubAttribute(simpleAttribute);
                    }
                    return;
                }
                Attribute subSubAttribute = ((ComplexAttribute)subAttribute).getSubAttribute(attributeParts[2]);
                if (subSubAttribute != null) {
                    ((SimpleAttribute)subSubAttribute).setValue(operation.getValues());
                    return;
                }
                AttributeSchema subSubAttributeSchema = SchemaUtil.getAttributeSchema(attributeParts[0] + "." + attributeParts[1] + "." + attributeParts[2], schema);
                if (subSubAttributeSchema == null) throw new BadRequestException("No such attribute with the name : " + attributeParts[2], "noTarget");
                if (subSubAttributeSchema.getMultiValued()) {
                    JSONArray jsonArray = null;
                    try {
                        jsonArray = new JSONArray(new JSONTokener(operation.getValues().toString()));
                    }
                    catch (JSONException e) {
                        throw new BadRequestException("invalidSyntax");
                    }
                    MultiValuedAttribute multiValuedAttribute = decoder.buildPrimitiveMultiValuedAttribute(subSubAttributeSchema, jsonArray);
                    ((ComplexAttribute)subAttribute).setSubAttribute(multiValuedAttribute);
                    return;
                }
                SimpleAttribute simpleAttribute = decoder.buildSimpleAttribute(subSubAttributeSchema, operation.getValues());
                ((ComplexAttribute)subAttribute).setSubAttribute(simpleAttribute);
                return;
            }
            AttributeSchema subAttributeSchena = SchemaUtil.getAttributeSchema(attributeParts[0] + "." + attributeParts[1], schema);
            if (subAttributeSchena == null) throw new BadRequestException("No such attribute with the name : " + attributeParts[1], "noTarget");
            if (subAttributeSchena.getMultiValued()) {
                MultiValuedAttribute multiValuedAttribute = new MultiValuedAttribute(subAttributeSchena.getName());
                DefaultAttributeFactory.createAttribute(subAttributeSchena, multiValuedAttribute);
                String complexAttributeName = subAttributeSchena.getName() + "_" + operation.getValues() + "_" + "default";
                ComplexAttribute complexAttribute = new ComplexAttribute(complexAttributeName);
                DefaultAttributeFactory.createAttribute(subAttributeSchena, complexAttribute);
                AttributeSchema subSubAttributeSchema = SchemaUtil.getAttributeSchema(attributeParts[0] + "." + attributeParts[1] + "." + attributeParts[2], schema);
                if (subSubAttributeSchema == null) throw new BadRequestException("No such attribute with the name : " + attributeParts[2], "noTarget");
                if (subSubAttributeSchema.getMultiValued()) {
                    MultiValuedAttribute multiValuedSubAttribute = new MultiValuedAttribute(subSubAttributeSchema.getName());
                    DefaultAttributeFactory.createAttribute(subSubAttributeSchema, multiValuedSubAttribute);
                    JSONArray jsonArray = null;
                    try {
                        jsonArray = new JSONArray(operation.getValues());
                    }
                    catch (JSONException e) {
                        throw new BadRequestException("invalidSyntax");
                    }
                    for (int i = 0; i < jsonArray.length(); ++i) {
                        try {
                            multiValuedSubAttribute.setAttributePrimitiveValue(jsonArray.get(i));
                            continue;
                        }
                        catch (JSONException e) {
                            throw new BadRequestException("invalidSyntax");
                        }
                    }
                    complexAttribute.setSubAttribute(multiValuedSubAttribute);
                } else {
                    SimpleAttribute simpleAttribute = new SimpleAttribute(subSubAttributeSchema.getName(), operation.getValues());
                    DefaultAttributeFactory.createAttribute(subSubAttributeSchema, simpleAttribute);
                    complexAttribute.setSubAttribute(simpleAttribute);
                }
                multiValuedAttribute.setAttributeValue(complexAttribute);
                ((ComplexAttribute)attribute).setSubAttribute(multiValuedAttribute);
                return;
            }
            ComplexAttribute complexAttribute = new ComplexAttribute(subAttributeSchena.getName());
            DefaultAttributeFactory.createAttribute(subAttributeSchena, complexAttribute);
            AttributeSchema subSubAttributeSchema = SchemaUtil.getAttributeSchema(attributeParts[0] + "." + attributeParts[1] + "." + attributeParts[2], schema);
            if (subSubAttributeSchema == null) throw new BadRequestException("No such attribute with the name : " + attributeParts[2], "noTarget");
            if (subSubAttributeSchema.getMultiValued()) {
                MultiValuedAttribute multiValuedAttribute = new MultiValuedAttribute(subSubAttributeSchema.getName());
                DefaultAttributeFactory.createAttribute(subSubAttributeSchema, multiValuedAttribute);
                JSONArray jsonArray = null;
                try {
                    jsonArray = new JSONArray(operation.getValues());
                }
                catch (JSONException e) {
                    throw new BadRequestException("invalidSyntax");
                }
                for (int i = 0; i < jsonArray.length(); ++i) {
                    try {
                        multiValuedAttribute.setAttributePrimitiveValue(jsonArray.get(i));
                        continue;
                    }
                    catch (JSONException e) {
                        throw new BadRequestException("invalidSyntax");
                    }
                }
                complexAttribute.setSubAttribute(multiValuedAttribute);
            } else {
                SimpleAttribute simpleAttribute = new SimpleAttribute(subSubAttributeSchema.getName(), operation.getValues());
                DefaultAttributeFactory.createAttribute(subSubAttributeSchema, simpleAttribute);
                complexAttribute.setSubAttribute(simpleAttribute);
            }
            ((ComplexAttribute)attribute).setSubAttribute(complexAttribute);
            return;
        }
        AttributeSchema attributeSchema = SchemaUtil.getAttributeSchema(attributeParts[0], schema);
        if (attributeSchema == null) throw new BadRequestException("No such attribute with the name : " + attributeParts[0], "noTarget");
        ComplexAttribute parentAttribute = new ComplexAttribute(attributeSchema.getName());
        DefaultAttributeFactory.createAttribute(attributeSchema, parentAttribute);
        AttributeSchema subAttributeSchena = SchemaUtil.getAttributeSchema(attributeParts[0] + "." + attributeParts[1], schema);
        if (subAttributeSchena == null) throw new BadRequestException("No such attribute with the name : " + attributeParts[1], "noTarget");
        if (subAttributeSchena.getMultiValued()) {
            MultiValuedAttribute multiValuedAttribute = new MultiValuedAttribute(subAttributeSchena.getName());
            DefaultAttributeFactory.createAttribute(subAttributeSchena, multiValuedAttribute);
            String complexAttributeName = subAttributeSchena.getName() + "_" + operation.getValues() + "_" + "default";
            ComplexAttribute complexAttribute = new ComplexAttribute(complexAttributeName);
            DefaultAttributeFactory.createAttribute(subAttributeSchena, complexAttribute);
            AttributeSchema subSubAttributeSchema = SchemaUtil.getAttributeSchema(attributeParts[0] + "." + attributeParts[1] + "." + attributeParts[2], schema);
            if (subSubAttributeSchema == null) throw new BadRequestException("No such attribute with the name : " + attributeParts[2], "noTarget");
            if (subSubAttributeSchema.getMultiValued()) {
                MultiValuedAttribute multiValuedSubAttribute = new MultiValuedAttribute(subSubAttributeSchema.getName());
                DefaultAttributeFactory.createAttribute(subSubAttributeSchema, multiValuedSubAttribute);
                JSONArray jsonArray = null;
                try {
                    jsonArray = new JSONArray(operation.getValues());
                }
                catch (JSONException e) {
                    throw new BadRequestException("invalidSyntax");
                }
                for (int i = 0; i < jsonArray.length(); ++i) {
                    try {
                        multiValuedSubAttribute.setAttributePrimitiveValue(jsonArray.get(i));
                        continue;
                    }
                    catch (JSONException e) {
                        throw new BadRequestException("invalidSyntax");
                    }
                }
                complexAttribute.setSubAttribute(multiValuedSubAttribute);
            } else {
                SimpleAttribute simpleAttribute = new SimpleAttribute(subSubAttributeSchema.getName(), operation.getValues());
                DefaultAttributeFactory.createAttribute(subSubAttributeSchema, simpleAttribute);
                complexAttribute.setSubAttribute(simpleAttribute);
            }
            multiValuedAttribute.setAttributeValue(complexAttribute);
            parentAttribute.setSubAttribute(multiValuedAttribute);
            return;
        }
        ComplexAttribute complexAttribute = new ComplexAttribute(subAttributeSchena.getName());
        DefaultAttributeFactory.createAttribute(subAttributeSchena, complexAttribute);
        AttributeSchema subSubAttributeSchema = SchemaUtil.getAttributeSchema(attributeParts[0] + "." + attributeParts[1] + "." + attributeParts[2], schema);
        if (subSubAttributeSchema == null) throw new BadRequestException("No such attribute with the name : " + attributeParts[2], "noTarget");
        if (subSubAttributeSchema.getMultiValued()) {
            MultiValuedAttribute multiValuedAttribute = new MultiValuedAttribute(subSubAttributeSchema.getName());
            DefaultAttributeFactory.createAttribute(subSubAttributeSchema, multiValuedAttribute);
            JSONArray jsonArray = null;
            try {
                jsonArray = new JSONArray(operation.getValues());
            }
            catch (JSONException e) {
                throw new BadRequestException("invalidSyntax");
            }
            for (int i = 0; i < jsonArray.length(); ++i) {
                try {
                    multiValuedAttribute.setAttributePrimitiveValue(jsonArray.get(i));
                    continue;
                }
                catch (JSONException e) {
                    throw new BadRequestException("invalidSyntax");
                }
            }
            complexAttribute.setSubAttribute(multiValuedAttribute);
        } else {
            SimpleAttribute simpleAttribute = new SimpleAttribute(subSubAttributeSchema.getName(), operation.getValues());
            DefaultAttributeFactory.createAttribute(subSubAttributeSchema, simpleAttribute);
            complexAttribute.setSubAttribute(simpleAttribute);
        }
        parentAttribute.setSubAttribute(complexAttribute);
        oldResource.setAttribute(parentAttribute);
    }

    private static void doPatchReplaceOnPathWithFilters(AbstractSCIMObject oldResource, SCIMResourceTypeSchema schema, JSONDecoder decoder, PatchOperation operation, String[] parts) throws NotImplementedException, BadRequestException, CharonException, JSONException, InternalErrorException {
        if (parts.length != 1) {
            String[] filterParts = parts[1].split(" ");
            ExpressionNode expressionNode = new ExpressionNode();
            expressionNode.setAttributeValue(filterParts[0]);
            expressionNode.setOperation(filterParts[1]);
            expressionNode.setValue(filterParts[2]);
            if (expressionNode.getOperation().equalsIgnoreCase(" eq ".trim())) {
                String[] attributeParts;
                if (parts.length == 3) {
                    parts[0] = parts[0] + parts[2];
                }
                if ((attributeParts = parts[0].split("[\\.]")).length == 1) {
                    PatchOperationUtil.doPatchReplaceWithFiltersForLevelOne(oldResource, attributeParts, expressionNode, operation, schema, decoder);
                } else if (attributeParts.length == 2) {
                    PatchOperationUtil.doPatchReplaceWithFiltersForLevelTwo(oldResource, attributeParts, expressionNode, operation, schema, decoder);
                } else if (attributeParts.length == 3) {
                    PatchOperationUtil.doPatchReplaceWithFiltersForLevelThree(oldResource, attributeParts, expressionNode, operation, schema, decoder);
                }
            } else {
                throw new NotImplementedException("Only Eq filter is supported");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static AbstractSCIMObject doPatchReplaceWithFiltersForLevelThree(AbstractSCIMObject oldResource, String[] attributeParts, ExpressionNode expressionNode, PatchOperation operation, SCIMResourceTypeSchema schema, JSONDecoder decoder) throws BadRequestException, CharonException {
        Attribute attribute = oldResource.getAttribute(attributeParts[0]);
        boolean isValueFound = false;
        if (attribute != null) {
            Attribute subAttribute = attribute.getSubAttribute(attributeParts[1]);
            if (subAttribute != null) {
                if (!subAttribute.getMultiValued().booleanValue()) throw new BadRequestException("Attribute : " + attributeParts[1] + " " + "is not a multivalued attribute.", "invalidPath");
                List<Attribute> subValues = ((MultiValuedAttribute)subAttribute).getAttributeValues();
                if (subValues == null) return oldResource;
                block0: for (Attribute subValue : subValues) {
                    Map<String, Attribute> subSubAttributes = ((ComplexAttribute)subValue).getSubAttributesList();
                    Map tempSubSubAttributes = (Map)CopyUtil.deepCopy(subSubAttributes);
                    for (Attribute subSubAttribute : tempSubSubAttributes.values()) {
                        if (!subSubAttribute.getName().equals(expressionNode.getAttributeValue())) continue;
                        Attribute replacingAttribute = subSubAttributes.get(attributeParts[2]);
                        if (replacingAttribute == null) {
                            AttributeSchema replacingAttributeSchema = SchemaUtil.getAttributeSchema(attributeParts[0] + "." + attributeParts[1] + "." + attributeParts[2], schema);
                            if (replacingAttributeSchema == null) throw new BadRequestException("No such attribute with the name : " + attributeParts[0] + "." + attributeParts[1] + "." + attributeParts[2]);
                            if (replacingAttributeSchema.getMultiValued()) {
                                ((ComplexAttribute)subValue).setSubAttribute(decoder.buildPrimitiveMultiValuedAttribute(replacingAttributeSchema, (JSONArray)operation.getValues()));
                                continue block0;
                            }
                            ((ComplexAttribute)subValue).setSubAttribute(decoder.buildSimpleAttribute(replacingAttributeSchema, operation.getValues()));
                            continue block0;
                        }
                        if (replacingAttribute.getMutability().equals((Object)SCIMDefinitions.Mutability.READ_ONLY) || replacingAttribute.getMutability().equals((Object)SCIMDefinitions.Mutability.IMMUTABLE)) {
                            throw new BadRequestException("Can not remove a immutable attribute or a read-only attribute", "mutability");
                        }
                        if (replacingAttribute.getMultiValued().booleanValue()) {
                            ((MultiValuedAttribute)replacingAttribute).getAttributePrimitiveValues().remove(expressionNode.getValue());
                            ((MultiValuedAttribute)replacingAttribute).setAttributePrimitiveValue(operation.getValues());
                        } else {
                            ((SimpleAttribute)replacingAttribute).setValue(operation.getValues());
                        }
                        isValueFound = true;
                    }
                }
                if (isValueFound) return oldResource;
                throw new BadRequestException("No matching filter value found.", "noTarget");
            }
            AttributeSchema subAttributeSchema = SchemaUtil.getAttributeSchema(attributeParts[0] + "." + attributeParts[1], schema);
            if (subAttributeSchema == null) throw new BadRequestException("Attribute : " + attributeParts[0] + "." + attributeParts[1] + "does not exists.", "invalidPath");
            MultiValuedAttribute multiValuedAttribute = new MultiValuedAttribute(subAttributeSchema.getName());
            DefaultAttributeFactory.createAttribute(subAttributeSchema, multiValuedAttribute);
            String complexName = subAttributeSchema.getName() + "_" + "default" + "_" + "default";
            ComplexAttribute complexAttribute = new ComplexAttribute(complexName);
            DefaultAttributeFactory.createAttribute(subAttributeSchema, complexAttribute);
            AttributeSchema subSubAttributeSchema = SchemaUtil.getAttributeSchema(attributeParts[0] + "." + attributeParts[1] + "." + attributeParts[2], schema);
            if (subSubAttributeSchema == null) throw new BadRequestException("Attribute : " + attributeParts[0] + "." + attributeParts[1] + "." + attributeParts[2] + "does not exists.", "invalidPath");
            if (subSubAttributeSchema.getMultiValued()) {
                MultiValuedAttribute multiValuedSubAttribute = new MultiValuedAttribute(subSubAttributeSchema.getName());
                DefaultAttributeFactory.createAttribute(subSubAttributeSchema, multiValuedSubAttribute);
                multiValuedSubAttribute.setAttributePrimitiveValue(operation.getValues());
                complexAttribute.setSubAttribute(multiValuedSubAttribute);
                multiValuedAttribute.setAttributeValue(complexAttribute);
                ((ComplexAttribute)attribute).setSubAttribute(multiValuedAttribute);
                return oldResource;
            } else {
                SimpleAttribute simpleAttribute = new SimpleAttribute(subSubAttributeSchema.getName(), operation.getValues());
                DefaultAttributeFactory.createAttribute(subSubAttributeSchema, simpleAttribute);
                complexAttribute.setSubAttribute(simpleAttribute);
                multiValuedAttribute.setAttributeValue(complexAttribute);
                ((ComplexAttribute)attribute).setSubAttribute(multiValuedAttribute);
            }
            return oldResource;
        } else {
            AttributeSchema attributeSchema = SchemaUtil.getAttributeSchema(attributeParts[0], schema);
            if (attributeSchema == null) throw new BadRequestException("Attribute : " + attributeParts[0] + "does not exists.", "invalidPath");
            if (!attributeSchema.getType().equals((Object)SCIMDefinitions.DataType.COMPLEX)) return oldResource;
            ComplexAttribute extensionAttribute = new ComplexAttribute(attributeSchema.getName());
            DefaultAttributeFactory.createAttribute(attributeSchema, extensionAttribute);
            AttributeSchema subAttributeSchema = SchemaUtil.getAttributeSchema(attributeParts[0] + "." + attributeParts[1], schema);
            if (subAttributeSchema == null) throw new BadRequestException("Attribute : " + attributeParts[0] + "." + attributeParts[1] + "does not exists.", "invalidPath");
            MultiValuedAttribute multiValuedAttribute = new MultiValuedAttribute(subAttributeSchema.getName());
            DefaultAttributeFactory.createAttribute(subAttributeSchema, multiValuedAttribute);
            String complexName = subAttributeSchema.getName() + "_" + "default" + "_" + "default";
            ComplexAttribute complexAttribute = new ComplexAttribute(complexName);
            DefaultAttributeFactory.createAttribute(subAttributeSchema, complexAttribute);
            AttributeSchema subSubAttributeSchema = SchemaUtil.getAttributeSchema(attributeParts[0] + "." + attributeParts[1] + "." + attributeParts[2], schema);
            if (subSubAttributeSchema == null) throw new BadRequestException("Attribute : " + attributeParts[0] + "." + attributeParts[1] + "." + attributeParts[2] + "does not exists.", "invalidPath");
            if (subSubAttributeSchema.getMultiValued()) {
                MultiValuedAttribute multiValuedSubAttribute = new MultiValuedAttribute(subSubAttributeSchema.getName());
                DefaultAttributeFactory.createAttribute(subSubAttributeSchema, multiValuedSubAttribute);
                multiValuedAttribute.setAttributePrimitiveValue(operation.getValues());
                complexAttribute.setSubAttribute(multiValuedSubAttribute);
                multiValuedAttribute.setAttributeValue(complexAttribute);
                extensionAttribute.setSubAttribute(multiValuedAttribute);
                oldResource.setAttribute(extensionAttribute);
                return oldResource;
            } else {
                SimpleAttribute simpleAttribute = new SimpleAttribute(subSubAttributeSchema.getName(), operation.getValues());
                DefaultAttributeFactory.createAttribute(subSubAttributeSchema, simpleAttribute);
                complexAttribute.setSubAttribute(simpleAttribute);
                multiValuedAttribute.setAttributeValue(simpleAttribute);
                extensionAttribute.setSubAttribute(multiValuedAttribute);
                oldResource.setAttribute(extensionAttribute);
            }
        }
        return oldResource;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static AbstractSCIMObject doPatchReplaceWithFiltersForLevelTwo(AbstractSCIMObject oldResource, String[] attributeParts, ExpressionNode expressionNode, PatchOperation operation, SCIMResourceTypeSchema schema, JSONDecoder decoder) throws CharonException, BadRequestException, JSONException, InternalErrorException {
        Attribute subAttribute;
        boolean isValueFound;
        block17: {
            Attribute attribute;
            block16: {
                block15: {
                    attribute = oldResource.getAttribute(attributeParts[0]);
                    isValueFound = false;
                    if (attribute == null) break block15;
                    if (attribute.getMultiValued().booleanValue()) break block16;
                    if (!attribute.getType().equals((Object)SCIMDefinitions.DataType.COMPLEX)) throw new BadRequestException("Attribute : " + expressionNode.getAttributeValue() + " " + "is not a multivalued attribute.", "invalidPath");
                    subAttribute = attribute.getSubAttribute(attributeParts[1]);
                    if (subAttribute == null) {
                        AttributeSchema subAttributeSchema = SchemaUtil.getAttributeSchema(attributeParts[0] + "." + attributeParts[1], schema);
                        if (subAttributeSchema == null) throw new BadRequestException("Attribute : " + attributeParts[0] + "." + attributeParts[1] + "does not exists.", "invalidPath");
                        if (!subAttributeSchema.getMultiValued()) throw new BadRequestException("Attribute : " + attributeParts[1] + "is not a multi valued attribute.", "invalidPath");
                        MultiValuedAttribute multiValuedAttribute = new MultiValuedAttribute(subAttributeSchema.getName());
                        DefaultAttributeFactory.createAttribute(subAttributeSchema, multiValuedAttribute);
                        multiValuedAttribute.setAttributeValue(decoder.buildComplexAttribute(subAttributeSchema, (JSONObject)operation.getValues()));
                        ((ComplexAttribute)attribute).setSubAttribute(multiValuedAttribute);
                        return oldResource;
                    }
                    break block17;
                }
                AttributeSchema attributeSchema = SchemaUtil.getAttributeSchema(attributeParts[0], schema);
                if (attributeSchema == null) throw new BadRequestException("No such attribute with the name : " + attributeParts[0], "invalidPath");
                if (!attributeSchema.getMultiValued()) {
                    ComplexAttribute extensionComplexAttribute = new ComplexAttribute(attributeSchema.getName());
                    DefaultAttributeFactory.createAttribute(attributeSchema, extensionComplexAttribute);
                    AttributeSchema subAttributeSchema = SchemaUtil.getAttributeSchema(attributeParts[0] + "." + attributeParts[1], schema);
                    if (subAttributeSchema == null) throw new BadRequestException("Attribute : " + attributeParts[0] + "." + attributeParts[1] + "does not exists.", "invalidPath");
                    if (!subAttributeSchema.getMultiValued()) throw new BadRequestException("Attribute : " + attributeParts[1] + "is not a multi valued attribute.", "invalidPath");
                    MultiValuedAttribute multiValuedAttribute = new MultiValuedAttribute(subAttributeSchema.getName());
                    DefaultAttributeFactory.createAttribute(subAttributeSchema, multiValuedAttribute);
                    multiValuedAttribute.setAttributeValue(decoder.buildComplexAttribute(subAttributeSchema, (JSONObject)operation.getValues()));
                    oldResource.setAttribute(multiValuedAttribute);
                    return oldResource;
                }
                MultiValuedAttribute multiValuedAttribute = new MultiValuedAttribute(attributeSchema.getName());
                DefaultAttributeFactory.createAttribute(attributeSchema, multiValuedAttribute);
                String complexName = attributeSchema.getName() + "_" + "default" + "_" + "default";
                ComplexAttribute complexAttribute = new ComplexAttribute(complexName);
                DefaultAttributeFactory.createAttribute(attributeSchema, complexAttribute);
                AttributeSchema subAttributeSchema = SchemaUtil.getAttributeSchema(attributeParts[0] + "." + attributeParts[1], schema);
                if (subAttributeSchema == null) throw new BadRequestException("Attribute : " + attributeParts[0] + "." + attributeParts[1] + "does not exists.", "invalidPath");
                if (subAttributeSchema.getMultiValued()) {
                    MultiValuedAttribute multiValuedSubAttribute = new MultiValuedAttribute(subAttributeSchema.getName());
                    DefaultAttributeFactory.createAttribute(subAttributeSchema, multiValuedSubAttribute);
                    multiValuedAttribute.setAttributePrimitiveValue(operation.getValues());
                    complexAttribute.setSubAttribute(multiValuedSubAttribute);
                    multiValuedAttribute.setAttributeValue(complexAttribute);
                    oldResource.setAttribute(multiValuedAttribute);
                    return oldResource;
                }
                SimpleAttribute simpleAttribute = new SimpleAttribute(subAttributeSchema.getName(), operation.getValues());
                DefaultAttributeFactory.createAttribute(subAttributeSchema, simpleAttribute);
                complexAttribute.setSubAttribute(simpleAttribute);
                multiValuedAttribute.setAttributeValue(complexAttribute);
                oldResource.setAttribute(multiValuedAttribute);
                return oldResource;
            }
            List<Attribute> subValues = ((MultiValuedAttribute)attribute).getAttributeValues();
            if (subValues == null) return oldResource;
            Iterator<Attribute> iterator = subValues.iterator();
            block0: while (true) {
                if (!iterator.hasNext()) {
                    if (isValueFound) return oldResource;
                    throw new BadRequestException("No matching filter value found.", "noTarget");
                }
                Attribute subValue = iterator.next();
                Map<String, Attribute> subAttributes = ((ComplexAttribute)subValue).getSubAttributesList();
                Map tempSubAttributes = (Map)CopyUtil.deepCopy(subAttributes);
                Iterator iterator2 = tempSubAttributes.values().iterator();
                while (true) {
                    if (!iterator2.hasNext()) continue block0;
                    Attribute subAttribute2 = (Attribute)iterator2.next();
                    if (!subAttribute2.getName().equals(expressionNode.getAttributeValue()) || !((SimpleAttribute)subAttribute2).getValue().equals(expressionNode.getValue())) continue;
                    Attribute replacingAttribute = subAttributes.get(attributeParts[1]);
                    if (replacingAttribute == null) {
                        AttributeSchema replacingAttributeSchema = SchemaUtil.getAttributeSchema(attributeParts[0] + "." + attributeParts[1], schema);
                        if (replacingAttributeSchema.getMultiValued()) {
                            MultiValuedAttribute multiValuedAttribute = new MultiValuedAttribute(replacingAttributeSchema.getName());
                            DefaultAttributeFactory.createAttribute(replacingAttributeSchema, multiValuedAttribute);
                            multiValuedAttribute.setAttributePrimitiveValue(operation.getValues());
                            ((ComplexAttribute)subValue).setSubAttribute(multiValuedAttribute);
                            continue block0;
                        }
                        SimpleAttribute simpleAttribute = new SimpleAttribute(replacingAttributeSchema.getName(), operation.getValues());
                        DefaultAttributeFactory.createAttribute(replacingAttributeSchema, simpleAttribute);
                        ((ComplexAttribute)subValue).setSubAttribute(simpleAttribute);
                        continue block0;
                    }
                    if (replacingAttribute.getMutability().equals((Object)SCIMDefinitions.Mutability.READ_ONLY)) throw new BadRequestException("Can not remove a immutable attribute or a read-only attribute", "mutability");
                    if (replacingAttribute.getMutability().equals((Object)SCIMDefinitions.Mutability.IMMUTABLE)) {
                        throw new BadRequestException("Can not remove a immutable attribute or a read-only attribute", "mutability");
                    }
                    if (replacingAttribute.getMultiValued().booleanValue()) {
                        ((MultiValuedAttribute)replacingAttribute).getAttributePrimitiveValues().remove(expressionNode.getValue());
                        ((MultiValuedAttribute)replacingAttribute).setAttributePrimitiveValue(operation.getValues());
                    } else {
                        ((SimpleAttribute)replacingAttribute).setValue(operation.getValues());
                    }
                    isValueFound = true;
                }
                break;
            }
        }
        List<Attribute> subValues = ((MultiValuedAttribute)subAttribute).getAttributeValues();
        if (subValues == null) return oldResource;
        Iterator<Attribute> subValueIterator = subValues.iterator();
        block2: while (true) {
            if (!subValueIterator.hasNext()) {
                AttributeSchema attributeSchema = SchemaUtil.getAttributeSchema(attributeParts[0] + "." + attributeParts[1], schema);
                subValues.add(decoder.buildComplexAttribute(attributeSchema, (JSONObject)operation.getValues()));
                if (isValueFound) return oldResource;
                throw new BadRequestException("No matching filter value found.", "noTarget");
            }
            Attribute subValue = subValueIterator.next();
            Map<String, Attribute> subValuesSubAttribute = ((ComplexAttribute)subValue).getSubAttributesList();
            Iterator<Attribute> iterator = subValuesSubAttribute.values().iterator();
            while (true) {
                if (!iterator.hasNext()) continue block2;
                Attribute subSubAttribute = iterator.next();
                if (!subSubAttribute.getName().equals(expressionNode.getAttributeValue()) || !((SimpleAttribute)subSubAttribute).getValue().equals(expressionNode.getValue())) continue;
                if (subValue.getMutability().equals((Object)SCIMDefinitions.Mutability.READ_ONLY)) throw new BadRequestException("Can not remove a immutable attribute or a read-only attribute", "mutability");
                if (subValue.getMutability().equals((Object)SCIMDefinitions.Mutability.IMMUTABLE)) {
                    throw new BadRequestException("Can not remove a immutable attribute or a read-only attribute", "mutability");
                }
                subValueIterator.remove();
                isValueFound = true;
            }
            break;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static AbstractSCIMObject doPatchReplaceWithFiltersForLevelOne(AbstractSCIMObject oldResource, String[] attributeParts, ExpressionNode expressionNode, PatchOperation operation, SCIMResourceTypeSchema schema, JSONDecoder decoder) throws BadRequestException, CharonException, JSONException, InternalErrorException {
        Attribute attribute = oldResource.getAttribute(attributeParts[0]);
        boolean isValueFound = false;
        if (attribute != null) {
            if (!attribute.getType().equals((Object)SCIMDefinitions.DataType.COMPLEX)) {
                if (!attribute.getMultiValued().booleanValue()) throw new BadRequestException("Attribute : " + expressionNode.getAttributeValue() + " " + "is not a multivalued attribute.", "invalidPath");
                List<Object> valuesList = ((MultiValuedAttribute)attribute).getAttributePrimitiveValues();
                Iterator<Object> iterator = valuesList.iterator();
                while (iterator.hasNext()) {
                    Object item = iterator.next();
                    if (!item.equals(expressionNode.getValue())) continue;
                    if (attribute.getMutability().equals((Object)SCIMDefinitions.Mutability.READ_ONLY) || attribute.getMutability().equals((Object)SCIMDefinitions.Mutability.IMMUTABLE)) {
                        throw new BadRequestException("Can not remove a immutable attribute or a read-only attribute", "mutability");
                    }
                    iterator.remove();
                    isValueFound = true;
                }
                if (!isValueFound) {
                    throw new BadRequestException("No matching filter value found.", "noTarget");
                }
                valuesList.add(operation.getValues());
                return oldResource;
            } else if (attribute.getMultiValued().booleanValue()) {
                List<Attribute> subValues = ((MultiValuedAttribute)attribute).getAttributeValues();
                if (subValues == null) return oldResource;
                Iterator<Attribute> subValueIterator = subValues.iterator();
                while (subValueIterator.hasNext()) {
                    Attribute subValue = subValueIterator.next();
                    Map<String, Attribute> subValuesSubAttribute = ((ComplexAttribute)subValue).getSubAttributesList();
                    for (Attribute subAttribute : subValuesSubAttribute.values()) {
                        if (!subAttribute.getName().equals(expressionNode.getAttributeValue()) || !((SimpleAttribute)subAttribute).getValue().equals(expressionNode.getValue())) continue;
                        if (subValue.getMutability().equals((Object)SCIMDefinitions.Mutability.READ_ONLY) || subValue.getMutability().equals((Object)SCIMDefinitions.Mutability.IMMUTABLE)) {
                            throw new BadRequestException("Can not remove a immutable attribute or a read-only attribute", "mutability");
                        }
                        subValueIterator.remove();
                        isValueFound = true;
                    }
                }
                if (!isValueFound) {
                    throw new BadRequestException("No matching filter value found.", "noTarget");
                }
                AttributeSchema attributeSchema = SchemaUtil.getAttributeSchema(attributeParts[0], schema);
                subValues.add(decoder.buildComplexAttribute(attributeSchema, (JSONObject)operation.getValues()));
                return oldResource;
            } else {
                Attribute subAttribute = attribute.getSubAttribute(expressionNode.getAttributeValue());
                if (subAttribute != null) {
                    if (!subAttribute.getMultiValued().booleanValue()) throw new BadRequestException("Sub attribute : " + expressionNode.getAttributeValue() + " " + "is not a multivalued attribute.", "invalidPath");
                    List<Object> valuesList = ((MultiValuedAttribute)subAttribute).getAttributePrimitiveValues();
                    Iterator<Object> iterator = valuesList.iterator();
                    while (iterator.hasNext()) {
                        Object item = iterator.next();
                        if (!item.equals(expressionNode.getValue())) continue;
                        if (subAttribute.getMutability().equals((Object)SCIMDefinitions.Mutability.READ_ONLY) || subAttribute.getMutability().equals((Object)SCIMDefinitions.Mutability.IMMUTABLE)) {
                            throw new BadRequestException("Can not remove a immutable attribute or a read-only attribute", "mutability");
                        }
                        iterator.remove();
                        isValueFound = true;
                    }
                    if (!isValueFound) {
                        throw new BadRequestException("No matching filter value found.", "noTarget");
                    }
                    valuesList.add(operation.getValues());
                    return oldResource;
                } else {
                    AttributeSchema subAttributeSchema = SchemaUtil.getAttributeSchema(attributeParts[0] + "." + expressionNode.getAttributeValue(), schema);
                    if (subAttributeSchema.getMultiValued()) {
                        ((ComplexAttribute)attribute).setSubAttribute(decoder.buildPrimitiveMultiValuedAttribute(subAttributeSchema, (JSONArray)operation.getValues()));
                        return oldResource;
                    } else {
                        if (!subAttributeSchema.getMultiValued()) return oldResource;
                        ((ComplexAttribute)attribute).setSubAttribute(decoder.buildSimpleAttribute(subAttributeSchema, operation.getValues()));
                    }
                }
            }
            return oldResource;
        } else {
            AttributeSchema attributeSchema = SchemaUtil.getAttributeSchema(attributeParts[0], schema);
            if (attributeSchema == null) throw new BadRequestException("No such attribute with the name : " + attributeParts[0], "invalidPath");
            if (attributeSchema.getType().equals((Object)SCIMDefinitions.DataType.COMPLEX)) {
                if (!attributeSchema.getMultiValued()) throw new BadRequestException("Attribute : " + attributeParts[0] + " " + "is not a multivalued attribute.", "invalidPath");
                MultiValuedAttribute multiValuedAttribute = new MultiValuedAttribute(attributeSchema.getName());
                DefaultAttributeFactory.createAttribute(attributeSchema, multiValuedAttribute);
                String complexName = attributeSchema.getName() + "_" + "default" + "_" + "default";
                ComplexAttribute complexAttribute = new ComplexAttribute(complexName);
                DefaultAttributeFactory.createAttribute(attributeSchema, complexAttribute);
                AttributeSchema subValuesSubAttributeSchema = SchemaUtil.getAttributeSchema(attributeParts[0] + "." + expressionNode.getAttributeValue(), schema);
                if (subValuesSubAttributeSchema == null) throw new BadRequestException("No such attribute with name : " + attributeParts[0] + "." + expressionNode.getAttributeValue(), "invalidPath");
                SimpleAttribute simpleAttribute = new SimpleAttribute(subValuesSubAttributeSchema.getName(), operation.getValues());
                DefaultAttributeFactory.createAttribute(subValuesSubAttributeSchema, simpleAttribute);
                complexAttribute.setSubAttribute(simpleAttribute);
                multiValuedAttribute.setAttributeValue(complexAttribute);
                oldResource.setAttribute(multiValuedAttribute);
                return oldResource;
            } else {
                if (!attributeSchema.getMultiValued()) throw new BadRequestException("Attribute : " + attributeParts[0] + " " + "is not a multivalued attribute.", "invalidPath");
                MultiValuedAttribute multiValuedAttribute = new MultiValuedAttribute(attributeSchema.getName());
                DefaultAttributeFactory.createAttribute(attributeSchema, multiValuedAttribute);
                multiValuedAttribute.setAttributePrimitiveValue(operation.getValues());
                oldResource.setAttribute(multiValuedAttribute);
            }
        }
        return oldResource;
    }

    private static AbstractSCIMObject doPatchReplaceOnResource(AbstractSCIMObject oldResource, AbstractSCIMObject copyOfOldResource, SCIMResourceTypeSchema schema, JSONDecoder decoder, PatchOperation operation) throws CharonException {
        try {
            AbstractSCIMObject attributeHoldingSCIMObject = decoder.decode(operation.getValues().toString(), schema);
            if (oldResource != null) {
                for (String attributeName : attributeHoldingSCIMObject.getAttributeList().keySet()) {
                    Attribute oldAttribute = oldResource.getAttribute(attributeName);
                    if (oldAttribute != null) {
                        if (oldAttribute.getMultiValued().booleanValue()) {
                            MultiValuedAttribute attributeValue = (MultiValuedAttribute)attributeHoldingSCIMObject.getAttribute(attributeName);
                            if (oldAttribute.getMutability().equals((Object)SCIMDefinitions.Mutability.IMMUTABLE) || oldAttribute.getMutability().equals((Object)SCIMDefinitions.Mutability.READ_ONLY)) {
                                throw new BadRequestException("Immutable or Read-Only attributes can not be modified.", "mutability");
                            }
                            oldResource.deleteAttribute(attributeName);
                            oldResource.setAttribute(attributeValue);
                            continue;
                        }
                        if (oldAttribute.getType().equals((Object)SCIMDefinitions.DataType.COMPLEX)) {
                            Map<String, Attribute> subAttributeList = ((ComplexAttribute)attributeHoldingSCIMObject.getAttribute(attributeName)).getSubAttributesList();
                            for (Map.Entry<String, Attribute> subAttrib : subAttributeList.entrySet()) {
                                Attribute subAttribute = oldAttribute.getSubAttribute(subAttrib.getKey());
                                if (subAttribute != null) {
                                    if (subAttribute.getType().equals((Object)SCIMDefinitions.DataType.COMPLEX)) {
                                        if (subAttribute.getMultiValued().booleanValue()) {
                                            MultiValuedAttribute attributeSubValue = (MultiValuedAttribute)((ComplexAttribute)attributeHoldingSCIMObject.getAttribute(attributeName)).getSubAttribute(subAttrib.getKey());
                                            if (subAttribute.getMutability().equals((Object)SCIMDefinitions.Mutability.IMMUTABLE) || subAttribute.getMutability().equals((Object)SCIMDefinitions.Mutability.READ_ONLY)) {
                                                throw new BadRequestException("Immutable or Read-Only attributes can not be modified.", "mutability");
                                            }
                                            ((ComplexAttribute)oldAttribute).removeSubAttribute(subAttribute.getName());
                                            ((ComplexAttribute)oldAttribute).setSubAttribute(attributeSubValue);
                                            continue;
                                        }
                                        Map<String, Attribute> subSubAttributeList = ((ComplexAttribute)attributeHoldingSCIMObject.getAttribute(attributeName).getSubAttribute(subAttrib.getKey())).getSubAttributesList();
                                        for (Map.Entry<String, Attribute> subSubAttrb : subSubAttributeList.entrySet()) {
                                            Attribute subSubAttribute = oldAttribute.getSubAttribute(subAttrib.getKey()).getSubAttribute(subSubAttrb.getKey());
                                            if (subSubAttribute != null) {
                                                if (subSubAttribute.getMultiValued().booleanValue()) {
                                                    if (subSubAttribute.getMutability().equals((Object)SCIMDefinitions.Mutability.IMMUTABLE) || subSubAttribute.getMutability().equals((Object)SCIMDefinitions.Mutability.READ_ONLY)) {
                                                        throw new BadRequestException("Immutable or Read-Only attributes can not be modified.", "mutability");
                                                    }
                                                    ((ComplexAttribute)oldAttribute.getSubAttribute(subAttrib.getKey())).removeSubAttribute(subSubAttribute.getName());
                                                    ((ComplexAttribute)oldAttribute.getSubAttribute(subAttrib.getKey())).setSubAttribute(subSubAttribute);
                                                    continue;
                                                }
                                                ((SimpleAttribute)subSubAttribute).setValue(((SimpleAttribute)subSubAttrb.getValue()).getValue());
                                                continue;
                                            }
                                            ((ComplexAttribute)subAttribute).setSubAttribute(subSubAttrb.getValue());
                                        }
                                        continue;
                                    }
                                    if (subAttribute.getMutability().equals((Object)SCIMDefinitions.Mutability.IMMUTABLE) || subAttribute.getMutability().equals((Object)SCIMDefinitions.Mutability.READ_ONLY)) {
                                        throw new BadRequestException("Immutable or Read-Only attributes can not be modified.", "mutability");
                                    }
                                    ((ComplexAttribute)oldAttribute).removeSubAttribute(subAttribute.getName());
                                    ((ComplexAttribute)oldAttribute).setSubAttribute(subAttributeList.get(subAttribute.getName()));
                                    continue;
                                }
                                ((ComplexAttribute)oldAttribute).setSubAttribute(subAttrib.getValue());
                            }
                            continue;
                        }
                        if (oldAttribute.getMutability().equals((Object)SCIMDefinitions.Mutability.IMMUTABLE) || oldAttribute.getMutability().equals((Object)SCIMDefinitions.Mutability.READ_ONLY)) {
                            throw new BadRequestException("Immutable or Read-Only attributes can not be modified.", "mutability");
                        }
                        ((SimpleAttribute)oldAttribute).setValue(((SimpleAttribute)attributeHoldingSCIMObject.getAttribute(oldAttribute.getName())).getValue());
                        continue;
                    }
                    oldResource.setAttribute(attributeHoldingSCIMObject.getAttributeList().get(attributeName));
                }
                AbstractSCIMObject validatedResource = ServerSideValidator.validateUpdatedSCIMObject(copyOfOldResource, oldResource, schema);
                return validatedResource;
            }
            throw new CharonException("Error in getting the old resource.");
        }
        catch (BadRequestException | CharonException e) {
            throw new CharonException("Error in performing the add operation", e);
        }
    }
}

