/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.charon3.core.protocol.endpoints;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.charon3.core.encoder.JSONDecoder;
import org.wso2.charon3.core.encoder.JSONEncoder;
import org.wso2.charon3.core.exceptions.AbstractCharonException;
import org.wso2.charon3.core.exceptions.CharonException;
import org.wso2.charon3.core.exceptions.NotFoundException;
import org.wso2.charon3.core.protocol.SCIMResponse;
import org.wso2.charon3.core.protocol.endpoints.ResourceManager;

public abstract class AbstractResourceManager
implements ResourceManager {
    private static final Logger logger = LoggerFactory.getLogger(AbstractResourceManager.class);
    private static JSONEncoder encoder = new JSONEncoder();
    private static JSONDecoder decoder = new JSONDecoder();
    private static Map<String, String> endpointURLMap;

    public static JSONEncoder getEncoder() throws CharonException {
        return encoder;
    }

    public static JSONDecoder getDecoder() throws CharonException {
        return decoder;
    }

    public static String getResourceEndpointURL(String resource) throws NotFoundException {
        if (endpointURLMap != null && endpointURLMap.size() != 0) {
            return endpointURLMap.get(resource);
        }
        throw new NotFoundException();
    }

    public static void setEndpointURLMap(Map<String, String> endpointURLMap) {
        AbstractResourceManager.endpointURLMap = endpointURLMap;
    }

    public static SCIMResponse encodeSCIMException(AbstractCharonException exception) {
        logger.debug(exception.getDetail(), (Throwable)exception);
        HashMap<String, String> responseHeaders = new HashMap<String, String>();
        responseHeaders.put("Content-Type", "application/scim+json");
        return new SCIMResponse(exception.getStatus(), encoder.encodeSCIMException(exception), responseHeaders);
    }
}

