/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.charon3.core.protocol.endpoints;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.charon3.core.attributes.Attribute;
import org.wso2.charon3.core.attributes.ComplexAttribute;
import org.wso2.charon3.core.attributes.SimpleAttribute;
import org.wso2.charon3.core.encoder.JSONEncoder;
import org.wso2.charon3.core.exceptions.BadRequestException;
import org.wso2.charon3.core.exceptions.CharonException;
import org.wso2.charon3.core.exceptions.NotFoundException;
import org.wso2.charon3.core.exceptions.NotImplementedException;
import org.wso2.charon3.core.extensions.UserManager;
import org.wso2.charon3.core.protocol.SCIMResponse;
import org.wso2.charon3.core.protocol.endpoints.AbstractResourceManager;

public class SchemaResourceManager
extends AbstractResourceManager {
    private static final Logger log = LoggerFactory.getLogger(SchemaResourceManager.class);
    private static final String ATTRIBUTES = "attributes";

    @Override
    public SCIMResponse get(String id, UserManager userManager, String attributes, String excludeAttributes) {
        try {
            List<Attribute> userSchemaAttributes = userManager.getUserSchema();
            return this.buildSchemasResponse(userSchemaAttributes);
        }
        catch (BadRequestException | CharonException | NotFoundException | NotImplementedException e) {
            return AbstractResourceManager.encodeSCIMException(e);
        }
    }

    private SCIMResponse buildSchemasResponse(List<Attribute> userSchemaAttributes) throws CharonException, NotFoundException {
        String schemaResponseBody = this.buildSchemasResponseBody(userSchemaAttributes).toString();
        Map<String, String> responseHeaders = this.getResponseHeaders();
        return new SCIMResponse(200, schemaResponseBody, responseHeaders);
    }

    private JSONArray buildSchemasResponseBody(List<Attribute> userSchemaAttributeList) throws CharonException {
        JSONArray rootObject = new JSONArray();
        JSONObject userSchemaObject = this.buildUserSchema(userSchemaAttributeList);
        rootObject.put((Object)userSchemaObject);
        return rootObject;
    }

    private JSONObject buildUserSchema(List<Attribute> userSchemaAttributeList) throws CharonException {
        try {
            JSONEncoder encoder = SchemaResourceManager.getEncoder();
            JSONObject userSchemaObject = new JSONObject();
            userSchemaObject.put("id", (Object)"urn:ietf:params:scim:schemas:core:2.0:User");
            userSchemaObject.put("name", (Object)"User");
            userSchemaObject.put("description", (Object)"User Account");
            JSONArray userSchemaAttributeArray = this.buildUserSchemaAttributeArray(userSchemaAttributeList, encoder);
            userSchemaObject.put(ATTRIBUTES, (Object)userSchemaAttributeArray);
            return userSchemaObject;
        }
        catch (JSONException e) {
            throw new CharonException("Error while encoding user schema", e);
        }
    }

    private JSONArray buildUserSchemaAttributeArray(List<Attribute> userSchemaAttributeList, JSONEncoder encoder) throws JSONException {
        JSONArray userSchemaAttributeArray = new JSONArray();
        for (Attribute userShemaAttribute : userSchemaAttributeList) {
            JSONObject userSchemaAttribute = userShemaAttribute instanceof ComplexAttribute ? encoder.encodeComplexAttributeSchema((ComplexAttribute)userShemaAttribute) : (userShemaAttribute instanceof SimpleAttribute ? encoder.encodeSimpleAttributeSchema((SimpleAttribute)userShemaAttribute) : encoder.encodeBasicAttributeSchema(userShemaAttribute));
            userSchemaAttributeArray.put((Object)userSchemaAttribute);
        }
        return userSchemaAttributeArray;
    }

    private Map<String, String> getResponseHeaders() throws NotFoundException {
        HashMap<String, String> responseHeaders = new HashMap<String, String>();
        responseHeaders.put("Content-Type", "application/scim+json");
        responseHeaders.put("Location", SchemaResourceManager.getResourceEndpointURL("/Schemas"));
        return responseHeaders;
    }

    @Override
    public SCIMResponse create(String scimObjectString, UserManager userManager, String attributes, String excludeAttributes) {
        String error = "Request is undefined";
        BadRequestException badRequestException = new BadRequestException(error, "invalidPath");
        return SchemaResourceManager.encodeSCIMException(badRequestException);
    }

    @Override
    public SCIMResponse delete(String id, UserManager userManager) {
        String error = "Request is undefined";
        BadRequestException badRequestException = new BadRequestException(error, "invalidPath");
        return SchemaResourceManager.encodeSCIMException(badRequestException);
    }

    @Override
    public SCIMResponse listWithGET(UserManager userManager, String filter, int startIndex, int count, String sortBy, String sortOrder, String domainName, String attributes, String excludeAttributes) {
        String error = "Request is undefined";
        BadRequestException badRequestException = new BadRequestException(error, "invalidPath");
        return SchemaResourceManager.encodeSCIMException(badRequestException);
    }

    @Override
    public SCIMResponse listWithGET(UserManager userManager, String filter, Integer startIndexInt, Integer countInt, String sortBy, String sortOrder, String domainName, String attributes, String excludeAttributes) {
        String error = "Request is undefined";
        BadRequestException badRequestException = new BadRequestException(error, "invalidPath");
        return SchemaResourceManager.encodeSCIMException(badRequestException);
    }

    @Override
    public SCIMResponse listWithPOST(String resourceString, UserManager userManager) {
        String error = "Request is undefined";
        BadRequestException badRequestException = new BadRequestException(error, "invalidPath");
        return SchemaResourceManager.encodeSCIMException(badRequestException);
    }

    @Override
    public SCIMResponse updateWithPUT(String existingId, String scimObjectString, UserManager userManager, String attributes, String excludeAttributes) {
        String error = "Request is undefined";
        BadRequestException badRequestException = new BadRequestException(error, "invalidPath");
        return SchemaResourceManager.encodeSCIMException(badRequestException);
    }

    @Override
    public SCIMResponse updateWithPATCH(String existingId, String scimObjectString, UserManager userManager, String attributes, String excludeAttributes) {
        String error = "Request is undefined";
        BadRequestException badRequestException = new BadRequestException(error, "invalidPath");
        return SchemaResourceManager.encodeSCIMException(badRequestException);
    }
}

