/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.charon3.core.objects;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.wso2.charon3.core.attributes.Attribute;
import org.wso2.charon3.core.attributes.ComplexAttribute;
import org.wso2.charon3.core.attributes.DefaultAttributeFactory;
import org.wso2.charon3.core.attributes.MultiValuedAttribute;
import org.wso2.charon3.core.attributes.SimpleAttribute;
import org.wso2.charon3.core.exceptions.BadRequestException;
import org.wso2.charon3.core.exceptions.CharonException;
import org.wso2.charon3.core.objects.AbstractSCIMObject;
import org.wso2.charon3.core.objects.Group;
import org.wso2.charon3.core.objects.plainobjects.MultiValuedComplexType;
import org.wso2.charon3.core.objects.plainobjects.ScimAddress;
import org.wso2.charon3.core.objects.plainobjects.ScimName;
import org.wso2.charon3.core.schema.AttributeSchema;
import org.wso2.charon3.core.schema.SCIMAttributeSchema;
import org.wso2.charon3.core.schema.SCIMResourceSchemaManager;
import org.wso2.charon3.core.schema.SCIMResourceTypeSchema;
import org.wso2.charon3.core.schema.SCIMSchemaDefinitions;
import org.wso2.charon3.core.utils.LambdaExceptionUtils;

public class User
extends AbstractSCIMObject {
    private static final long serialVersionUID = 6106269076155338045L;

    public String getUsername() {
        SCIMAttributeSchema attributeDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.USERNAME;
        return this.getSimpleAttribute(attributeDefinition).map(LambdaExceptionUtils.rethrowFunction(SimpleAttribute::getStringValue)).orElse(null);
    }

    public void replaceUsername(String username) {
        this.replaceSimpleAttribute(SCIMSchemaDefinitions.SCIMUserSchemaDefinition.USERNAME, username);
    }

    public String getDisplayName() {
        SCIMAttributeSchema attributeDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.DISPLAY_NAME;
        return this.getSimpleAttribute(attributeDefinition).map(simpleAttribute -> this.stripToNull(LambdaExceptionUtils.rethrowFunction(SimpleAttribute::getStringValue).apply((SimpleAttribute)simpleAttribute))).orElse(null);
    }

    public void replaceDisplayName(String displayName) {
        this.replaceSimpleAttribute(SCIMSchemaDefinitions.SCIMUserSchemaDefinition.DISPLAY_NAME, displayName);
    }

    public String getNickName() {
        SCIMAttributeSchema attributeDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.NICK_NAME;
        return this.getSimpleAttribute(attributeDefinition).map(simpleAttribute -> this.stripToNull(LambdaExceptionUtils.rethrowFunction(SimpleAttribute::getStringValue).apply((SimpleAttribute)simpleAttribute))).orElse(null);
    }

    public void replaceNickName(String nickName) {
        this.replaceSimpleAttribute(SCIMSchemaDefinitions.SCIMUserSchemaDefinition.NICK_NAME, nickName);
    }

    public String getProfileUrl() {
        SCIMAttributeSchema attributeDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.PROFILE_URL;
        return this.getSimpleAttribute(attributeDefinition).map(simpleAttribute -> this.stripToNull((String)simpleAttribute.getValue())).orElse(null);
    }

    public void replaceProfileUrl(String profileUrl) {
        this.replaceSimpleAttribute(SCIMSchemaDefinitions.SCIMUserSchemaDefinition.PROFILE_URL, profileUrl);
    }

    public String getUserType() {
        SCIMAttributeSchema attributeDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.USER_TYPE;
        return this.getSimpleAttribute(attributeDefinition).map(simpleAttribute -> this.stripToNull(LambdaExceptionUtils.rethrowFunction(SimpleAttribute::getStringValue).apply((SimpleAttribute)simpleAttribute))).orElse(null);
    }

    public void replaceUserType(String userType) {
        this.replaceSimpleAttribute(SCIMSchemaDefinitions.SCIMUserSchemaDefinition.USER_TYPE, userType);
    }

    public String getTitle() {
        SCIMAttributeSchema attributeDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.TITLE;
        return this.getSimpleAttribute(attributeDefinition).map(simpleAttribute -> this.stripToNull(LambdaExceptionUtils.rethrowFunction(SimpleAttribute::getStringValue).apply((SimpleAttribute)simpleAttribute))).orElse(null);
    }

    public void replaceTitle(String title) {
        this.replaceSimpleAttribute(SCIMSchemaDefinitions.SCIMUserSchemaDefinition.TITLE, title);
    }

    public String getPreferredLanguage() {
        SCIMAttributeSchema attributeDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.PREFERRED_LANGUAGE;
        return this.getSimpleAttribute(attributeDefinition).map(simpleAttribute -> this.stripToNull(LambdaExceptionUtils.rethrowFunction(SimpleAttribute::getStringValue).apply((SimpleAttribute)simpleAttribute))).orElse(null);
    }

    public void setPreferredLanguage(String preferredLanguage) {
        this.replaceSimpleAttribute(SCIMSchemaDefinitions.SCIMUserSchemaDefinition.PREFERRED_LANGUAGE, preferredLanguage);
    }

    public void replacePreferredLanguage(String preferredLanguage) {
        this.replaceSimpleAttribute(SCIMSchemaDefinitions.SCIMUserSchemaDefinition.PREFERRED_LANGUAGE, preferredLanguage);
    }

    public String getLocale() {
        SCIMAttributeSchema attributeDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.LOCALE;
        return this.getSimpleAttribute(attributeDefinition).map(simpleAttribute -> this.stripToNull(LambdaExceptionUtils.rethrowFunction(SimpleAttribute::getStringValue).apply((SimpleAttribute)simpleAttribute))).orElse(null);
    }

    public void replaceLocale(String locale) {
        this.replaceSimpleAttribute(SCIMSchemaDefinitions.SCIMUserSchemaDefinition.LOCALE, locale);
    }

    public String getTimezone() {
        SCIMAttributeSchema attributeDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.TIME_ZONE;
        return this.getSimpleAttribute(attributeDefinition).map(simpleAttribute -> this.stripToNull(LambdaExceptionUtils.rethrowFunction(SimpleAttribute::getStringValue).apply((SimpleAttribute)simpleAttribute))).orElse(null);
    }

    public void setTimezone(String timezone) {
        this.replaceSimpleAttribute(SCIMSchemaDefinitions.SCIMUserSchemaDefinition.TIME_ZONE, timezone);
    }

    public void replaceTimezone(String timezone) {
        this.replaceSimpleAttribute(SCIMSchemaDefinitions.SCIMUserSchemaDefinition.TIME_ZONE, timezone);
    }

    public boolean getActive() {
        SCIMAttributeSchema attributeDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.ACTIVE;
        return this.getSimpleAttribute(attributeDefinition).map(simpleAttribute -> LambdaExceptionUtils.rethrowFunction(SimpleAttribute::getBooleanValue).apply((SimpleAttribute)simpleAttribute)).orElse(false);
    }

    public void replaceActive(boolean active) {
        this.replaceSimpleAttribute(SCIMSchemaDefinitions.SCIMUserSchemaDefinition.ACTIVE, active);
    }

    public ScimName getName() {
        SCIMAttributeSchema nameDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.NAME;
        SCIMAttributeSchema formattedDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.FORMATTED;
        SCIMAttributeSchema givenNameDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.GIVEN_NAME;
        SCIMAttributeSchema familynameDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.FAMILY_NAME;
        SCIMAttributeSchema middleNameDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.MIDDLE_NAME;
        SCIMAttributeSchema honorificPrefixDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.HONORIFIC_PREFIX;
        SCIMAttributeSchema honorificSuffixDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.HONORIFIC_SUFFIX;
        return this.getComplexAttribute(nameDefinition).map(name -> {
            ScimName scimName = new ScimName();
            this.getSimpleAttributeValue(formattedDefinition, (ComplexAttribute)name).ifPresent(scimName::setFormatted);
            this.getSimpleAttributeValue(givenNameDefinition, (ComplexAttribute)name).ifPresent(scimName::setGivenName);
            this.getSimpleAttributeValue(familynameDefinition, (ComplexAttribute)name).ifPresent(scimName::setFamilyName);
            this.getSimpleAttributeValue(middleNameDefinition, (ComplexAttribute)name).ifPresent(scimName::setMiddleName);
            this.getSimpleAttributeValue(honorificPrefixDefinition, (ComplexAttribute)name).ifPresent(scimName::setHonorificPrefix);
            this.getSimpleAttributeValue(honorificSuffixDefinition, (ComplexAttribute)name).ifPresent(scimName::setHonorificSuffix);
            if (this.isBlank(scimName.getFormatted()) && this.isBlank(scimName.getFamilyName()) && this.isBlank(scimName.getGivenName()) && this.isBlank(scimName.getMiddleName()) && this.isBlank(scimName.getHonorificPrefix()) && this.isBlank(scimName.getHonorificSuffix())) {
                return null;
            }
            return scimName;
        }).orElse(null);
    }

    public void replaceName(ScimName scimName) {
        SCIMAttributeSchema nameDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.NAME;
        SCIMAttributeSchema formattedDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.FORMATTED;
        SCIMAttributeSchema givenNameDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.GIVEN_NAME;
        SCIMAttributeSchema familynameDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.FAMILY_NAME;
        SCIMAttributeSchema middleNameDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.MIDDLE_NAME;
        SCIMAttributeSchema honorificPrefixDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.HONORIFIC_PREFIX;
        SCIMAttributeSchema honorificSuffixDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.HONORIFIC_SUFFIX;
        ComplexAttribute name = new ComplexAttribute(nameDefinition.getName());
        LambdaExceptionUtils.rethrowBiConsumer(DefaultAttributeFactory::createAttribute).accept(nameDefinition, name);
        BiConsumer<AttributeSchema, Supplier> writeAttribute = (attributeSchema, stringSupplier) -> {
            if (this.isNotBlank((String)stringSupplier.get())) {
                SimpleAttribute attribute = new SimpleAttribute(attributeSchema.getName(), stringSupplier.get());
                LambdaExceptionUtils.rethrowBiConsumer(DefaultAttributeFactory::createAttribute).accept((AttributeSchema)attributeSchema, attribute);
                LambdaExceptionUtils.rethrowConsumer(name::setSubAttribute).accept(attribute);
            }
        };
        writeAttribute.accept(formattedDefinition, scimName::getFormatted);
        writeAttribute.accept(familynameDefinition, scimName::getFamilyName);
        writeAttribute.accept(givenNameDefinition, scimName::getGivenName);
        writeAttribute.accept(middleNameDefinition, scimName::getMiddleName);
        writeAttribute.accept(honorificPrefixDefinition, scimName::getHonorificPrefix);
        writeAttribute.accept(honorificSuffixDefinition, scimName::getHonorificSuffix);
        if (name.getSubAttributesList().isEmpty()) {
            this.deleteAttribute(nameDefinition.getName());
        } else {
            this.deleteAttribute(nameDefinition.getName());
            this.setAttribute(name);
        }
    }

    public List<MultiValuedComplexType> getEmails() {
        SCIMAttributeSchema complexDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.EMAILS;
        SCIMAttributeSchema valueDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.EMAIL_VALUE;
        SCIMAttributeSchema displayDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.EMAIL_DISPLAY;
        SCIMAttributeSchema typeDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.EMAIL_TYPE;
        SCIMAttributeSchema primaryDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.EMAIL_PRIMARY;
        return this.getMultivaluedComplexType(complexDefinition, valueDefinition, displayDefinition, typeDefinition, primaryDefinition, null).orElse(Collections.emptyList());
    }

    public void replaceEmails(List<MultiValuedComplexType> multiValuedComplexTypeList) {
        SCIMAttributeSchema complexDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.EMAILS;
        SCIMAttributeSchema valueDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.EMAIL_VALUE;
        SCIMAttributeSchema displayDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.EMAIL_DISPLAY;
        SCIMAttributeSchema typeDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.EMAIL_TYPE;
        SCIMAttributeSchema primaryDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.EMAIL_PRIMARY;
        this.addMultivaluedComplexAtribute(multiValuedComplexTypeList, complexDefinition, valueDefinition, displayDefinition, typeDefinition, primaryDefinition, null);
    }

    public List<MultiValuedComplexType> getPhoneNumbers() {
        SCIMAttributeSchema complexDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.PHONE_NUMBERS;
        SCIMAttributeSchema valueDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.PHONE_NUMBERS_VALUE;
        SCIMAttributeSchema displayDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.PHONE_NUMBERS_DISPLAY;
        SCIMAttributeSchema typeDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.PHONE_NUMBERS_TYPE;
        SCIMAttributeSchema primaryDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.PHONE_NUMBERS_PRIMARY;
        return this.getMultivaluedComplexType(complexDefinition, valueDefinition, displayDefinition, typeDefinition, primaryDefinition, null).orElse(Collections.emptyList());
    }

    public void replacePhoneNumbers(List<MultiValuedComplexType> multiValuedComplexTypeList) {
        SCIMAttributeSchema complexDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.PHONE_NUMBERS;
        SCIMAttributeSchema valueDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.PHONE_NUMBERS_VALUE;
        SCIMAttributeSchema displayDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.PHONE_NUMBERS_DISPLAY;
        SCIMAttributeSchema typeDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.PHONE_NUMBERS_TYPE;
        SCIMAttributeSchema primaryDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.PHONE_NUMBERS_PRIMARY;
        this.addMultivaluedComplexAtribute(multiValuedComplexTypeList, complexDefinition, valueDefinition, displayDefinition, typeDefinition, primaryDefinition, null);
    }

    public List<MultiValuedComplexType> getInstantMessagingAddresses() {
        SCIMAttributeSchema complexDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.IMS;
        SCIMAttributeSchema valueDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.IMS_VALUE;
        SCIMAttributeSchema displayDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.IMS_DISPLAY;
        SCIMAttributeSchema typeDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.IMS_TYPE;
        SCIMAttributeSchema primaryDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.IMS_PRIMARY;
        return this.getMultivaluedComplexType(complexDefinition, valueDefinition, displayDefinition, typeDefinition, primaryDefinition, null).orElse(Collections.emptyList());
    }

    public void replaceInstantMessagingAddresses(List<MultiValuedComplexType> multiValuedComplexTypeList) {
        SCIMAttributeSchema complexDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.IMS;
        SCIMAttributeSchema valueDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.IMS_VALUE;
        SCIMAttributeSchema displayDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.IMS_DISPLAY;
        SCIMAttributeSchema typeDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.IMS_TYPE;
        SCIMAttributeSchema primaryDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.IMS_PRIMARY;
        this.addMultivaluedComplexAtribute(multiValuedComplexTypeList, complexDefinition, valueDefinition, displayDefinition, typeDefinition, primaryDefinition, null);
    }

    public List<MultiValuedComplexType> getPhotos() {
        SCIMAttributeSchema complexDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.PHOTOS;
        SCIMAttributeSchema valueDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.PHOTOS_VALUE;
        SCIMAttributeSchema displayDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.PHOTOS_DISPLAY;
        SCIMAttributeSchema typeDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.PHOTOS_TYPE;
        SCIMAttributeSchema primaryDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.PHOTOS_PRIMARY;
        return this.getMultivaluedComplexType(complexDefinition, valueDefinition, displayDefinition, typeDefinition, primaryDefinition, null).orElse(Collections.emptyList());
    }

    public void replacePhotos(List<MultiValuedComplexType> multiValuedComplexTypeList) {
        SCIMAttributeSchema complexDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.PHOTOS;
        SCIMAttributeSchema valueDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.PHOTOS_VALUE;
        SCIMAttributeSchema displayDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.PHOTOS_DISPLAY;
        SCIMAttributeSchema typeDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.PHOTOS_TYPE;
        SCIMAttributeSchema primaryDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.PHOTOS_PRIMARY;
        this.addMultivaluedComplexAtribute(multiValuedComplexTypeList, complexDefinition, valueDefinition, displayDefinition, typeDefinition, primaryDefinition, null);
    }

    public List<MultiValuedComplexType> getX509Certificates() {
        SCIMAttributeSchema complexDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.X509CERTIFICATES;
        SCIMAttributeSchema valueDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.X509CERTIFICATES_VALUE;
        SCIMAttributeSchema displayDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.X509CERTIFICATES_DISPLAY;
        SCIMAttributeSchema typeDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.X509CERTIFICATES_TYPE;
        SCIMAttributeSchema primaryDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.X509CERTIFICATES_PRIMARY;
        return this.getMultivaluedComplexType(complexDefinition, valueDefinition, displayDefinition, typeDefinition, primaryDefinition, null).orElse(Collections.emptyList());
    }

    public void replaceX509Certificates(List<MultiValuedComplexType> multiValuedComplexTypeList) {
        SCIMAttributeSchema complexDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.X509CERTIFICATES;
        SCIMAttributeSchema valueDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.X509CERTIFICATES_VALUE;
        SCIMAttributeSchema displayDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.X509CERTIFICATES_DISPLAY;
        SCIMAttributeSchema typeDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.X509CERTIFICATES_TYPE;
        SCIMAttributeSchema primaryDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.X509CERTIFICATES_PRIMARY;
        this.addMultivaluedComplexAtribute(multiValuedComplexTypeList, complexDefinition, valueDefinition, displayDefinition, typeDefinition, primaryDefinition, null);
    }

    public List<MultiValuedComplexType> getGroups() {
        SCIMAttributeSchema complexDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.GROUPS;
        SCIMAttributeSchema valueDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.GROUP_VALUE;
        SCIMAttributeSchema displayDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.GROUP_DISPLAY;
        SCIMAttributeSchema typeDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.GROUP_TYPE;
        SCIMAttributeSchema referenceDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.GROUP_REF;
        return this.getMultivaluedComplexType(complexDefinition, valueDefinition, displayDefinition, typeDefinition, null, referenceDefinition).orElse(Collections.emptyList());
    }

    public void replaceGroups(List<MultiValuedComplexType> multiValuedComplexTypeList) {
        SCIMAttributeSchema complexDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.GROUPS;
        SCIMAttributeSchema valueDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.GROUP_VALUE;
        SCIMAttributeSchema displayDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.GROUP_DISPLAY;
        SCIMAttributeSchema typeDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.GROUP_TYPE;
        SCIMAttributeSchema referenceDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.GROUP_REF;
        this.addMultivaluedComplexAtribute(multiValuedComplexTypeList, complexDefinition, valueDefinition, displayDefinition, typeDefinition, null, referenceDefinition);
    }

    public List<MultiValuedComplexType> getRoles() {
        SCIMAttributeSchema complexDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.ROLES;
        SCIMAttributeSchema valueDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.ROLES_VALUE;
        SCIMAttributeSchema displayDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.ROLES_DISPLAY;
        SCIMAttributeSchema typeDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.ROLES_TYPE;
        return this.getMultivaluedComplexType(complexDefinition, valueDefinition, displayDefinition, typeDefinition, null, null).orElse(Collections.emptyList());
    }

    public void replaceRoles(List<MultiValuedComplexType> multiValuedComplexTypeList) {
        SCIMAttributeSchema complexDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.ROLES;
        SCIMAttributeSchema valueDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.ROLES_VALUE;
        SCIMAttributeSchema displayDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.ROLES_DISPLAY;
        SCIMAttributeSchema typeDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.ROLES_TYPE;
        this.addMultivaluedComplexAtribute(multiValuedComplexTypeList, complexDefinition, valueDefinition, displayDefinition, typeDefinition, null, null);
    }

    public List<ScimAddress> getAddresses() {
        SCIMAttributeSchema multiValuedDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.ADDRESSES;
        SCIMAttributeSchema formattedDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.ADDRESSES_FORMATTED;
        SCIMAttributeSchema streetAddressDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.ADDRESSES_STREET_ADDRESS;
        SCIMAttributeSchema typeDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.ADDRESSES_TYPE;
        SCIMAttributeSchema primaryDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.ADDRESSES_PRIMARY;
        SCIMAttributeSchema localityDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.ADDRESSES_LOCALITY;
        SCIMAttributeSchema regionDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.ADDRESSES_REGION;
        SCIMAttributeSchema postalCodeDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.ADDRESSES_POSTAL_CODE;
        SCIMAttributeSchema countryDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.ADDRESSES_COUNTRY;
        return this.getMultiValuedAttribute(multiValuedDefinition).map(multiValuedAttribute -> {
            ArrayList<ScimAddress> multiValuedComplexTypes = new ArrayList<ScimAddress>();
            for (Attribute attributeValue : multiValuedAttribute.getAttributeValues()) {
                ComplexAttribute complexAttribute = (ComplexAttribute)attributeValue;
                ScimAddress address = new ScimAddress();
                this.getSimpleAttributeValue(formattedDefinition, complexAttribute).ifPresent(address::setFormatted);
                this.getSimpleAttributeValue(streetAddressDefinition, complexAttribute).ifPresent(address::setStreetAddress);
                this.getSimpleAttributeValue(typeDefinition, complexAttribute).ifPresent(address::setType);
                this.getSimpleAttribute(primaryDefinition, complexAttribute).map(LambdaExceptionUtils.rethrowFunction(SimpleAttribute::getBooleanValue)).ifPresent(address::setPrimary);
                this.getSimpleAttributeValue(localityDefinition, complexAttribute).ifPresent(address::setLocality);
                this.getSimpleAttributeValue(regionDefinition, complexAttribute).ifPresent(address::setRegion);
                this.getSimpleAttributeValue(postalCodeDefinition, complexAttribute).ifPresent(address::setPostalCode);
                this.getSimpleAttributeValue(countryDefinition, complexAttribute).ifPresent(address::setCountry);
                if (this.isBlank(address.getFormatted()) && this.isBlank(address.getStreetAddress()) && this.isBlank(address.getLocality()) && this.isBlank(address.getRegion()) && this.isBlank(address.getPostalCode()) && this.isBlank(address.getCountry()) && this.isBlank(address.getType()) && !address.isPrimary()) continue;
                multiValuedComplexTypes.add(address);
            }
            return multiValuedComplexTypes;
        }).orElse(Collections.emptyList());
    }

    public void replaceAddresses(List<ScimAddress> addressList) {
        SCIMAttributeSchema addressDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.ADDRESSES;
        SCIMAttributeSchema formattedDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.ADDRESSES_FORMATTED;
        SCIMAttributeSchema streetAddressDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.ADDRESSES_STREET_ADDRESS;
        SCIMAttributeSchema typeDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.ADDRESSES_TYPE;
        SCIMAttributeSchema primaryDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.ADDRESSES_PRIMARY;
        SCIMAttributeSchema localityDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.ADDRESSES_LOCALITY;
        SCIMAttributeSchema regionDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.ADDRESSES_REGION;
        SCIMAttributeSchema postalCodeDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.ADDRESSES_POSTAL_CODE;
        SCIMAttributeSchema countryDefinition = SCIMSchemaDefinitions.SCIMUserSchemaDefinition.ADDRESSES_COUNTRY;
        this.deleteAttribute(addressDefinition.getName());
        MultiValuedAttribute multivaluedAddressAttribute = new MultiValuedAttribute(addressDefinition.getName());
        LambdaExceptionUtils.rethrowBiConsumer(DefaultAttributeFactory::createAttribute).accept(addressDefinition, multivaluedAddressAttribute);
        addressList.forEach(address -> {
            ComplexAttribute complexAttribute = new ComplexAttribute(addressDefinition.getName());
            BiConsumer<SCIMAttributeSchema, Supplier<Object>> setSubAttribute = this.getSetSubAttributeConsumer(complexAttribute);
            setSubAttribute.accept(formattedDefinition, address::getFormatted);
            setSubAttribute.accept(streetAddressDefinition, address::getStreetAddress);
            setSubAttribute.accept(localityDefinition, address::getLocality);
            setSubAttribute.accept(regionDefinition, address::getRegion);
            setSubAttribute.accept(postalCodeDefinition, address::getPostalCode);
            setSubAttribute.accept(countryDefinition, address::getCountry);
            setSubAttribute.accept(typeDefinition, address::getType);
            setSubAttribute.accept(primaryDefinition, () -> address.isPrimary() ? Boolean.valueOf(true) : null);
            multivaluedAddressAttribute.setAttributeValue(complexAttribute);
        });
        this.setAttribute(multivaluedAddressAttribute);
    }

    public String getUserName() throws CharonException {
        return this.getSimpleAttributeStringVal("userName");
    }

    public void setUserName(String userName) throws CharonException, BadRequestException {
        this.setSimpleAttribute("userName", SCIMSchemaDefinitions.SCIMUserSchemaDefinition.USERNAME, userName);
    }

    public void replaceUserName(String username) {
        this.replaceSimpleAttribute(SCIMSchemaDefinitions.SCIMUserSchemaDefinition.USERNAME, username);
    }

    public String getPassword() throws CharonException {
        return this.getSimpleAttributeStringVal("password");
    }

    public void setPassword(String password) throws CharonException, BadRequestException {
        this.setSimpleAttribute("password", SCIMSchemaDefinitions.SCIMUserSchemaDefinition.PASSWORD, password);
    }

    private void setSimpleAttribute(String attributeName, AttributeSchema attributeSchema, Object value) throws CharonException, BadRequestException {
        if (this.isAttributeExist(attributeName)) {
            ((SimpleAttribute)this.attributeList.get(attributeName)).updateValue(value);
        } else {
            SimpleAttribute simpleAttribute = new SimpleAttribute(attributeName, value);
            simpleAttribute = (SimpleAttribute)DefaultAttributeFactory.createAttribute(attributeSchema, simpleAttribute);
            this.attributeList.put(attributeName, simpleAttribute);
        }
    }

    private String getSimpleAttributeStringVal(String attributeName) throws CharonException {
        return this.isAttributeExist(attributeName) ? ((SimpleAttribute)this.attributeList.get(attributeName)).getStringValue() : null;
    }

    @Deprecated
    public void setGroup(String type, String value, String display) throws CharonException, BadRequestException {
        SimpleAttribute typeSimpleAttribute = null;
        SimpleAttribute valueSimpleAttribute = null;
        SimpleAttribute displaySimpleAttribute = null;
        ComplexAttribute complexAttribute = new ComplexAttribute();
        if (type != null) {
            typeSimpleAttribute = new SimpleAttribute("type", type);
            typeSimpleAttribute = (SimpleAttribute)DefaultAttributeFactory.createAttribute(SCIMSchemaDefinitions.SCIMUserSchemaDefinition.GROUP_TYPE, typeSimpleAttribute);
            complexAttribute.setSubAttribute(typeSimpleAttribute);
        }
        if (value != null) {
            valueSimpleAttribute = new SimpleAttribute("value", value);
            valueSimpleAttribute = (SimpleAttribute)DefaultAttributeFactory.createAttribute(SCIMSchemaDefinitions.SCIMUserSchemaDefinition.GROUP_VALUE, valueSimpleAttribute);
            complexAttribute.setSubAttribute(valueSimpleAttribute);
        }
        if (display != null) {
            displaySimpleAttribute = new SimpleAttribute("display", display);
            displaySimpleAttribute = (SimpleAttribute)DefaultAttributeFactory.createAttribute(SCIMSchemaDefinitions.SCIMUserSchemaDefinition.GROUP_DISPLAY, displaySimpleAttribute);
            complexAttribute.setSubAttribute(displaySimpleAttribute);
        }
        if (complexAttribute.getSubAttributesList().size() != 0) {
            Object typeVal = "default";
            Object valueVal = "default";
            if (typeSimpleAttribute != null && typeSimpleAttribute.getValue() != null) {
                typeVal = typeSimpleAttribute.getValue();
            }
            if (valueSimpleAttribute != null && valueSimpleAttribute.getValue() != null) {
                valueVal = valueSimpleAttribute.getValue();
            }
            String complexAttributeName = "groups_" + valueVal + "_" + typeVal;
            complexAttribute.setName(complexAttributeName);
            DefaultAttributeFactory.createAttribute(SCIMSchemaDefinitions.SCIMUserSchemaDefinition.GROUPS, complexAttribute);
            this.setGroup(complexAttribute);
        }
    }

    private void setGroup(ComplexAttribute groupPropertiesAttribute) throws CharonException, BadRequestException {
        if (this.attributeList.containsKey("groups")) {
            MultiValuedAttribute groupsAttribute = (MultiValuedAttribute)this.attributeList.get("groups");
            groupsAttribute.setAttributeValue(groupPropertiesAttribute);
        } else {
            MultiValuedAttribute groupsAttribute = new MultiValuedAttribute("groups");
            groupsAttribute.setAttributeValue(groupPropertiesAttribute);
            groupsAttribute = (MultiValuedAttribute)DefaultAttributeFactory.createAttribute(SCIMSchemaDefinitions.SCIMUserSchemaDefinition.GROUPS, groupsAttribute);
            this.attributeList.put("groups", groupsAttribute);
        }
    }

    public void setGroup(String type, Group group) throws CharonException, BadRequestException {
        SimpleAttribute typeSimpleAttribute = null;
        SimpleAttribute valueSimpleAttribute = null;
        SimpleAttribute displaySimpleAttribute = null;
        SimpleAttribute referenceSimpleAttribute = null;
        String reference = group.getLocation();
        String value = group.getId();
        String display = group.getDisplayName();
        ComplexAttribute complexAttribute = new ComplexAttribute();
        if (type != null) {
            typeSimpleAttribute = new SimpleAttribute("type", type);
            typeSimpleAttribute = (SimpleAttribute)DefaultAttributeFactory.createAttribute(SCIMSchemaDefinitions.SCIMUserSchemaDefinition.GROUP_TYPE, typeSimpleAttribute);
            complexAttribute.setSubAttribute(typeSimpleAttribute);
        }
        if (value != null) {
            valueSimpleAttribute = new SimpleAttribute("value", value);
            valueSimpleAttribute = (SimpleAttribute)DefaultAttributeFactory.createAttribute(SCIMSchemaDefinitions.SCIMUserSchemaDefinition.GROUP_VALUE, valueSimpleAttribute);
            complexAttribute.setSubAttribute(valueSimpleAttribute);
        }
        if (reference != null) {
            referenceSimpleAttribute = new SimpleAttribute("$ref", reference);
            DefaultAttributeFactory.createAttribute(SCIMSchemaDefinitions.SCIMGroupSchemaDefinition.REF, referenceSimpleAttribute);
            complexAttribute.setSubAttribute(referenceSimpleAttribute);
        }
        if (display != null) {
            displaySimpleAttribute = new SimpleAttribute("display", display);
            displaySimpleAttribute = (SimpleAttribute)DefaultAttributeFactory.createAttribute(SCIMSchemaDefinitions.SCIMUserSchemaDefinition.GROUP_DISPLAY, displaySimpleAttribute);
            complexAttribute.setSubAttribute(displaySimpleAttribute);
        }
        if (complexAttribute.getSubAttributesList().size() != 0) {
            Object typeVal = "default";
            Object valueVal = "default";
            if (typeSimpleAttribute != null && typeSimpleAttribute.getValue() != null) {
                typeVal = typeSimpleAttribute.getValue();
            }
            if (valueSimpleAttribute != null && valueSimpleAttribute.getValue() != null) {
                valueVal = valueSimpleAttribute.getValue();
            }
            String complexAttributeName = "groups_" + valueVal + "_" + typeVal;
            complexAttribute.setName(complexAttributeName);
            DefaultAttributeFactory.createAttribute(SCIMSchemaDefinitions.SCIMUserSchemaDefinition.GROUPS, complexAttribute);
            this.setGroup(complexAttribute);
        }
    }

    public void setSchemas() {
        SCIMResourceTypeSchema schema = SCIMResourceSchemaManager.getInstance().getUserResourceSchema();
        List<String> schemasList = schema.getSchemasList();
        for (String scheme : schemasList) {
            this.setSchema(scheme);
        }
    }
}

