/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.charon3.core.protocol.endpoints;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.charon3.core.attributes.Attribute;
import org.wso2.charon3.core.encoder.JSONDecoder;
import org.wso2.charon3.core.encoder.JSONEncoder;
import org.wso2.charon3.core.exceptions.BadRequestException;
import org.wso2.charon3.core.exceptions.CharonException;
import org.wso2.charon3.core.exceptions.ConflictException;
import org.wso2.charon3.core.exceptions.InternalErrorException;
import org.wso2.charon3.core.exceptions.NotFoundException;
import org.wso2.charon3.core.exceptions.NotImplementedException;
import org.wso2.charon3.core.extensions.UserManager;
import org.wso2.charon3.core.objects.Group;
import org.wso2.charon3.core.objects.ListedResource;
import org.wso2.charon3.core.protocol.SCIMResponse;
import org.wso2.charon3.core.protocol.endpoints.AbstractResourceManager;
import org.wso2.charon3.core.schema.SCIMResourceSchemaManager;
import org.wso2.charon3.core.schema.SCIMResourceTypeSchema;
import org.wso2.charon3.core.schema.SCIMSchemaDefinitions;
import org.wso2.charon3.core.schema.ServerSideValidator;
import org.wso2.charon3.core.utils.CopyUtil;
import org.wso2.charon3.core.utils.PatchOperationUtil;
import org.wso2.charon3.core.utils.ResourceManagerUtil;
import org.wso2.charon3.core.utils.codeutils.FilterTreeManager;
import org.wso2.charon3.core.utils.codeutils.Node;
import org.wso2.charon3.core.utils.codeutils.PatchOperation;
import org.wso2.charon3.core.utils.codeutils.SearchRequest;

public class GroupResourceManager
extends AbstractResourceManager {
    private static final Logger logger = LoggerFactory.getLogger(GroupResourceManager.class);

    @Override
    public SCIMResponse get(String id, UserManager userManager, String attributes, String excludeAttributes) {
        JSONEncoder encoder = null;
        try {
            encoder = GroupResourceManager.getEncoder();
            SCIMResourceTypeSchema schema = SCIMResourceSchemaManager.getInstance().getGroupResourceSchema();
            Map<String, Boolean> requiredAttributes = ResourceManagerUtil.getOnlyRequiredAttributesURIs((SCIMResourceTypeSchema)CopyUtil.deepCopy(schema), attributes, excludeAttributes);
            Group group = userManager.getGroup(id, requiredAttributes);
            if (group == null) {
                String message = "Group not found in the user store.";
                throw new NotFoundException(message);
            }
            ServerSideValidator.validateRetrievedSCIMObjectInList(group, schema, attributes, excludeAttributes);
            String encodedGroup = encoder.encodeSCIMObject(group);
            HashMap<String, String> httpHeaders = new HashMap<String, String>();
            httpHeaders.put("Content-Type", "application/scim+json");
            return new SCIMResponse(200, encodedGroup, httpHeaders);
        }
        catch (NotFoundException e) {
            return GroupResourceManager.encodeSCIMException(e);
        }
        catch (BadRequestException e) {
            return GroupResourceManager.encodeSCIMException(e);
        }
        catch (CharonException e) {
            return GroupResourceManager.encodeSCIMException(e);
        }
        catch (NotImplementedException e) {
            return GroupResourceManager.encodeSCIMException(e);
        }
    }

    @Override
    public SCIMResponse create(String scimObjectString, UserManager userManager, String attributes, String excludeAttributes) {
        JSONEncoder encoder = null;
        JSONDecoder decoder = null;
        try {
            encoder = GroupResourceManager.getEncoder();
            decoder = GroupResourceManager.getDecoder();
            SCIMResourceTypeSchema schema = SCIMResourceSchemaManager.getInstance().getGroupResourceSchema();
            Map<String, Boolean> requiredAttributes = ResourceManagerUtil.getOnlyRequiredAttributesURIs((SCIMResourceTypeSchema)CopyUtil.deepCopy(schema), attributes, excludeAttributes);
            Group group = decoder.decodeResource(scimObjectString, schema, new Group());
            ServerSideValidator.validateCreatedSCIMObject(group, SCIMSchemaDefinitions.SCIM_GROUP_SCHEMA);
            Group createdGroup = userManager.createGroup(group, requiredAttributes);
            HashMap<String, String> httpHeaders = new HashMap<String, String>();
            if (createdGroup == null) {
                String message = "Newly created Group resource is null..";
                throw new InternalErrorException(message);
            }
            String encodedGroup = encoder.encodeSCIMObject(createdGroup);
            httpHeaders.put("Location", GroupResourceManager.getResourceEndpointURL("/Groups") + "/" + createdGroup.getId());
            httpHeaders.put("Content-Type", "application/scim+json");
            return new SCIMResponse(201, encodedGroup, httpHeaders);
        }
        catch (InternalErrorException e) {
            return GroupResourceManager.encodeSCIMException(e);
        }
        catch (BadRequestException e) {
            return GroupResourceManager.encodeSCIMException(e);
        }
        catch (ConflictException e) {
            return GroupResourceManager.encodeSCIMException(e);
        }
        catch (CharonException e) {
            return GroupResourceManager.encodeSCIMException(e);
        }
        catch (NotFoundException e) {
            return GroupResourceManager.encodeSCIMException(e);
        }
        catch (NotImplementedException e) {
            return GroupResourceManager.encodeSCIMException(e);
        }
    }

    @Override
    public SCIMResponse delete(String id, UserManager userManager) {
        Object encoder = null;
        try {
            if (userManager != null) {
                userManager.deleteGroup(id);
                return new SCIMResponse(204, null, null);
            }
            String error = "Provided user manager handler is null.";
            throw new InternalErrorException(error);
        }
        catch (InternalErrorException e) {
            return GroupResourceManager.encodeSCIMException(e);
        }
        catch (CharonException e) {
            return GroupResourceManager.encodeSCIMException(e);
        }
        catch (NotFoundException e) {
            return GroupResourceManager.encodeSCIMException(e);
        }
        catch (NotImplementedException e) {
            return GroupResourceManager.encodeSCIMException(e);
        }
        catch (BadRequestException e) {
            return GroupResourceManager.encodeSCIMException(e);
        }
    }

    @Override
    public SCIMResponse listWithGET(UserManager userManager, String filter, int startIndex, int count, String sortBy, String sortOrder, String domainName, String attributes, String excludeAttributes) {
        if (count < 0) {
            count = 0;
        }
        if (startIndex < 1) {
            startIndex = 1;
        }
        try {
            sortOrder = this.resolveSortOrder(sortOrder, sortBy);
            SCIMResourceTypeSchema schema = SCIMResourceSchemaManager.getInstance().getGroupResourceSchema();
            Node rootNode = this.buildNode(filter, schema);
            JSONEncoder encoder = GroupResourceManager.getEncoder();
            Map<String, Boolean> requiredAttributes = ResourceManagerUtil.getOnlyRequiredAttributesURIs((SCIMResourceTypeSchema)CopyUtil.deepCopy(schema), attributes, excludeAttributes);
            if (userManager != null) {
                List<Object> tempList = userManager.listGroupsWithGET(rootNode, startIndex, count, sortBy, sortOrder, domainName, requiredAttributes);
                return this.processGroupList(tempList, encoder, attributes, excludeAttributes, startIndex);
            }
            String error = "Provided user manager handler is null.";
            if (logger.isDebugEnabled()) {
                logger.error(error);
            }
            throw new InternalErrorException(error);
        }
        catch (BadRequestException | CharonException | InternalErrorException | NotFoundException | NotImplementedException e) {
            return GroupResourceManager.encodeSCIMException(e);
        }
        catch (IOException e) {
            String error = "Error in tokenization of the input filter";
            CharonException charonException = new CharonException(error);
            return AbstractResourceManager.encodeSCIMException(charonException);
        }
    }

    private String resolveSortOrder(String sortOrder, String sortBy) throws BadRequestException {
        if (sortOrder != null) {
            if (!"ascending".equalsIgnoreCase(sortOrder) && !"descending".equalsIgnoreCase(sortOrder)) {
                String error = " Invalid sortOrder value is specified";
                throw new BadRequestException(error, "invalidValue");
            }
        } else if (sortBy != null) {
            sortOrder = "ascending";
        }
        return sortOrder;
    }

    private Node buildNode(String filter, SCIMResourceTypeSchema schema) throws BadRequestException, IOException {
        if (filter != null) {
            FilterTreeManager filterTreeManager = new FilterTreeManager(filter, schema);
            return filterTreeManager.buildTree();
        }
        return null;
    }

    @Override
    public SCIMResponse listWithGET(UserManager userManager, String filter, Integer startIndexInt, Integer countInt, String sortBy, String sortOrder, String domainName, String attributes, String excludeAttributes) {
        try {
            Integer count = ResourceManagerUtil.processCount(countInt);
            Integer startIndex = ResourceManagerUtil.processStartIndex(startIndexInt);
            sortOrder = this.resolveSortOrder(sortOrder, sortBy);
            SCIMResourceTypeSchema schema = SCIMResourceSchemaManager.getInstance().getGroupResourceSchema();
            Node rootNode = this.buildNode(filter, schema);
            JSONEncoder encoder = GroupResourceManager.getEncoder();
            Map<String, Boolean> requiredAttributes = ResourceManagerUtil.getOnlyRequiredAttributesURIs((SCIMResourceTypeSchema)CopyUtil.deepCopy(schema), attributes, excludeAttributes);
            if (userManager != null) {
                List<Object> tempList = userManager.listGroupsWithGET(rootNode, startIndex, count, sortBy, sortOrder, domainName, requiredAttributes);
                return this.processGroupList(tempList, encoder, attributes, excludeAttributes, startIndex);
            }
            String error = "Provided user manager handler is null.";
            if (logger.isDebugEnabled()) {
                logger.debug(error);
            }
            throw new InternalErrorException(error);
        }
        catch (BadRequestException | CharonException | InternalErrorException | NotFoundException | NotImplementedException e) {
            return GroupResourceManager.encodeSCIMException(e);
        }
        catch (IOException e) {
            String error = "Error in tokenization of the input filter";
            CharonException charonException = new CharonException(error);
            return AbstractResourceManager.encodeSCIMException(charonException);
        }
    }

    private SCIMResponse processGroupList(List<Object> tempList, JSONEncoder encoder, String attributes, String excludeAttributes, int startIndex) throws NotFoundException, CharonException, BadRequestException {
        int totalResults = 0;
        if (tempList == null) {
            tempList = Collections.emptyList();
        } else if (tempList.size() >= 1) {
            if (tempList.get(0) instanceof Integer) {
                totalResults = (Integer)tempList.get(0);
                tempList.remove(0);
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug("First element in the list is not an int. Setting result count as: " + tempList.size());
                }
                totalResults = tempList.size();
            }
        }
        List<Object> returnedGroups = tempList;
        for (Object group : returnedGroups) {
            ServerSideValidator.validateRetrievedSCIMObjectInList((Group)group, SCIMSchemaDefinitions.SCIM_GROUP_SCHEMA, attributes, excludeAttributes);
        }
        ListedResource listedResource = this.createListedResource(returnedGroups, startIndex, totalResults);
        String encodedListedResource = encoder.encodeSCIMObject(listedResource);
        HashMap<String, String> responseHeaders = new HashMap<String, String>();
        responseHeaders.put("Content-Type", "application/scim+json");
        return new SCIMResponse(200, encodedListedResource, responseHeaders);
    }

    @Override
    public SCIMResponse listWithPOST(String resourceString, UserManager userManager) {
        JSONEncoder encoder = null;
        JSONDecoder decoder = null;
        try {
            encoder = GroupResourceManager.getEncoder();
            decoder = GroupResourceManager.getDecoder();
            SCIMResourceTypeSchema schema = SCIMResourceSchemaManager.getInstance().getGroupResourceSchema();
            SearchRequest searchRequest = decoder.decodeSearchRequestBody(resourceString, schema);
            searchRequest.setCount(ResourceManagerUtil.processCount(searchRequest.getCountStr()));
            searchRequest.setStartIndex(ResourceManagerUtil.processStartIndex(searchRequest.getStartIndexStr()));
            if (searchRequest.getSchema() != null && !searchRequest.getSchema().equals("urn:ietf:params:scim:api:messages:2.0:SearchRequest")) {
                throw new BadRequestException("Provided schema is invalid", "invalidValue");
            }
            if (searchRequest.getSortOder() != null && !searchRequest.getSortOder().equalsIgnoreCase("ascending") && !searchRequest.getSortOder().equalsIgnoreCase("descending")) {
                String error = " Invalid sortOrder value is specified";
                throw new BadRequestException(error, "invalidValue");
            }
            if (searchRequest.getSortOder() == null && searchRequest.getSortBy() != null) {
                searchRequest.setSortOder("ascending");
            }
            Map<String, Boolean> requiredAttributes = ResourceManagerUtil.getOnlyRequiredAttributesURIs((SCIMResourceTypeSchema)CopyUtil.deepCopy(schema), searchRequest.getAttributesAsString(), searchRequest.getExcludedAttributesAsString());
            int totalResults = 0;
            if (userManager != null) {
                List<Object> tempList = userManager.listGroupsWithPost(searchRequest, requiredAttributes);
                totalResults = (Integer)tempList.get(0);
                tempList.remove(0);
                List<Object> returnedGroups = tempList;
                for (Object group : returnedGroups) {
                    ServerSideValidator.validateRetrievedSCIMObjectInList((Group)group, schema, searchRequest.getAttributesAsString(), searchRequest.getExcludedAttributesAsString());
                }
                ListedResource listedResource = this.createListedResource(returnedGroups, searchRequest.getStartIndex(), totalResults);
                String encodedListedResource = encoder.encodeSCIMObject(listedResource);
                HashMap<String, String> responseHeaders = new HashMap<String, String>();
                responseHeaders.put("Content-Type", "application/scim+json");
                return new SCIMResponse(200, encodedListedResource, responseHeaders);
            }
            String error = "Provided user manager handler is null.";
            throw new InternalErrorException(error);
        }
        catch (CharonException e) {
            return AbstractResourceManager.encodeSCIMException(e);
        }
        catch (NotFoundException e) {
            return AbstractResourceManager.encodeSCIMException(e);
        }
        catch (InternalErrorException e) {
            return AbstractResourceManager.encodeSCIMException(e);
        }
        catch (BadRequestException e) {
            return AbstractResourceManager.encodeSCIMException(e);
        }
        catch (NotImplementedException e) {
            return AbstractResourceManager.encodeSCIMException(e);
        }
    }

    @Override
    public SCIMResponse updateWithPUT(String existingId, String scimObjectString, UserManager userManager, String attributes, String excludeAttributes) {
        JSONEncoder encoder = null;
        JSONDecoder decoder = null;
        try {
            Group oldGroup;
            encoder = GroupResourceManager.getEncoder();
            decoder = GroupResourceManager.getDecoder();
            SCIMResourceTypeSchema schema = SCIMResourceSchemaManager.getInstance().getGroupResourceSchema();
            Map<String, Boolean> requiredAttributes = ResourceManagerUtil.getOnlyRequiredAttributesURIs((SCIMResourceTypeSchema)CopyUtil.deepCopy(schema), attributes, excludeAttributes);
            Group group = decoder.decodeResource(scimObjectString, schema, new Group());
            Group updatedGroup = null;
            if (userManager != null) {
                oldGroup = userManager.getGroup(existingId, ResourceManagerUtil.getAllAttributeURIs(schema));
                if (oldGroup == null) {
                    String error = "No user exists with the given id: " + existingId;
                    throw new NotFoundException(error);
                }
            } else {
                String error = "Provided user manager handler is null.";
                throw new InternalErrorException(error);
            }
            Group newGroup = (Group)ServerSideValidator.validateUpdatedSCIMObject(oldGroup, group, schema);
            updatedGroup = userManager.updateGroup(oldGroup, newGroup, requiredAttributes);
            HashMap<String, String> httpHeaders = new HashMap<String, String>();
            if (updatedGroup == null) {
                String error = "Updated Group resource is null.";
                throw new InternalErrorException(error);
            }
            Group copiedGroup = (Group)CopyUtil.deepCopy(updatedGroup);
            ServerSideValidator.validateReturnedAttributes(copiedGroup, attributes, excludeAttributes);
            String encodedGroup = encoder.encodeSCIMObject(copiedGroup);
            httpHeaders.put("Location", GroupResourceManager.getResourceEndpointURL("/Groups") + "/" + updatedGroup.getId());
            httpHeaders.put("Content-Type", "application/scim+json");
            return new SCIMResponse(200, encodedGroup, httpHeaders);
        }
        catch (NotFoundException e) {
            return GroupResourceManager.encodeSCIMException(e);
        }
        catch (BadRequestException e) {
            return GroupResourceManager.encodeSCIMException(e);
        }
        catch (CharonException e) {
            return GroupResourceManager.encodeSCIMException(e);
        }
        catch (InternalErrorException e) {
            return GroupResourceManager.encodeSCIMException(e);
        }
        catch (NotImplementedException e) {
            return GroupResourceManager.encodeSCIMException(e);
        }
    }

    @Override
    public SCIMResponse updateWithPATCH(String existingId, String patchRequest, UserManager userManager, String attributes, String excludeAttributes) {
        try {
            Group patchedGroup;
            if (userManager == null) {
                String error = "Provided user manager handler is null.";
                throw new InternalErrorException(error);
            }
            SCIMResourceTypeSchema schema = SCIMResourceSchemaManager.getInstance().getGroupResourceSchema();
            Map<String, Boolean> requiredAttributes = ResourceManagerUtil.getAllAttributeURIs(schema);
            Group oldGroup = userManager.getGroup(existingId, requiredAttributes);
            if (oldGroup == null) {
                throw new NotFoundException("No group with the id : " + existingId + " in the user store.");
            }
            Group originalGroup = (Group)CopyUtil.deepCopy(oldGroup);
            Group updatedGroup = userManager.updateGroup(originalGroup, patchedGroup = this.doPatchGroup(oldGroup, schema, patchRequest), requiredAttributes);
            if (updatedGroup != null) {
                Group copyOfUpdatedGroup = (Group)CopyUtil.deepCopy(updatedGroup);
                ServerSideValidator.validateReturnedAttributes(copyOfUpdatedGroup, attributes, excludeAttributes);
                String encodedGroup = GroupResourceManager.getEncoder().encodeSCIMObject(copyOfUpdatedGroup);
                HashMap<String, String> httpHeaders = new HashMap<String, String>();
                httpHeaders.put("Location", GroupResourceManager.getResourceEndpointURL("/Users") + "/" + updatedGroup.getId());
                httpHeaders.put("Content-Type", "application/scim+json");
                return new SCIMResponse(200, encodedGroup, httpHeaders);
            }
            String error = "Updated group resource is null.";
            throw new CharonException(error);
        }
        catch (BadRequestException | CharonException | InternalErrorException | NotFoundException | NotImplementedException e) {
            return AbstractResourceManager.encodeSCIMException(e);
        }
        catch (RuntimeException e) {
            CharonException e1 = new CharonException("Error in performing the patch operation on group resource.", e);
            return AbstractResourceManager.encodeSCIMException(e1);
        }
    }

    @Override
    public SCIMResponse updateWithPATCH(String existingGroupId, String patchRequest, UserManager userManager) {
        try {
            if (userManager == null) {
                String error = "Provided user manager handler is null.";
                throw new InternalErrorException(error);
            }
            SCIMResourceTypeSchema schema = SCIMResourceSchemaManager.getInstance().getGroupResourceSchema();
            Map<String, Boolean> requestAttributes = ResourceManagerUtil.getAllAttributeURIs(schema);
            Group oldGroup = userManager.getGroup(existingGroupId, requestAttributes);
            if (oldGroup == null) {
                throw new NotFoundException("No group with the id : " + existingGroupId + " exists in the user store.");
            }
            Group originalGroup = (Group)CopyUtil.deepCopy(oldGroup);
            Group patchedGroup = this.doPatchGroup(oldGroup, schema, patchRequest);
            userManager.updateGroup(originalGroup, patchedGroup);
            HashMap<String, String> httpHeaders = new HashMap<String, String>();
            httpHeaders.put("Content-Type", "application/scim+json");
            return new SCIMResponse(204, null, httpHeaders);
        }
        catch (BadRequestException | CharonException | InternalErrorException | NotFoundException | NotImplementedException e) {
            return AbstractResourceManager.encodeSCIMException(e);
        }
        catch (RuntimeException e) {
            CharonException ex = new CharonException("Error in performing the patch operation on group resource.", e);
            return AbstractResourceManager.encodeSCIMException(ex);
        }
    }

    private Group doPatchGroup(Group oldGroup, SCIMResourceTypeSchema groupSchema, String patchRequest) throws CharonException, BadRequestException, NotImplementedException, InternalErrorException {
        Group originalGroup = (Group)CopyUtil.deepCopy(oldGroup);
        Group copyOfOldGroup = (Group)CopyUtil.deepCopy(oldGroup);
        Group patchedGroup = null;
        ArrayList<PatchOperation> opList = GroupResourceManager.getDecoder().decodeRequest(patchRequest);
        block10: for (PatchOperation operation : opList) {
            switch (operation.getOperation()) {
                case "add": {
                    if (patchedGroup == null) {
                        patchedGroup = (Group)PatchOperationUtil.doPatchAdd(operation, GroupResourceManager.getDecoder(), oldGroup, copyOfOldGroup, groupSchema);
                        copyOfOldGroup = (Group)CopyUtil.deepCopy(patchedGroup);
                        continue block10;
                    }
                    patchedGroup = (Group)PatchOperationUtil.doPatchAdd(operation, GroupResourceManager.getDecoder(), patchedGroup, copyOfOldGroup, groupSchema);
                    copyOfOldGroup = (Group)CopyUtil.deepCopy(patchedGroup);
                    continue block10;
                }
                case "remove": {
                    if (patchedGroup == null) {
                        patchedGroup = (Group)PatchOperationUtil.doPatchRemove(operation, oldGroup, copyOfOldGroup, groupSchema);
                        copyOfOldGroup = (Group)CopyUtil.deepCopy(patchedGroup);
                        continue block10;
                    }
                    patchedGroup = (Group)PatchOperationUtil.doPatchRemove(operation, patchedGroup, copyOfOldGroup, groupSchema);
                    copyOfOldGroup = (Group)CopyUtil.deepCopy(patchedGroup);
                    continue block10;
                }
                case "replace": {
                    if (patchedGroup == null) {
                        patchedGroup = (Group)PatchOperationUtil.doPatchReplace(operation, GroupResourceManager.getDecoder(), oldGroup, copyOfOldGroup, groupSchema);
                        copyOfOldGroup = (Group)CopyUtil.deepCopy(patchedGroup);
                        continue block10;
                    }
                    patchedGroup = (Group)PatchOperationUtil.doPatchReplace(operation, GroupResourceManager.getDecoder(), patchedGroup, copyOfOldGroup, groupSchema);
                    copyOfOldGroup = (Group)CopyUtil.deepCopy(patchedGroup);
                    continue block10;
                }
            }
            throw new BadRequestException("Unknown operation.", "invalidSyntax");
        }
        return (Group)ServerSideValidator.validateUpdatedSCIMObject(originalGroup, patchedGroup, groupSchema);
    }

    public ListedResource createListedResource(List<Object> groups, int startIndex, int totalResults) throws CharonException, NotFoundException {
        ListedResource listedResource = new ListedResource();
        listedResource.setSchema("urn:ietf:params:scim:api:messages:2.0:ListResponse");
        listedResource.setTotalResults(totalResults);
        listedResource.setStartIndex(startIndex);
        listedResource.setItemsPerPage(groups.size());
        for (Object group : groups) {
            Map<String, Attribute> userAttributes = ((Group)group).getAttributeList();
            listedResource.setResources(userAttributes);
        }
        return listedResource;
    }
}

