/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.charon3.core.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.wso2.charon3.core.config.CharonConfiguration;
import org.wso2.charon3.core.exceptions.BadRequestException;
import org.wso2.charon3.core.exceptions.CharonException;
import org.wso2.charon3.core.schema.AttributeSchema;
import org.wso2.charon3.core.schema.SCIMDefinitions;
import org.wso2.charon3.core.schema.SCIMResourceTypeSchema;
import org.wso2.charon3.core.utils.CopyUtil;

public class ResourceManagerUtil {
    public static Map<String, Boolean> getOnlyRequiredAttributesURIs(SCIMResourceTypeSchema schema, String requestedAttributes, String requestedExcludingAttributes) throws CharonException {
        ArrayList attributeSchemaArrayList = (ArrayList)CopyUtil.deepCopy(schema.getAttributesList());
        List<String> requestedAttributesList = null;
        List<String> requestedExcludingAttributesList = null;
        if (requestedAttributes != null) {
            requestedAttributesList = Arrays.asList(requestedAttributes.split(","));
        }
        if (requestedExcludingAttributes != null) {
            requestedExcludingAttributesList = Arrays.asList(requestedExcludingAttributes.split(","));
        }
        ArrayList<AttributeSchema> attributeList = schema.getAttributesList();
        for (AttributeSchema attributeSchema : attributeList) {
            block13: {
                block14: {
                    block15: {
                        block12: {
                            if (attributeSchema.getReturned().equals((Object)SCIMDefinitions.Returned.NEVER)) {
                                ResourceManagerUtil.removeAttributesFromList(attributeSchemaArrayList, attributeSchema.getName());
                            }
                            if (requestedAttributes != null || requestedExcludingAttributes != null) break block12;
                            if (attributeSchema.getReturned().equals((Object)SCIMDefinitions.Returned.REQUEST)) {
                                ResourceManagerUtil.removeAttributesFromList(attributeSchemaArrayList, attributeSchema.getName());
                            }
                            break block13;
                        }
                        if (requestedAttributes == null) break block14;
                        if (attributeSchema.getReturned().equals((Object)SCIMDefinitions.Returned.DEFAULT)) break block15;
                        if (!attributeSchema.getReturned().equals((Object)SCIMDefinitions.Returned.REQUEST)) break block13;
                    }
                    if (requestedAttributesList.stream().noneMatch(attributeSchema.getName()::equalsIgnoreCase) && !ResourceManagerUtil.isSubAttributeExistsInList(requestedAttributesList, attributeSchema)) {
                        ResourceManagerUtil.removeAttributesFromList(attributeSchemaArrayList, attributeSchema.getName());
                    }
                    break block13;
                }
                if (requestedExcludingAttributes != null) {
                    if (attributeSchema.getReturned().equals((Object)SCIMDefinitions.Returned.REQUEST)) {
                        ResourceManagerUtil.removeAttributesFromList(attributeSchemaArrayList, attributeSchema.getName());
                    }
                    if (attributeSchema.getReturned().equals((Object)SCIMDefinitions.Returned.DEFAULT)) {
                        if (requestedExcludingAttributesList.stream().anyMatch(attributeSchema.getName()::equalsIgnoreCase)) {
                            ResourceManagerUtil.removeAttributesFromList(attributeSchemaArrayList, attributeSchema.getName());
                        }
                    }
                }
            }
            ResourceManagerUtil.getOnlyRequiredSubAttributesURIs(attributeSchema, attributeSchemaArrayList, requestedAttributes, requestedExcludingAttributes, requestedAttributesList, requestedExcludingAttributesList);
        }
        return ResourceManagerUtil.convertSchemasToURIs(attributeSchemaArrayList);
    }

    private static void getOnlyRequiredSubAttributesURIs(AttributeSchema attributeSchema, ArrayList<AttributeSchema> attributeSchemaArrayList, String requestedAttributes, String requestedExcludingAttributes, List<String> requestedAttributesList, List<String> requestedExcludingAttributesList) throws CharonException {
        if (attributeSchema.getType().equals((Object)SCIMDefinitions.DataType.COMPLEX)) {
            AttributeSchema realAttributeSchema = null;
            for (AttributeSchema schema : attributeSchemaArrayList) {
                if (!schema.getName().equals(attributeSchema.getName())) continue;
                realAttributeSchema = schema;
                break;
            }
            if (realAttributeSchema != null) {
                List<AttributeSchema> subAttributeList = attributeSchema.getSubAttributeSchemas();
                for (AttributeSchema subAttributeSchema : subAttributeList) {
                    if (subAttributeSchema.getReturned().equals((Object)SCIMDefinitions.Returned.NEVER)) {
                        realAttributeSchema.removeSubAttribute(subAttributeSchema.getName());
                    }
                    if (requestedAttributes == null && requestedExcludingAttributes == null) {
                        if (subAttributeSchema.getReturned().equals((Object)SCIMDefinitions.Returned.REQUEST)) {
                            realAttributeSchema.removeSubAttribute(subAttributeSchema.getName());
                        }
                    } else if (requestedAttributes != null) {
                        if (subAttributeSchema.getReturned().equals((Object)SCIMDefinitions.Returned.DEFAULT) || subAttributeSchema.getReturned().equals((Object)SCIMDefinitions.Returned.REQUEST)) {
                            if (requestedAttributesList.stream().noneMatch((attributeSchema.getName() + "." + subAttributeSchema.getName())::equalsIgnoreCase) && !ResourceManagerUtil.isSubSubAttributeExistsInList(requestedAttributesList, attributeSchema, subAttributeSchema)) {
                                if (requestedAttributesList.stream().noneMatch(attributeSchema.getName()::equalsIgnoreCase)) {
                                    realAttributeSchema.removeSubAttribute(subAttributeSchema.getName());
                                }
                            }
                        }
                    } else if (requestedExcludingAttributes != null) {
                        if (subAttributeSchema.getReturned().equals((Object)SCIMDefinitions.Returned.REQUEST)) {
                            realAttributeSchema.removeSubAttribute(subAttributeSchema.getName());
                        }
                        if (subAttributeSchema.getReturned().equals((Object)SCIMDefinitions.Returned.DEFAULT) && requestedExcludingAttributesList.contains(attributeSchema.getName() + "." + subAttributeSchema.getName())) {
                            realAttributeSchema.removeSubAttribute(subAttributeSchema.getName());
                        }
                    }
                    ResourceManagerUtil.getOnlyRequiredSubSubAttributesURIs(attributeSchema, subAttributeSchema, attributeSchemaArrayList, requestedAttributes, requestedExcludingAttributes, requestedAttributesList, requestedExcludingAttributesList);
                }
            }
        }
    }

    private static void getOnlyRequiredSubSubAttributesURIs(AttributeSchema attribute, AttributeSchema subAttribute, ArrayList<AttributeSchema> attributeSchemaArrayList, String requestedAttributes, String requestedExcludingAttributes, List<String> requestedAttributesList, List<String> requestedExcludingAttributesList) throws CharonException {
        if (subAttribute.getType().equals((Object)SCIMDefinitions.DataType.COMPLEX)) {
            AttributeSchema realAttributeSchema = null;
            block0: for (AttributeSchema schema : attributeSchemaArrayList) {
                List<AttributeSchema> subSchemas = schema.getSubAttributeSchemas();
                if (subSchemas == null) continue;
                for (AttributeSchema subSchema : subSchemas) {
                    if (!subSchema.getURI().equals(subAttribute.getURI())) continue;
                    realAttributeSchema = subSchema;
                    continue block0;
                }
            }
            if (realAttributeSchema != null) {
                List<AttributeSchema> subSubAttributeList = subAttribute.getSubAttributeSchemas();
                for (AttributeSchema subSubAttributeSchema : subSubAttributeList) {
                    if (subSubAttributeSchema.getReturned().equals((Object)SCIMDefinitions.Returned.NEVER)) {
                        realAttributeSchema.removeSubAttribute(subSubAttributeSchema.getName());
                    }
                    if (requestedAttributes == null && requestedExcludingAttributes == null) {
                        if (!subSubAttributeSchema.getReturned().equals((Object)SCIMDefinitions.Returned.REQUEST)) continue;
                        realAttributeSchema.removeSubAttribute(subSubAttributeSchema.getName());
                        continue;
                    }
                    if (requestedAttributes != null) {
                        if (!subSubAttributeSchema.getReturned().equals((Object)SCIMDefinitions.Returned.DEFAULT) && !subSubAttributeSchema.getReturned().equals((Object)SCIMDefinitions.Returned.REQUEST)) continue;
                        if (!requestedAttributesList.stream().noneMatch((attribute.getName() + "." + subAttribute.getName() + "." + subSubAttributeSchema.getName())::equalsIgnoreCase)) continue;
                        if (!requestedAttributesList.stream().noneMatch(attribute.getName()::equalsIgnoreCase)) continue;
                        if (!requestedAttributesList.stream().noneMatch((attribute.getName() + "." + subAttribute.getName())::equalsIgnoreCase)) continue;
                        realAttributeSchema.removeSubAttribute(subSubAttributeSchema.getName());
                        continue;
                    }
                    if (requestedExcludingAttributes == null) continue;
                    if (subSubAttributeSchema.getReturned().equals((Object)SCIMDefinitions.Returned.REQUEST)) {
                        realAttributeSchema.removeSubAttribute(subSubAttributeSchema.getName());
                    }
                    if (!subSubAttributeSchema.getReturned().equals((Object)SCIMDefinitions.Returned.DEFAULT)) continue;
                    if (!requestedExcludingAttributesList.stream().anyMatch((attribute.getName() + "." + subAttribute.getName() + "." + subSubAttributeSchema.getName())::equalsIgnoreCase)) continue;
                    realAttributeSchema.removeSubAttribute(subSubAttributeSchema.getName());
                }
            }
        }
    }

    private static boolean isSubAttributeExistsInList(List<String> requestedAttributes, AttributeSchema attributeSchema) {
        if (attributeSchema.getType().equals((Object)SCIMDefinitions.DataType.COMPLEX)) {
            List<AttributeSchema> subAttributeSchemas = attributeSchema.getSubAttributeSchemas();
            for (AttributeSchema subAttributeSchema : subAttributeSchemas) {
                if (requestedAttributes.stream().anyMatch((attributeSchema.getName() + "." + subAttributeSchema.getName())::equalsIgnoreCase)) {
                    return true;
                }
                if (!subAttributeSchema.getType().equals((Object)SCIMDefinitions.DataType.COMPLEX)) continue;
                List<AttributeSchema> subSubAttributeSchemas = subAttributeSchema.getSubAttributeSchemas();
                for (AttributeSchema subSubAttributeSchema : subSubAttributeSchemas) {
                    if (!requestedAttributes.stream().anyMatch((attributeSchema.getName() + "." + subAttributeSchema.getName() + "." + subSubAttributeSchema.getName())::equalsIgnoreCase)) continue;
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private static boolean isSubSubAttributeExistsInList(List<String> requestedAttributes, AttributeSchema attributeSchema, AttributeSchema subAttributeSchema) {
        if (subAttributeSchema.getType().equals((Object)SCIMDefinitions.DataType.COMPLEX)) {
            List<AttributeSchema> subSubAttributeSchemas = subAttributeSchema.getSubAttributeSchemas();
            for (AttributeSchema subSubAttributeSchema : subSubAttributeSchemas) {
                if (!requestedAttributes.stream().anyMatch((attributeSchema.getName() + "." + subAttributeSchema.getName() + "." + subSubAttributeSchema.getName())::equalsIgnoreCase)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private static Map<String, Boolean> convertSchemasToURIs(List<AttributeSchema> schemas) {
        HashMap<String, Boolean> uriList = new HashMap<String, Boolean>();
        for (AttributeSchema schema : schemas) {
            if (schema.getType().equals((Object)SCIMDefinitions.DataType.COMPLEX)) {
                List<AttributeSchema> subAttributeSchemas = schema.getSubAttributeSchemas();
                for (AttributeSchema subAttributeSchema : subAttributeSchemas) {
                    if (subAttributeSchema.getType().equals((Object)SCIMDefinitions.DataType.COMPLEX)) {
                        List<AttributeSchema> subSubAttributeSchemas = subAttributeSchema.getSubAttributeSchemas();
                        for (AttributeSchema subSubAttributeSchema : subSubAttributeSchemas) {
                            uriList.put(subSubAttributeSchema.getURI(), subAttributeSchema.getMultiValued());
                        }
                        continue;
                    }
                    uriList.put(subAttributeSchema.getURI(), schema.getMultiValued());
                }
                continue;
            }
            uriList.put(schema.getURI(), schema.getMultiValued());
        }
        return uriList;
    }

    private static void removeAttributesFromList(List<AttributeSchema> attributeSchemaList, String attributeName) throws CharonException {
        List tempList = (List)CopyUtil.deepCopy(attributeSchemaList);
        int count = 0;
        for (AttributeSchema attributeSchema : tempList) {
            if (attributeSchema.getName().equals(attributeName)) {
                attributeSchemaList.remove(count);
            }
            ++count;
        }
    }

    public static Map<String, Boolean> getAllAttributeURIs(SCIMResourceTypeSchema schema) throws CharonException {
        return ResourceManagerUtil.getOnlyRequiredAttributesURIs(schema, null, null);
    }

    public static int processCount(String countStr) throws BadRequestException {
        int count;
        if (countStr == null || countStr.trim().isEmpty() || !countStr.matches("\\d+")) {
            count = CharonConfiguration.getInstance().getCountValueForPagination();
        } else {
            try {
                count = Integer.parseInt(countStr);
            }
            catch (NumberFormatException e) {
                throw new BadRequestException("Value of parameter count is Invalid");
            }
        }
        if (count < 0) {
            count = 0;
        }
        return count;
    }

    public static Integer processCount(Integer countInt) {
        if (countInt == null || countInt.toString().isEmpty()) {
            return null;
        }
        if (countInt <= 0) {
            return 0;
        }
        return countInt;
    }

    public static Integer processStartIndex(Integer startIndex) {
        if (startIndex == null) {
            return 1;
        }
        if (startIndex >= 1) {
            return startIndex;
        }
        return 1;
    }

    public static int processStartIndex(String startIndexStr) throws BadRequestException {
        int startIndex = 1;
        if (startIndexStr == null || startIndexStr.trim().isEmpty() || !startIndexStr.matches("\\d+")) {
            return startIndex;
        }
        try {
            startIndex = Integer.parseInt(startIndexStr);
        }
        catch (NumberFormatException e) {
            throw new BadRequestException("Value of parameter startIndex is Invalid");
        }
        if (startIndex < 1) {
            startIndex = 1;
        }
        return startIndex;
    }
}

