/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.charon3.core.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.wso2.charon3.core.exceptions.CharonException;
import org.wso2.charon3.core.exceptions.InternalErrorException;
import org.wso2.charon3.core.schema.AttributeSchema;
import org.wso2.charon3.core.schema.SCIMAttributeSchema;
import org.wso2.charon3.core.schema.SCIMDefinitions;

public class SCIMUserSchemaExtensionBuilder {
    private static SCIMUserSchemaExtensionBuilder configReader = new SCIMUserSchemaExtensionBuilder();
    private static Map<String, ExtensionAttributeSchemaConfig> extensionConfig = new HashMap<String, ExtensionAttributeSchemaConfig>();
    String extensionRootAttributeURI = null;
    private static Map<String, AttributeSchema> attributeSchemas = new HashMap<String, AttributeSchema>();
    private AttributeSchema extensionSchema = null;

    public static SCIMUserSchemaExtensionBuilder getInstance() {
        return configReader;
    }

    public AttributeSchema getExtensionSchema() {
        return this.extensionSchema;
    }

    public void buildUserSchemaExtension(String configFilePath) throws CharonException, InternalErrorException {
        this.readConfiguration(configFilePath);
        for (Map.Entry<String, ExtensionAttributeSchemaConfig> attributeSchemaConfig : extensionConfig.entrySet()) {
            if (!attributeSchemaConfig.getValue().hasChildren()) {
                this.buildSimpleAttributeSchema(attributeSchemaConfig.getValue());
                continue;
            }
            this.buildComplexAttributeSchema(attributeSchemaConfig.getValue());
        }
        this.extensionSchema = attributeSchemas.get(this.extensionRootAttributeURI);
    }

    private void readConfiguration(String configFilePath) throws CharonException {
        File provisioningConfig = new File(configFilePath);
        try {
            FileInputStream inputStream = new FileInputStream(provisioningConfig);
            Scanner scanner = new Scanner((InputStream)inputStream, "utf-8").useDelimiter("\\A");
            String jsonString = scanner.hasNext() ? scanner.next() : "";
            JSONArray attributeConfigArray = new JSONArray(jsonString);
            for (int index = 0; index < attributeConfigArray.length(); ++index) {
                JSONObject rawAttributeConfig = attributeConfigArray.getJSONObject(index);
                ExtensionAttributeSchemaConfig schemaAttributeConfig = new ExtensionAttributeSchemaConfig(rawAttributeConfig);
                extensionConfig.put(schemaAttributeConfig.getURI(), schemaAttributeConfig);
                if (index != attributeConfigArray.length() - 1) continue;
                this.extensionRootAttributeURI = schemaAttributeConfig.getURI();
            }
            ((InputStream)inputStream).close();
        }
        catch (FileNotFoundException e) {
            throw new CharonException("scim2-schema-extension.config file not found!", e);
        }
        catch (JSONException e) {
            throw new CharonException("Error while parsing scim2-schema-extension.config file!", e);
        }
        catch (IOException e) {
            throw new CharonException("Error while closing scim2-schema-extension.config file!", e);
        }
    }

    private String getSubAttributeURI(ExtensionAttributeSchemaConfig config, String subAttributeName) {
        if (this.isRootConfig(config)) {
            return config.getURI() + ":" + subAttributeName;
        }
        return config.getURI() + "." + subAttributeName;
    }

    private boolean isRootConfig(ExtensionAttributeSchemaConfig config) {
        return config.getURI().equals(config.getName());
    }

    private void buildComplexAttributeSchema(ExtensionAttributeSchemaConfig config) throws InternalErrorException {
        if (!attributeSchemas.containsKey(config.getURI())) {
            String[] subAttributes;
            for (String subAttribute : subAttributes = config.getSubAttributes()) {
                ExtensionAttributeSchemaConfig subAttribConfig = extensionConfig.get(this.getSubAttributeURI(config, subAttribute));
                if (subAttribConfig == null) {
                    String error = String.format("Error adding subattribute %s to attribute %s. Error in SCIM2 extension schema config format.", subAttribute, config.getURI());
                    throw new InternalErrorException(error);
                }
                if (!subAttribConfig.getType().equals((Object)SCIMDefinitions.DataType.COMPLEX)) {
                    if (subAttribConfig.hasChildren()) {
                        String error = "A attribute of primitive type can not have sub attributes";
                        throw new InternalErrorException(error);
                    }
                    this.buildSimpleAttributeSchema(subAttribConfig);
                    continue;
                }
                if (!subAttribConfig.hasChildren()) {
                    String error = "A attribute of complex type should have sub attributes";
                    throw new InternalErrorException(error);
                }
                this.buildComplexAttributeSchema(subAttribConfig);
            }
            this.buildComplexSchema(config);
        }
    }

    private void buildComplexSchema(ExtensionAttributeSchemaConfig config) {
        String[] subAttributeNames = config.getSubAttributes();
        ArrayList<AttributeSchema> subAttributes = new ArrayList<AttributeSchema>();
        for (String subAttributeName : subAttributeNames) {
            subAttributes.add(attributeSchemas.get(this.getSubAttributeURI(config, subAttributeName)));
        }
        SCIMAttributeSchema complexAttribute = this.createSCIMAttributeSchema(config, subAttributes);
        attributeSchemas.put(config.getURI(), complexAttribute);
    }

    private void buildSimpleAttributeSchema(ExtensionAttributeSchemaConfig config) {
        ArrayList<AttributeSchema> subAttributeList = new ArrayList<AttributeSchema>();
        if (!attributeSchemas.containsKey(config.getURI())) {
            SCIMAttributeSchema attributeSchema = this.createSCIMAttributeSchema(config, subAttributeList);
            attributeSchemas.put(config.getURI(), attributeSchema);
        }
    }

    public SCIMAttributeSchema createSCIMAttributeSchema(ExtensionAttributeSchemaConfig attribute, ArrayList<AttributeSchema> subAttributeList) {
        return SCIMAttributeSchema.createSCIMAttributeSchema(attribute.getURI(), attribute.getName(), attribute.getType(), attribute.getMultiValued(), attribute.description, attribute.required, attribute.caseExact, attribute.mutability, attribute.returned, attribute.uniqueness, attribute.canonicalValues, attribute.referenceTypes, subAttributeList);
    }

    static class ExtensionAttributeSchemaConfig {
        private String uri;
        private String name;
        private SCIMDefinitions.DataType type;
        private Boolean multiValued;
        private String description;
        private Boolean required;
        private Boolean caseExact;
        private SCIMDefinitions.Mutability mutability;
        private SCIMDefinitions.Returned returned;
        private SCIMDefinitions.Uniqueness uniqueness;
        private String[] subAttributes;
        private ArrayList<String> canonicalValues;
        private ArrayList<SCIMDefinitions.ReferenceType> referenceTypes;

        public String[] getSubAttributes() {
            return this.subAttributes;
        }

        public String getURI() {
            return this.uri;
        }

        public void setURI(String uri) {
            this.uri = uri;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public SCIMDefinitions.DataType getType() {
            return this.type;
        }

        public void setType(SCIMDefinitions.DataType type) {
            this.type = type;
        }

        public Boolean getMultiValued() {
            return this.multiValued;
        }

        public void setMultiValued(Boolean multiValued) {
            this.multiValued = multiValued;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public Boolean getRequired() {
            return this.required;
        }

        public void setRequired(Boolean required) {
            this.required = required;
        }

        public Boolean getCaseExact() {
            return this.caseExact;
        }

        public void setCaseExact(Boolean caseExact) {
            this.caseExact = caseExact;
        }

        public SCIMDefinitions.Mutability getMutability() {
            return this.mutability;
        }

        public void setMutability(SCIMDefinitions.Mutability mutability) {
            this.mutability = mutability;
        }

        public SCIMDefinitions.Returned getReturned() {
            return this.returned;
        }

        public void setReturned(SCIMDefinitions.Returned returned) {
            this.returned = returned;
        }

        public SCIMDefinitions.Uniqueness getUniqueness() {
            return this.uniqueness;
        }

        public void setUniqueness(SCIMDefinitions.Uniqueness uniqueness) {
            this.uniqueness = uniqueness;
        }

        public ArrayList<String> getCanonicalValues() {
            return this.canonicalValues;
        }

        public ArrayList<SCIMDefinitions.ReferenceType> getReferenceTypes() {
            return this.referenceTypes;
        }

        public boolean hasChildren() {
            return this.subAttributes != null;
        }

        public ExtensionAttributeSchemaConfig(JSONObject attributeConfigJSON) throws CharonException {
            try {
                this.uri = attributeConfigJSON.getString("attributeURI");
                this.name = attributeConfigJSON.getString("attributeName");
                this.type = this.getDefinedDataType(attributeConfigJSON.getString("dataType"));
                this.multiValued = attributeConfigJSON.getBoolean("multiValued");
                this.description = attributeConfigJSON.getString("description");
                this.required = Boolean.parseBoolean(attributeConfigJSON.getString("required"));
                this.caseExact = Boolean.parseBoolean(attributeConfigJSON.getString("caseExact"));
                this.mutability = this.getDefinedMutability(attributeConfigJSON.getString("mutability"));
                this.returned = this.getDefinedReturned(attributeConfigJSON.getString("returned"));
                this.uniqueness = this.getDefinedUniqueness(attributeConfigJSON.getString("uniqueness"));
                String subAttributesString = attributeConfigJSON.getString("subAttributes");
                if (!"null".equalsIgnoreCase(subAttributesString)) {
                    this.subAttributes = subAttributesString.split(" ");
                }
                this.canonicalValues = this.setCanonicalValues(attributeConfigJSON.getJSONArray("canonicalValues"));
                this.referenceTypes = this.setReferenceTypes(attributeConfigJSON.getJSONArray("referenceTypes"));
            }
            catch (JSONException e) {
                throw new CharonException("Error while parsing extension configuration", e);
            }
        }

        private SCIMDefinitions.DataType getDefinedDataType(String input) {
            SCIMDefinitions.DataType type = null;
            if ("STRING".equalsIgnoreCase(input)) {
                type = SCIMDefinitions.DataType.STRING;
            } else if ("INTEGER".equalsIgnoreCase(input)) {
                type = SCIMDefinitions.DataType.INTEGER;
            } else if ("DECIMAL".equalsIgnoreCase(input)) {
                type = SCIMDefinitions.DataType.DECIMAL;
            } else if ("BOOLEAN".equalsIgnoreCase(input)) {
                type = SCIMDefinitions.DataType.BOOLEAN;
            } else if ("DATETIME".equalsIgnoreCase(input)) {
                type = SCIMDefinitions.DataType.DATE_TIME;
            } else if ("BINARY".equalsIgnoreCase(input)) {
                type = SCIMDefinitions.DataType.BINARY;
            } else if ("REFERENCE".equalsIgnoreCase(input)) {
                type = SCIMDefinitions.DataType.REFERENCE;
            } else if ("COMPLEX".equalsIgnoreCase(input)) {
                type = SCIMDefinitions.DataType.COMPLEX;
            }
            return type;
        }

        private SCIMDefinitions.Mutability getDefinedMutability(String input) {
            SCIMDefinitions.Mutability type = null;
            if ("readWrite".equalsIgnoreCase(input)) {
                type = SCIMDefinitions.Mutability.READ_WRITE;
            } else if ("readOnly".equalsIgnoreCase(input)) {
                type = SCIMDefinitions.Mutability.READ_ONLY;
            } else if ("immutable".equalsIgnoreCase(input)) {
                type = SCIMDefinitions.Mutability.IMMUTABLE;
            } else if ("writeOnly".equalsIgnoreCase(input)) {
                type = SCIMDefinitions.Mutability.WRITE_ONLY;
            }
            return type;
        }

        private SCIMDefinitions.Returned getDefinedReturned(String input) {
            SCIMDefinitions.Returned type = null;
            if ("always".equalsIgnoreCase(input)) {
                type = SCIMDefinitions.Returned.ALWAYS;
            } else if ("never".equalsIgnoreCase(input)) {
                type = SCIMDefinitions.Returned.NEVER;
            } else if ("default".equalsIgnoreCase(input)) {
                type = SCIMDefinitions.Returned.DEFAULT;
            } else if ("request".equalsIgnoreCase(input)) {
                type = SCIMDefinitions.Returned.REQUEST;
            }
            return type;
        }

        private SCIMDefinitions.Uniqueness getDefinedUniqueness(String input) {
            SCIMDefinitions.Uniqueness type = null;
            if ("none".equalsIgnoreCase(input)) {
                type = SCIMDefinitions.Uniqueness.NONE;
            } else if ("server".equalsIgnoreCase(input)) {
                type = SCIMDefinitions.Uniqueness.SERVER;
            } else if ("global".equalsIgnoreCase(input)) {
                type = SCIMDefinitions.Uniqueness.GLOBAL;
            }
            return type;
        }

        private ArrayList<String> setCanonicalValues(JSONArray input) throws JSONException {
            ArrayList<String> canonicalValues = new ArrayList<String>();
            JSONArray canonicalValuesList = input;
            for (int index = 0; index < canonicalValuesList.length(); ++index) {
                canonicalValues.add((String)canonicalValuesList.get(index));
            }
            return canonicalValues;
        }

        private ArrayList<SCIMDefinitions.ReferenceType> setReferenceTypes(JSONArray input) throws JSONException {
            ArrayList<SCIMDefinitions.ReferenceType> referenceTypes = new ArrayList<SCIMDefinitions.ReferenceType>();
            JSONArray referenceTypesList = input;
            for (int index = 0; index < referenceTypesList.length(); ++index) {
                String referenceValue = (String)referenceTypesList.get(index);
                if (referenceValue.equalsIgnoreCase("external")) {
                    referenceTypes.add(SCIMDefinitions.ReferenceType.EXTERNAL);
                    continue;
                }
                if (referenceValue.equalsIgnoreCase("user")) {
                    referenceTypes.add(SCIMDefinitions.ReferenceType.USER);
                    continue;
                }
                if (referenceValue.equalsIgnoreCase("group")) {
                    referenceTypes.add(SCIMDefinitions.ReferenceType.GROUP);
                    continue;
                }
                if (!referenceValue.equalsIgnoreCase("uri")) continue;
                referenceTypes.add(SCIMDefinitions.ReferenceType.URI);
            }
            return referenceTypes;
        }
    }
}

