/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.charon3.core.protocol;

import org.wso2.charon3.core.exceptions.BadRequestException;
import org.wso2.charon3.core.extensions.RoleManager;
import org.wso2.charon3.core.extensions.UserManager;
import org.wso2.charon3.core.objects.bulk.BulkRequestContent;
import org.wso2.charon3.core.objects.bulk.BulkRequestData;
import org.wso2.charon3.core.objects.bulk.BulkResponseContent;
import org.wso2.charon3.core.objects.bulk.BulkResponseData;
import org.wso2.charon3.core.protocol.SCIMResponse;
import org.wso2.charon3.core.protocol.endpoints.GroupResourceManager;
import org.wso2.charon3.core.protocol.endpoints.ResourceManager;
import org.wso2.charon3.core.protocol.endpoints.RoleResourceManager;
import org.wso2.charon3.core.protocol.endpoints.UserResourceManager;

public class BulkRequestProcessor {
    private UserResourceManager userResourceManager = new UserResourceManager();
    private GroupResourceManager groupResourceManager = new GroupResourceManager();
    private RoleResourceManager roleResourceManager = new RoleResourceManager();
    private int failOnError = 0;
    private int errors = 0;
    private UserManager userManager = null;
    private RoleManager roleManager = null;

    public UserResourceManager getUserResourceManager() {
        return this.userResourceManager;
    }

    public void setUserResourceManager(UserResourceManager userResourceManager) {
        this.userResourceManager = userResourceManager;
    }

    public GroupResourceManager getGroupResourceManager() {
        return this.groupResourceManager;
    }

    public void setGroupResourceManager(GroupResourceManager groupResourceManager) {
        this.groupResourceManager = groupResourceManager;
    }

    public RoleResourceManager getRoleResourceManager() {
        return this.roleResourceManager;
    }

    public void setRoleResourceManager(RoleResourceManager roleResourceManager) {
        this.roleResourceManager = roleResourceManager;
    }

    public int getFailOnError() {
        return this.failOnError;
    }

    public void setFailOnError(int failOnError) {
        this.failOnError = failOnError;
    }

    public int getErrors() {
        return this.errors;
    }

    public void setErrors(int errors) {
        this.errors = errors;
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public RoleManager getRoleManager() {
        return this.roleManager;
    }

    public void setRoleManager(RoleManager roleManager) {
        this.roleManager = roleManager;
    }

    public BulkResponseData processBulkRequests(BulkRequestData bulkRequestData) throws BadRequestException {
        BulkResponseData bulkResponseData = new BulkResponseData();
        for (BulkRequestContent bulkRequestContent : bulkRequestData.getUserOperationRequests()) {
            if (this.failOnError == 0) {
                bulkResponseData.addUserOperation(this.getBulkResponseContent(bulkRequestContent, this.userResourceManager));
                continue;
            }
            if (this.errors >= this.failOnError) continue;
            bulkResponseData.addUserOperation(this.getBulkResponseContent(bulkRequestContent, this.userResourceManager));
        }
        for (BulkRequestContent bulkRequestContent : bulkRequestData.getGroupOperationRequests()) {
            if (this.failOnError == 0) {
                bulkResponseData.addGroupOperation(this.getBulkResponseContent(bulkRequestContent, this.groupResourceManager));
                continue;
            }
            if (this.errors >= this.failOnError) continue;
            bulkResponseData.addGroupOperation(this.getBulkResponseContent(bulkRequestContent, this.groupResourceManager));
        }
        for (BulkRequestContent bulkRequestContent : bulkRequestData.getRoleOperationRequests()) {
            if (this.failOnError == 0) {
                bulkResponseData.addRoleOperation(this.getBulkResponseContent(bulkRequestContent, this.roleResourceManager));
                continue;
            }
            if (this.errors >= this.failOnError) continue;
            bulkResponseData.addRoleOperation(this.getBulkResponseContent(bulkRequestContent, this.roleResourceManager));
        }
        bulkResponseData.setSchema("urn:ietf:params:scim:api:messages:2.0:BulkResponse");
        return bulkResponseData;
    }

    private BulkResponseContent getBulkResponseContent(BulkRequestContent bulkRequestContent, ResourceManager resourceManager) throws BadRequestException {
        BulkResponseContent bulkResponseContent = null;
        if (bulkRequestContent.getMethod().equals("POST")) {
            SCIMResponse response = bulkRequestContent.getPath().contains("/Roles") ? resourceManager.createRole(bulkRequestContent.getData(), this.roleManager) : resourceManager.create(bulkRequestContent.getData(), this.userManager, null, null);
            bulkResponseContent = this.createBulkResponseContent(response, "POST", bulkRequestContent);
            this.errorsCheck(response);
        } else if (bulkRequestContent.getMethod().equals("PUT")) {
            String resourceId = this.extractIDFromPath(bulkRequestContent.getPath());
            SCIMResponse response = bulkRequestContent.getPath().contains("/Roles") ? resourceManager.updateWithPUTRole(resourceId, bulkRequestContent.getData(), this.roleManager) : resourceManager.updateWithPUT(resourceId, bulkRequestContent.getData(), this.userManager, null, null);
            bulkResponseContent = this.createBulkResponseContent(response, "PUT", bulkRequestContent);
            this.errorsCheck(response);
        } else if (bulkRequestContent.getMethod().equals("PATCH")) {
            String resourceId = this.extractIDFromPath(bulkRequestContent.getPath());
            SCIMResponse response = bulkRequestContent.getPath().contains("/Roles") ? resourceManager.updateWithPATCHRole(resourceId, bulkRequestContent.getData(), this.roleManager) : resourceManager.updateWithPATCH(resourceId, bulkRequestContent.getData(), this.userManager, null, null);
            bulkResponseContent = this.createBulkResponseContent(response, "PATCH", bulkRequestContent);
            this.errorsCheck(response);
        } else if (bulkRequestContent.getMethod().equals("DELETE")) {
            String resourceId = this.extractIDFromPath(bulkRequestContent.getPath());
            SCIMResponse response = bulkRequestContent.getPath().contains("/Roles") ? resourceManager.deleteRole(resourceId, this.roleManager) : resourceManager.delete(resourceId, this.userManager);
            bulkResponseContent = this.createBulkResponseContent(response, "DELETE", bulkRequestContent);
            this.errorsCheck(response);
        }
        return bulkResponseContent;
    }

    private String extractIDFromPath(String path) throws BadRequestException {
        String[] parts = path.split("[/]");
        if (parts[2] != null) {
            return parts[2];
        }
        throw new BadRequestException("No resource Id is provided in path", "invalidValue");
    }

    private BulkResponseContent createBulkResponseContent(SCIMResponse response, String method, BulkRequestContent requestContent) {
        BulkResponseContent bulkResponseContent = new BulkResponseContent();
        bulkResponseContent.setScimResponse(response);
        bulkResponseContent.setMethod(method);
        if (response.getHeaderParamMap() != null) {
            bulkResponseContent.setLocation(response.getHeaderParamMap().get("Location"));
        }
        bulkResponseContent.setBulkID(requestContent.getBulkID());
        bulkResponseContent.setVersion(requestContent.getVersion());
        return bulkResponseContent;
    }

    private void errorsCheck(SCIMResponse response) {
        if (response.getResponseStatus() != 200 && response.getResponseStatus() != 201 && response.getResponseStatus() != 204) {
            ++this.errors;
        }
    }
}

