/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.charon3.core.aParser;

import java.util.Stack;

public class ParserException
extends Exception {
    private static final String newline = System.getProperty("line.separator", "\n");
    private String reason;
    private String text60;
    private int index60;
    private Stack<String> ruleStack;

    public ParserException(String reason, String text, int index, Stack<String> ruleStack) {
        this.reason = reason;
        this.ruleStack = ruleStack;
        int start = index < 30 ? 0 : index - 30;
        int end = text.length() < index + 30 ? text.length() : index + 30;
        this.text60 = text.substring(start, end).replaceAll("[\\x00-\\x1F]", " ");
        this.index60 = index < 30 ? index : 30;
    }

    public String getReason() {
        return this.reason;
    }

    public String getSubstring() {
        return this.text60;
    }

    public int getSubstringIndex() {
        return this.index60;
    }

    public Stack<String> getRuleStack() {
        return this.ruleStack;
    }

    @Override
    public String getMessage() {
        ParserException secondaryError;
        String marker = "                              ";
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.reason + newline);
        buffer.append(this.text60 + newline);
        buffer.append(marker.substring(0, this.index60) + "^" + newline);
        if (!this.ruleStack.empty()) {
            buffer.append("rule stack:");
            for (String rule : this.ruleStack) {
                buffer.append(newline + "  " + rule);
            }
        }
        if ((secondaryError = (ParserException)this.getCause()) != null) {
            buffer.append("possible cause: " + secondaryError.reason + newline);
            buffer.append(secondaryError.text60 + newline);
            buffer.append(marker.substring(0, secondaryError.index60) + "^" + newline);
            if (!secondaryError.ruleStack.empty()) {
                buffer.append("rule stack:");
                for (String rule : secondaryError.ruleStack) {
                    buffer.append(newline + "  " + rule);
                }
            }
        }
        return buffer.toString();
    }
}

