/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.charon3.core.protocol.endpoints;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.charon3.core.attributes.Attribute;
import org.wso2.charon3.core.attributes.ComplexAttribute;
import org.wso2.charon3.core.attributes.SimpleAttribute;
import org.wso2.charon3.core.encoder.JSONEncoder;
import org.wso2.charon3.core.exceptions.BadRequestException;
import org.wso2.charon3.core.exceptions.CharonException;
import org.wso2.charon3.core.exceptions.NotFoundException;
import org.wso2.charon3.core.exceptions.NotImplementedException;
import org.wso2.charon3.core.extensions.UserManager;
import org.wso2.charon3.core.protocol.SCIMResponse;
import org.wso2.charon3.core.protocol.endpoints.AbstractResourceManager;

public class SchemaResourceManager
extends AbstractResourceManager {
    private static final Logger log = LoggerFactory.getLogger(SchemaResourceManager.class);
    private static final String ATTRIBUTES = "attributes";

    @Override
    public SCIMResponse get(String id, UserManager userManager, String attributes, String excludeAttributes) {
        try {
            List<Attribute> userSchemaAttributes = userManager.getUserSchema();
            List<Attribute> userEnterpriseSchemaAttributes = userManager.getEnterpriseUserSchema();
            HashMap<String, List<Attribute>> schemas = new HashMap<String, List<Attribute>>();
            schemas.put("urn:ietf:params:scim:schemas:core:2.0:User", userSchemaAttributes);
            schemas.put("urn:ietf:params:scim:schemas:extension:enterprise:2.0:User", userEnterpriseSchemaAttributes);
            return this.buildSchemasResponse(schemas);
        }
        catch (BadRequestException | CharonException | NotFoundException | NotImplementedException e) {
            return AbstractResourceManager.encodeSCIMException(e);
        }
    }

    private SCIMResponse buildSchemasResponse(Map<String, List<Attribute>> schemas) throws CharonException, NotFoundException {
        String schemaResponseBody = this.buildSchemasResponseBody(schemas).toString();
        Map<String, String> responseHeaders = this.getResponseHeaders();
        return new SCIMResponse(200, schemaResponseBody, responseHeaders);
    }

    private JSONArray buildSchemasResponseBody(Map<String, List<Attribute>> schemas) throws CharonException {
        JSONArray rootObject = new JSONArray();
        if (schemas.get("urn:ietf:params:scim:schemas:core:2.0:User") != null) {
            JSONObject userSchemaObject = this.buildUserSchema(schemas.get("urn:ietf:params:scim:schemas:core:2.0:User"));
            rootObject.put((Object)userSchemaObject);
        }
        if (schemas.get("urn:ietf:params:scim:schemas:extension:enterprise:2.0:User") != null) {
            JSONObject enterpriseUserSchemaObject = this.buildEnterpriseUserSchema(schemas.get("urn:ietf:params:scim:schemas:extension:enterprise:2.0:User"));
            rootObject.put((Object)enterpriseUserSchemaObject);
        }
        return rootObject;
    }

    private JSONObject buildEnterpriseUserSchema(List<Attribute> enterpriseUserSchemaList) throws CharonException {
        try {
            JSONEncoder encoder = SchemaResourceManager.getEncoder();
            JSONObject enterpriseUserSchemaObject = new JSONObject();
            enterpriseUserSchemaObject.put("id", (Object)"urn:ietf:params:scim:schemas:extension:enterprise:2.0:User");
            enterpriseUserSchemaObject.put("name", (Object)"EnterpriseUser");
            enterpriseUserSchemaObject.put("description", (Object)"Enterprise User");
            JSONArray enterpriseUserAttributeArray = this.buildSchemaAttributeArray(enterpriseUserSchemaList, encoder);
            enterpriseUserSchemaObject.put(ATTRIBUTES, (Object)enterpriseUserAttributeArray);
            return enterpriseUserSchemaObject;
        }
        catch (JSONException e) {
            throw new CharonException("Error while encoding enterprise user schema.", e);
        }
    }

    private JSONObject buildUserSchema(List<Attribute> userSchemaAttributeList) throws CharonException {
        try {
            JSONEncoder encoder = SchemaResourceManager.getEncoder();
            JSONObject userSchemaObject = new JSONObject();
            userSchemaObject.put("id", (Object)"urn:ietf:params:scim:schemas:core:2.0:User");
            userSchemaObject.put("name", (Object)"User");
            userSchemaObject.put("description", (Object)"User Account");
            JSONArray userSchemaAttributeArray = this.buildSchemaAttributeArray(userSchemaAttributeList, encoder);
            userSchemaObject.put(ATTRIBUTES, (Object)userSchemaAttributeArray);
            return userSchemaObject;
        }
        catch (JSONException e) {
            throw new CharonException("Error while encoding user schema", e);
        }
    }

    private JSONArray buildSchemaAttributeArray(List<Attribute> schemaAttributeList, JSONEncoder encoder) throws JSONException {
        JSONArray schemaAttributeArray = new JSONArray();
        for (Attribute schemaAttribute : schemaAttributeList) {
            JSONObject schemaJSONAttribute = schemaAttribute instanceof ComplexAttribute ? encoder.encodeComplexAttributeSchema((ComplexAttribute)schemaAttribute) : (schemaAttribute instanceof SimpleAttribute ? encoder.encodeSimpleAttributeSchema((SimpleAttribute)schemaAttribute) : encoder.encodeBasicAttributeSchema(schemaAttribute));
            schemaAttributeArray.put((Object)schemaJSONAttribute);
        }
        return schemaAttributeArray;
    }

    private Map<String, String> getResponseHeaders() throws NotFoundException {
        HashMap<String, String> responseHeaders = new HashMap<String, String>();
        responseHeaders.put("Content-Type", "application/scim+json");
        responseHeaders.put("Location", SchemaResourceManager.getResourceEndpointURL("/Schemas"));
        return responseHeaders;
    }

    @Override
    public SCIMResponse create(String scimObjectString, UserManager userManager, String attributes, String excludeAttributes) {
        String error = "Request is undefined";
        BadRequestException badRequestException = new BadRequestException(error, "invalidPath");
        return SchemaResourceManager.encodeSCIMException(badRequestException);
    }

    @Override
    public SCIMResponse delete(String id, UserManager userManager) {
        String error = "Request is undefined";
        BadRequestException badRequestException = new BadRequestException(error, "invalidPath");
        return SchemaResourceManager.encodeSCIMException(badRequestException);
    }

    @Override
    public SCIMResponse listWithGET(UserManager userManager, String filter, int startIndex, int count, String sortBy, String sortOrder, String domainName, String attributes, String excludeAttributes) {
        String error = "Request is undefined";
        BadRequestException badRequestException = new BadRequestException(error, "invalidPath");
        return SchemaResourceManager.encodeSCIMException(badRequestException);
    }

    @Override
    public SCIMResponse listWithGET(UserManager userManager, String filter, Integer startIndexInt, Integer countInt, String sortBy, String sortOrder, String domainName, String attributes, String excludeAttributes) {
        String error = "Request is undefined";
        BadRequestException badRequestException = new BadRequestException(error, "invalidPath");
        return SchemaResourceManager.encodeSCIMException(badRequestException);
    }

    @Override
    public SCIMResponse listWithPOST(String resourceString, UserManager userManager) {
        String error = "Request is undefined";
        BadRequestException badRequestException = new BadRequestException(error, "invalidPath");
        return SchemaResourceManager.encodeSCIMException(badRequestException);
    }

    @Override
    public SCIMResponse updateWithPUT(String existingId, String scimObjectString, UserManager userManager, String attributes, String excludeAttributes) {
        String error = "Request is undefined";
        BadRequestException badRequestException = new BadRequestException(error, "invalidPath");
        return SchemaResourceManager.encodeSCIMException(badRequestException);
    }

    @Override
    public SCIMResponse updateWithPATCH(String existingId, String scimObjectString, UserManager userManager, String attributes, String excludeAttributes) {
        String error = "Request is undefined";
        BadRequestException badRequestException = new BadRequestException(error, "invalidPath");
        return SchemaResourceManager.encodeSCIMException(badRequestException);
    }
}

