/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.charon3.core.objects;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.wso2.charon3.core.attributes.Attribute;
import org.wso2.charon3.core.attributes.ComplexAttribute;
import org.wso2.charon3.core.attributes.DefaultAttributeFactory;
import org.wso2.charon3.core.attributes.MultiValuedAttribute;
import org.wso2.charon3.core.attributes.SimpleAttribute;
import org.wso2.charon3.core.exceptions.BadRequestException;
import org.wso2.charon3.core.exceptions.CharonException;
import org.wso2.charon3.core.objects.SCIMObject;
import org.wso2.charon3.core.objects.ScimAttributeAware;
import org.wso2.charon3.core.schema.ResourceTypeSchema;
import org.wso2.charon3.core.schema.SCIMDefinitions;
import org.wso2.charon3.core.schema.SCIMSchemaDefinitions;

public class AbstractSCIMObject
extends ScimAttributeAware
implements SCIMObject {
    private static final long serialVersionUID = 6106269076155338045L;
    protected Map<String, Attribute> attributeList = new HashMap<String, Attribute>();
    protected List<String> schemaList = new ArrayList<String>();

    public void setAttribute(Attribute newAttribute, ResourceTypeSchema resourceSchema) {
        if (!this.isAttributeExist(newAttribute.getName())) {
            this.attributeList.put(newAttribute.getName(), newAttribute);
        }
    }

    public void setAttribute(Attribute newAttribute) {
        if (!this.isAttributeExist(newAttribute.getName())) {
            this.attributeList.put(newAttribute.getName(), newAttribute);
        }
    }

    protected boolean isSchemaExists(String schemaName) {
        return this.schemaList.contains(schemaName);
    }

    public boolean isAttributeExist(String attributeName) {
        return this.attributeList.containsKey(attributeName);
    }

    @Override
    public Map<String, Attribute> getAttributeList() {
        return this.attributeList;
    }

    public void setSchema(String schema) {
        this.schemaList.add(schema);
    }

    @Override
    public List<String> getSchemaList() {
        return this.schemaList;
    }

    @Override
    public Attribute getAttribute(String attributeName) {
        if (this.attributeList.containsKey(attributeName)) {
            return this.attributeList.get(attributeName);
        }
        return null;
    }

    @Override
    public void deleteAttribute(String id) {
        if (this.attributeList.containsKey(id)) {
            this.attributeList.remove(id);
        }
    }

    public void deleteSubAttribute(String parentAttribute, String childAttribute) {
        if (this.attributeList.containsKey(parentAttribute)) {
            ((ComplexAttribute)this.attributeList.get(parentAttribute)).removeSubAttribute(childAttribute);
        }
    }

    public void deleteSubSubAttribute(String childAttribute, String parentAttribute, String grandParentAttribute) throws CharonException {
        if (this.attributeList.containsKey(grandParentAttribute)) {
            ComplexAttribute grandParent = (ComplexAttribute)this.attributeList.get(grandParentAttribute);
            Attribute parent = grandParent.getSubAttribute(parentAttribute);
            ((ComplexAttribute)parent).removeSubAttribute(childAttribute);
        }
    }

    public void deleteValuesSubAttribute(String attribute, String subAttribute, String subSimpleAttribute) {
        if (this.attributeList.containsKey(attribute)) {
            MultiValuedAttribute parentAttribute = (MultiValuedAttribute)this.attributeList.get(attribute);
            List<Attribute> attributeValues = parentAttribute.getAttributeValues();
            for (Attribute subValue : attributeValues) {
                if (!subAttribute.equals(subValue.getName())) continue;
                ((ComplexAttribute)subValue).removeSubAttribute(subSimpleAttribute);
                break;
            }
        }
    }

    public void deleteSubValuesSubAttribute(String grandParentAttribute, String parentAttribute, String subValue, String childAttribute) {
        if (this.attributeList.containsKey(grandParentAttribute)) {
            ComplexAttribute grandParent = (ComplexAttribute)this.attributeList.get(grandParentAttribute);
            Map<String, Attribute> subAttributeList = grandParent.getSubAttributesList();
            MultiValuedAttribute parent = (MultiValuedAttribute)subAttributeList.get(parentAttribute);
            List<Attribute> parentAttributeList = parent.getAttributeValues();
            for (Attribute parentsSubValue : parentAttributeList) {
                if (!subValue.equals(parentsSubValue.getName())) continue;
                ((ComplexAttribute)parentsSubValue).removeSubAttribute(childAttribute);
            }
        }
    }

    protected boolean isMetaAttributeExist() {
        return this.attributeList.containsKey("meta");
    }

    public void setId(String id) throws CharonException, BadRequestException {
        if (this.isAttributeExist("id")) {
            String error = "Read only attribute is trying to be modified";
            throw new CharonException(error);
        }
        SimpleAttribute idAttribute = new SimpleAttribute("id", id);
        idAttribute = (SimpleAttribute)DefaultAttributeFactory.createAttribute(SCIMSchemaDefinitions.ID, idAttribute);
        this.setAttribute(idAttribute);
    }

    public void setExternalId(String externalId) throws CharonException, BadRequestException {
        SimpleAttribute externalIdAttribute = new SimpleAttribute("externalId", externalId);
        DefaultAttributeFactory.createAttribute(SCIMSchemaDefinitions.EXTERNAL_ID, externalIdAttribute);
        this.setAttribute(externalIdAttribute);
    }

    @Deprecated
    public void setCreatedDate(Date createdDate) throws CharonException, BadRequestException {
        this.setCreatedInstant(createdDate == null ? null : createdDate.toInstant());
    }

    public void setCreatedInstant(Instant created) throws CharonException, BadRequestException {
        SimpleAttribute createdDateAttribute = new SimpleAttribute("created", created);
        createdDateAttribute = (SimpleAttribute)DefaultAttributeFactory.createAttribute(SCIMSchemaDefinitions.CREATED, createdDateAttribute);
        if (this.getMetaAttribute() != null) {
            ComplexAttribute metaAttribute = this.getMetaAttribute();
            if (metaAttribute.isSubAttributeExist(createdDateAttribute.getName())) {
                String error = "Read only meta attribute is tried to modify";
                throw new CharonException(error);
            }
            metaAttribute.setSubAttribute(createdDateAttribute);
        } else {
            this.createMetaAttribute();
            this.getMetaAttribute().setSubAttribute(createdDateAttribute);
        }
    }

    @Deprecated
    public void setLastModified(Date lastModifiedDate) throws CharonException, BadRequestException {
        this.setLastModifiedInstant(lastModifiedDate == null ? null : lastModifiedDate.toInstant());
    }

    public void setLastModifiedInstant(Instant lastModified) throws CharonException, BadRequestException {
        SimpleAttribute lastModifiedAttribute = (SimpleAttribute)DefaultAttributeFactory.createAttribute(SCIMSchemaDefinitions.LAST_MODIFIED, new SimpleAttribute("lastModified", lastModified));
        if (this.getMetaAttribute() != null) {
            ComplexAttribute metaAttribute = this.getMetaAttribute();
            if (metaAttribute.isSubAttributeExist(lastModifiedAttribute.getName())) {
                metaAttribute.removeSubAttribute(lastModifiedAttribute.getName());
                metaAttribute.setSubAttribute(lastModifiedAttribute);
            } else {
                metaAttribute.setSubAttribute(lastModifiedAttribute);
            }
        } else {
            this.createMetaAttribute();
            this.getMetaAttribute().setSubAttribute(lastModifiedAttribute);
        }
    }

    protected void createMetaAttribute() throws CharonException, BadRequestException {
        ComplexAttribute metaAttribute = (ComplexAttribute)DefaultAttributeFactory.createAttribute(SCIMSchemaDefinitions.META, new ComplexAttribute("meta"));
        if (this.isMetaAttributeExist()) {
            String error = "Read only meta attribute is tried to modify";
            throw new CharonException(error);
        }
        this.attributeList.put("meta", metaAttribute);
    }

    protected ComplexAttribute getMetaAttribute() {
        if (this.isMetaAttributeExist()) {
            return (ComplexAttribute)this.attributeList.get("meta");
        }
        return null;
    }

    public void setLocation(String location) throws CharonException, BadRequestException {
        SimpleAttribute locationAttribute = (SimpleAttribute)DefaultAttributeFactory.createAttribute(SCIMSchemaDefinitions.LOCATION, new SimpleAttribute("location", location));
        if (this.getMetaAttribute() != null) {
            ComplexAttribute metaAttribute = this.getMetaAttribute();
            if (metaAttribute.isSubAttributeExist(locationAttribute.getName())) {
                String error = "Read only attribute is tried to modify";
                throw new CharonException(error);
            }
            metaAttribute.setSubAttribute(locationAttribute);
        } else {
            this.createMetaAttribute();
            this.getMetaAttribute().setSubAttribute(locationAttribute);
        }
    }

    public void setResourceType(String resourceType) throws BadRequestException, CharonException {
        SimpleAttribute resourceTypeAttribute = (SimpleAttribute)DefaultAttributeFactory.createAttribute(SCIMSchemaDefinitions.RESOURCE_TYPE, new SimpleAttribute("resourceType", resourceType));
        if (this.getMetaAttribute() != null) {
            ComplexAttribute metaAttribute = this.getMetaAttribute();
            if (metaAttribute.isSubAttributeExist(resourceTypeAttribute.getName())) {
                String error = "Read only attribute is tried to modify";
                throw new CharonException(error);
            }
            metaAttribute.setSubAttribute(resourceTypeAttribute);
        } else {
            this.createMetaAttribute();
            this.getMetaAttribute().setSubAttribute(resourceTypeAttribute);
        }
    }

    @Deprecated
    public Date getCreatedDate() throws CharonException {
        Instant created = this.getCreatedInstant();
        return created != null ? new Date(created.toEpochMilli()) : null;
    }

    @Deprecated
    public Date getLastModified() throws CharonException {
        Instant lastModified = this.getLastModifiedInstant();
        return lastModified != null ? new Date(lastModified.toEpochMilli()) : null;
    }

    public String toString() {
        String scimObjectStringValue = null;
        Map<String, Attribute> attributeList = this.getAttributeList();
        for (Attribute attribute : attributeList.values()) {
            Map<String, Attribute> subSubAttributes;
            String complexSubValue;
            ComplexAttribute complexSubAttribute;
            if (attribute instanceof SimpleAttribute) {
                scimObjectStringValue = this.simpleAttributeToString(scimObjectStringValue, attribute);
                continue;
            }
            if (attribute instanceof ComplexAttribute) {
                ComplexAttribute complexAttribute = (ComplexAttribute)attribute;
                String complexValue = null;
                Map<String, Attribute> subAttributes = complexAttribute.getSubAttributesList();
                for (Attribute subAttribute : subAttributes.values()) {
                    if (subAttribute instanceof SimpleAttribute) {
                        complexValue = this.simpleAttributeToString(complexValue, (SimpleAttribute)subAttribute);
                        continue;
                    }
                    if (subAttribute instanceof MultiValuedAttribute) {
                        if (!subAttribute.getType().equals((Object)SCIMDefinitions.DataType.COMPLEX)) {
                            String primitiveValue = null;
                            primitiveValue = this.multiValuedPrimitiveAttributeToString(((MultiValuedAttribute)subAttribute).getAttributePrimitiveValues(), subAttribute.getName());
                            if (complexValue == null) {
                                complexValue = primitiveValue;
                                continue;
                            }
                            complexValue = complexValue + "," + primitiveValue;
                            continue;
                        }
                        String multiValue = null;
                        List<Attribute> subAttributeList = ((MultiValuedAttribute)subAttribute).getAttributeValues();
                        for (Attribute subValue : subAttributeList) {
                            ComplexAttribute complexSubAttribute2 = (ComplexAttribute)subValue;
                            String complexSubValue2 = null;
                            Map<String, Attribute> subSubAttributes2 = complexSubAttribute2.getSubAttributesList();
                            for (Attribute subSubAttribute : subSubAttributes2.values()) {
                                if (subSubAttribute instanceof SimpleAttribute) {
                                    complexSubValue2 = this.simpleAttributeToString(complexSubValue2, (SimpleAttribute)subSubAttribute);
                                    continue;
                                }
                                if (!(subSubAttribute instanceof MultiValuedAttribute)) continue;
                                complexSubValue2 = this.multiValuedPrimitiveAttributeToString(((MultiValuedAttribute)subSubAttribute).getAttributePrimitiveValues(), subSubAttribute.getName());
                            }
                            complexSubValue2 = "{" + complexSubValue2 + "}";
                            if (multiValue == null) {
                                multiValue = complexSubValue2;
                                continue;
                            }
                            multiValue = multiValue + "," + complexSubValue2;
                        }
                        if (scimObjectStringValue != null) {
                            scimObjectStringValue = scimObjectStringValue + "," + attribute.getName() + ":{" + subAttribute.getName() + ":[" + multiValue + "]}";
                            continue;
                        }
                        scimObjectStringValue = attribute.getName() + ":{" + subAttribute.getName() + ":[" + multiValue + "]}";
                        continue;
                    }
                    if (!(subAttribute instanceof ComplexAttribute)) continue;
                    complexSubAttribute = (ComplexAttribute)subAttribute;
                    complexSubValue = null;
                    subSubAttributes = complexSubAttribute.getSubAttributesList();
                    for (Attribute subSubAttribute : subSubAttributes.values()) {
                        if (subSubAttribute instanceof SimpleAttribute) {
                            complexSubValue = this.simpleAttributeToString(complexSubValue, (SimpleAttribute)subSubAttribute);
                            continue;
                        }
                        if (!(subSubAttribute instanceof MultiValuedAttribute)) continue;
                        complexSubValue = this.multiValuedPrimitiveAttributeToString(((MultiValuedAttribute)subSubAttribute).getAttributePrimitiveValues(), subSubAttribute.getName());
                    }
                    complexValue = complexSubValue = subAttribute.getName() + ":{" + complexSubValue + "}";
                }
                if (scimObjectStringValue == null) {
                    scimObjectStringValue = attribute.getName() + ":{" + complexValue + "}";
                    continue;
                }
                scimObjectStringValue = scimObjectStringValue + "," + attribute.getName() + ":{" + complexValue + "}";
                continue;
            }
            if (!(attribute instanceof MultiValuedAttribute)) continue;
            MultiValuedAttribute multiValuedAttribute = (MultiValuedAttribute)attribute;
            if (multiValuedAttribute.getType().equals((Object)SCIMDefinitions.DataType.COMPLEX)) {
                String multiValue = null;
                List<Attribute> subAttributeList = multiValuedAttribute.getAttributeValues();
                for (Attribute subAttribute : subAttributeList) {
                    complexSubAttribute = (ComplexAttribute)subAttribute;
                    complexSubValue = null;
                    subSubAttributes = complexSubAttribute.getSubAttributesList();
                    for (Attribute subSubAttribute : subSubAttributes.values()) {
                        if (subSubAttribute instanceof SimpleAttribute) {
                            complexSubValue = this.simpleAttributeToString(complexSubValue, (SimpleAttribute)subSubAttribute);
                            continue;
                        }
                        if (!(subSubAttribute instanceof MultiValuedAttribute)) continue;
                        complexSubValue = this.multiValuedPrimitiveAttributeToString(((MultiValuedAttribute)subSubAttribute).getAttributePrimitiveValues(), subSubAttribute.getName());
                    }
                    complexSubValue = "{" + complexSubValue + "}";
                    if (multiValue == null) {
                        multiValue = complexSubValue;
                        continue;
                    }
                    multiValue = multiValue + "," + complexSubValue;
                }
                if (scimObjectStringValue != null) {
                    scimObjectStringValue = scimObjectStringValue + "," + attribute.getName() + ":[" + multiValue + "]";
                    continue;
                }
                scimObjectStringValue = attribute.getName() + ":[" + multiValue + "]";
                continue;
            }
            List<Object> primitiveValueList = multiValuedAttribute.getAttributePrimitiveValues();
            String complexValue = null;
            complexValue = this.multiValuedPrimitiveAttributeToString(primitiveValueList, multiValuedAttribute.getName());
            if (scimObjectStringValue == null) {
                scimObjectStringValue = complexValue;
                continue;
            }
            scimObjectStringValue = scimObjectStringValue + "," + complexValue;
        }
        return scimObjectStringValue;
    }

    private String simpleAttributeToString(String stringValue, Attribute attribute) {
        SimpleAttribute simpleAttribute = (SimpleAttribute)attribute;
        String simpleValue = simpleAttribute.getName() + " : " + simpleAttribute.getValue();
        stringValue = stringValue != null ? stringValue + "," + simpleValue : simpleValue;
        return stringValue;
    }

    private String multiValuedPrimitiveAttributeToString(List<Object> attributePrimitiveValues, String attributeName) {
        String complexValue = attributeName + ":[";
        for (Object item : attributePrimitiveValues) {
            if (complexValue.equals(attributeName + "[")) {
                complexValue = (String)item;
                continue;
            }
            complexValue = complexValue + "," + (String)item;
        }
        complexValue = complexValue + "]";
        return complexValue;
    }

    @Override
    public AbstractSCIMObject getResource() {
        return this;
    }
}

