/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.charon3.core.schema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.wso2.charon3.core.schema.AttributeSchema;
import org.wso2.charon3.core.schema.SCIMAttributeSchema;
import org.wso2.charon3.core.schema.SCIMDefinitions;
import org.wso2.charon3.core.schema.SCIMResourceTypeSchema;

public class SCIMSchemaDefinitions {
    public static final SCIMAttributeSchema RESOURCE_TYPE = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:meta.resourceType", "resourceType", SCIMDefinitions.DataType.STRING, false, "The name of the resource type of the resource.", false, true, SCIMDefinitions.Mutability.READ_ONLY, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, null);
    public static final SCIMAttributeSchema CREATED = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:meta.created", "created", SCIMDefinitions.DataType.DATE_TIME, false, "The \"DateTime\" that the resource was added to the service provider.", false, false, SCIMDefinitions.Mutability.READ_ONLY, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, null);
    public static final SCIMAttributeSchema LAST_MODIFIED = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:meta.lastModified", "lastModified", SCIMDefinitions.DataType.DATE_TIME, false, "The most recent DateTime that the details of this resource were updated at the service provider.", false, false, SCIMDefinitions.Mutability.READ_ONLY, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, null);
    public static final SCIMAttributeSchema LOCATION = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:meta.location", "location", SCIMDefinitions.DataType.STRING, false, "Location  The uri of the resource being returned", false, false, SCIMDefinitions.Mutability.READ_ONLY, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, null);
    public static final SCIMAttributeSchema VERSION = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:meta.version", "version", SCIMDefinitions.DataType.STRING, false, "The version of the resource being returned.", false, true, SCIMDefinitions.Mutability.READ_ONLY, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, null);
    public static final SCIMAttributeSchema ID = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:id", "id", SCIMDefinitions.DataType.STRING, false, "Unique identifier for the SCIM Resource as defined by the Service Provider.", false, true, SCIMDefinitions.Mutability.READ_ONLY, SCIMDefinitions.Returned.ALWAYS, SCIMDefinitions.Uniqueness.SERVER, null, null, null);
    public static final SCIMAttributeSchema EXTERNAL_ID = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:externalId", "externalId", SCIMDefinitions.DataType.STRING, false, "A String that is an identifier for the resource as defined by the provisioning client.The service provider MUST always interpret the externalId as scoped to the provisioning domain.", false, true, SCIMDefinitions.Mutability.READ_WRITE, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, null);
    public static final SCIMAttributeSchema META = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:meta", "meta", SCIMDefinitions.DataType.COMPLEX, false, "A complex attribute containing resource metadata.", false, false, SCIMDefinitions.Mutability.READ_ONLY, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, new ArrayList<AttributeSchema>(Arrays.asList(RESOURCE_TYPE, CREATED, LAST_MODIFIED, LOCATION, VERSION)));
    public static final SCIMResourceTypeSchema SCIM_USER_SCHEMA = SCIMResourceTypeSchema.createSCIMResourceSchema(new ArrayList<String>(Arrays.asList("urn:ietf:params:scim:schemas:core:2.0:User")), ID, EXTERNAL_ID, META, SCIMUserSchemaDefinition.USERNAME, SCIMUserSchemaDefinition.NAME, SCIMUserSchemaDefinition.DISPLAY_NAME, SCIMUserSchemaDefinition.NICK_NAME, SCIMUserSchemaDefinition.PROFILE_URL, SCIMUserSchemaDefinition.TITLE, SCIMUserSchemaDefinition.USER_TYPE, SCIMUserSchemaDefinition.PREFERRED_LANGUAGE, SCIMUserSchemaDefinition.LOCALE, SCIMUserSchemaDefinition.TIME_ZONE, SCIMUserSchemaDefinition.ACTIVE, SCIMUserSchemaDefinition.PASSWORD, SCIMUserSchemaDefinition.EMAILS, SCIMUserSchemaDefinition.PHONE_NUMBERS, SCIMUserSchemaDefinition.IMS, SCIMUserSchemaDefinition.PHOTOS, SCIMUserSchemaDefinition.ADDRESSES, SCIMUserSchemaDefinition.GROUPS, SCIMUserSchemaDefinition.ENTITLEMENTS, SCIMUserSchemaDefinition.ROLES, SCIMUserSchemaDefinition.X509CERTIFICATES);
    public static final SCIMResourceTypeSchema SCIM_GROUP_SCHEMA = SCIMResourceTypeSchema.createSCIMResourceSchema(new ArrayList<String>(Arrays.asList("urn:ietf:params:scim:schemas:core:2.0:Group")), ID, EXTERNAL_ID, META, SCIMGroupSchemaDefinition.DISPLAY_NAME, SCIMGroupSchemaDefinition.MEMBERS);
    public static final SCIMResourceTypeSchema SCIM_ROLE_SCHEMA = SCIMResourceTypeSchema.createSCIMResourceSchema(new ArrayList<String>(Collections.singletonList("urn:ietf:params:scim:schemas:extension:2.0:Role")), ID, SCIMRoleSchemaDefinition.DISPLAY_NAME, SCIMRoleSchemaDefinition.USERS, SCIMRoleSchemaDefinition.GROUPS, SCIMRoleSchemaDefinition.PERMISSIONS);
    public static final SCIMResourceTypeSchema SCIM_SERVICE_PROVIDER_CONFIG_SCHEMA = SCIMResourceTypeSchema.createSCIMResourceSchema(new ArrayList<String>(Arrays.asList("urn:ietf:params:scim:schemas:core:2.0:ServiceProviderConfig")), META, SCIMServiceProviderConfigSchemaDefinition.DOCUMENTATION_URI, SCIMServiceProviderConfigSchemaDefinition.PATCH, SCIMServiceProviderConfigSchemaDefinition.BULK, SCIMServiceProviderConfigSchemaDefinition.SORT, SCIMServiceProviderConfigSchemaDefinition.FILTER, SCIMServiceProviderConfigSchemaDefinition.CHANGE_PASSWORD, SCIMServiceProviderConfigSchemaDefinition.ETAG, SCIMServiceProviderConfigSchemaDefinition.AUTHENTICATION_SCHEMES);
    public static final SCIMResourceTypeSchema SCIM_RESOURCE_TYPE_SCHEMA = SCIMResourceTypeSchema.createSCIMResourceSchema(new ArrayList<String>(Arrays.asList("urn:ietf:params:scim:api:messages:2.0:ListResponse")), META, SCIMResourceTypeSchemaDefinition.ID, SCIMResourceTypeSchemaDefinition.NAME, SCIMResourceTypeSchemaDefinition.ENDPOINT, SCIMResourceTypeSchemaDefinition.DESCRIPTION, SCIMResourceTypeSchemaDefinition.SCHEMA, SCIMResourceTypeSchemaDefinition.SCHEMA_EXTENSIONS);

    public static class SCIMResourceTypeSchemaDefinition {
        public static final SCIMAttributeSchema SCHEMA_EXTENSION_SCHEMA = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:RESOURCE_TYPE:schemaExtension.schema", "schema", SCIMDefinitions.DataType.REFERENCE, false, "The uri of a schema extension.", true, false, SCIMDefinitions.Mutability.READ_ONLY, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, new ArrayList<SCIMDefinitions.ReferenceType>(Arrays.asList(SCIMDefinitions.ReferenceType.URI)), null);
        public static final SCIMAttributeSchema SCHEMA_EXTENSION_REQUIRED = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:RESOURCE_TYPE:schemaExtension.required", "required", SCIMDefinitions.DataType.BOOLEAN, false, "A Boolean value that specifies whether or not the schema extension is required for the resource type.", true, false, SCIMDefinitions.Mutability.READ_ONLY, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, null);
        public static final SCIMAttributeSchema ID = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:RESOURCE_TYPE:id", "id", SCIMDefinitions.DataType.STRING, false, "The resource type's server unique id", true, false, SCIMDefinitions.Mutability.READ_ONLY, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, null);
        public static final SCIMAttributeSchema DESCRIPTION = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:RESOURCE_TYPE:description", "description", SCIMDefinitions.DataType.STRING, false, "e resource type's human-readable description. When applicable, service providers MUST specify the description.", true, false, SCIMDefinitions.Mutability.READ_ONLY, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, null);
        public static final SCIMAttributeSchema NAME = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:RESOURCE_TYPE:name", "name", SCIMDefinitions.DataType.STRING, false, "The resource type name.  When applicable, service providers MUST specify the name, e.g., 'User'.\"", true, false, SCIMDefinitions.Mutability.READ_ONLY, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, null);
        public static final SCIMAttributeSchema ENDPOINT = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:RESOURCE_TYPE:endpoint", "endpoint", SCIMDefinitions.DataType.REFERENCE, false, "The resource type's HTTP-addressable endpoint relative to the Base URL, e.g., '/Users'.", true, false, SCIMDefinitions.Mutability.READ_ONLY, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, new ArrayList<SCIMDefinitions.ReferenceType>(Arrays.asList(SCIMDefinitions.ReferenceType.URI)), null);
        public static final SCIMAttributeSchema SCHEMA = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:RESOURCE_TYPE:schema", "schema", SCIMDefinitions.DataType.REFERENCE, false, "The resource type's primary/base schema uri.", true, false, SCIMDefinitions.Mutability.READ_ONLY, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, new ArrayList<SCIMDefinitions.ReferenceType>(Arrays.asList(SCIMDefinitions.ReferenceType.URI)), null);
        public static final SCIMAttributeSchema SCHEMA_EXTENSIONS = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:RESOURCE_TYPE:schemaExtensions", "schemaExtensions", SCIMDefinitions.DataType.COMPLEX, false, "A list of URIs of the resource type's schema extensions.", true, false, SCIMDefinitions.Mutability.READ_ONLY, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, new ArrayList<AttributeSchema>(Arrays.asList(SCHEMA_EXTENSION_SCHEMA, SCHEMA_EXTENSION_REQUIRED)));
    }

    public static class SCIMServiceProviderConfigSchemaDefinition {
        public static final SCIMAttributeSchema PATCH_SUPPORTED = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:ServiceProviderConfig:patcg.supported", "supported", SCIMDefinitions.DataType.BOOLEAN, false, "A Boolean value specifying whether or not the operation is supported.", true, false, SCIMDefinitions.Mutability.READ_ONLY, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, null);
        public static final SCIMAttributeSchema BULK_SUPPORTED = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:ServiceProviderConfig:bulk.supported", "supported", SCIMDefinitions.DataType.BOOLEAN, false, "A Boolean value specifying whether or not the operation is supported.", true, false, SCIMDefinitions.Mutability.READ_ONLY, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, null);
        public static final SCIMAttributeSchema FILTER_SUPPORTED = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:ServiceProviderConfig:filter.supported", "supported", SCIMDefinitions.DataType.BOOLEAN, false, "A Boolean value specifying whether or not the operation is supported.", true, false, SCIMDefinitions.Mutability.READ_ONLY, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, null);
        public static final SCIMAttributeSchema SORT_SUPPORTED = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:ServiceProviderConfig:sort.supported", "supported", SCIMDefinitions.DataType.BOOLEAN, false, "A Boolean value specifying whether or not the operation is supported.", true, false, SCIMDefinitions.Mutability.READ_ONLY, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, null);
        public static final SCIMAttributeSchema ETAG_SUPPORTED = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:ServiceProviderConfig:etag.supported", "supported", SCIMDefinitions.DataType.BOOLEAN, false, "A Boolean value specifying whether or not the operation is supported.", true, false, SCIMDefinitions.Mutability.READ_ONLY, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, null);
        public static final SCIMAttributeSchema CHANGE_PASSWORD_SUPPORTED = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:ServiceProviderConfig:changePassword.supported", "supported", SCIMDefinitions.DataType.BOOLEAN, false, "A Boolean value specifying whether or not the operation is supported.", true, false, SCIMDefinitions.Mutability.READ_ONLY, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, null);
        public static final SCIMAttributeSchema MAX_OPERATIONS = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:ServiceProviderConfig:bulk.maxOperations", "maxOperations", SCIMDefinitions.DataType.INTEGER, false, "An integer value specifying the maximum number of operations.", true, false, SCIMDefinitions.Mutability.READ_ONLY, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, null);
        public static final SCIMAttributeSchema MAX_PAYLOAD_SIZE = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:ServiceProviderConfig:bulk.maxPayloadSize", "maxPayloadSize", SCIMDefinitions.DataType.INTEGER, false, "An integer value specifying the maximum payload size in bytes.", true, false, SCIMDefinitions.Mutability.READ_ONLY, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, null);
        public static final SCIMAttributeSchema MAX_RESULTS = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:ServiceProviderConfig:filter.maxResults", "maxResults", SCIMDefinitions.DataType.INTEGER, false, "An integer value specifying the maximum number of resources returned in a response.", true, false, SCIMDefinitions.Mutability.READ_ONLY, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, null);
        public static final SCIMAttributeSchema NAME = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:ServiceProviderConfig:authenticationSchemes.name", "name", SCIMDefinitions.DataType.STRING, false, "The common authentication scheme name,e.g., HTTP Basic.", true, false, SCIMDefinitions.Mutability.READ_ONLY, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, null);
        public static final SCIMAttributeSchema DESCRIPTION = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:ServiceProviderConfig:authenticationSchemes.description", "description", SCIMDefinitions.DataType.STRING, false, "A description of the authentication scheme.", true, false, SCIMDefinitions.Mutability.READ_ONLY, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, null);
        public static final SCIMAttributeSchema SPEC_URI = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:ServiceProviderConfig:authenticationSchemes.specUri", "specUri", SCIMDefinitions.DataType.REFERENCE, false, "An HTTP-addressable URL pointing to the authentication scheme's specification.", false, false, SCIMDefinitions.Mutability.READ_ONLY, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, new ArrayList<SCIMDefinitions.ReferenceType>(Arrays.asList(SCIMDefinitions.ReferenceType.EXTERNAL)), null);
        public static final SCIMAttributeSchema AUTHENTICATION_SCHEMES_DOCUMENTATION_URI = SCIMAttributeSchema.createSCIMAttributeSchema("documentationUri", "urn:ietf:params:scim:schemas:core:2.0:ServiceProviderConfig:authenticationSchemes.documentationUri", SCIMDefinitions.DataType.REFERENCE, false, "An HTTP-addressable URL pointing to the service provider's human-consumable help documentation.", false, false, SCIMDefinitions.Mutability.READ_ONLY, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, new ArrayList<SCIMDefinitions.ReferenceType>(Arrays.asList(SCIMDefinitions.ReferenceType.EXTERNAL)), null);
        public static final SCIMAttributeSchema TYPE = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:ServiceProviderConfig:authenticationSchemes.type", "type", SCIMDefinitions.DataType.STRING, false, "A label indicating the attribute's function, e.g., 'work' or 'home'.", true, false, SCIMDefinitions.Mutability.READ_ONLY, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, null);
        public static final SCIMAttributeSchema PRIMARY = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:ServiceProviderConfig:authenticationSchemes.primary", "primary", SCIMDefinitions.DataType.BOOLEAN, false, "A Boolean value indicating the 'primary' or preferred attribute value for this attribute.  The primary attribute value 'true' MUST appear no more than once.", false, false, SCIMDefinitions.Mutability.READ_ONLY, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, null);
        public static final SCIMAttributeSchema DOCUMENTATION_URI = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:ServiceProviderConfig:documentationUri", "documentationUri", SCIMDefinitions.DataType.REFERENCE, false, "An HTTP-addressable URL pointing to the service provider's human-consumable help documentation.", true, false, SCIMDefinitions.Mutability.READ_ONLY, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, null);
        public static final SCIMAttributeSchema PATCH = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:ServiceProviderConfig:patch", "patch", SCIMDefinitions.DataType.COMPLEX, false, "A complex type that specifies PATCH configuration options.", true, false, SCIMDefinitions.Mutability.READ_ONLY, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, new ArrayList<AttributeSchema>(Arrays.asList(PATCH_SUPPORTED)));
        public static final SCIMAttributeSchema BULK = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:ServiceProviderConfig:bulk", "bulk", SCIMDefinitions.DataType.COMPLEX, false, "A complex type that specifies bulk configuration options.", true, false, SCIMDefinitions.Mutability.READ_ONLY, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, new ArrayList<AttributeSchema>(Arrays.asList(BULK_SUPPORTED, MAX_OPERATIONS, MAX_PAYLOAD_SIZE)));
        public static final SCIMAttributeSchema FILTER = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:ServiceProviderConfig:filter", "filter", SCIMDefinitions.DataType.COMPLEX, false, "A complex type that specifies FILTER options.", true, false, SCIMDefinitions.Mutability.READ_ONLY, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, new ArrayList<AttributeSchema>(Arrays.asList(FILTER_SUPPORTED, MAX_RESULTS)));
        public static final SCIMAttributeSchema CHANGE_PASSWORD = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:ServiceProviderConfig:changePassword", "changePassword", SCIMDefinitions.DataType.COMPLEX, false, "A complex type that specifies configuration options related to changing a password.", true, false, SCIMDefinitions.Mutability.READ_ONLY, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, new ArrayList<AttributeSchema>(Arrays.asList(CHANGE_PASSWORD_SUPPORTED)));
        public static final SCIMAttributeSchema SORT = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:ServiceProviderConfig:sort", "sort", SCIMDefinitions.DataType.COMPLEX, false, "A complex type that specifies sort result options.", true, false, SCIMDefinitions.Mutability.READ_ONLY, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, new ArrayList<AttributeSchema>(Arrays.asList(SORT_SUPPORTED)));
        public static final SCIMAttributeSchema ETAG = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:ServiceProviderConfig:etag", "etag", SCIMDefinitions.DataType.COMPLEX, false, "The version of the resources", true, false, SCIMDefinitions.Mutability.READ_ONLY, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, new ArrayList<AttributeSchema>(Arrays.asList(ETAG_SUPPORTED)));
        public static final SCIMAttributeSchema AUTHENTICATION_SCHEMES = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:ServiceProviderConfig:authenticationSchemes", "authenticationSchemes", SCIMDefinitions.DataType.COMPLEX, true, "A complex type that specifies supported authentication scheme properties.", true, false, SCIMDefinitions.Mutability.READ_ONLY, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, new ArrayList<AttributeSchema>(Arrays.asList(NAME, DESCRIPTION, SPEC_URI, AUTHENTICATION_SCHEMES_DOCUMENTATION_URI, TYPE, PRIMARY)));
    }

    public static class SCIMRoleSchemaDefinition {
        public static final SCIMAttributeSchema USERS_VALUE = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:extension:2.0:Role:users.value", "value", SCIMDefinitions.DataType.STRING, false, "Identifier of the user of this role.", false, false, SCIMDefinitions.Mutability.IMMUTABLE, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, null);
        public static final SCIMAttributeSchema USERS_REF = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:extension:2.0:Role:users.$ref", "$ref", SCIMDefinitions.DataType.REFERENCE, false, "The uri corresponding to a SCIM resource that is a user of this Role.", false, false, SCIMDefinitions.Mutability.IMMUTABLE, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, new ArrayList<SCIMDefinitions.ReferenceType>(Arrays.asList(SCIMDefinitions.ReferenceType.ROLE, SCIMDefinitions.ReferenceType.USER)), null);
        public static final SCIMAttributeSchema USERS_DISPLAY = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:extension:2.0:Role:users.display", "display", SCIMDefinitions.DataType.STRING, false, "A human-readable name for the user.", false, false, SCIMDefinitions.Mutability.READ_WRITE, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, null);
        public static final SCIMAttributeSchema USERS_TYPE = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:extension:2.0:Role:groups.type", "type", SCIMDefinitions.DataType.STRING, false, "A label indicating the type of resource, e.g. 'User' or 'Group'", false, false, SCIMDefinitions.Mutability.READ_WRITE, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, null);
        public static final SCIMAttributeSchema GROUPS_VALUE = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:extension:2.0:Role:groups.value", "value", SCIMDefinitions.DataType.STRING, false, "Identifier of the group of this role.", false, false, SCIMDefinitions.Mutability.IMMUTABLE, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, null);
        public static final SCIMAttributeSchema GROUPS_REF = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:extension:2.0:Role:groups.$ref", "$ref", SCIMDefinitions.DataType.REFERENCE, false, "The uri corresponding to a SCIM resource that is a group of this Role.", false, false, SCIMDefinitions.Mutability.IMMUTABLE, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, new ArrayList<SCIMDefinitions.ReferenceType>(Arrays.asList(SCIMDefinitions.ReferenceType.ROLE, SCIMDefinitions.ReferenceType.GROUP)), null);
        public static final SCIMAttributeSchema GROUPS_DISPLAY = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:extension:2.0:Role:groups.display", "display", SCIMDefinitions.DataType.STRING, false, "A human-readable name for the group.", false, false, SCIMDefinitions.Mutability.READ_WRITE, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, null);
        public static final SCIMAttributeSchema GROUPS_TYPE = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:extension:2.0:Role:groups.type", "type", SCIMDefinitions.DataType.STRING, false, "A label indicating the type of resource, e.g. 'User' or 'Group'", false, false, SCIMDefinitions.Mutability.READ_WRITE, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, null);
        public static final SCIMAttributeSchema DISPLAY_NAME = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:extension:2.0:Role:displayName", "displayName", SCIMDefinitions.DataType.STRING, false, "A human-readable name for the Role. REQUIRED.", true, false, SCIMDefinitions.Mutability.READ_WRITE, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, null);
        public static final SCIMAttributeSchema USERS = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:extension:2.0:Role:users", "users", SCIMDefinitions.DataType.COMPLEX, true, "A list of users of the role.", false, false, SCIMDefinitions.Mutability.READ_WRITE, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, new ArrayList<AttributeSchema>(Arrays.asList(USERS_VALUE, USERS_REF, USERS_DISPLAY, USERS_TYPE)));
        public static final SCIMAttributeSchema GROUPS = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:extension:2.0:Role:groups", "groups", SCIMDefinitions.DataType.COMPLEX, true, "A list of groups of the role.", false, false, SCIMDefinitions.Mutability.READ_WRITE, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, new ArrayList<AttributeSchema>(Arrays.asList(GROUPS_VALUE, GROUPS_REF, GROUPS_DISPLAY, GROUPS_TYPE)));
        public static final SCIMAttributeSchema PERMISSIONS = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:extension:2.0:Role:permissions", "permissions", SCIMDefinitions.DataType.REFERENCE, true, "A list of permissions of the role.", false, false, SCIMDefinitions.Mutability.READ_WRITE, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, null);
    }

    public static class SCIMGroupSchemaDefinition {
        public static final SCIMAttributeSchema VALUE = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:Group:members.value", "value", SCIMDefinitions.DataType.STRING, false, "Identifier of the member of this Group.", false, false, SCIMDefinitions.Mutability.IMMUTABLE, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, null);
        public static final SCIMAttributeSchema REF = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:Group:members.$ref", "$ref", SCIMDefinitions.DataType.REFERENCE, false, "The uri corresponding to a SCIM resource that is a member of this Group.", false, false, SCIMDefinitions.Mutability.IMMUTABLE, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, new ArrayList<SCIMDefinitions.ReferenceType>(Arrays.asList(SCIMDefinitions.ReferenceType.USER, SCIMDefinitions.ReferenceType.GROUP)), null);
        public static final SCIMAttributeSchema DISPLAY = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:Group:members.display", "display", SCIMDefinitions.DataType.STRING, false, "A human-readable name for the Member", false, false, SCIMDefinitions.Mutability.READ_WRITE, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, null);
        public static final SCIMAttributeSchema TYPE = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:Group:members.type", "type", SCIMDefinitions.DataType.STRING, false, "A label indicating the type of resource, e.g. 'User' or 'Group'", false, false, SCIMDefinitions.Mutability.READ_WRITE, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, null);
        public static final SCIMAttributeSchema DISPLAY_NAME = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:Group:displayName", "displayName", SCIMDefinitions.DataType.STRING, false, "A human-readable name for the Group. REQUIRED.", true, false, SCIMDefinitions.Mutability.READ_WRITE, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, null);
        public static final SCIMAttributeSchema MEMBERS = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:Group:members", "members", SCIMDefinitions.DataType.COMPLEX, true, "A list of members of the Group.", false, false, SCIMDefinitions.Mutability.READ_WRITE, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, new ArrayList<AttributeSchema>(Arrays.asList(VALUE, REF, DISPLAY, TYPE)));
        public static final SCIMAttributeSchema ROLES_VALUE = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:Group:roles.value", "value", SCIMDefinitions.DataType.STRING, false, "The value of a role.", false, false, SCIMDefinitions.Mutability.READ_WRITE, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, null);
        public static final SCIMAttributeSchema ROLES_DISPLAY = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:Group:roles.display", "display", SCIMDefinitions.DataType.REFERENCE, false, "A human-readable name, primarily used for display purposes.", false, false, SCIMDefinitions.Mutability.READ_WRITE, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, null);
        public static final SCIMAttributeSchema ROLES_REF = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:Group:roles.$ref", "$ref", SCIMDefinitions.DataType.REFERENCE, false, "The uri of the corresponding 'Role' resource to which the group belongs.", false, false, SCIMDefinitions.Mutability.READ_ONLY, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, new ArrayList<SCIMDefinitions.ReferenceType>(Arrays.asList(SCIMDefinitions.ReferenceType.GROUP, SCIMDefinitions.ReferenceType.ROLE)), null);
        public static final SCIMAttributeSchema ROLES_SCHEMA = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:Group:roles", "roles", SCIMDefinitions.DataType.COMPLEX, true, "A list of roles of the Group.", false, false, SCIMDefinitions.Mutability.READ_ONLY, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, new ArrayList<AttributeSchema>(Arrays.asList(ROLES_VALUE, ROLES_REF, ROLES_DISPLAY)));
    }

    public static class SCIMUserSchemaDefinition {
        public static final SCIMAttributeSchema EMAIL_VALUE = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:User:emails.value", "value", SCIMDefinitions.DataType.STRING, false, "Email addresses for the user.  The value SHOULD be canonicalized by the service provider, e.g.,\n'bjensen@example.com' instead of 'bjensen@EXAMPLE.COM'.Canonical type values of 'work', 'home', and 'other'.", false, false, SCIMDefinitions.Mutability.READ_WRITE, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, null);
        public static final SCIMAttributeSchema EMAIL_DISPLAY = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:User:emails.display", "display", SCIMDefinitions.DataType.STRING, false, "A human-readable name, primarily used for display purposes.  READ-ONLY.", false, false, SCIMDefinitions.Mutability.READ_ONLY, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, null);
        public static final SCIMAttributeSchema EMAIL_TYPE = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:User:emails.type", "type", SCIMDefinitions.DataType.STRING, false, "A label indicating the attribute's function, e.g., 'work' or 'home'.", false, false, SCIMDefinitions.Mutability.READ_WRITE, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, new ArrayList<String>(Arrays.asList("work", "home", "other")), null, null);
        public static final SCIMAttributeSchema EMAIL_PRIMARY = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:User:emails.primary", "primary", SCIMDefinitions.DataType.BOOLEAN, false, "A Boolean value indicating the 'primary' or preferred attribute value for this attribute, e.g., the psreferred mailing address or primary email address.  The primary attribute value 'true' MUST appear no more than once.", false, false, SCIMDefinitions.Mutability.READ_WRITE, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, null);
        public static final SCIMAttributeSchema PHONE_NUMBERS_VALUE = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:User:phoneNumbers.value", "value", SCIMDefinitions.DataType.STRING, false, "Phone number of the User.", false, false, SCIMDefinitions.Mutability.READ_WRITE, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, null);
        public static final SCIMAttributeSchema PHONE_NUMBERS_DISPLAY = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:User:phoneNumbers.display", "display", SCIMDefinitions.DataType.STRING, false, "A human-readable name, primarily used for display purposes.  READ-ONLY.", false, false, SCIMDefinitions.Mutability.READ_WRITE, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, null);
        public static final SCIMAttributeSchema PHONE_NUMBERS_TYPE = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:User:phoneNumbers.type", "type", SCIMDefinitions.DataType.STRING, false, "A label indicating the attribute's function, e.g., 'work', 'home', 'mobile'.", false, false, SCIMDefinitions.Mutability.READ_WRITE, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, new ArrayList<String>(Arrays.asList("work", "home", "other", "fax", "mobile", "pager")), null, null);
        public static final SCIMAttributeSchema PHONE_NUMBERS_PRIMARY = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:User:phoneNumbers.primary", "primary", SCIMDefinitions.DataType.BOOLEAN, false, "A Boolean value indicating the 'primary' or preferred attribute value for this attribute, e.g., the preferred\nphone number or primary phone number.  The primary attribute value 'true' MUST appear no more than once.", false, false, SCIMDefinitions.Mutability.READ_WRITE, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, null);
        public static final SCIMAttributeSchema IMS_VALUE = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:User:ims.value", "value", SCIMDefinitions.DataType.STRING, false, "Instant messaging address for the User.", false, false, SCIMDefinitions.Mutability.READ_WRITE, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, null);
        public static final SCIMAttributeSchema IMS_DISPLAY = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:User:ims.display", "display", SCIMDefinitions.DataType.STRING, false, "A human-readable name, primarily used for display purposes.  READ-ONLY.", false, false, SCIMDefinitions.Mutability.READ_WRITE, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, null);
        public static final SCIMAttributeSchema IMS_TYPE = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:User:ims.type", "type", SCIMDefinitions.DataType.STRING, false, "A label indicating the attribute's function, e.g., 'aim', 'gtalk', 'xmpp'.", false, false, SCIMDefinitions.Mutability.READ_WRITE, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, new ArrayList<String>(Arrays.asList("skpye", "yahoo", "gtalk", "aim", "icq", "xmpp", "msn", "qq")), null, null);
        public static final SCIMAttributeSchema IMS_PRIMARY = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:User:ims.primary", "primary", SCIMDefinitions.DataType.BOOLEAN, false, "A Boolean value indicating the 'primary' or preferred attribute value for this attribute, e.g., the preferred\nmessenger or primary messenger.  The primary attribute value 'true' MUST appear no more than once.", false, false, SCIMDefinitions.Mutability.READ_WRITE, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, null);
        public static final SCIMAttributeSchema PHOTOS_VALUE = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:User:photos.value", "value", SCIMDefinitions.DataType.REFERENCE, false, "URLs of photos of the User.", false, false, SCIMDefinitions.Mutability.READ_WRITE, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, new ArrayList<SCIMDefinitions.ReferenceType>(Arrays.asList(SCIMDefinitions.ReferenceType.EXTERNAL)), null);
        public static final SCIMAttributeSchema PHOTOS_DISPLAY = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:User:photos.display", "display", SCIMDefinitions.DataType.STRING, false, "A human-readable name, primarily used for display purposes.  READ-ONLY.", false, false, SCIMDefinitions.Mutability.READ_WRITE, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, null);
        public static final SCIMAttributeSchema PHOTOS_TYPE = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:User:photos.type", "type", SCIMDefinitions.DataType.STRING, false, "A label indicating the attribute's function, i.e., 'photo' or 'thumbnail'.", false, false, SCIMDefinitions.Mutability.READ_WRITE, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, new ArrayList<String>(Arrays.asList("photo", "thumbnail")), null, null);
        public static final SCIMAttributeSchema PHOTOS_PRIMARY = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:User:photos.primary", "primary", SCIMDefinitions.DataType.BOOLEAN, false, "A Boolean value indicating the 'primary' or preferred attribute value for this attribute, e.g., the preferred\nphone number or primary phone number. The primary attribute value 'true' MUST appear no more than once.", false, false, SCIMDefinitions.Mutability.READ_WRITE, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, null);
        public static final SCIMAttributeSchema ADDRESSES_FORMATTED = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:User:addresses.formatted", "formatted", SCIMDefinitions.DataType.STRING, false, "The full mailing address, formatted for display or use with a mailing label.  This attribute MAY contain\nnewlines.", false, false, SCIMDefinitions.Mutability.READ_WRITE, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, null);
        public static final SCIMAttributeSchema ADDRESSES_STREET_ADDRESS = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:User:addresses.streetAddress", "streetAddress", SCIMDefinitions.DataType.STRING, false, "The full street address component, which may include house number, street name, P.O. box, and multi-line\nextended street address information.  This attribute MAY contain newlines.", false, false, SCIMDefinitions.Mutability.READ_WRITE, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, null);
        public static final SCIMAttributeSchema ADDRESSES_LOCALITY = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:User:addresses.locality", "locality", SCIMDefinitions.DataType.STRING, false, "The city or locality component.", false, false, SCIMDefinitions.Mutability.READ_WRITE, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, null);
        public static final SCIMAttributeSchema ADDRESSES_REGION = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:User:addresses.region", "region", SCIMDefinitions.DataType.STRING, false, "The state or region component.", false, false, SCIMDefinitions.Mutability.READ_WRITE, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, null);
        public static final SCIMAttributeSchema ADDRESSES_POSTAL_CODE = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:User:addresses.postalCode", "postalCode", SCIMDefinitions.DataType.STRING, false, "The zip code or postal code component.", false, false, SCIMDefinitions.Mutability.READ_WRITE, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, null);
        public static final SCIMAttributeSchema ADDRESSES_COUNTRY = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:User:addresses.country", "country", SCIMDefinitions.DataType.STRING, false, "The country name component.", false, false, SCIMDefinitions.Mutability.READ_WRITE, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, null);
        public static final SCIMAttributeSchema ADDRESSES_TYPE = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:User:addresses.type", "type", SCIMDefinitions.DataType.STRING, false, "A label indicating the attribute's function, e.g., 'work' or 'home'.", false, false, SCIMDefinitions.Mutability.READ_WRITE, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, new ArrayList<String>(Arrays.asList("work", "home", "other")), null, null);
        public static final SCIMAttributeSchema ADDRESSES_PRIMARY = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:User:addresses.primary", "primary", SCIMDefinitions.DataType.BOOLEAN, false, "A Boolean value indicating the 'primary' or preferred attribute value for this attribute.  The primary\nattribute value 'true' MUST appear no more than once.", false, false, SCIMDefinitions.Mutability.READ_WRITE, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, null);
        public static final SCIMAttributeSchema GROUP_VALUE = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:User:groups.value", "value", SCIMDefinitions.DataType.STRING, false, "The identifier of the User's group.", false, false, SCIMDefinitions.Mutability.READ_ONLY, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, null);
        public static final SCIMAttributeSchema GROUP_REF = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:User:groups.$ref", "$ref", SCIMDefinitions.DataType.REFERENCE, false, "The uri of the corresponding 'Group' resource to which the user belongs.", false, false, SCIMDefinitions.Mutability.READ_ONLY, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, new ArrayList<SCIMDefinitions.ReferenceType>(Arrays.asList(SCIMDefinitions.ReferenceType.USER, SCIMDefinitions.ReferenceType.GROUP)), null);
        public static final SCIMAttributeSchema GROUP_DISPLAY = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:User:groups.display", "display", SCIMDefinitions.DataType.STRING, false, "A human-readable name, primarily used for display purposes. READ-ONLY.", false, false, SCIMDefinitions.Mutability.READ_ONLY, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, null);
        public static final SCIMAttributeSchema GROUP_TYPE = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:User:groups.type", "type", SCIMDefinitions.DataType.STRING, false, "A label indicating the attribute's function, e.g., 'direct' or 'indirect'.", false, false, SCIMDefinitions.Mutability.READ_WRITE, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, new ArrayList<String>(Arrays.asList("direct", "indirect")), null, null);
        public static final SCIMAttributeSchema ENTITLEMENTS_VALUE = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:User:entitlements.value", "value", SCIMDefinitions.DataType.STRING, false, "The value of an entitlement.", false, false, SCIMDefinitions.Mutability.READ_WRITE, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, null);
        public static final SCIMAttributeSchema ENTITLEMENTS_DISPLAY = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:User:entitlements.display", "display", SCIMDefinitions.DataType.REFERENCE, false, "A human-readable name, primarily used for display purposes.  READ-ONLY.", false, false, SCIMDefinitions.Mutability.READ_WRITE, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, new ArrayList<SCIMDefinitions.ReferenceType>(Arrays.asList(SCIMDefinitions.ReferenceType.USER, SCIMDefinitions.ReferenceType.GROUP)), null);
        public static final SCIMAttributeSchema ENTITLEMENTS_TYPE = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:User:entitlements.type", "type", SCIMDefinitions.DataType.STRING, false, "A label indicating the attribute's function.", false, false, SCIMDefinitions.Mutability.READ_WRITE, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, null);
        public static final SCIMAttributeSchema ENTITLEMENTS_PRIMARY = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:User:entitlements.primary", "primary", SCIMDefinitions.DataType.BOOLEAN, false, "A Boolean value indicating the 'primary' or preferred attribute value for this attribute.  The primary\nattribute value 'true' MUST appear no more than once.", false, false, SCIMDefinitions.Mutability.READ_WRITE, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, null);
        public static final SCIMAttributeSchema ROLES_VALUE = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:User:roles.value", "value", SCIMDefinitions.DataType.STRING, false, "The value of a role.", false, false, SCIMDefinitions.Mutability.READ_WRITE, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, null);
        public static final SCIMAttributeSchema ROLES_DISPLAY = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:User:roles.display", "display", SCIMDefinitions.DataType.REFERENCE, false, "A human-readable name, primarily used for display purposes.  READ-ONLY.", false, false, SCIMDefinitions.Mutability.READ_WRITE, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, null);
        public static final SCIMAttributeSchema ROLES_TYPE = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:User:roles.type", "type", SCIMDefinitions.DataType.STRING, false, "A label indicating the attribute's function.", false, false, SCIMDefinitions.Mutability.READ_WRITE, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, null);
        public static final SCIMAttributeSchema ROLES_PRIMARY = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:User:roles.primary", "primary", SCIMDefinitions.DataType.BOOLEAN, false, "A Boolean value indicating the 'primary' or preferred attribute value for this attribute.  The primary attribute value 'true' MUST appear no more than once.", false, false, SCIMDefinitions.Mutability.READ_WRITE, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, null);
        public static final SCIMAttributeSchema ROLES_REF = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:User:roles.$ref", "$ref", SCIMDefinitions.DataType.REFERENCE, false, "The uri of the corresponding 'Role' resource to which the user belongs.", false, false, SCIMDefinitions.Mutability.READ_ONLY, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, new ArrayList<SCIMDefinitions.ReferenceType>(Arrays.asList(SCIMDefinitions.ReferenceType.USER, SCIMDefinitions.ReferenceType.ROLE)), null);
        public static final SCIMAttributeSchema X509CERTIFICATES_VALUE = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:User:x509certificates.value", "value", SCIMDefinitions.DataType.STRING, false, "The value of an X.509 certificate.", false, false, SCIMDefinitions.Mutability.READ_WRITE, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, null);
        public static final SCIMAttributeSchema X509CERTIFICATES_DISPLAY = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:User:x509certificates.display", "display", SCIMDefinitions.DataType.REFERENCE, false, "A human-readable name, primarily used for display purposes.  READ-ONLY.", false, false, SCIMDefinitions.Mutability.READ_WRITE, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, null);
        public static final SCIMAttributeSchema X509CERTIFICATES_TYPE = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:User:x509certificates.type", "type", SCIMDefinitions.DataType.STRING, false, "A label indicating the attribute's function.", false, false, SCIMDefinitions.Mutability.READ_WRITE, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, null);
        public static final SCIMAttributeSchema X509CERTIFICATES_PRIMARY = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:User:x509certificates.primary", "primary", SCIMDefinitions.DataType.BOOLEAN, false, "A Boolean value indicating the 'primary' or preferred attribute value for this attribute.The primary attribute value 'true' MUST appear no more than once.", false, false, SCIMDefinitions.Mutability.READ_WRITE, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, null);
        public static final SCIMAttributeSchema FORMATTED = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:User:name.formatted", "formatted", SCIMDefinitions.DataType.STRING, false, "The full name, including all middle names, titles, and suffixes as appropriate, formatted for display\n(e.g., 'Ms. Barbara J Jensen, III').", false, false, SCIMDefinitions.Mutability.READ_WRITE, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, null);
        public static final SCIMAttributeSchema FAMILY_NAME = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:User:name.familyName", "familyName", SCIMDefinitions.DataType.STRING, false, "The family name of the User, or last name in most Western languages (e.g., 'Jensen' given the full\nname 'Ms. Barbara J Jensen, III').", false, false, SCIMDefinitions.Mutability.READ_WRITE, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, null);
        public static final SCIMAttributeSchema GIVEN_NAME = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:User:name.givenName", "givenName", SCIMDefinitions.DataType.STRING, false, "The given name of the User, or first name in most Western languages (e.g., 'Barbara' given the\nfull name 'Ms. Barbara J Jensen, III').", false, false, SCIMDefinitions.Mutability.READ_WRITE, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, null);
        public static final SCIMAttributeSchema MIDDLE_NAME = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:User:name.middleName", "middleName", SCIMDefinitions.DataType.STRING, false, "The middle name(s) of the User (e.g., 'Jane' given the full name 'Ms. Barbara J Jensen, III').", false, false, SCIMDefinitions.Mutability.READ_WRITE, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, null);
        public static final SCIMAttributeSchema HONORIFIC_PREFIX = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:User:name.honorificPrefix", "honorificPrefix", SCIMDefinitions.DataType.STRING, false, "The honorific prefix(es) of the User, or title in most Western languages (e.g., 'Ms.' given the full name\n'Ms. Barbara J Jensen, III').", false, false, SCIMDefinitions.Mutability.READ_WRITE, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, null);
        public static final SCIMAttributeSchema HONORIFIC_SUFFIX = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:User:name.honorificSuffix", "honorificSuffix", SCIMDefinitions.DataType.STRING, false, "The honorific suffix(es) of the User, or suffix in most Western languages (e.g., 'III' given the full name\n'Ms. Barbara J Jensen, III').", false, false, SCIMDefinitions.Mutability.READ_WRITE, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, null);
        public static final SCIMAttributeSchema USERNAME = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:User:userName", "userName", SCIMDefinitions.DataType.STRING, false, "A service provider's unique identifier for the user, typically\nused by the user to directly authenticate to the service provider.Each User MUST include a non-empty userName value.  This identifier\nMUST be unique across the service provider's entire set of Users.", true, false, SCIMDefinitions.Mutability.READ_WRITE, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.SERVER, null, null, null);
        public static final SCIMAttributeSchema NAME = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:User:name", "name", SCIMDefinitions.DataType.COMPLEX, false, "The components of the user's real name.Providers MAY return just the full name as a single string in the\nformatted sub-attribute, or they MAY return just the individual component attributes using the other sub-attributes, or they MAY\nreturn both.  If both variants are returned, they SHOULD be describing the same name, with the formatted name indicating how the\ncomponent attributes should be combined.", false, false, SCIMDefinitions.Mutability.READ_WRITE, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, new ArrayList<AttributeSchema>(Arrays.asList(FORMATTED, FAMILY_NAME, GIVEN_NAME, MIDDLE_NAME, HONORIFIC_PREFIX, HONORIFIC_SUFFIX)));
        public static final SCIMAttributeSchema DISPLAY_NAME = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:User:displayName", "displayName", SCIMDefinitions.DataType.STRING, false, "The name of the User, suitable for display\nto end-users.  The name SHOULD be the full name of the User being described, if known.", false, false, SCIMDefinitions.Mutability.READ_WRITE, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, null);
        public static final SCIMAttributeSchema NICK_NAME = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:User:nickName", "nickName", SCIMDefinitions.DataType.STRING, false, "The casual way to address the user in real life, e.g., 'Bob' or 'Bobby' instead of 'Robert'.  This attribute\nSHOULD NOT be used to represent a User's username (e.g., 'bjensen' or 'mpepperidge').", false, false, SCIMDefinitions.Mutability.READ_WRITE, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, null);
        public static final SCIMAttributeSchema PROFILE_URL = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:User:profileUrl", "profileUrl", SCIMDefinitions.DataType.REFERENCE, false, "A fully qualified URL pointing to a page\nrepresenting the User's online profile.", false, false, SCIMDefinitions.Mutability.READ_WRITE, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, new ArrayList<SCIMDefinitions.ReferenceType>(Arrays.asList(SCIMDefinitions.ReferenceType.EXTERNAL)), null);
        public static final SCIMAttributeSchema TITLE = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:User:title", "title", SCIMDefinitions.DataType.STRING, false, "The user's title, such as \\\"Vice President.\\\"", false, false, SCIMDefinitions.Mutability.READ_WRITE, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, null);
        public static final SCIMAttributeSchema USER_TYPE = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:User:userType", "userType", SCIMDefinitions.DataType.STRING, false, "Used to identify the relationship between the organization and the user.  Typical values used might be\n'Contractor', 'Employee', 'Intern', 'Temp', 'External', and 'Unknown', but any value may be used.", false, false, SCIMDefinitions.Mutability.READ_WRITE, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, null);
        public static final SCIMAttributeSchema PREFERRED_LANGUAGE = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:User:preferredLanguage", "preferredLanguage", SCIMDefinitions.DataType.STRING, false, "Indicates the User's preferred written or\nspoken language.  Generally used for selecting a localized user interface; e.g., 'en_US' specifies the language English and country", false, false, SCIMDefinitions.Mutability.READ_WRITE, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, null);
        public static final SCIMAttributeSchema LOCALE = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:User:locale", "locale", SCIMDefinitions.DataType.STRING, false, "Used to indicate the User's default location\nfor purposes of localizing items such as currency, date time format, or numerical representations.", false, false, SCIMDefinitions.Mutability.READ_WRITE, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, null);
        public static final SCIMAttributeSchema TIME_ZONE = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:User:timezone", "timezone", SCIMDefinitions.DataType.STRING, false, "The User's time zone in the 'Olson' time zone\ndatabase format, e.g., 'America/Los_Angeles'.", false, false, SCIMDefinitions.Mutability.READ_WRITE, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, null);
        public static final SCIMAttributeSchema ACTIVE = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:User:active", "active", SCIMDefinitions.DataType.BOOLEAN, false, "A Boolean value indicating the User's administrative status.", false, false, SCIMDefinitions.Mutability.READ_WRITE, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, null);
        public static final SCIMAttributeSchema PASSWORD = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:User:password", "password", SCIMDefinitions.DataType.STRING, false, "The User's cleartext password.  This attribute is intended to be used as a means to specify an initial\npassword when creating a new User or to reset an existing User's password.", false, false, SCIMDefinitions.Mutability.WRITE_ONLY, SCIMDefinitions.Returned.NEVER, SCIMDefinitions.Uniqueness.NONE, null, null, null);
        public static final SCIMAttributeSchema EMAILS = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:User:emails", "emails", SCIMDefinitions.DataType.COMPLEX, true, "Email addresses for the user.  The value SHOULD be canonicalized by the service provider, e.g.,\n'bjensen@example.com' instead of 'bjensen@EXAMPLE.COM'.Canonical type values of 'work', 'home', and 'other'.", false, false, SCIMDefinitions.Mutability.READ_WRITE, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, new ArrayList<AttributeSchema>(Arrays.asList(EMAIL_VALUE, EMAIL_DISPLAY, EMAIL_TYPE, EMAIL_PRIMARY)));
        public static final SCIMAttributeSchema PHONE_NUMBERS = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:User:phoneNumbers", "phoneNumbers", SCIMDefinitions.DataType.COMPLEX, true, "Phone numbers for the User.  The value SHOULD be canonicalized by the service provider according to the\nformat specified in RFC 3966, e.g., 'tel:+1-201-555-0123'.Canonical type values of 'work', 'home', 'mobile', 'fax', 'pager", false, false, SCIMDefinitions.Mutability.READ_WRITE, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, new ArrayList<AttributeSchema>(Arrays.asList(PHONE_NUMBERS_VALUE, PHONE_NUMBERS_DISPLAY, PHONE_NUMBERS_TYPE, PHONE_NUMBERS_PRIMARY)));
        public static final SCIMAttributeSchema IMS = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:User:ims", "ims", SCIMDefinitions.DataType.COMPLEX, true, "Instant messaging addresses for the User.", false, false, SCIMDefinitions.Mutability.READ_WRITE, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, new ArrayList<AttributeSchema>(Arrays.asList(IMS_VALUE, IMS_DISPLAY, IMS_TYPE, IMS_PRIMARY)));
        public static final SCIMAttributeSchema PHOTOS = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:User:photos", "photos", SCIMDefinitions.DataType.COMPLEX, true, "URLs of photos of the User.", false, false, SCIMDefinitions.Mutability.READ_WRITE, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, new ArrayList<AttributeSchema>(Arrays.asList(PHOTOS_VALUE, PHOTOS_DISPLAY, PHOTOS_TYPE, PHOTOS_PRIMARY)));
        public static final SCIMAttributeSchema ADDRESSES = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:User:addresses", "addresses", SCIMDefinitions.DataType.COMPLEX, true, "A physical mailing address for this User.\nCanonical type values of 'work', 'home', and 'other'.  This attribute is a complex type with the following sub-attributes.", false, false, SCIMDefinitions.Mutability.READ_WRITE, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, new ArrayList<AttributeSchema>(Arrays.asList(ADDRESSES_FORMATTED, ADDRESSES_STREET_ADDRESS, ADDRESSES_LOCALITY, ADDRESSES_REGION, ADDRESSES_POSTAL_CODE, ADDRESSES_COUNTRY, ADDRESSES_TYPE, ADDRESSES_PRIMARY)));
        public static final SCIMAttributeSchema GROUPS = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:User:groups", "groups", SCIMDefinitions.DataType.COMPLEX, true, "A list of groups to which the user belongs,\neither through direct membership, through nested groups, or dynamically calculated.", false, false, SCIMDefinitions.Mutability.READ_ONLY, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, new ArrayList<AttributeSchema>(Arrays.asList(GROUP_VALUE, GROUP_REF, GROUP_DISPLAY, GROUP_TYPE)));
        public static final SCIMAttributeSchema ROLES_SCHEMA = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:User:roles", "roles", SCIMDefinitions.DataType.COMPLEX, true, "A list of roles for the User that collectively represent who the User is, e.g., 'Student', 'Faculty'.", false, false, SCIMDefinitions.Mutability.READ_ONLY, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, new ArrayList<AttributeSchema>(Arrays.asList(ROLES_VALUE, ROLES_REF, ROLES_DISPLAY)));
        public static final SCIMAttributeSchema ENTITLEMENTS = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:User:entitlements", "entitlements", SCIMDefinitions.DataType.COMPLEX, true, "A list of entitlements for the User that represent a thing the User has.", false, false, SCIMDefinitions.Mutability.READ_WRITE, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, new ArrayList<AttributeSchema>(Arrays.asList(ENTITLEMENTS_VALUE, ENTITLEMENTS_DISPLAY, ENTITLEMENTS_TYPE, ENTITLEMENTS_PRIMARY)));
        public static final SCIMAttributeSchema ROLES = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:User:roles", "roles", SCIMDefinitions.DataType.COMPLEX, true, "A list of roles for the User that collectively represent who the User is, e.g., 'Student', 'Faculty'.", false, false, SCIMDefinitions.Mutability.READ_WRITE, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, new ArrayList<AttributeSchema>(Arrays.asList(ROLES_VALUE, ROLES_DISPLAY, ROLES_TYPE, ROLES_PRIMARY)));
        public static final SCIMAttributeSchema X509CERTIFICATES = SCIMAttributeSchema.createSCIMAttributeSchema("urn:ietf:params:scim:schemas:core:2.0:User:x509Certificates", "x509Certificates", SCIMDefinitions.DataType.COMPLEX, true, "A list of certificates issued to the User.", false, false, SCIMDefinitions.Mutability.READ_WRITE, SCIMDefinitions.Returned.DEFAULT, SCIMDefinitions.Uniqueness.NONE, null, null, new ArrayList<AttributeSchema>(Arrays.asList(X509CERTIFICATES_VALUE, X509CERTIFICATES_DISPLAY, X509CERTIFICATES_TYPE, X509CERTIFICATES_PRIMARY)));
    }
}

