/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.charon3.core.utils;

import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.json.JSONObject;
import org.wso2.charon3.core.exceptions.BadRequestException;
import org.wso2.charon3.core.exceptions.CharonException;
import org.wso2.charon3.core.schema.AttributeSchema;
import org.wso2.charon3.core.schema.SCIMDefinitions;
import org.wso2.charon3.core.schema.SCIMResourceTypeSchema;

public class AttributeUtil {
    private static final String ATTRIBUTE_EXTENSION_SCHEMA_PREFIX = "urn:ietf:params:scim:schemas:extension";

    public static Object getAttributeValueFromString(Object attributeValue, SCIMDefinitions.DataType dataType) throws CharonException, BadRequestException {
        if (attributeValue == null) {
            return attributeValue;
        }
        String attributeStringValue = null;
        attributeStringValue = attributeValue instanceof Boolean ? String.valueOf(attributeValue) : (attributeValue instanceof Integer ? String.valueOf(attributeValue) : (attributeValue instanceof Double ? String.valueOf(attributeValue) : (JSONObject.NULL.equals(attributeValue) ? "" : (String)attributeValue)));
        switch (dataType) {
            case STRING: {
                return attributeStringValue.trim();
            }
            case BOOLEAN: {
                return AttributeUtil.parseBoolean(attributeValue);
            }
            case DECIMAL: {
                return Double.parseDouble(attributeStringValue);
            }
            case INTEGER: {
                return Integer.parseInt(attributeStringValue);
            }
            case DATE_TIME: {
                return AttributeUtil.parseDateTime(attributeStringValue);
            }
            case BINARY: {
                return Byte.valueOf(attributeStringValue);
            }
            case REFERENCE: {
                return AttributeUtil.parseReference(attributeStringValue);
            }
            case COMPLEX: {
                return AttributeUtil.parseComplex(attributeStringValue);
            }
        }
        return null;
    }

    public static String getStringValueOfAttribute(Object attributeValue, SCIMDefinitions.DataType dataType) throws CharonException {
        switch (dataType) {
            case STRING: {
                return String.valueOf(attributeValue);
            }
            case BOOLEAN: {
                return String.valueOf(attributeValue);
            }
            case DECIMAL: {
                return String.valueOf(attributeValue);
            }
            case INTEGER: {
                return String.valueOf(attributeValue);
            }
            case DATE_TIME: {
                return AttributeUtil.formatDateTime((Instant)attributeValue);
            }
            case BINARY: {
                return String.valueOf(attributeValue);
            }
            case REFERENCE: {
                return String.valueOf(attributeValue);
            }
            case COMPLEX: {
                return String.valueOf(attributeValue);
            }
        }
        throw new CharonException("Error in converting attribute value of type: " + (Object)((Object)dataType) + " to string.");
    }

    public static Instant parseDateTime(String dateTimeString) throws CharonException {
        try {
            return LocalDateTime.parse(dateTimeString).toInstant(ZoneOffset.UTC);
        }
        catch (DateTimeException e) {
            try {
                return OffsetDateTime.parse(dateTimeString).toInstant();
            }
            catch (DateTimeException dte) {
                throw new CharonException("Error in parsing date time. Date time should adhere to ISO_OFFSET_DATE_TIME format", e);
            }
        }
    }

    public static String parseReference(String referenceString) throws CharonException {
        return referenceString;
    }

    public static String parseComplex(String complexString) {
        return complexString;
    }

    public static String formatDateTime(Instant instant) {
        return instant.toString();
    }

    public static Boolean parseBoolean(Object booleanValue) throws BadRequestException {
        try {
            return (Boolean)booleanValue;
        }
        catch (Exception e) {
            return Boolean.parseBoolean((String)booleanValue);
        }
    }

    public static String getAttributeURI(String attributeName, SCIMResourceTypeSchema schema) throws BadRequestException {
        boolean isSCIM2ExtensionSchemaAttribute = false;
        if (StringUtils.startsWith((String)attributeName, (String)ATTRIBUTE_EXTENSION_SCHEMA_PREFIX)) {
            isSCIM2ExtensionSchemaAttribute = true;
        }
        for (AttributeSchema attributeSchema : schema.getAttributesList()) {
            if (attributeSchema.getName().equalsIgnoreCase(attributeName) || attributeSchema.getURI().equals(attributeName)) {
                return attributeSchema.getURI();
            }
            String subAttributeURI = AttributeUtil.checkSCIMSubAttributeURIs(attributeSchema.getSubAttributeSchemas(), attributeSchema, attributeName);
            if (subAttributeURI != null) {
                return subAttributeURI;
            }
            if ((!isSCIM2ExtensionSchemaAttribute || !attributeName.contains(attributeSchema.getURI())) && (isSCIM2ExtensionSchemaAttribute || !attributeName.contains(attributeSchema.getName())) || !attributeSchema.getMultiValued()) continue;
            String subAttribute = null;
            if (attributeName.contains(".")) {
                String[] splittedString = attributeName.split(attributeSchema.getName() + ".", 2);
                subAttribute = splittedString[1];
            }
            subAttributeURI = attributeSchema.getURI();
            if (subAttribute == null) continue;
            subAttributeURI = subAttributeURI + "." + subAttribute;
            return subAttributeURI;
        }
        String error = "Not a valid attribute name/uri";
        throw new BadRequestException(error, "invalidValue");
    }

    private static String checkSCIMSubAttributeURIs(List<AttributeSchema> subAttributes, AttributeSchema attributeSchema, String attributeName) {
        if (subAttributes != null) {
            for (AttributeSchema subAttributeSchema : subAttributes) {
                List<AttributeSchema> subSubAttributeSchemas;
                if ((attributeSchema.getName() + "." + subAttributeSchema.getName()).equalsIgnoreCase(attributeName) || subAttributeSchema.getURI().equals(attributeName)) {
                    return subAttributeSchema.getURI();
                }
                if (!subAttributeSchema.getType().equals((Object)SCIMDefinitions.DataType.COMPLEX) || (subSubAttributeSchemas = subAttributeSchema.getSubAttributeSchemas()) == null) continue;
                for (AttributeSchema subSubAttributeSchema : subSubAttributeSchemas) {
                    if (!(attributeSchema.getName() + "." + subAttributeSchema.getName() + "." + subSubAttributeSchema.getName()).equalsIgnoreCase(attributeName) && !subSubAttributeSchema.getURI().equals(attributeName)) continue;
                    return subSubAttributeSchema.getURI();
                }
            }
        }
        return null;
    }
}

