/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.charon3.core.utils;

import java.util.ArrayList;
import java.util.List;
import org.wso2.charon3.core.schema.AttributeSchema;
import org.wso2.charon3.core.schema.SCIMDefinitions;
import org.wso2.charon3.core.schema.SCIMResourceTypeSchema;

public class SchemaUtil {
    public static AttributeSchema getAttributeSchema(String attributeFullName, SCIMResourceTypeSchema scimObjectType) {
        SCIMResourceTypeSchema resourceSchema = scimObjectType;
        if (resourceSchema != null) {
            ArrayList<AttributeSchema> attributeSchemas = resourceSchema.getAttributesList();
            for (AttributeSchema attributeSchema : attributeSchemas) {
                List<AttributeSchema> subAttributeSchemaList;
                if (attributeFullName.equals(attributeSchema.getName())) {
                    return attributeSchema;
                }
                if (!attributeSchema.getType().equals((Object)SCIMDefinitions.DataType.COMPLEX)) continue;
                if (attributeSchema.getMultiValued()) {
                    subAttributeSchemaList = attributeSchema.getSubAttributeSchemas();
                    for (AttributeSchema subAttributeSchema : subAttributeSchemaList) {
                        if (!attributeFullName.equals(attributeSchema.getName() + "." + subAttributeSchema.getName())) continue;
                        return subAttributeSchema;
                    }
                    continue;
                }
                subAttributeSchemaList = attributeSchema.getSubAttributeSchemas();
                for (AttributeSchema subAttributeSchema : subAttributeSchemaList) {
                    if (attributeFullName.equals(attributeSchema.getName() + "." + subAttributeSchema.getName())) {
                        return subAttributeSchema;
                    }
                    if (!subAttributeSchema.getType().equals((Object)SCIMDefinitions.DataType.COMPLEX)) continue;
                    List<AttributeSchema> subSubAttributeSchemaList = subAttributeSchema.getSubAttributeSchemas();
                    for (AttributeSchema subSubAttributeSchema : subSubAttributeSchemaList) {
                        if (!attributeFullName.equals(attributeSchema.getName() + "." + subAttributeSchema.getName() + "." + subSubAttributeSchema.getName())) continue;
                        return subSubAttributeSchema;
                    }
                }
            }
        }
        return null;
    }
}

