/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.charon3.core.config;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.wso2.charon3.core.attributes.SCIMCustomAttribute;
import org.wso2.charon3.core.config.ExtensionBuilder;
import org.wso2.charon3.core.exceptions.CharonException;
import org.wso2.charon3.core.exceptions.InternalErrorException;
import org.wso2.charon3.core.schema.AttributeSchema;

public class SCIMCustomSchemaExtensionBuilder
extends ExtensionBuilder {
    private static SCIMCustomSchemaExtensionBuilder customSchemaExtensionBuilder = new SCIMCustomSchemaExtensionBuilder();
    private String rootAttributeURI;

    private SCIMCustomSchemaExtensionBuilder() {
    }

    public static SCIMCustomSchemaExtensionBuilder getInstance() {
        return customSchemaExtensionBuilder;
    }

    public void setURI(String schemaUri) {
        this.rootAttributeURI = schemaUri;
    }

    @Override
    public String getURI() {
        return this.rootAttributeURI;
    }

    public AttributeSchema buildUserCustomSchemaExtension(List<SCIMCustomAttribute> attributes) throws CharonException, InternalErrorException {
        HashMap<String, AttributeSchema> attributeSchemas = new HashMap<String, AttributeSchema>();
        HashMap<String, ExtensionBuilder.ExtensionAttributeSchemaConfig> attributeConfigs = new HashMap<String, ExtensionBuilder.ExtensionAttributeSchemaConfig>();
        this.readConfiguration(attributes, attributeConfigs);
        for (Map.Entry attributeSchemaConfig : attributeConfigs.entrySet()) {
            if (!((ExtensionBuilder.ExtensionAttributeSchemaConfig)attributeSchemaConfig.getValue()).hasChildren()) {
                this.buildSimpleAttributeSchema((ExtensionBuilder.ExtensionAttributeSchemaConfig)attributeSchemaConfig.getValue(), attributeSchemas);
                continue;
            }
            this.buildComplexAttributeSchema((ExtensionBuilder.ExtensionAttributeSchemaConfig)attributeSchemaConfig.getValue(), attributeSchemas, attributeConfigs);
        }
        return (AttributeSchema)attributeSchemas.get(this.rootAttributeURI);
    }

    private void readConfiguration(List<SCIMCustomAttribute> schemaConfigurations, Map<String, ExtensionBuilder.ExtensionAttributeSchemaConfig> attributeConfigs) {
        for (SCIMCustomAttribute schemaConfiguration : schemaConfigurations) {
            ExtensionBuilder.ExtensionAttributeSchemaConfig schemaAttributeConfig = new ExtensionBuilder.ExtensionAttributeSchemaConfig(schemaConfiguration.getProperties());
            attributeConfigs.put(schemaAttributeConfig.getURI(), schemaAttributeConfig);
        }
    }
}

