/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.charon3.core.schema;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.wso2.charon3.core.schema.AttributeSchema;
import org.wso2.charon3.core.schema.ResourceTypeSchema;

public class SCIMResourceTypeSchema
implements ResourceTypeSchema,
Serializable {
    private static final long serialVersionUID = 6106269076155338045L;
    private List<String> schemasList;
    private ArrayList<AttributeSchema> attributeList = new ArrayList();

    private SCIMResourceTypeSchema(List<String> schemas, AttributeSchema[] attributeSchemas) {
        this.schemasList = schemas;
        if (attributeSchemas != null) {
            for (AttributeSchema attributeSchema : attributeSchemas) {
                if (attributeSchema == null) continue;
                this.attributeList.add(attributeSchema);
            }
        }
    }

    public static SCIMResourceTypeSchema createSCIMResourceSchema(List<String> schemas, AttributeSchema ... attributeSchemas) {
        return new SCIMResourceTypeSchema(schemas, attributeSchemas);
    }

    public Boolean isSchemaAvailable(String schema) {
        if (this.schemasList.contains(schema)) {
            return true;
        }
        return false;
    }

    @Override
    public List<String> getSchemasList() {
        return this.schemasList;
    }

    @Override
    public void setSchemasList(String schema) {
        this.schemasList.add(schema);
    }

    @Override
    public ArrayList<AttributeSchema> getAttributesList() {
        return this.attributeList;
    }

    @Override
    public void setAttributeList(ArrayList attributeList) {
        this.attributeList = attributeList;
    }
}

