/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.charon3.core.schema;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.wso2.charon3.core.attributes.SimpleAttribute;
import org.wso2.charon3.core.exceptions.BadRequestException;
import org.wso2.charon3.core.exceptions.CharonException;
import org.wso2.charon3.core.exceptions.NotFoundException;
import org.wso2.charon3.core.objects.AbstractSCIMObject;
import org.wso2.charon3.core.objects.Role;
import org.wso2.charon3.core.objects.User;
import org.wso2.charon3.core.protocol.endpoints.AbstractResourceManager;
import org.wso2.charon3.core.schema.AbstractValidator;
import org.wso2.charon3.core.schema.SCIMResourceTypeSchema;
import org.wso2.charon3.core.utils.AttributeUtil;

public class ServerSideValidator
extends AbstractValidator {
    public static void validateCreatedSCIMObject(AbstractSCIMObject scimObject, SCIMResourceTypeSchema resourceSchema) throws CharonException, BadRequestException, NotFoundException {
        String location;
        if (scimObject instanceof User) {
            ServerSideValidator.setDisplayNameInComplexMultiValuedAttributes(scimObject, resourceSchema);
        }
        ServerSideValidator.removeAnyReadOnlyAttributes(scimObject, resourceSchema);
        if (!(scimObject instanceof Role)) {
            String id = UUID.randomUUID().toString();
            scimObject.setId(id);
            Instant now = Instant.now();
            scimObject.setCreatedInstant(AttributeUtil.parseDateTime(AttributeUtil.formatDateTime(now)));
            scimObject.setLastModifiedInstant(AttributeUtil.parseDateTime(AttributeUtil.formatDateTime(now)));
        }
        if (resourceSchema.isSchemaAvailable("urn:ietf:params:scim:schemas:core:2.0:User").booleanValue()) {
            location = ServerSideValidator.createLocationHeader(AbstractResourceManager.getResourceEndpointURL("/Users"), scimObject.getId());
            scimObject.setLocation(location);
            scimObject.setResourceType("User");
        } else if (resourceSchema.isSchemaAvailable("urn:ietf:params:scim:schemas:core:2.0:Group").booleanValue()) {
            location = ServerSideValidator.createLocationHeader(AbstractResourceManager.getResourceEndpointURL("/Groups"), scimObject.getId());
            scimObject.setLocation(location);
            scimObject.setResourceType("Group");
        } else if (resourceSchema.isSchemaAvailable("urn:ietf:params:scim:schemas:extension:2.0:Role").booleanValue()) {
            scimObject.setResourceType("Role");
        }
        ServerSideValidator.validateSCIMObjectForRequiredAttributes(scimObject, resourceSchema);
        ServerSideValidator.validateSchemaList(scimObject, resourceSchema);
    }

    private static String createLocationHeader(String location, String resourceID) {
        String locationString = location + "/" + resourceID;
        return locationString;
    }

    public static void validateRetrievedSCIMObjectInList(AbstractSCIMObject scimObject, SCIMResourceTypeSchema resourceSchema, String reuqestedAttributes, String requestedExcludingAttributes) throws BadRequestException, CharonException {
        ServerSideValidator.validateReturnedAttributes(scimObject, reuqestedAttributes, requestedExcludingAttributes);
    }

    public static void validateRetrievedSCIMObject(AbstractSCIMObject scimObject, SCIMResourceTypeSchema resourceSchema, String reuqestedAttributes, String requestedExcludingAttributes) throws BadRequestException, CharonException {
        ServerSideValidator.validateReturnedAttributes(scimObject, reuqestedAttributes, requestedExcludingAttributes);
        ServerSideValidator.validateSchemaList(scimObject, resourceSchema);
    }

    public static void validateRetrievedSCIMRoleObject(Role scimObject, String requestedAttributes, String requestedExcludingAttributes) {
        List<String> requestedExcludingAttributesList = null;
        List<String> requestedAttributesList = null;
        if (requestedExcludingAttributes != null) {
            requestedExcludingAttributesList = Arrays.asList(requestedExcludingAttributes.split(","));
        }
        if (requestedAttributes != null) {
            requestedAttributesList = Arrays.asList(requestedAttributes.split(","));
        }
        if (requestedAttributesList != null && requestedAttributesList.stream().noneMatch("permissions"::equalsIgnoreCase)) {
            scimObject.setPermissions(new ArrayList<String>());
        } else if (requestedExcludingAttributesList != null && requestedExcludingAttributesList.stream().anyMatch("permissions"::equalsIgnoreCase)) {
            scimObject.setPermissions(new ArrayList<String>());
        }
    }

    public static AbstractSCIMObject validateUpdatedSCIMObject(AbstractSCIMObject oldObject, AbstractSCIMObject newObject, SCIMResourceTypeSchema resourceSchema) throws CharonException, BadRequestException {
        AbstractSCIMObject validatedObject = null;
        if (newObject instanceof User) {
            ServerSideValidator.setDisplayNameInComplexMultiValuedAttributes(newObject, resourceSchema);
        }
        validatedObject = ServerSideValidator.checkIfReadOnlyAndImmutableAttributesModified(oldObject, newObject, resourceSchema);
        validatedObject.setAttribute(oldObject.getAttribute("meta"));
        validatedObject.setAttribute(oldObject.getAttribute("id"));
        validatedObject.setLastModifiedInstant(Instant.now());
        ServerSideValidator.validateSCIMObjectForRequiredAttributes(newObject, resourceSchema);
        ServerSideValidator.validateSchemaList(validatedObject, resourceSchema);
        return validatedObject;
    }

    public static AbstractSCIMObject validateResourceTypeSCIMObject(AbstractSCIMObject scimObject) throws NotFoundException, BadRequestException, CharonException {
        String endpoint = (String)((SimpleAttribute)scimObject.getAttribute("name")).getValue();
        String location = ServerSideValidator.createLocationHeader(AbstractResourceManager.getResourceEndpointURL("/ResourceTypes"), endpoint);
        scimObject.setLocation(location);
        scimObject.setResourceType("ResourceType");
        return scimObject;
    }
}

