/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.charon3.core.objects;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.wso2.charon3.core.attributes.Attribute;
import org.wso2.charon3.core.attributes.ComplexAttribute;
import org.wso2.charon3.core.attributes.DefaultAttributeFactory;
import org.wso2.charon3.core.attributes.MultiValuedAttribute;
import org.wso2.charon3.core.attributes.SimpleAttribute;
import org.wso2.charon3.core.exceptions.BadRequestException;
import org.wso2.charon3.core.exceptions.CharonException;
import org.wso2.charon3.core.objects.AbstractSCIMObject;
import org.wso2.charon3.core.objects.Group;
import org.wso2.charon3.core.objects.User;
import org.wso2.charon3.core.schema.SCIMResourceSchemaManager;
import org.wso2.charon3.core.schema.SCIMResourceTypeSchema;
import org.wso2.charon3.core.schema.SCIMSchemaDefinitions;
import org.wso2.charon3.core.utils.LambdaExceptionUtils;

public class Role
extends AbstractSCIMObject {
    private static final long serialVersionUID = 6106269076155338045L;
    private List<String> permissions = new ArrayList<String>();

    public String getDisplayName() {
        if (this.isAttributeExist("displayName")) {
            return LambdaExceptionUtils.rethrowSupplier(() -> ((SimpleAttribute)this.attributeList.get("displayName")).getStringValue()).get();
        }
        return null;
    }

    public void setDisplayName(String displayName) throws CharonException, BadRequestException {
        if (this.isAttributeExist("displayName")) {
            ((SimpleAttribute)this.attributeList.get("displayName")).updateValue(displayName);
        } else {
            SimpleAttribute displayAttribute = new SimpleAttribute("displayName", displayName);
            displayAttribute = (SimpleAttribute)DefaultAttributeFactory.createAttribute(SCIMSchemaDefinitions.SCIMGroupSchemaDefinition.DISPLAY_NAME, displayAttribute);
            this.attributeList.put("displayName", displayAttribute);
        }
    }

    public void replaceDisplayName(String displayName) {
        this.replaceSimpleAttribute(SCIMSchemaDefinitions.SCIMRoleSchemaDefinition.DISPLAY_NAME, displayName);
    }

    public List<String> getUsers() {
        ArrayList<String> userList = new ArrayList<String>();
        if (this.isAttributeExist("users")) {
            MultiValuedAttribute users = (MultiValuedAttribute)this.attributeList.get("users");
            List<Attribute> subValuesList = users.getAttributeValues();
            for (Attribute subValue : subValuesList) {
                ComplexAttribute complexAttribute = (ComplexAttribute)subValue;
                Map<String, Attribute> subAttributesList = complexAttribute.getSubAttributesList();
                if (subAttributesList == null || !subAttributesList.containsKey("value")) continue;
                userList.add((String)((SimpleAttribute)subAttributesList.get("value")).getValue());
            }
        }
        return userList;
    }

    public List<String> getUsersWithDisplayName() {
        MultiValuedAttribute users;
        List<Attribute> values;
        ArrayList<String> displayNames = new ArrayList<String>();
        if (this.isAttributeExist("users") && (values = (users = (MultiValuedAttribute)this.attributeList.get("users")).getAttributeValues()) != null) {
            List<Attribute> subValuesList = users.getAttributeValues();
            for (Attribute subValue : subValuesList) {
                ComplexAttribute complexAttribute = (ComplexAttribute)subValue;
                Map<String, Attribute> subAttributesList = complexAttribute.getSubAttributesList();
                if (subAttributesList == null || !subAttributesList.containsKey("display")) continue;
                displayNames.add((String)((SimpleAttribute)subAttributesList.get("display")).getValue());
            }
            return displayNames;
        }
        return displayNames;
    }

    public void setUser(User user) throws BadRequestException, CharonException {
        if (this.isAttributeExist("users")) {
            MultiValuedAttribute users = (MultiValuedAttribute)this.attributeList.get("users");
            ComplexAttribute complexAttribute = this.processUser(user);
            users.setAttributeValue(complexAttribute);
        } else {
            MultiValuedAttribute users = new MultiValuedAttribute("users");
            DefaultAttributeFactory.createAttribute(SCIMSchemaDefinitions.SCIMRoleSchemaDefinition.USERS, users);
            ComplexAttribute complexAttribute = this.processUser(user);
            users.setAttributeValue(complexAttribute);
            this.setAttribute(users);
        }
    }

    private ComplexAttribute processUser(User user) throws BadRequestException, CharonException {
        String userId = user.getId();
        String userName = user.getUserName();
        String reference = user.getLocation();
        ComplexAttribute complexAttribute = new ComplexAttribute();
        complexAttribute.setName("users_" + userId + "default");
        if (userId != null) {
            SimpleAttribute valueSimpleAttribute = new SimpleAttribute("value", userId);
            DefaultAttributeFactory.createAttribute(SCIMSchemaDefinitions.SCIMRoleSchemaDefinition.USERS_VALUE, valueSimpleAttribute);
            complexAttribute.setSubAttribute(valueSimpleAttribute);
        }
        if (userName != null) {
            SimpleAttribute displaySimpleAttribute = new SimpleAttribute("display", userName);
            DefaultAttributeFactory.createAttribute(SCIMSchemaDefinitions.SCIMRoleSchemaDefinition.USERS_DISPLAY, displaySimpleAttribute);
            complexAttribute.setSubAttribute(displaySimpleAttribute);
        }
        if (reference != null) {
            SimpleAttribute referenceSimpleAttribute = new SimpleAttribute("$ref", reference);
            DefaultAttributeFactory.createAttribute(SCIMSchemaDefinitions.SCIMRoleSchemaDefinition.USERS_REF, referenceSimpleAttribute);
            complexAttribute.setSubAttribute(referenceSimpleAttribute);
        }
        DefaultAttributeFactory.createAttribute(SCIMSchemaDefinitions.SCIMRoleSchemaDefinition.USERS, complexAttribute);
        return complexAttribute;
    }

    public List<String> getGroups() {
        ArrayList<String> groupList = new ArrayList<String>();
        if (this.isAttributeExist("groups")) {
            MultiValuedAttribute groups = (MultiValuedAttribute)this.attributeList.get("groups");
            List<Attribute> subValuesList = groups.getAttributeValues();
            for (Attribute subValue : subValuesList) {
                ComplexAttribute complexAttribute = (ComplexAttribute)subValue;
                Map<String, Attribute> subAttributesList = complexAttribute.getSubAttributesList();
                if (subAttributesList == null || !subAttributesList.containsKey("value")) continue;
                groupList.add((String)((SimpleAttribute)subAttributesList.get("value")).getValue());
            }
        }
        return groupList;
    }

    public List<String> getGroupsWithDisplayName() {
        MultiValuedAttribute groups;
        List<Attribute> values;
        ArrayList<String> displayNames = new ArrayList<String>();
        if (this.isAttributeExist("groups") && (values = (groups = (MultiValuedAttribute)this.attributeList.get("groups")).getAttributeValues()) != null) {
            List<Attribute> subValuesList = groups.getAttributeValues();
            for (Attribute subValue : subValuesList) {
                ComplexAttribute complexAttribute = (ComplexAttribute)subValue;
                Map<String, Attribute> subAttributesList = complexAttribute.getSubAttributesList();
                if (subAttributesList == null || !subAttributesList.containsKey("display")) continue;
                displayNames.add((String)((SimpleAttribute)subAttributesList.get("display")).getValue());
            }
            return displayNames;
        }
        return displayNames;
    }

    public void setGroup(Group group) throws BadRequestException, CharonException {
        if (this.isAttributeExist("groups")) {
            MultiValuedAttribute groups = (MultiValuedAttribute)this.attributeList.get("groups");
            ComplexAttribute complexAttribute = this.processGroup(group);
            groups.setAttributeValue(complexAttribute);
        } else {
            MultiValuedAttribute groups = new MultiValuedAttribute("groups");
            DefaultAttributeFactory.createAttribute(SCIMSchemaDefinitions.SCIMRoleSchemaDefinition.GROUPS, groups);
            ComplexAttribute complexAttribute = this.processGroup(group);
            groups.setAttributeValue(complexAttribute);
            this.setAttribute(groups);
        }
    }

    private ComplexAttribute processGroup(Group group) throws BadRequestException, CharonException {
        String groupID = group.getId();
        String groupName = group.getDisplayName();
        String reference = group.getLocation();
        ComplexAttribute complexAttribute = new ComplexAttribute();
        complexAttribute.setName("groups_" + groupID + "default");
        if (groupID != null) {
            SimpleAttribute valueSimpleAttribute = new SimpleAttribute("value", groupID);
            DefaultAttributeFactory.createAttribute(SCIMSchemaDefinitions.SCIMRoleSchemaDefinition.GROUPS_VALUE, valueSimpleAttribute);
            complexAttribute.setSubAttribute(valueSimpleAttribute);
        }
        if (groupName != null) {
            SimpleAttribute displaySimpleAttribute = new SimpleAttribute("display", groupName);
            DefaultAttributeFactory.createAttribute(SCIMSchemaDefinitions.SCIMRoleSchemaDefinition.GROUPS_DISPLAY, displaySimpleAttribute);
            complexAttribute.setSubAttribute(displaySimpleAttribute);
        }
        if (reference != null) {
            SimpleAttribute referenceSimpleAttribute = new SimpleAttribute("$ref", reference);
            DefaultAttributeFactory.createAttribute(SCIMSchemaDefinitions.SCIMRoleSchemaDefinition.GROUPS_REF, referenceSimpleAttribute);
            complexAttribute.setSubAttribute(referenceSimpleAttribute);
        }
        DefaultAttributeFactory.createAttribute(SCIMSchemaDefinitions.SCIMRoleSchemaDefinition.GROUPS, complexAttribute);
        return complexAttribute;
    }

    public void setSchemas() {
        SCIMResourceTypeSchema schema = SCIMResourceSchemaManager.getInstance().getRoleResourceSchema();
        List<String> schemasList = schema.getSchemasList();
        for (String scheme : schemasList) {
            this.setSchema(scheme);
        }
    }

    public void setPermissions(List<String> permissions) {
        this.permissions = permissions;
    }

    public List<String> getPermissions() {
        return this.permissions;
    }

    public void setSystemRole(boolean isSystemRole) throws CharonException, BadRequestException {
        SimpleAttribute systemRoleAttribute = (SimpleAttribute)DefaultAttributeFactory.createAttribute(SCIMSchemaDefinitions.SYSTEM_ROLE, new SimpleAttribute("systemRole", isSystemRole));
        if (this.getMetaAttribute() != null) {
            ComplexAttribute metaAttribute = this.getMetaAttribute();
            if (metaAttribute.isSubAttributeExist(systemRoleAttribute.getName())) {
                String error = "Tried to modify a read only attribute.";
                throw new CharonException(error);
            }
            metaAttribute.setSubAttribute(systemRoleAttribute);
        } else {
            this.createMetaAttribute();
            this.getMetaAttribute().setSubAttribute(systemRoleAttribute);
        }
    }
}

