/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.charon3.core.encoder;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.charon3.core.attributes.Attribute;
import org.wso2.charon3.core.attributes.ComplexAttribute;
import org.wso2.charon3.core.attributes.DefaultAttributeFactory;
import org.wso2.charon3.core.attributes.MultiValuedAttribute;
import org.wso2.charon3.core.attributes.SimpleAttribute;
import org.wso2.charon3.core.exceptions.AbstractCharonException;
import org.wso2.charon3.core.exceptions.BadRequestException;
import org.wso2.charon3.core.exceptions.CharonException;
import org.wso2.charon3.core.exceptions.InternalErrorException;
import org.wso2.charon3.core.objects.AbstractSCIMObject;
import org.wso2.charon3.core.objects.Group;
import org.wso2.charon3.core.objects.ListedResource;
import org.wso2.charon3.core.objects.Role;
import org.wso2.charon3.core.objects.User;
import org.wso2.charon3.core.objects.bulk.BulkRequestContent;
import org.wso2.charon3.core.objects.bulk.BulkRequestData;
import org.wso2.charon3.core.schema.AttributeSchema;
import org.wso2.charon3.core.schema.ResourceTypeSchema;
import org.wso2.charon3.core.schema.SCIMDefinitions;
import org.wso2.charon3.core.schema.SCIMResourceSchemaManager;
import org.wso2.charon3.core.schema.SCIMResourceTypeSchema;
import org.wso2.charon3.core.utils.AttributeUtil;
import org.wso2.charon3.core.utils.codeutils.FilterTreeManager;
import org.wso2.charon3.core.utils.codeutils.Node;
import org.wso2.charon3.core.utils.codeutils.PatchOperation;
import org.wso2.charon3.core.utils.codeutils.SearchRequest;

public class JSONDecoder {
    private static final Logger logger = LoggerFactory.getLogger(JSONDecoder.class);

    public <T extends AbstractSCIMObject> ListedResource decodeListedResource(String scimResourceString, ResourceTypeSchema resourceSchema, Class<T> scimObjectType) throws BadRequestException, CharonException {
        JSONObject decodedJsonObj;
        try {
            decodedJsonObj = new JSONObject(new JSONTokener(scimResourceString));
        }
        catch (JSONException e) {
            logger.error("json error in decoding the resource", (Throwable)e);
            throw new BadRequestException("invalidSyntax");
        }
        int totalResults = this.getIntValueFromJson(decodedJsonObj, "totalResults");
        int startIndex = this.getIntValueFromJson(decodedJsonObj, "startIndex");
        int itemsPerPage = this.getIntValueFromJson(decodedJsonObj, "itemsPerPage");
        ListedResource listedResource = new ListedResource();
        listedResource.setSchema("urn:ietf:params:scim:api:messages:2.0:ListResponse");
        listedResource.setTotalResults(totalResults);
        listedResource.setStartIndex(startIndex);
        listedResource.setItemsPerPage(itemsPerPage);
        JSONArray resources = null;
        try {
            resources = decodedJsonObj.getJSONArray("Resources");
        }
        catch (JSONException e) {
            logger.debug("could not get '{}' from json structure, result is empty", (Object)"Resources");
            return listedResource;
        }
        for (int i = 0; i < resources.length(); ++i) {
            JSONObject resource;
            try {
                resource = resources.getJSONObject(i);
            }
            catch (JSONException e) {
                logger.error("could not get '{}' from json structure", (Object)"Resources");
                throw new CharonException("invalidSyntax", e);
            }
            try {
                AbstractSCIMObject abstractSCIMObject = this.decodeResource(resource.toString(), resourceSchema, (AbstractSCIMObject)scimObjectType.newInstance());
                listedResource.addResource(abstractSCIMObject);
                continue;
            }
            catch (IllegalAccessException | InstantiationException | InternalErrorException e) {
                throw new CharonException("could not create resource instance of type " + scimObjectType.getName(), e);
            }
        }
        return listedResource;
    }

    public AbstractCharonException decodeCharonException(String scimErrorString) throws BadRequestException, CharonException {
        JSONObject decodedJsonObj;
        try {
            decodedJsonObj = new JSONObject(new JSONTokener(scimErrorString));
        }
        catch (JSONException e) {
            logger.error("json error in decoding the resource", (Throwable)e);
            throw new BadRequestException("invalidSyntax");
        }
        String schema = this.getFirstSchemaValueFromJson(decodedJsonObj);
        String scimType = this.getStringValueFromJson(decodedJsonObj, "scimType");
        String detail = this.getStringValueFromJson(decodedJsonObj, "detail");
        int httpStatusCode = this.getIntValueFromJson(decodedJsonObj, "status");
        if (schema == null || !schema.equals("urn:ietf:params:scim:api:messages:2.0:Error")) {
            throw new CharonException("given scim resource string does not seem to be an error. Expected scim error URI but got: '" + schema + "'");
        }
        return new AbstractCharonException(httpStatusCode, detail, scimType);
    }

    public <T extends AbstractCharonException> T decodeCharonException(String scimErrorString, Class<T> exceptionType) throws BadRequestException, CharonException {
        AbstractCharonException exception;
        AbstractCharonException abstractCharonException = this.decodeCharonException(scimErrorString);
        try {
            exception = (AbstractCharonException)exceptionType.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new CharonException("could not create instance of type: " + exceptionType.getName(), e);
        }
        exception.setSchemas(abstractCharonException.getSchemas());
        exception.setDetail(abstractCharonException.getDetail());
        exception.setScimType(abstractCharonException.getScimType());
        exception.setStatus(abstractCharonException.getStatus());
        return (T)exception;
    }

    private String getFirstSchemaValueFromJson(JSONObject jsonObject) throws CharonException {
        String value;
        block2: {
            value = null;
            try {
                JSONArray schemas = jsonObject.getJSONArray("schemas");
                value = schemas.getString(0);
            }
            catch (JSONException e) {
                logger.debug("could not get '{}' value from scim resource as an array", (Object)"schemas");
                value = this.getStringValueFromJson(jsonObject, "schemas");
                if (value != null) break block2;
                throw new CharonException("could not retrieve the 'schemas' field from the given json resource");
            }
        }
        return value;
    }

    private String getStringValueFromJson(JSONObject jsonObject, String name) throws CharonException {
        String value = null;
        try {
            value = jsonObject.getString(name);
        }
        catch (JSONException e) {
            logger.debug("could not get '{}' value from scim resource", (Object)name);
        }
        return value;
    }

    private int getIntValueFromJson(JSONObject jsonObject, String name) throws CharonException {
        int totalResults;
        try {
            totalResults = jsonObject.getInt(name);
        }
        catch (JSONException e) {
            logger.error("could not get '{}' value from scim resource", (Object)name);
            throw new CharonException("invalidSyntax", e);
        }
        return totalResults;
    }

    public <T extends AbstractSCIMObject> T decodeResource(String scimResourceString, ResourceTypeSchema resourceSchema, T scimObject) throws BadRequestException, CharonException, InternalErrorException {
        try {
            JSONObject decodedJsonObj = new JSONObject(new JSONTokener(scimResourceString));
            ArrayList<AttributeSchema> attributeSchemas = resourceSchema.getAttributesList();
            for (int i = 0; i < resourceSchema.getSchemasList().size(); ++i) {
                scimObject.setSchema(resourceSchema.getSchemasList().get(i));
            }
            for (AttributeSchema attributeSchema : attributeSchemas) {
                SCIMDefinitions.DataType attributeSchemaDataType;
                Object attributeValObj = decodedJsonObj.opt(attributeSchema.getName());
                if (attributeValObj == null) {
                    attributeValObj = decodedJsonObj.opt(attributeSchema.getURI());
                }
                if ((attributeSchemaDataType = attributeSchema.getType()).equals((Object)SCIMDefinitions.DataType.STRING) || attributeSchemaDataType.equals((Object)SCIMDefinitions.DataType.BINARY) || attributeSchemaDataType.equals((Object)SCIMDefinitions.DataType.BOOLEAN) || attributeSchemaDataType.equals((Object)SCIMDefinitions.DataType.DATE_TIME) || attributeSchemaDataType.equals((Object)SCIMDefinitions.DataType.DECIMAL) || attributeSchemaDataType.equals((Object)SCIMDefinitions.DataType.INTEGER) || attributeSchemaDataType.equals((Object)SCIMDefinitions.DataType.REFERENCE)) {
                    if (!attributeSchema.getMultiValued()) {
                        if (attributeValObj instanceof String || attributeValObj instanceof Boolean || attributeValObj instanceof Integer || JSONObject.NULL.equals(attributeValObj) || attributeValObj == null) {
                            if (attributeValObj == null) continue;
                            scimObject.setAttribute(this.buildSimpleAttribute(attributeSchema, attributeValObj), resourceSchema);
                            continue;
                        }
                        logger.error("Error decoding the simple attribute");
                        throw new BadRequestException("invalidSyntax");
                    }
                    if (attributeValObj instanceof JSONArray || attributeValObj == null) {
                        if (attributeValObj == null) continue;
                        if (scimObject instanceof Role) {
                            ((Role)scimObject).setPermissions(this.toList((JSONArray)attributeValObj));
                        }
                        scimObject.setAttribute(this.buildPrimitiveMultiValuedAttribute(attributeSchema, (JSONArray)attributeValObj), resourceSchema);
                        continue;
                    }
                    logger.error("Error decoding the primitive multivalued attribute");
                    throw new BadRequestException("invalidSyntax");
                }
                if (!attributeSchemaDataType.equals((Object)SCIMDefinitions.DataType.COMPLEX)) continue;
                if (attributeSchema.getMultiValued()) {
                    if (attributeValObj instanceof JSONArray || attributeValObj == null) {
                        if (attributeValObj == null) continue;
                        scimObject.setAttribute(this.buildComplexMultiValuedAttribute(attributeSchema, (JSONArray)attributeValObj), resourceSchema);
                        continue;
                    }
                    logger.error("Error decoding the complex multivalued attribute");
                    throw new BadRequestException("invalidSyntax");
                }
                if (attributeSchema.getMultiValued()) continue;
                if (attributeValObj instanceof JSONObject || attributeValObj == null) {
                    if (attributeValObj == null) continue;
                    scimObject.setAttribute(this.buildComplexAttribute(attributeSchema, (JSONObject)attributeValObj), resourceSchema);
                    continue;
                }
                logger.error("Error decoding the complex attribute");
                throw new BadRequestException("invalidSyntax");
            }
            return scimObject;
        }
        catch (JSONException e) {
            logger.error("json error in decoding the resource");
            throw new BadRequestException("invalidSyntax");
        }
    }

    public List<String> toList(JSONArray array) throws JSONException {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < array.length(); ++i) {
            list.add(array.getString(i));
        }
        return list;
    }

    public SimpleAttribute buildSimpleAttribute(AttributeSchema attributeSchema, Object attributeValue) throws CharonException, BadRequestException {
        Object attributeValueObject = AttributeUtil.getAttributeValueFromString(attributeValue, attributeSchema.getType());
        SimpleAttribute simpleAttribute = new SimpleAttribute(attributeSchema.getName(), attributeValueObject);
        return (SimpleAttribute)DefaultAttributeFactory.createAttribute(attributeSchema, simpleAttribute);
    }

    public MultiValuedAttribute buildComplexMultiValuedAttribute(AttributeSchema attributeSchema, JSONArray attributeValues) throws CharonException, BadRequestException {
        try {
            MultiValuedAttribute multiValuedAttribute = new MultiValuedAttribute(attributeSchema.getName());
            ArrayList<Attribute> complexAttributeValues = new ArrayList<Attribute>();
            ArrayList<Object> simpleAttributeValues = new ArrayList<Object>();
            for (int i = 0; i < attributeValues.length(); ++i) {
                Object attributeValue = attributeValues.get(i);
                if (attributeValue instanceof JSONObject) {
                    JSONObject complexAttributeValue = (JSONObject)attributeValue;
                    complexAttributeValues.add(this.buildComplexValue(attributeSchema, complexAttributeValue));
                    continue;
                }
                if (attributeValue instanceof String || attributeValue instanceof Integer || attributeValue instanceof Double || attributeValue instanceof Boolean || attributeValue == null) {
                    if (logger.isDebugEnabled()) {
                        if (attributeValue != null) {
                            logger.debug("Primitive attribute type detected. Attribute type: " + attributeValue.getClass().getName() + ", attribute value: " + attributeValue);
                        } else {
                            logger.debug("Attribute value is null.");
                        }
                    }
                    if (attributeValue == null) continue;
                    simpleAttributeValues.add(attributeValue);
                    continue;
                }
                String error = "Unknown JSON representation for the MultiValued attribute " + attributeSchema.getName() + " which has data type as " + (Object)((Object)attributeSchema.getType());
                throw new BadRequestException(error, "invalidSyntax");
            }
            multiValuedAttribute.setAttributeValues(complexAttributeValues);
            multiValuedAttribute.setAttributePrimitiveValues(simpleAttributeValues);
            return (MultiValuedAttribute)DefaultAttributeFactory.createAttribute(attributeSchema, multiValuedAttribute);
        }
        catch (JSONException e) {
            String error = "Error in accessing JSON value of multivalued attribute";
            throw new CharonException(error, e);
        }
    }

    public MultiValuedAttribute buildPrimitiveMultiValuedAttribute(AttributeSchema attributeSchema, JSONArray attributeValues) throws CharonException, BadRequestException {
        try {
            MultiValuedAttribute multiValuedAttribute = new MultiValuedAttribute(attributeSchema.getName());
            ArrayList<Object> primitiveValues = new ArrayList<Object>();
            for (int i = 0; i < attributeValues.length(); ++i) {
                Object attributeValue = attributeValues.get(i);
                if (attributeValue instanceof String || attributeValue instanceof Boolean || attributeValue instanceof Integer || attributeValue == null) {
                    if (attributeValue == null) continue;
                    primitiveValues.add(attributeValue);
                    continue;
                }
                String error = "Unknown JSON representation for the MultiValued attribute " + attributeSchema.getName() + " which has data type as " + (Object)((Object)attributeSchema.getType());
                throw new BadRequestException(error, "invalidSyntax");
            }
            multiValuedAttribute.setAttributePrimitiveValues(primitiveValues);
            return (MultiValuedAttribute)DefaultAttributeFactory.createAttribute(attributeSchema, multiValuedAttribute);
        }
        catch (JSONException e) {
            String error = "Error in accessing JSON value of multivalued attribute";
            throw new CharonException(error, e);
        }
    }

    public ComplexAttribute buildComplexAttribute(AttributeSchema complexAttributeSchema, JSONObject jsonObject) throws BadRequestException, CharonException, InternalErrorException, JSONException {
        ComplexAttribute complexAttribute = new ComplexAttribute(complexAttributeSchema.getName());
        HashMap<String, Attribute> subAttributesMap = new HashMap<String, Attribute>();
        List<AttributeSchema> subAttributeSchemas = complexAttributeSchema.getSubAttributeSchemas();
        String userExtensionName = SCIMResourceSchemaManager.getInstance().getExtensionName();
        String customExtensionName = SCIMResourceSchemaManager.getInstance().getCustomSchemaExtensionURI();
        for (AttributeSchema subAttributeSchema : subAttributeSchemas) {
            Object attributeValObj = jsonObject.opt(subAttributeSchema.getName());
            SCIMDefinitions.DataType subAttributeSchemaType = subAttributeSchema.getType();
            if (subAttributeSchemaType.equals((Object)SCIMDefinitions.DataType.STRING) || subAttributeSchemaType.equals((Object)SCIMDefinitions.DataType.BINARY) || subAttributeSchemaType.equals((Object)SCIMDefinitions.DataType.BOOLEAN) || subAttributeSchemaType.equals((Object)SCIMDefinitions.DataType.DATE_TIME) || subAttributeSchemaType.equals((Object)SCIMDefinitions.DataType.DECIMAL) || subAttributeSchemaType.equals((Object)SCIMDefinitions.DataType.INTEGER) || subAttributeSchemaType.equals((Object)SCIMDefinitions.DataType.REFERENCE)) {
                if (!subAttributeSchema.getMultiValued()) {
                    if (attributeValObj instanceof String || attributeValObj instanceof Boolean || attributeValObj instanceof Integer || JSONObject.NULL.equals(attributeValObj) || attributeValObj == null) {
                        if (attributeValObj == null) continue;
                        subAttributesMap.put(subAttributeSchema.getName(), this.buildSimpleAttribute(subAttributeSchema, attributeValObj));
                        continue;
                    }
                    logger.error("Error decoding the sub attribute");
                    throw new BadRequestException("invalidSyntax");
                }
                if (attributeValObj instanceof JSONArray || attributeValObj == null) {
                    if (attributeValObj == null) continue;
                    subAttributesMap.put(subAttributeSchema.getName(), this.buildPrimitiveMultiValuedAttribute(subAttributeSchema, (JSONArray)attributeValObj));
                    continue;
                }
                logger.error("Error decoding the sub attribute");
                throw new BadRequestException("invalidSyntax");
            }
            if (complexAttributeSchema.getName().equals(userExtensionName) || complexAttributeSchema.getName().equals(customExtensionName)) {
                if (!subAttributeSchemaType.equals((Object)SCIMDefinitions.DataType.COMPLEX)) continue;
                List<AttributeSchema> subList = subAttributeSchema.getSubAttributeSchemas();
                for (AttributeSchema attributeSchema : subList) {
                    if (!attributeSchema.getType().equals((Object)SCIMDefinitions.DataType.COMPLEX)) continue;
                    String error = "Complex attribute can not have complex sub attributes";
                    throw new InternalErrorException(error);
                }
                if (subAttributeSchema.getMultiValued()) {
                    if (attributeValObj instanceof JSONArray || attributeValObj == null) {
                        if (attributeValObj == null) continue;
                        MultiValuedAttribute multiValuedAttribute = new MultiValuedAttribute(subAttributeSchema.getName());
                        JSONArray attributeValues = null;
                        ArrayList<Attribute> complexAttributeValues = new ArrayList<Attribute>();
                        try {
                            attributeValues = (JSONArray)attributeValObj;
                        }
                        catch (Exception e) {
                            logger.error("Error decoding the extension");
                            throw new BadRequestException("invalidSyntax");
                        }
                        for (int i = 0; i < attributeValues.length(); ++i) {
                            Object attributeValue = attributeValues.get(i);
                            if (!(attributeValue instanceof JSONObject)) {
                                String error = "Unknown JSON representation for the MultiValued attribute " + subAttributeSchema.getName() + " which has data type as " + (Object)((Object)subAttributeSchema.getType());
                                throw new BadRequestException(error, "invalidSyntax");
                            }
                            JSONObject complexAttributeValue = (JSONObject)attributeValue;
                            complexAttributeValues.add(this.buildComplexValue(subAttributeSchema, complexAttributeValue));
                            multiValuedAttribute.setAttributeValues(complexAttributeValues);
                            MultiValuedAttribute complexMultiValuedSubAttribute = (MultiValuedAttribute)DefaultAttributeFactory.createAttribute(subAttributeSchema, multiValuedAttribute);
                            subAttributesMap.put(complexMultiValuedSubAttribute.getName(), complexMultiValuedSubAttribute);
                        }
                        continue;
                    }
                    logger.error("Error decoding the extension sub attribute");
                    throw new BadRequestException("invalidSyntax");
                }
                if (attributeValObj instanceof JSONObject || attributeValObj == null) {
                    if (attributeValObj == null) continue;
                    ComplexAttribute complexSubAttribute = this.buildComplexAttribute(subAttributeSchema, (JSONObject)attributeValObj);
                    subAttributesMap.put(complexSubAttribute.getName(), complexSubAttribute);
                    continue;
                }
                logger.error("Error decoding the extension sub attribute");
                throw new BadRequestException("invalidSyntax");
            }
            String error = "Complex attribute can not have complex sub attributes";
            throw new InternalErrorException(error);
        }
        complexAttribute.setSubAttributesList(subAttributesMap);
        return (ComplexAttribute)DefaultAttributeFactory.createAttribute(complexAttributeSchema, complexAttribute);
    }

    private ComplexAttribute buildComplexValue(AttributeSchema attributeSchema, JSONObject jsonObject) throws CharonException, BadRequestException {
        ComplexAttribute complexAttribute = new ComplexAttribute(attributeSchema.getName());
        HashMap<String, Attribute> subAttributesMap = new HashMap<String, Attribute>();
        List<AttributeSchema> subAttributeSchemas = attributeSchema.getSubAttributeSchemas();
        for (AttributeSchema subAttributeSchema : subAttributeSchemas) {
            Object subAttributeValue = jsonObject.opt(subAttributeSchema.getName());
            if (subAttributeSchema.getName().equals("value")) {
                if (subAttributeValue != null) {
                    Object subAttributeValueForType = jsonObject.opt("type");
                    if (subAttributeValueForType != null) {
                        complexAttribute.setName(attributeSchema.getName() + "_" + subAttributeValue + "_" + subAttributeValueForType);
                    } else {
                        complexAttribute.setName(attributeSchema.getName() + "_" + subAttributeValue + "_" + "default");
                    }
                } else {
                    Object subAttributeValueFortype = jsonObject.opt("type");
                    if (subAttributeValueFortype != null) {
                        complexAttribute.setName(attributeSchema.getName() + "_" + "default" + "_" + subAttributeValueFortype);
                    } else {
                        complexAttribute.setName(attributeSchema.getName() + "_" + "default" + "_" + "default");
                    }
                }
            }
            if (subAttributeValue == null) continue;
            if (subAttributeSchema.getMultiValued()) {
                if (subAttributeValue instanceof JSONArray) {
                    MultiValuedAttribute multiValuedAttribute = this.buildPrimitiveMultiValuedAttribute(subAttributeSchema, (JSONArray)subAttributeValue);
                    multiValuedAttribute = (MultiValuedAttribute)DefaultAttributeFactory.createAttribute(subAttributeSchema, multiValuedAttribute);
                    subAttributesMap.put(subAttributeSchema.getName(), multiValuedAttribute);
                    continue;
                }
                throw new BadRequestException("invalidSyntax");
            }
            if (subAttributeValue instanceof String || subAttributeValue instanceof Boolean || JSONObject.NULL.equals(subAttributeValue) || subAttributeValue instanceof Integer) {
                SimpleAttribute simpleAttribute = this.buildSimpleAttribute(subAttributeSchema, subAttributeValue);
                simpleAttribute = (SimpleAttribute)DefaultAttributeFactory.createAttribute(subAttributeSchema, simpleAttribute);
                subAttributesMap.put(subAttributeSchema.getName(), simpleAttribute);
                continue;
            }
            throw new BadRequestException("invalidSyntax");
        }
        complexAttribute.setSubAttributesList(subAttributesMap);
        return (ComplexAttribute)DefaultAttributeFactory.createAttribute(attributeSchema, complexAttribute);
    }

    public ArrayList<PatchOperation> decodeRequest(String scimResourceString) throws BadRequestException {
        ArrayList<PatchOperation> operationList = new ArrayList<PatchOperation>();
        try {
            JSONObject decodedJsonObj = new JSONObject(new JSONTokener(scimResourceString));
            JSONArray operationJsonList = (JSONArray)decodedJsonObj.opt("Operations");
            for (int count = 0; count < operationJsonList.length(); ++count) {
                JSONObject operation = (JSONObject)operationJsonList.get(count);
                PatchOperation patchOperation = new PatchOperation();
                String op = (String)operation.opt("op");
                patchOperation.setExecutionOrder(count + 1);
                if (op == null) {
                    throw new BadRequestException("Operation can not be null.", "invalidSyntax");
                }
                if (op.equalsIgnoreCase("add")) {
                    patchOperation.setOperation("add");
                } else if (op.equalsIgnoreCase("remove")) {
                    patchOperation.setOperation("remove");
                } else if (op.equalsIgnoreCase("replace")) {
                    patchOperation.setOperation("replace");
                } else {
                    throw new BadRequestException("Unknown operation: " + op, "invalidSyntax");
                }
                patchOperation.setPath((String)operation.opt("path"));
                patchOperation.setValues(operation.opt("value"));
                operationList.add(patchOperation);
            }
        }
        catch (JSONException e) {
            logger.error("json error in decoding the request", (Throwable)e);
            throw new BadRequestException("invalidSyntax");
        }
        return operationList;
    }

    public AbstractSCIMObject decode(String scimResourceString, SCIMResourceTypeSchema schema) throws CharonException, BadRequestException {
        try {
            JSONObject decodedJsonObj = new JSONObject(new JSONTokener(scimResourceString));
            AbstractSCIMObject scimObject = null;
            scimObject = schema.getSchemasList().contains("urn:ietf:params:scim:schemas:core:2.0:Group") ? this.decodeResource(decodedJsonObj.toString(), schema, new Group()) : this.decodeResource(decodedJsonObj.toString(), schema, new User());
            return scimObject;
        }
        catch (JSONException | CharonException | InternalErrorException e) {
            throw new CharonException("Error in decoding the request", e);
        }
        catch (BadRequestException e) {
            throw new BadRequestException("invalidSyntax");
        }
    }

    public SearchRequest decodeSearchRequestBody(String scimResourceString, SCIMResourceTypeSchema schema) throws BadRequestException {
        FilterTreeManager filterTreeManager = null;
        Node rootNode = null;
        try {
            int i;
            JSONObject decodedJsonObj = new JSONObject(new JSONTokener(scimResourceString));
            SearchRequest searchRequest = new SearchRequest();
            ArrayList<String> attributes = new ArrayList<String>();
            ArrayList<String> excludedAttributes = new ArrayList<String>();
            JSONArray attributesValues = (JSONArray)decodedJsonObj.opt("attributes");
            JSONArray excludedAttributesValues = (JSONArray)decodedJsonObj.opt("excludedAttributes");
            JSONArray schemas = (JSONArray)decodedJsonObj.opt("schemas");
            if (schemas.length() != 1) {
                throw new BadRequestException("Schema is invalid", "invalidValue");
            }
            if (attributesValues != null) {
                for (i = 0; i < attributesValues.length(); ++i) {
                    attributes.add((String)attributesValues.get(i));
                }
            }
            if (excludedAttributesValues != null) {
                for (i = 0; i < excludedAttributesValues.length(); ++i) {
                    excludedAttributes.add((String)excludedAttributesValues.get(i));
                }
            }
            if (decodedJsonObj.opt("filter") != null) {
                filterTreeManager = new FilterTreeManager((String)decodedJsonObj.opt("filter"), schema);
                rootNode = filterTreeManager.buildTree();
            }
            searchRequest.setAttributes(attributes);
            searchRequest.setExcludedAttributes(excludedAttributes);
            searchRequest.setSchema((String)schemas.get(0));
            searchRequest.setCountStr(decodedJsonObj.optString("count"));
            searchRequest.setStartIndexStr(decodedJsonObj.optString("startIndex"));
            searchRequest.setDomainName(decodedJsonObj.optString("domain"));
            searchRequest.setFilter(rootNode);
            if (!decodedJsonObj.optString("sortBy").equals("")) {
                searchRequest.setSortBy(decodedJsonObj.optString("sortBy"));
            }
            if (!decodedJsonObj.optString("sortOrder").equals("")) {
                searchRequest.setSortOder(decodedJsonObj.optString("sortOrder"));
            }
            return searchRequest;
        }
        catch (IOException | JSONException e) {
            logger.error("Error while decoding the resource string");
            throw new BadRequestException("invalidSyntax");
        }
    }

    public BulkRequestData decodeBulkData(String bulkResourceString) throws BadRequestException {
        BulkRequestData bulkRequestDataObject = new BulkRequestData();
        ArrayList<BulkRequestContent> usersEndpointOperationList = new ArrayList<BulkRequestContent>();
        ArrayList<BulkRequestContent> groupsEndpointOperationList = new ArrayList<BulkRequestContent>();
        ArrayList<BulkRequestContent> rolesEndpointOperationList = new ArrayList<BulkRequestContent>();
        ArrayList<String> schemas = new ArrayList<String>();
        try {
            JSONObject decodedObject = new JSONObject(new JSONTokener(bulkResourceString));
            JSONArray membersAttributeSchemas = (JSONArray)decodedObject.opt("schemas");
            for (int i = 0; i < membersAttributeSchemas.length(); ++i) {
                schemas.add(membersAttributeSchemas.get(i).toString());
            }
            bulkRequestDataObject.setSchemas(schemas);
            JSONArray membersAttributeOperations = (JSONArray)decodedObject.opt("Operations");
            for (int i = 0; i < membersAttributeOperations.length(); ++i) {
                JSONObject member = (JSONObject)membersAttributeOperations.get(i);
                String requestType = member.optString("path");
                if (requestType == null) {
                    throw new BadRequestException("Missing required attribute : path", "invalidSyntax");
                }
                String requestMethod = member.optString("method");
                if (requestMethod == null) {
                    throw new BadRequestException("Missing required attribute : method", "invalidSyntax");
                }
                String requestVersion = member.optString("version");
                if (requestMethod.equals("POST")) {
                    if (!member.optString("bulkId").equals("") && member.optString("bulkId") != null) {
                        this.setRequestData(requestType, requestMethod, requestVersion, member, usersEndpointOperationList, groupsEndpointOperationList, rolesEndpointOperationList);
                        continue;
                    }
                    String error = "JSON string could not be decoded properly.Required attribute BULK_ID is missing in the request";
                    logger.error(error);
                    throw new BadRequestException(error, "invalidValue");
                }
                this.setRequestData(requestType, requestMethod, requestVersion, member, usersEndpointOperationList, groupsEndpointOperationList, rolesEndpointOperationList);
            }
            int failOnErrorsAttribute = decodedObject.optInt("failOnErrors");
            bulkRequestDataObject.setFailOnErrors(failOnErrorsAttribute);
            bulkRequestDataObject.setUserOperationRequests(usersEndpointOperationList);
            bulkRequestDataObject.setGroupOperationRequests(groupsEndpointOperationList);
            bulkRequestDataObject.setRoleOperationRequests(rolesEndpointOperationList);
        }
        catch (JSONException e1) {
            String error = "JSON string could not be decoded properly.";
            logger.error(error);
            throw new BadRequestException("invalidSyntax");
        }
        return bulkRequestDataObject;
    }

    private void setRequestData(String requestType, String requestMethod, String requestVersion, JSONObject member, List<BulkRequestContent> usersEndpointOperationList, List<BulkRequestContent> groupsEndpointOperationList, List<BulkRequestContent> rolesEndpointOperationList) {
        BulkRequestContent newRequestData;
        if (requestType.contains("/Users")) {
            newRequestData = this.getBulkRequestContent(member, requestMethod, requestType, requestVersion);
            usersEndpointOperationList.add(newRequestData);
        }
        if (requestType.contains("/Groups")) {
            newRequestData = this.getBulkRequestContent(member, requestMethod, requestType, requestVersion);
            groupsEndpointOperationList.add(newRequestData);
        }
        if (requestType.contains("/Roles")) {
            newRequestData = this.getBulkRequestContent(member, requestMethod, requestType, requestVersion);
            rolesEndpointOperationList.add(newRequestData);
        }
    }

    private BulkRequestContent getBulkRequestContent(JSONObject member, String requestMethod, String requestType, String requestVersion) {
        BulkRequestContent newRequestData = new BulkRequestContent();
        newRequestData.setData(member.optString("data"));
        newRequestData.setBulkID(member.optString("bulkId"));
        newRequestData.setMethod(requestMethod);
        newRequestData.setPath(requestType);
        newRequestData.setVersion(requestMethod);
        newRequestData.setVersion(requestVersion);
        return newRequestData;
    }
}

