/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.charon3.core.config;

import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.wso2.charon3.core.exceptions.CharonException;
import org.wso2.charon3.core.exceptions.InternalErrorException;
import org.wso2.charon3.core.schema.AttributeSchema;
import org.wso2.charon3.core.schema.SCIMAttributeSchema;
import org.wso2.charon3.core.schema.SCIMDefinitions;

public abstract class ExtensionBuilder {
    public abstract String getURI();

    protected String getSubAttributeURI(ExtensionAttributeSchemaConfig config, String subAttributeName) {
        if (this.isRootConfig(config)) {
            return config.getURI() + ":" + subAttributeName;
        }
        return config.getURI() + "." + subAttributeName;
    }

    protected boolean isRootConfig(ExtensionAttributeSchemaConfig config) {
        return this.getURI().equals(config.getURI());
    }

    protected void buildComplexAttributeSchema(ExtensionAttributeSchemaConfig config, Map<String, AttributeSchema> attributeSchemas, Map<String, ExtensionAttributeSchemaConfig> extensionConfig) throws InternalErrorException {
        if (!attributeSchemas.containsKey(config.getURI())) {
            String[] subAttributes;
            for (String subAttribute : subAttributes = config.getSubAttributes()) {
                ExtensionAttributeSchemaConfig subAttribConfig = extensionConfig.get(this.getSubAttributeURI(config, subAttribute));
                if (subAttribConfig == null) {
                    String error = String.format("Error adding subattribute %s to attribute %s. Error in SCIM2 extension schema config format.", subAttribute, config.getURI());
                    throw new InternalErrorException(error);
                }
                if (!subAttribConfig.getType().equals((Object)SCIMDefinitions.DataType.COMPLEX)) {
                    if (subAttribConfig.hasChildren()) {
                        String error = "A attribute of primitive type can not have sub attributes";
                        throw new InternalErrorException(error);
                    }
                    this.buildSimpleAttributeSchema(subAttribConfig, attributeSchemas);
                    continue;
                }
                if (!subAttribConfig.hasChildren()) {
                    String error = "A attribute of complex type should have sub attributes";
                    throw new InternalErrorException(error);
                }
                this.buildComplexAttributeSchema(subAttribConfig, attributeSchemas, extensionConfig);
            }
            this.buildComplexSchema(config, attributeSchemas);
        }
    }

    protected void buildComplexSchema(ExtensionAttributeSchemaConfig config, Map<String, AttributeSchema> attributeSchemas) {
        String[] subAttributeNames = config.getSubAttributes();
        ArrayList<AttributeSchema> subAttributes = new ArrayList<AttributeSchema>();
        for (String subAttributeName : subAttributeNames) {
            subAttributes.add(attributeSchemas.get(this.getSubAttributeURI(config, subAttributeName)));
        }
        SCIMAttributeSchema complexAttribute = this.createSCIMAttributeSchema(config, subAttributes);
        attributeSchemas.put(config.getURI(), complexAttribute);
    }

    protected void buildSimpleAttributeSchema(ExtensionAttributeSchemaConfig config, Map<String, AttributeSchema> attributeSchemas) {
        ArrayList<AttributeSchema> subAttributeList = new ArrayList<AttributeSchema>();
        if (!attributeSchemas.containsKey(config.getURI())) {
            SCIMAttributeSchema attributeSchema = this.createSCIMAttributeSchema(config, subAttributeList);
            attributeSchemas.put(config.getURI(), attributeSchema);
        }
    }

    public SCIMAttributeSchema createSCIMAttributeSchema(ExtensionAttributeSchemaConfig attribute, ArrayList<AttributeSchema> subAttributeList) {
        return SCIMAttributeSchema.createSCIMAttributeSchema(attribute.getURI(), attribute.getName(), attribute.getType(), attribute.getMultiValued(), attribute.getDescription(), attribute.getRequired(), attribute.getCaseExact(), attribute.getMutability(), attribute.getReturned(), attribute.getUniqueness(), attribute.canonicalValues, attribute.referenceTypes, subAttributeList);
    }

    protected static class ExtensionAttributeSchemaConfig {
        protected String uri;
        protected String name;
        protected SCIMDefinitions.DataType type;
        protected Boolean multiValued;
        protected String description;
        protected Boolean required;
        protected Boolean caseExact;
        protected SCIMDefinitions.Mutability mutability;
        protected SCIMDefinitions.Returned returned;
        protected SCIMDefinitions.Uniqueness uniqueness;
        protected String[] subAttributes;
        protected ArrayList<String> canonicalValues;
        protected ArrayList<SCIMDefinitions.ReferenceType> referenceTypes;

        public String[] getSubAttributes() {
            return (String[])this.subAttributes.clone();
        }

        public String getURI() {
            return this.uri;
        }

        public void setURI(String uri) {
            this.uri = uri;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public SCIMDefinitions.DataType getType() {
            return this.type;
        }

        public void setType(SCIMDefinitions.DataType type) {
            this.type = type;
        }

        public Boolean getMultiValued() {
            return this.multiValued;
        }

        public void setMultiValued(Boolean multiValued) {
            this.multiValued = multiValued;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public Boolean getRequired() {
            return this.required;
        }

        public void setRequired(Boolean required) {
            this.required = required;
        }

        public Boolean getCaseExact() {
            return this.caseExact;
        }

        public void setCaseExact(Boolean caseExact) {
            this.caseExact = caseExact;
        }

        public SCIMDefinitions.Mutability getMutability() {
            return this.mutability;
        }

        public void setMutability(SCIMDefinitions.Mutability mutability) {
            this.mutability = mutability;
        }

        public SCIMDefinitions.Returned getReturned() {
            return this.returned;
        }

        public void setReturned(SCIMDefinitions.Returned returned) {
            this.returned = returned;
        }

        public SCIMDefinitions.Uniqueness getUniqueness() {
            return this.uniqueness;
        }

        public void setUniqueness(SCIMDefinitions.Uniqueness uniqueness) {
            this.uniqueness = uniqueness;
        }

        public ArrayList<String> getCanonicalValues() {
            return this.canonicalValues;
        }

        public ArrayList<SCIMDefinitions.ReferenceType> getReferenceTypes() {
            return this.referenceTypes;
        }

        public boolean hasChildren() {
            return this.subAttributes != null;
        }

        public ExtensionAttributeSchemaConfig(Map<String, String> attributeConfig) {
            this.uri = attributeConfig.get("attributeURI");
            this.name = attributeConfig.get("attributeName");
            this.type = this.getDefinedDataType(attributeConfig.get("dataType"));
            this.multiValued = Boolean.valueOf(attributeConfig.get("multiValued"));
            this.description = attributeConfig.get("description");
            this.required = Boolean.parseBoolean(attributeConfig.get("required"));
            this.caseExact = Boolean.parseBoolean(attributeConfig.get("caseExact"));
            this.mutability = this.getDefinedMutability(attributeConfig.get("mutability"));
            this.returned = this.getDefinedReturned(attributeConfig.get("returned"));
            this.uniqueness = this.getDefinedUniqueness(attributeConfig.get("uniqueness"));
            String subAttributesString = attributeConfig.get("subAttributes");
            if (StringUtils.isNotBlank((String)subAttributesString) && !"null".equalsIgnoreCase(subAttributesString)) {
                this.subAttributes = subAttributesString.split(" ");
            }
        }

        public ExtensionAttributeSchemaConfig(JSONObject attributeConfigJSON) throws CharonException {
            try {
                this.uri = attributeConfigJSON.getString("attributeURI");
                this.name = attributeConfigJSON.getString("attributeName");
                this.type = this.getDefinedDataType(attributeConfigJSON.getString("dataType"));
                this.multiValued = attributeConfigJSON.getBoolean("multiValued");
                this.description = attributeConfigJSON.getString("description");
                this.required = Boolean.parseBoolean(attributeConfigJSON.getString("required"));
                this.caseExact = Boolean.parseBoolean(attributeConfigJSON.getString("caseExact"));
                this.mutability = this.getDefinedMutability(attributeConfigJSON.getString("mutability"));
                this.returned = this.getDefinedReturned(attributeConfigJSON.getString("returned"));
                this.uniqueness = this.getDefinedUniqueness(attributeConfigJSON.getString("uniqueness"));
                String subAttributesString = attributeConfigJSON.getString("subAttributes");
                if (!"null".equalsIgnoreCase(subAttributesString)) {
                    this.subAttributes = subAttributesString.split(" ");
                }
                this.canonicalValues = this.setCanonicalValues(attributeConfigJSON.getJSONArray("canonicalValues"));
                this.referenceTypes = this.setReferenceTypes(attributeConfigJSON.getJSONArray("referenceTypes"));
            }
            catch (JSONException e) {
                throw new CharonException("Error while parsing extension configuration", e);
            }
        }

        protected SCIMDefinitions.DataType getDefinedDataType(String input) {
            SCIMDefinitions.DataType type = null;
            type = "STRING".equalsIgnoreCase(input) ? SCIMDefinitions.DataType.STRING : ("INTEGER".equalsIgnoreCase(input) ? SCIMDefinitions.DataType.INTEGER : ("DECIMAL".equalsIgnoreCase(input) ? SCIMDefinitions.DataType.DECIMAL : ("BOOLEAN".equalsIgnoreCase(input) ? SCIMDefinitions.DataType.BOOLEAN : ("DATETIME".equalsIgnoreCase(input) ? SCIMDefinitions.DataType.DATE_TIME : ("BINARY".equalsIgnoreCase(input) ? SCIMDefinitions.DataType.BINARY : ("REFERENCE".equalsIgnoreCase(input) ? SCIMDefinitions.DataType.REFERENCE : ("COMPLEX".equalsIgnoreCase(input) ? SCIMDefinitions.DataType.COMPLEX : SCIMDefinitions.DataType.STRING)))))));
            return type;
        }

        protected SCIMDefinitions.Mutability getDefinedMutability(String input) {
            SCIMDefinitions.Mutability type = null;
            type = "readWrite".equalsIgnoreCase(input) ? SCIMDefinitions.Mutability.READ_WRITE : ("readOnly".equalsIgnoreCase(input) ? SCIMDefinitions.Mutability.READ_ONLY : ("immutable".equalsIgnoreCase(input) ? SCIMDefinitions.Mutability.IMMUTABLE : ("writeOnly".equalsIgnoreCase(input) ? SCIMDefinitions.Mutability.WRITE_ONLY : SCIMDefinitions.Mutability.READ_WRITE)));
            return type;
        }

        protected SCIMDefinitions.Returned getDefinedReturned(String input) {
            SCIMDefinitions.Returned type = null;
            type = "always".equalsIgnoreCase(input) ? SCIMDefinitions.Returned.ALWAYS : ("never".equalsIgnoreCase(input) ? SCIMDefinitions.Returned.NEVER : ("default".equalsIgnoreCase(input) ? SCIMDefinitions.Returned.DEFAULT : ("request".equalsIgnoreCase(input) ? SCIMDefinitions.Returned.REQUEST : SCIMDefinitions.Returned.DEFAULT)));
            return type;
        }

        protected SCIMDefinitions.Uniqueness getDefinedUniqueness(String input) {
            SCIMDefinitions.Uniqueness type = null;
            type = "none".equalsIgnoreCase(input) ? SCIMDefinitions.Uniqueness.NONE : ("server".equalsIgnoreCase(input) ? SCIMDefinitions.Uniqueness.SERVER : ("global".equalsIgnoreCase(input) ? SCIMDefinitions.Uniqueness.GLOBAL : SCIMDefinitions.Uniqueness.NONE));
            return type;
        }

        protected ArrayList<String> setCanonicalValues(JSONArray input) throws JSONException {
            ArrayList<String> canonicalValues = new ArrayList<String>();
            JSONArray canonicalValuesList = input;
            for (int index = 0; index < canonicalValuesList.length(); ++index) {
                canonicalValues.add((String)canonicalValuesList.get(index));
            }
            return canonicalValues;
        }

        protected ArrayList<SCIMDefinitions.ReferenceType> setReferenceTypes(JSONArray input) throws JSONException {
            ArrayList<SCIMDefinitions.ReferenceType> referenceTypes = new ArrayList<SCIMDefinitions.ReferenceType>();
            JSONArray referenceTypesList = input;
            for (int index = 0; index < referenceTypesList.length(); ++index) {
                String referenceValue = (String)referenceTypesList.get(index);
                if (referenceValue.equalsIgnoreCase("external")) {
                    referenceTypes.add(SCIMDefinitions.ReferenceType.EXTERNAL);
                    continue;
                }
                if (referenceValue.equalsIgnoreCase("user")) {
                    referenceTypes.add(SCIMDefinitions.ReferenceType.USER);
                    continue;
                }
                if (referenceValue.equalsIgnoreCase("group")) {
                    referenceTypes.add(SCIMDefinitions.ReferenceType.GROUP);
                    continue;
                }
                if (!referenceValue.equalsIgnoreCase("uri")) continue;
                referenceTypes.add(SCIMDefinitions.ReferenceType.URI);
            }
            return referenceTypes;
        }
    }
}

