/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.charon3.core.protocol.endpoints;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.charon3.core.encoder.JSONDecoder;
import org.wso2.charon3.core.encoder.JSONEncoder;
import org.wso2.charon3.core.exceptions.AbstractCharonException;
import org.wso2.charon3.core.exceptions.CharonException;
import org.wso2.charon3.core.exceptions.NotFoundException;
import org.wso2.charon3.core.protocol.SCIMResponse;
import org.wso2.charon3.core.protocol.endpoints.DefaultResourceURLBuilder;
import org.wso2.charon3.core.protocol.endpoints.ResourceManager;
import org.wso2.charon3.core.protocol.endpoints.ResourceURLBuilder;

public abstract class AbstractResourceManager
implements ResourceManager {
    private static final Logger logger = LoggerFactory.getLogger(AbstractResourceManager.class);
    private static JSONEncoder encoder = new JSONEncoder();
    private static JSONDecoder decoder = new JSONDecoder();
    private static ResourceURLBuilder resourceURLBuilder = new DefaultResourceURLBuilder();

    public static JSONEncoder getEncoder() throws CharonException {
        return encoder;
    }

    public static JSONDecoder getDecoder() throws CharonException {
        return decoder;
    }

    public static void setResourceURLBuilder(ResourceURLBuilder resourceURLBuilder) {
        AbstractResourceManager.resourceURLBuilder = resourceURLBuilder;
    }

    public static String getResourceEndpointURL(String resource) throws NotFoundException {
        return resourceURLBuilder.build(resource);
    }

    public static void setEndpointURLMap(Map<String, String> endpointURLMap) {
        if (resourceURLBuilder instanceof DefaultResourceURLBuilder) {
            ((DefaultResourceURLBuilder)resourceURLBuilder).setEndpointURIMap(endpointURLMap);
        }
    }

    public static SCIMResponse encodeSCIMException(AbstractCharonException exception) {
        if (exception.getStatus() == 500) {
            logger.error(exception.getDetail(), (Throwable)exception);
        } else {
            logger.debug(exception.getDetail(), (Throwable)exception);
        }
        HashMap<String, String> responseHeaders = new HashMap<String, String>();
        responseHeaders.put("Content-Type", "application/scim+json");
        return new SCIMResponse(exception.getStatus(), encoder.encodeSCIMException(exception), responseHeaders);
    }
}

