/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.charon3.core.protocol.endpoints;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.charon3.core.attributes.Attribute;
import org.wso2.charon3.core.encoder.JSONDecoder;
import org.wso2.charon3.core.encoder.JSONEncoder;
import org.wso2.charon3.core.exceptions.BadRequestException;
import org.wso2.charon3.core.exceptions.CharonException;
import org.wso2.charon3.core.exceptions.ConflictException;
import org.wso2.charon3.core.exceptions.InternalErrorException;
import org.wso2.charon3.core.exceptions.NotFoundException;
import org.wso2.charon3.core.exceptions.NotImplementedException;
import org.wso2.charon3.core.extensions.RoleManager;
import org.wso2.charon3.core.extensions.UserManager;
import org.wso2.charon3.core.objects.ListedResource;
import org.wso2.charon3.core.objects.Role;
import org.wso2.charon3.core.objects.plainobjects.RolesGetResponse;
import org.wso2.charon3.core.protocol.SCIMResponse;
import org.wso2.charon3.core.protocol.endpoints.AbstractResourceManager;
import org.wso2.charon3.core.schema.SCIMResourceSchemaManager;
import org.wso2.charon3.core.schema.SCIMResourceTypeSchema;
import org.wso2.charon3.core.schema.SCIMSchemaDefinitions;
import org.wso2.charon3.core.schema.ServerSideValidator;
import org.wso2.charon3.core.utils.CopyUtil;
import org.wso2.charon3.core.utils.PatchOperationUtil;
import org.wso2.charon3.core.utils.ResourceManagerUtil;
import org.wso2.charon3.core.utils.codeutils.FilterTreeManager;
import org.wso2.charon3.core.utils.codeutils.Node;
import org.wso2.charon3.core.utils.codeutils.PatchOperation;
import org.wso2.charon3.core.utils.codeutils.SearchRequest;

public class RoleResourceManager
extends AbstractResourceManager {
    private static final Logger logger = LoggerFactory.getLogger(RoleResourceManager.class);

    @Override
    public SCIMResponse getRole(String id, RoleManager roleManager, String attributes, String excludeAttributes) {
        try {
            if (roleManager == null) {
                String error = "Provided role manager is null.";
                throw new InternalErrorException(error);
            }
            JSONEncoder encoder = RoleResourceManager.getEncoder();
            SCIMResourceTypeSchema schema = SCIMResourceSchemaManager.getInstance().getRoleResourceSchema();
            Map<String, Boolean> requiredAttributes = ResourceManagerUtil.getOnlyRequiredAttributesURIs((SCIMResourceTypeSchema)CopyUtil.deepCopy(schema), attributes, excludeAttributes);
            Role role = roleManager.getRole(id, requiredAttributes);
            if (role == null) {
                String message = "Role id: " + id + " not found in the system.";
                throw new NotFoundException(message);
            }
            ServerSideValidator.validateRetrievedSCIMObject(role, schema, attributes, excludeAttributes);
            ServerSideValidator.validateRetrievedSCIMRoleObject(role, attributes, excludeAttributes);
            String encodedRole = encoder.encodeSCIMObject(role);
            HashMap<String, String> httpHeaders = new HashMap<String, String>();
            httpHeaders.put("Content-Type", "application/scim+json");
            return new SCIMResponse(200, encodedRole, httpHeaders);
        }
        catch (BadRequestException | CharonException | InternalErrorException | NotFoundException | NotImplementedException e) {
            return RoleResourceManager.encodeSCIMException(e);
        }
    }

    @Override
    public SCIMResponse createRole(String postRequest, RoleManager roleManager) {
        try {
            if (roleManager == null) {
                String error = "Provided role manager is null.";
                throw new InternalErrorException(error);
            }
            JSONEncoder encoder = RoleResourceManager.getEncoder();
            JSONDecoder decoder = RoleResourceManager.getDecoder();
            SCIMResourceTypeSchema schema = SCIMResourceSchemaManager.getInstance().getRoleResourceSchema();
            Role role = decoder.decodeResource(postRequest, schema, new Role());
            ServerSideValidator.validateCreatedSCIMObject(role, SCIMSchemaDefinitions.SCIM_ROLE_SCHEMA);
            Role createdRole = roleManager.createRole(role);
            HashMap<String, String> httpHeaders = new HashMap<String, String>();
            if (createdRole == null) {
                String message = "Newly created Role resource is null.";
                throw new InternalErrorException(message);
            }
            String encodedRole = encoder.encodeSCIMObject(createdRole);
            httpHeaders.put("Location", RoleResourceManager.getResourceEndpointURL("/Roles") + "/" + createdRole.getId());
            httpHeaders.put("Content-Type", "application/scim+json");
            return new SCIMResponse(201, encodedRole, httpHeaders);
        }
        catch (BadRequestException | CharonException | ConflictException | InternalErrorException | NotFoundException | NotImplementedException e) {
            return RoleResourceManager.encodeSCIMException(e);
        }
    }

    @Override
    public SCIMResponse deleteRole(String id, RoleManager roleManager) {
        try {
            if (roleManager == null) {
                String error = "Provided role manager is null.";
                throw new InternalErrorException(error);
            }
            roleManager.deleteRole(id);
            return new SCIMResponse(204, null, null);
        }
        catch (BadRequestException | CharonException | InternalErrorException | NotFoundException | NotImplementedException e) {
            return RoleResourceManager.encodeSCIMException(e);
        }
    }

    @Override
    public SCIMResponse listWithGETRole(RoleManager roleManager, String filter, Integer startIndexInt, Integer countInt, String sortBy, String sortOrder) {
        try {
            if (roleManager == null) {
                String error = "Provided role manager is null.";
                throw new InternalErrorException(error);
            }
            Integer count = ResourceManagerUtil.processCount(countInt);
            Integer startIndex = ResourceManagerUtil.processStartIndex(startIndexInt);
            sortOrder = this.resolveSortOrder(sortOrder, sortBy);
            SCIMResourceTypeSchema schema = SCIMResourceSchemaManager.getInstance().getRoleResourceSchema();
            Node rootNode = this.buildNode(filter, schema);
            JSONEncoder encoder = RoleResourceManager.getEncoder();
            RolesGetResponse rolesResponse = roleManager.listRolesWithGET(rootNode, startIndex, count, sortBy, sortOrder);
            return this.processRoleList(rolesResponse, encoder, startIndex);
        }
        catch (BadRequestException | CharonException | InternalErrorException | NotImplementedException e) {
            return RoleResourceManager.encodeSCIMException(e);
        }
        catch (IOException e) {
            String error = "Error in tokenization of the input filter.";
            CharonException charonException = new CharonException(error);
            return AbstractResourceManager.encodeSCIMException(charonException);
        }
    }

    private String resolveSortOrder(String sortOrder, String sortBy) throws BadRequestException {
        if (sortOrder != null) {
            if (!"ascending".equalsIgnoreCase(sortOrder) && !"descending".equalsIgnoreCase(sortOrder)) {
                String error = "Invalid sortOrder value is specified.";
                throw new BadRequestException(error, "invalidValue");
            }
        } else if (sortBy != null) {
            sortOrder = "ascending";
        }
        return sortOrder;
    }

    private Node buildNode(String filter, SCIMResourceTypeSchema schema) throws BadRequestException, IOException {
        if (filter != null) {
            FilterTreeManager filterTreeManager = new FilterTreeManager(filter, schema);
            return filterTreeManager.buildTree();
        }
        return null;
    }

    private SCIMResponse processRoleList(RolesGetResponse rolesResponse, JSONEncoder encoder, int startIndex) throws CharonException, BadRequestException {
        if (rolesResponse == null) {
            rolesResponse = new RolesGetResponse(0, Collections.emptyList());
        }
        if (rolesResponse.getRoles() == null) {
            rolesResponse.setRoles(Collections.emptyList());
        }
        for (Role role : rolesResponse.getRoles()) {
            ServerSideValidator.validateSCIMObjectForRequiredAttributes(role, SCIMSchemaDefinitions.SCIM_ROLE_SCHEMA);
        }
        ListedResource listedResource = this.createListedResource(rolesResponse, startIndex);
        String encodedListedResource = encoder.encodeSCIMObject(listedResource);
        HashMap<String, String> responseHeaders = new HashMap<String, String>();
        responseHeaders.put("Content-Type", "application/scim+json");
        return new SCIMResponse(200, encodedListedResource, responseHeaders);
    }

    protected ListedResource createListedResource(RolesGetResponse rolesResponse, int startIndex) {
        ListedResource listedResource = new ListedResource();
        listedResource.setSchema("urn:ietf:params:scim:api:messages:2.0:ListResponse");
        listedResource.setTotalResults(rolesResponse.getTotalRoles());
        listedResource.setStartIndex(startIndex);
        listedResource.setItemsPerPage(rolesResponse.getRoles().size());
        for (Role role : rolesResponse.getRoles()) {
            Map<String, Attribute> userAttributes = role.getAttributeList();
            listedResource.setResources(userAttributes);
        }
        return listedResource;
    }

    @Override
    public SCIMResponse listWithPOSTRole(String searchRequest, RoleManager roleManager) {
        try {
            if (roleManager == null) {
                String error = "Provided role manager is null.";
                throw new InternalErrorException(error);
            }
            JSONEncoder encoder = RoleResourceManager.getEncoder();
            JSONDecoder decoder = RoleResourceManager.getDecoder();
            SCIMResourceTypeSchema schema = SCIMResourceSchemaManager.getInstance().getRoleResourceSchema();
            SearchRequest searchRequestObject = decoder.decodeSearchRequestBody(searchRequest, schema);
            searchRequestObject.setCount(ResourceManagerUtil.processCount(searchRequestObject.getCountStr()));
            searchRequestObject.setStartIndex(ResourceManagerUtil.processStartIndex(searchRequestObject.getStartIndexStr()));
            if (searchRequestObject.getSchema() != null && !searchRequestObject.getSchema().equals("urn:ietf:params:scim:api:messages:2.0:SearchRequest")) {
                throw new BadRequestException("Provided schema is invalid.", "invalidValue");
            }
            if (searchRequestObject.getSortOder() != null && !searchRequestObject.getSortOder().equalsIgnoreCase("ascending") && !searchRequestObject.getSortOder().equalsIgnoreCase("descending")) {
                String error = " Invalid sortOrder value is specified";
                throw new BadRequestException(error, "invalidValue");
            }
            if (searchRequestObject.getSortOder() == null && searchRequestObject.getSortBy() != null) {
                searchRequestObject.setSortOder("ascending");
            }
            RolesGetResponse rolesResponse = roleManager.listRolesWithPost(searchRequestObject);
            for (Role role : rolesResponse.getRoles()) {
                ServerSideValidator.validateRetrievedSCIMObjectInList(role, schema, searchRequestObject.getAttributesAsString(), searchRequestObject.getExcludedAttributesAsString());
            }
            ListedResource listedResource = this.createListedResource(rolesResponse, searchRequestObject.getStartIndex());
            String encodedListedResource = encoder.encodeSCIMObject(listedResource);
            HashMap<String, String> responseHeaders = new HashMap<String, String>();
            responseHeaders.put("Content-Type", "application/scim+json");
            return new SCIMResponse(200, encodedListedResource, responseHeaders);
        }
        catch (BadRequestException | CharonException | InternalErrorException | NotImplementedException e) {
            return AbstractResourceManager.encodeSCIMException(e);
        }
    }

    @Override
    public SCIMResponse updateWithPUTRole(String id, String putRequest, RoleManager roleManager) {
        try {
            if (roleManager == null) {
                String error = "Provided role manager is null.";
                throw new InternalErrorException(error);
            }
            JSONEncoder encoder = RoleResourceManager.getEncoder();
            JSONDecoder decoder = RoleResourceManager.getDecoder();
            SCIMResourceTypeSchema schema = SCIMResourceSchemaManager.getInstance().getRoleResourceSchema();
            Map<String, Boolean> requestAttributes = ResourceManagerUtil.getAllAttributeURIs(schema);
            Role role = decoder.decodeResource(putRequest, schema, new Role());
            Role oldRole = roleManager.getRole(id, requestAttributes);
            if (oldRole == null) {
                String error = "No role exists with the given id: " + id;
                throw new NotFoundException(error);
            }
            Role newRole = (Role)ServerSideValidator.validateUpdatedSCIMObject(oldRole, role, schema);
            Role updatedRole = roleManager.updateRole(oldRole, newRole);
            return this.getScimResponse(encoder, updatedRole);
        }
        catch (BadRequestException | CharonException | ConflictException | InternalErrorException | NotFoundException | NotImplementedException e) {
            return RoleResourceManager.encodeSCIMException(e);
        }
    }

    @Override
    public SCIMResponse updateWithPATCHRole(String id, String patchRequest, RoleManager roleManager) {
        try {
            if (roleManager == null) {
                String error = "Provided role manager handler is null.";
                throw new InternalErrorException(error);
            }
            JSONEncoder encoder = RoleResourceManager.getEncoder();
            SCIMResourceTypeSchema schema = SCIMResourceSchemaManager.getInstance().getRoleResourceSchema();
            Map<String, Boolean> requestAttributes = ResourceManagerUtil.getAllAttributeURIs(schema);
            Role oldRole = roleManager.getRole(id, requestAttributes);
            if (oldRole == null) {
                throw new NotFoundException("No role with the id : " + id + " exists in the system.");
            }
            Role originalRole = (Role)CopyUtil.deepCopy(oldRole);
            Role patchedRole = this.doPatchRole(oldRole, schema, patchRequest);
            Role updatedRole = roleManager.updateRole(originalRole, patchedRole);
            return this.getScimResponse(encoder, updatedRole);
        }
        catch (BadRequestException | CharonException | ConflictException | InternalErrorException | NotFoundException | NotImplementedException e) {
            return AbstractResourceManager.encodeSCIMException(e);
        }
        catch (RuntimeException e) {
            CharonException ex = new CharonException("Error in performing the patch operation on role resource.", e);
            return AbstractResourceManager.encodeSCIMException(ex);
        }
    }

    private SCIMResponse getScimResponse(JSONEncoder encoder, Role updatedRole) throws CharonException, NotFoundException, InternalErrorException {
        HashMap<String, String> httpHeaders = new HashMap<String, String>();
        if (updatedRole == null) {
            String error = "Updated Role resource is null.";
            throw new InternalErrorException(error);
        }
        Role copiedRole = (Role)CopyUtil.deepCopy(updatedRole);
        String encodedRole = encoder.encodeSCIMObject(copiedRole);
        httpHeaders.put("Location", RoleResourceManager.getResourceEndpointURL("/Roles") + "/" + updatedRole.getId());
        httpHeaders.put("Content-Type", "application/scim+json");
        return new SCIMResponse(200, encodedRole, httpHeaders);
    }

    private Role doPatchRole(Role oldRole, SCIMResourceTypeSchema roleSchema, String patchRequest) throws CharonException, BadRequestException, NotImplementedException, InternalErrorException {
        Role originalRole = (Role)CopyUtil.deepCopy(oldRole);
        Role copyOfOldRole = (Role)CopyUtil.deepCopy(oldRole);
        Role patchedRole = null;
        ArrayList<PatchOperation> opList = RoleResourceManager.getDecoder().decodeRequest(patchRequest);
        block10: for (PatchOperation operation : opList) {
            switch (operation.getOperation()) {
                case "add": {
                    patchedRole = patchedRole == null ? (Role)PatchOperationUtil.doPatchAdd(operation, RoleResourceManager.getDecoder(), oldRole, copyOfOldRole, roleSchema) : (Role)PatchOperationUtil.doPatchAdd(operation, RoleResourceManager.getDecoder(), patchedRole, copyOfOldRole, roleSchema);
                    copyOfOldRole = (Role)CopyUtil.deepCopy(patchedRole);
                    continue block10;
                }
                case "remove": {
                    patchedRole = patchedRole == null ? (Role)PatchOperationUtil.doPatchRemove(operation, oldRole, copyOfOldRole, roleSchema) : (Role)PatchOperationUtil.doPatchRemove(operation, patchedRole, copyOfOldRole, roleSchema);
                    copyOfOldRole = (Role)CopyUtil.deepCopy(patchedRole);
                    continue block10;
                }
                case "replace": {
                    patchedRole = patchedRole == null ? (Role)PatchOperationUtil.doPatchReplace(operation, RoleResourceManager.getDecoder(), oldRole, copyOfOldRole, roleSchema) : (Role)PatchOperationUtil.doPatchReplace(operation, RoleResourceManager.getDecoder(), patchedRole, copyOfOldRole, roleSchema);
                    copyOfOldRole = (Role)CopyUtil.deepCopy(patchedRole);
                    continue block10;
                }
            }
            throw new BadRequestException("Unknown operation.", "invalidSyntax");
        }
        return (Role)ServerSideValidator.validateUpdatedSCIMObject(originalRole, patchedRole, roleSchema);
    }

    @Override
    public SCIMResponse get(String id, UserManager userManager, String attributes, String excludeAttributes) {
        return new SCIMResponse(501, "Service provider does not support the request operation.", Collections.emptyMap());
    }

    @Override
    public SCIMResponse create(String scimObjectString, UserManager userManager, String attributes, String excludeAttributes) {
        return new SCIMResponse(501, "Service provider does not support the request operation.", Collections.emptyMap());
    }

    @Override
    public SCIMResponse delete(String id, UserManager userManager) {
        return new SCIMResponse(501, "Service provider does not support the request operation.", Collections.emptyMap());
    }

    @Override
    public SCIMResponse listWithGET(UserManager userManager, String filter, int startIndex, int count, String sortBy, String sortOrder, String domainName, String attributes, String excludeAttributes) {
        return new SCIMResponse(501, "Service provider does not support the request operation.", Collections.emptyMap());
    }

    @Override
    public SCIMResponse listWithGET(UserManager userManager, String filter, Integer startIndexInt, Integer countInt, String sortBy, String sortOrder, String domainName, String attributes, String excludeAttributes) {
        return new SCIMResponse(501, "Service provider does not support the request operation.", Collections.emptyMap());
    }

    @Override
    public SCIMResponse listWithPOST(String resourceString, UserManager userManager) {
        return new SCIMResponse(501, "Service provider does not support the request operation.", Collections.emptyMap());
    }

    @Override
    public SCIMResponse updateWithPUT(String existingId, String scimObjectString, UserManager userManager, String attributes, String excludeAttributes) {
        return new SCIMResponse(501, "Service provider does not support the request operation.", Collections.emptyMap());
    }

    @Override
    public SCIMResponse updateWithPATCH(String existingId, String scimObjectString, UserManager userManager, String attributes, String excludeAttributes) {
        return new SCIMResponse(501, "Service provider does not support the request operation.", Collections.emptyMap());
    }

    @Override
    public SCIMResponse updateWithPATCH(String existingId, String patchRequest, UserManager userManager) {
        return new SCIMResponse(501, "Service provider does not support the request operation.", Collections.emptyMap());
    }
}

