/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.charon3.core.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.wso2.charon3.core.config.ExtensionBuilder;
import org.wso2.charon3.core.exceptions.CharonException;
import org.wso2.charon3.core.exceptions.InternalErrorException;
import org.wso2.charon3.core.schema.AttributeSchema;

public class SCIMUserSchemaExtensionBuilder
extends ExtensionBuilder {
    private static SCIMUserSchemaExtensionBuilder configReader = new SCIMUserSchemaExtensionBuilder();
    private static Map<String, ExtensionBuilder.ExtensionAttributeSchemaConfig> extensionConfig = new HashMap<String, ExtensionBuilder.ExtensionAttributeSchemaConfig>();
    String extensionRootAttributeName = null;
    String extensionRootAttributeURI = null;
    private static Map<String, AttributeSchema> attributeSchemas = new HashMap<String, AttributeSchema>();
    private AttributeSchema extensionSchema = null;

    public static SCIMUserSchemaExtensionBuilder getInstance() {
        return configReader;
    }

    public AttributeSchema getExtensionSchema() {
        return this.extensionSchema;
    }

    public void buildUserSchemaExtension(String configFilePath) throws CharonException, InternalErrorException {
        File provisioningConfig = new File(configFilePath);
        try (FileInputStream configFilePathInputStream = new FileInputStream(provisioningConfig);){
            this.buildUserSchemaExtension(configFilePathInputStream);
        }
        catch (FileNotFoundException e) {
            throw new CharonException("scim2-schema-extension.config file not found!", e);
        }
        catch (JSONException e) {
            throw new CharonException("Error while parsing scim2-schema-extension.config file!", e);
        }
        catch (IOException e) {
            throw new CharonException("Error while closing scim2-schema-extension.config file!", e);
        }
    }

    public void buildUserSchemaExtension(InputStream inputStream) throws CharonException, InternalErrorException {
        this.readConfiguration(inputStream);
        for (Map.Entry<String, ExtensionBuilder.ExtensionAttributeSchemaConfig> attributeSchemaConfig : extensionConfig.entrySet()) {
            if (!attributeSchemaConfig.getValue().hasChildren()) {
                this.buildSimpleAttributeSchema(attributeSchemaConfig.getValue(), attributeSchemas);
                continue;
            }
            this.buildComplexAttributeSchema(attributeSchemaConfig.getValue(), attributeSchemas, extensionConfig);
        }
        this.extensionSchema = attributeSchemas.get(this.extensionRootAttributeURI);
    }

    public void readConfiguration(InputStream inputStream) throws CharonException {
        Scanner scanner = new Scanner(inputStream, "utf-8").useDelimiter("\\A");
        String jsonString = scanner.hasNext() ? scanner.next() : "";
        JSONArray attributeConfigArray = new JSONArray(jsonString);
        for (int index = 0; index < attributeConfigArray.length(); ++index) {
            JSONObject rawAttributeConfig = attributeConfigArray.getJSONObject(index);
            ExtensionBuilder.ExtensionAttributeSchemaConfig schemaAttributeConfig = new ExtensionBuilder.ExtensionAttributeSchemaConfig(rawAttributeConfig);
            extensionConfig.put(schemaAttributeConfig.getURI(), schemaAttributeConfig);
            if (index != attributeConfigArray.length() - 1) continue;
            this.extensionRootAttributeURI = schemaAttributeConfig.getURI();
            this.extensionRootAttributeName = schemaAttributeConfig.getName();
        }
    }

    @Override
    public String getURI() {
        return this.extensionRootAttributeURI;
    }

    @Override
    protected boolean isRootConfig(ExtensionBuilder.ExtensionAttributeSchemaConfig config) {
        return StringUtils.isNotBlank((String)this.extensionRootAttributeName) && this.extensionRootAttributeName.equals(config.getName());
    }
}

