/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.charon3.core.encoder;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.charon3.core.attributes.Attribute;
import org.wso2.charon3.core.attributes.ComplexAttribute;
import org.wso2.charon3.core.attributes.MultiValuedAttribute;
import org.wso2.charon3.core.attributes.SimpleAttribute;
import org.wso2.charon3.core.exceptions.AbstractCharonException;
import org.wso2.charon3.core.exceptions.CharonException;
import org.wso2.charon3.core.exceptions.InternalErrorException;
import org.wso2.charon3.core.objects.Role;
import org.wso2.charon3.core.objects.SCIMObject;
import org.wso2.charon3.core.objects.bulk.BulkResponseContent;
import org.wso2.charon3.core.objects.bulk.BulkResponseData;
import org.wso2.charon3.core.schema.SCIMDefinitions;
import org.wso2.charon3.core.schema.SCIMResourceSchemaManager;
import org.wso2.charon3.core.utils.AttributeUtil;

public class JSONEncoder {
    private String format = "json";
    private static final Logger logger = LoggerFactory.getLogger(JSONEncoder.class);

    public String getFormat() {
        return this.format;
    }

    public String encodeSCIMObject(SCIMObject scimObject) throws CharonException {
        JSONObject rootObject = this.getSCIMObjectAsJSONObject(scimObject);
        return rootObject.toString();
    }

    public String encodeSCIMException(AbstractCharonException exception) {
        JSONObject rootErrorObject = new JSONObject();
        JSONObject errorObject = new JSONObject();
        try {
            JSONArray arrSchemas = new JSONArray(Collections.singletonList(exception.getSchemas()));
            errorObject.put("schemas", (Object)arrSchemas);
            if (exception.getScimType() != null) {
                errorObject.put("scimType", (Object)String.valueOf(exception.getScimType()));
            }
            errorObject.put("detail", (Object)String.valueOf(exception.getDetail()));
            errorObject.put("status", (Object)String.valueOf(exception.getStatus()));
            rootErrorObject = errorObject;
        }
        catch (JSONException e) {
            logger.error("SCIMException encoding error");
        }
        return rootErrorObject.toString();
    }

    public JSONObject getSCIMObjectAsJSONObject(SCIMObject scimObject) throws CharonException {
        JSONObject rootObject = new JSONObject();
        try {
            this.encodeArrayOfValues("schemas", scimObject.getSchemaList().toArray(), rootObject);
            Map<String, Attribute> attributes = scimObject.getAttributeList();
            if (attributes != null && !attributes.isEmpty()) {
                for (Attribute attribute : attributes.values()) {
                    if (attribute instanceof SimpleAttribute) {
                        this.encodeSimpleAttribute((SimpleAttribute)attribute, rootObject);
                        continue;
                    }
                    if (attribute instanceof ComplexAttribute) {
                        this.encodeComplexAttribute((ComplexAttribute)attribute, rootObject);
                        continue;
                    }
                    if (!(attribute instanceof MultiValuedAttribute)) continue;
                    this.encodeMultiValuedAttribute((MultiValuedAttribute)attribute, rootObject);
                }
            }
            if (scimObject instanceof Role && !((Role)scimObject).getPermissions().isEmpty()) {
                this.encodeArrayOfValues("permissions", ((Role)scimObject).getPermissions().toArray(), rootObject);
            }
        }
        catch (JSONException e) {
            String errorMessage = "Error in encoding resource..";
            throw new CharonException(errorMessage);
        }
        return rootObject;
    }

    public void encodeArrayOfValues(String arrayName, Object[] arrayValues, JSONObject rootObject) throws JSONException {
        JSONArray jsonArray = new JSONArray();
        for (Object arrayValue : arrayValues) {
            jsonArray.put(arrayValue);
        }
        rootObject.put(arrayName, (Object)jsonArray);
    }

    public void encodeSimpleAttribute(SimpleAttribute attribute, JSONObject rootObject) throws JSONException {
        if (attribute.getValue() != null) {
            if (attribute.getType() != null && attribute.getType() == SCIMDefinitions.DataType.DATE_TIME) {
                rootObject.put(attribute.getName(), (Object)AttributeUtil.formatDateTime((Instant)attribute.getValue()));
                return;
            }
            rootObject.put(attribute.getName(), attribute.getValue());
        }
    }

    public JSONObject encodeSimpleAttributeSchema(SimpleAttribute simpleAttribute) throws JSONException {
        return this.encodeBasicAttributeSchema(simpleAttribute);
    }

    public JSONObject encodeBasicAttributeSchema(Attribute attribute) throws JSONException {
        JSONObject attributeSchema = new JSONObject();
        attributeSchema.put("name", (Object)attribute.getName());
        attributeSchema.put("type", (Object)attribute.getType());
        attributeSchema.put("multiValued", (Object)attribute.getMultiValued());
        attributeSchema.put("description", (Object)attribute.getDescription());
        attributeSchema.put("required", (Object)attribute.getRequired());
        attributeSchema.put("caseExact", (Object)attribute.getCaseExact());
        attributeSchema.put("mutability", (Object)attribute.getMutability());
        attributeSchema.put("returned", (Object)attribute.getReturned());
        attributeSchema.put("uniqueness", (Object)attribute.getUniqueness());
        Map<String, String> customAttributes = attribute.getAttributeProperties();
        for (Map.Entry<String, String> entry : customAttributes.entrySet()) {
            attributeSchema.put(entry.getKey(), (Object)entry.getValue());
        }
        Map<String, JSONObject> customJSONProperties = attribute.getAttributeJSONProperties();
        for (Map.Entry<String, JSONObject> entry : customJSONProperties.entrySet()) {
            attributeSchema.put(entry.getKey(), (Object)entry.getValue());
        }
        return attributeSchema;
    }

    public void encodeComplexAttribute(ComplexAttribute complexAttribute, JSONObject rootObject) throws JSONException {
        JSONObject subObject = new JSONObject();
        Map<String, Attribute> attributes = complexAttribute.getSubAttributesList();
        for (Attribute attributeValue : attributes.values()) {
            if (attributeValue instanceof SimpleAttribute) {
                this.encodeSimpleAttribute((SimpleAttribute)attributeValue, subObject);
            } else if (attributeValue instanceof MultiValuedAttribute) {
                this.encodeMultiValuedAttribute((MultiValuedAttribute)attributeValue, subObject);
            } else if (attributeValue instanceof ComplexAttribute) {
                this.encodeComplexAttribute((ComplexAttribute)attributeValue, subObject);
            }
            rootObject.put(complexAttribute.getName(), (Object)subObject);
        }
    }

    public JSONObject encodeComplexAttributeSchema(ComplexAttribute complexAttribute) throws JSONException {
        JSONObject complexAttributeSchema = this.encodeBasicAttributeSchema(complexAttribute);
        Map<String, Attribute> subAttributesMap = complexAttribute.getSubAttributesList();
        if (subAttributesMap != null) {
            JSONArray subAttributesSchemaArray = new JSONArray();
            for (Map.Entry<String, Attribute> subAttribute : subAttributesMap.entrySet()) {
                JSONObject subAttributesSchema = this.encodeBasicAttributeSchema(subAttribute.getValue());
                subAttributesSchemaArray.put((Object)subAttributesSchema);
            }
            complexAttributeSchema.put("subAttributes", (Object)subAttributesSchemaArray);
        }
        return complexAttributeSchema;
    }

    protected void encodeSimpleAttributeValue(SimpleAttribute attributeValue, JSONArray jsonArray) throws JSONException {
        if (attributeValue.getValue() != null) {
            JSONObject attributeValueObject = new JSONObject();
            if (attributeValue.getType() != null && attributeValue.getType() == SCIMDefinitions.DataType.DATE_TIME) {
                attributeValueObject.put(attributeValue.getName(), (Object)AttributeUtil.formatDateTime((Instant)attributeValue.getValue()));
                return;
            }
            attributeValueObject.put(attributeValue.getName(), attributeValue.getValue());
            jsonArray.put((Object)attributeValueObject);
        }
    }

    public void encodeMultiValuedAttribute(MultiValuedAttribute multiValuedAttribute, JSONObject jsonObject) throws JSONException {
        JSONArray jsonArray = new JSONArray();
        List<Object> stringAttributeValues = multiValuedAttribute.getAttributePrimitiveValues();
        List<Attribute> attributeValues = multiValuedAttribute.getAttributeValues();
        if (attributeValues != null && !attributeValues.isEmpty()) {
            for (Attribute attributeValue : attributeValues) {
                if (attributeValue instanceof SimpleAttribute) {
                    this.encodeSimpleAttributeValue((SimpleAttribute)attributeValue, jsonArray);
                    continue;
                }
                if (!(attributeValue instanceof ComplexAttribute)) continue;
                this.encodeComplexAttributeValue((ComplexAttribute)attributeValue, jsonArray);
            }
        }
        if (stringAttributeValues != null && !stringAttributeValues.isEmpty()) {
            for (Object arrayValue : stringAttributeValues) {
                if (arrayValue instanceof SCIMObject) {
                    try {
                        jsonArray.put((Object)this.getSCIMObjectAsJSONObject((SCIMObject)arrayValue));
                        continue;
                    }
                    catch (CharonException e) {
                        throw new JSONException((Throwable)e);
                    }
                }
                jsonArray.put(arrayValue);
            }
        }
        jsonObject.put(multiValuedAttribute.getName(), (Object)jsonArray);
    }

    protected void encodeComplexAttributeValue(ComplexAttribute attributeValue, JSONArray jsonArray) throws JSONException {
        JSONObject subObject = new JSONObject();
        Map<String, Attribute> subAttributes = attributeValue.getSubAttributesList();
        for (Attribute value : subAttributes.values()) {
            if (value instanceof SimpleAttribute) {
                this.encodeSimpleAttribute((SimpleAttribute)value, subObject);
                continue;
            }
            if (value instanceof ComplexAttribute) {
                this.encodeComplexAttribute((ComplexAttribute)value, subObject);
                continue;
            }
            if (!(value instanceof MultiValuedAttribute)) continue;
            this.encodeMultiValuedAttribute((MultiValuedAttribute)value, subObject);
        }
        jsonArray.put((Object)subObject);
    }

    public String buildServiceProviderConfigJsonBody(HashMap<String, Object> config) throws JSONException {
        JSONObject rootObject = new JSONObject();
        JSONObject bulkObject = new JSONObject();
        bulkObject.put("supported", config.get("bulk"));
        bulkObject.put("maxOperations", config.get("maxOperations"));
        bulkObject.put("maxPayloadSize", config.get("maxPayLaodSize"));
        JSONObject filterObject = new JSONObject();
        filterObject.put("supported", config.get("filter"));
        filterObject.put("maxResults", config.get("maxResults"));
        JSONObject patchObject = new JSONObject();
        patchObject.put("supported", config.get("patch"));
        JSONObject sortObject = new JSONObject();
        sortObject.put("supported", config.get("sort"));
        JSONObject etagObject = new JSONObject();
        etagObject.put("supported", config.get("etag"));
        JSONObject changePasswordObject = new JSONObject();
        changePasswordObject.put("supported", config.get("changePassword"));
        JSONArray authenticationSchemesArray = new JSONArray();
        ArrayList values = (ArrayList)config.get("authenticationSchemes");
        for (int i = 0; i < values.size(); ++i) {
            JSONObject authenticationSchemeObject = new JSONObject();
            Object[] value = (Object[])values.get(i);
            authenticationSchemeObject.put("name", value[0]);
            authenticationSchemeObject.put("description", value[1]);
            authenticationSchemeObject.put("specUri", value[2]);
            authenticationSchemeObject.put("documentationUri", value[3]);
            authenticationSchemeObject.put("type", value[4]);
            authenticationSchemeObject.put("primary", value[5]);
            authenticationSchemesArray.put((Object)authenticationSchemeObject);
        }
        rootObject.put("schemas", (Object)new JSONArray().put((Object)"urn:ietf:params:scim:schemas:core:2.0:ServiceProviderConfig"));
        rootObject.put("documentationUri", config.get("documentationURL"));
        rootObject.put("bulk", (Object)bulkObject);
        rootObject.put("filter", (Object)filterObject);
        rootObject.put("patch", (Object)patchObject);
        rootObject.put("changePassword", (Object)changePasswordObject);
        rootObject.put("sort", (Object)sortObject);
        rootObject.put("etag", (Object)etagObject);
        rootObject.put("authenticationSchemes", (Object)authenticationSchemesArray);
        return rootObject.toString();
    }

    public String buildUserResourceTypeJsonBody() throws JSONException {
        JSONObject userResourceTypeObject = new JSONObject();
        userResourceTypeObject.put("schemas", (Object)"urn:ietf:params:scim:schemas:core:2.0:ResourceType");
        userResourceTypeObject.put("id", (Object)"User");
        userResourceTypeObject.put("name", (Object)"User");
        userResourceTypeObject.put("endpoint", (Object)"/Users");
        userResourceTypeObject.put("description", (Object)"User Account");
        userResourceTypeObject.put("schema", (Object)"urn:ietf:params:scim:schemas:core:2.0:User");
        if (SCIMResourceSchemaManager.getInstance().isExtensionSet().booleanValue()) {
            JSONArray schemaExtensions = new JSONArray();
            JSONObject extensionSchemaObject = new JSONObject();
            extensionSchemaObject.put("schema", (Object)SCIMResourceSchemaManager.getInstance().getExtensionURI());
            extensionSchemaObject.put("required", SCIMResourceSchemaManager.getInstance().getExtensionRequired());
            schemaExtensions.put((Object)extensionSchemaObject);
            if (StringUtils.isNotBlank((String)SCIMResourceSchemaManager.getInstance().getCustomSchemaExtensionURI())) {
                JSONObject customSchemaObject = new JSONObject();
                customSchemaObject.put("schema", (Object)SCIMResourceSchemaManager.getInstance().getCustomSchemaExtensionURI());
                customSchemaObject.put("required", false);
                schemaExtensions.put((Object)customSchemaObject);
            }
            userResourceTypeObject.put("schemaExtensions", (Object)schemaExtensions);
        }
        return userResourceTypeObject.toString();
    }

    public String buildGroupResourceTypeJsonBody() throws JSONException {
        JSONObject groupResourceTypeObject = new JSONObject();
        groupResourceTypeObject.put("schemas", (Object)"urn:ietf:params:scim:schemas:core:2.0:ResourceType");
        groupResourceTypeObject.put("id", (Object)"Group");
        groupResourceTypeObject.put("name", (Object)"Group");
        groupResourceTypeObject.put("endpoint", (Object)"/Groups");
        groupResourceTypeObject.put("description", (Object)"Group");
        groupResourceTypeObject.put("schema", (Object)"urn:ietf:params:scim:schemas:core:2.0:Group");
        return groupResourceTypeObject.toString();
    }

    public String encodeBulkResponseData(BulkResponseData bulkResponseData) throws InternalErrorException {
        String encodedString;
        List<BulkResponseContent> userResponseDataList = bulkResponseData.getUserOperationResponse();
        List<BulkResponseContent> groupResponseDataList = bulkResponseData.getGroupOperationResponse();
        List<BulkResponseContent> roleResponseDataList = bulkResponseData.getRoleOperationResponse();
        JSONObject rootObject = new JSONObject();
        try {
            this.encodeArrayOfValues("schemas", bulkResponseData.getSchemas().toArray(), rootObject);
            ArrayList<JSONObject> operationResponseList = new ArrayList<JSONObject>();
            for (BulkResponseContent userOperationResponse : userResponseDataList) {
                this.encodeResponseContent(userOperationResponse, operationResponseList);
            }
            for (BulkResponseContent groupOperationResponse : groupResponseDataList) {
                this.encodeResponseContent(groupOperationResponse, operationResponseList);
            }
            for (BulkResponseContent roleOperationResponse : roleResponseDataList) {
                this.encodeResponseContent(roleOperationResponse, operationResponseList);
            }
            this.encodeArrayOfValues("Operations", operationResponseList.toArray(), rootObject);
            encodedString = rootObject.toString();
        }
        catch (JSONException e) {
            throw new InternalErrorException("Error in encoding the response");
        }
        return encodedString;
    }

    private void encodeResponseContent(BulkResponseContent responseContent, ArrayList<JSONObject> operationResponseList) throws JSONException {
        int statusCode = responseContent.getScimResponse().getResponseStatus();
        JSONObject status = new JSONObject();
        status.put("code", statusCode);
        JSONObject operationObject = new JSONObject();
        operationObject.put("location", (Object)responseContent.getLocation());
        operationObject.put("method", (Object)responseContent.getMethod());
        operationObject.put("bulkId", (Object)responseContent.getBulkID());
        operationObject.put("status", (Object)status);
        if (statusCode != 200 && statusCode != 201 && statusCode != 204 || responseContent.getScimResponse() != null) {
            operationObject.put("response", (Object)responseContent.getScimResponse().getResponseMessage());
        }
        operationResponseList.add(operationObject);
    }
}

