/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.charon3.core.objects;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.wso2.charon3.core.attributes.Attribute;
import org.wso2.charon3.core.attributes.ComplexAttribute;
import org.wso2.charon3.core.attributes.DefaultAttributeFactory;
import org.wso2.charon3.core.attributes.MultiValuedAttribute;
import org.wso2.charon3.core.attributes.SimpleAttribute;
import org.wso2.charon3.core.exceptions.BadRequestException;
import org.wso2.charon3.core.exceptions.CharonException;
import org.wso2.charon3.core.objects.AbstractSCIMObject;
import org.wso2.charon3.core.objects.Group;
import org.wso2.charon3.core.objects.User;
import org.wso2.charon3.core.objects.plainobjects.MultiValuedComplexType;
import org.wso2.charon3.core.schema.SCIMAttributeSchema;
import org.wso2.charon3.core.schema.SCIMResourceSchemaManager;
import org.wso2.charon3.core.schema.SCIMResourceTypeSchema;
import org.wso2.charon3.core.schema.SCIMSchemaDefinitions;
import org.wso2.charon3.core.utils.LambdaExceptionUtils;

public class RoleV2
extends AbstractSCIMObject {
    private static final long serialVersionUID = 6106269076155338045L;

    public String getDisplayName() {
        if (this.isAttributeExist("displayName")) {
            return LambdaExceptionUtils.rethrowSupplier(() -> ((SimpleAttribute)this.attributeList.get("displayName")).getStringValue()).get();
        }
        return null;
    }

    public void setDisplayName(String displayName) throws CharonException, BadRequestException {
        if (this.isAttributeExist("displayName")) {
            ((SimpleAttribute)this.attributeList.get("displayName")).updateValue(displayName);
        } else {
            SimpleAttribute displayAttribute = new SimpleAttribute("displayName", displayName);
            displayAttribute = (SimpleAttribute)DefaultAttributeFactory.createAttribute(SCIMSchemaDefinitions.SCIMGroupSchemaDefinition.DISPLAY_NAME, displayAttribute);
            this.attributeList.put("displayName", displayAttribute);
        }
    }

    public void replaceDisplayName(String displayName) {
        this.replaceSimpleAttribute(SCIMSchemaDefinitions.SCIMRoleSchemaDefinition.DISPLAY_NAME, displayName);
    }

    public List<String> getUsers() {
        return this.getSubAttributeValuesListInMultiValuedComplexAttribute("users", "value");
    }

    public List<String> getUsersWithDisplayName() {
        return this.getSubAttributeValuesListInMultiValuedComplexAttribute("users", "display");
    }

    public void setUser(User user) throws BadRequestException, CharonException {
        if (this.isAttributeExist("users")) {
            MultiValuedAttribute users = (MultiValuedAttribute)this.attributeList.get("users");
            ComplexAttribute complexAttribute = this.processUser(user);
            users.setAttributeValue(complexAttribute);
        } else {
            MultiValuedAttribute users = new MultiValuedAttribute("users");
            DefaultAttributeFactory.createAttribute(SCIMSchemaDefinitions.SCIMRoleSchemaDefinition.USERS, users);
            ComplexAttribute complexAttribute = this.processUser(user);
            users.setAttributeValue(complexAttribute);
            this.setAttribute(users);
        }
    }

    private ComplexAttribute processUser(User user) throws BadRequestException, CharonException {
        String userId = user.getId();
        String userName = user.getUserName();
        String reference = user.getLocation();
        ComplexAttribute complexAttribute = new ComplexAttribute();
        complexAttribute.setName("users_" + userId + "default");
        if (userId != null) {
            SimpleAttribute valueSimpleAttribute = new SimpleAttribute("value", userId);
            DefaultAttributeFactory.createAttribute(SCIMSchemaDefinitions.SCIMRoleSchemaDefinition.USERS_VALUE, valueSimpleAttribute);
            complexAttribute.setSubAttribute(valueSimpleAttribute);
        }
        if (userName != null) {
            SimpleAttribute displaySimpleAttribute = new SimpleAttribute("display", userName);
            DefaultAttributeFactory.createAttribute(SCIMSchemaDefinitions.SCIMRoleSchemaDefinition.USERS_DISPLAY, displaySimpleAttribute);
            complexAttribute.setSubAttribute(displaySimpleAttribute);
        }
        if (reference != null) {
            SimpleAttribute referenceSimpleAttribute = new SimpleAttribute("$ref", reference);
            DefaultAttributeFactory.createAttribute(SCIMSchemaDefinitions.SCIMRoleSchemaDefinition.USERS_REF, referenceSimpleAttribute);
            complexAttribute.setSubAttribute(referenceSimpleAttribute);
        }
        DefaultAttributeFactory.createAttribute(SCIMSchemaDefinitions.SCIMRoleSchemaDefinition.USERS, complexAttribute);
        return complexAttribute;
    }

    public List<String> getGroups() {
        return this.getSubAttributeValuesListInMultiValuedComplexAttribute("groups", "value");
    }

    public List<String> getGroupsWithDisplayName() {
        return this.getSubAttributeValuesListInMultiValuedComplexAttribute("groups", "display");
    }

    public void setGroup(Group group) throws BadRequestException, CharonException {
        if (this.isAttributeExist("groups")) {
            MultiValuedAttribute groups = (MultiValuedAttribute)this.attributeList.get("groups");
            ComplexAttribute complexAttribute = this.processGroup(group);
            groups.setAttributeValue(complexAttribute);
        } else {
            MultiValuedAttribute groups = new MultiValuedAttribute("groups");
            DefaultAttributeFactory.createAttribute(SCIMSchemaDefinitions.SCIMRoleSchemaDefinition.GROUPS, groups);
            ComplexAttribute complexAttribute = this.processGroup(group);
            groups.setAttributeValue(complexAttribute);
            this.setAttribute(groups);
        }
    }

    private ComplexAttribute processGroup(Group group) throws BadRequestException, CharonException {
        String groupID = group.getId();
        String groupName = group.getDisplayName();
        String reference = group.getLocation();
        ComplexAttribute complexAttribute = new ComplexAttribute();
        complexAttribute.setName("groups_" + groupID + "default");
        if (groupID != null) {
            SimpleAttribute valueSimpleAttribute = new SimpleAttribute("value", groupID);
            DefaultAttributeFactory.createAttribute(SCIMSchemaDefinitions.SCIMRoleSchemaDefinition.GROUPS_VALUE, valueSimpleAttribute);
            complexAttribute.setSubAttribute(valueSimpleAttribute);
        }
        if (groupName != null) {
            SimpleAttribute displaySimpleAttribute = new SimpleAttribute("display", groupName);
            DefaultAttributeFactory.createAttribute(SCIMSchemaDefinitions.SCIMRoleSchemaDefinition.GROUPS_DISPLAY, displaySimpleAttribute);
            complexAttribute.setSubAttribute(displaySimpleAttribute);
        }
        if (reference != null) {
            SimpleAttribute referenceSimpleAttribute = new SimpleAttribute("$ref", reference);
            DefaultAttributeFactory.createAttribute(SCIMSchemaDefinitions.SCIMRoleSchemaDefinition.GROUPS_REF, referenceSimpleAttribute);
            complexAttribute.setSubAttribute(referenceSimpleAttribute);
        }
        DefaultAttributeFactory.createAttribute(SCIMSchemaDefinitions.SCIMRoleSchemaDefinition.GROUPS, complexAttribute);
        return complexAttribute;
    }

    public void setSchemas() {
        SCIMResourceTypeSchema schema = SCIMResourceSchemaManager.getInstance().getRoleResourceSchema();
        List<String> schemasList = schema.getSchemasList();
        for (String scheme : schemasList) {
            this.setSchema(scheme);
        }
    }

    public List<String> getPermissionValues() {
        return this.getSubAttributeValuesListInMultiValuedComplexAttribute("permissions", "value");
    }

    public List<String> getPermissionDisplayNames() {
        return this.getSubAttributeValuesListInMultiValuedComplexAttribute("permissions", "display");
    }

    public List<MultiValuedComplexType> getPermissions() {
        SCIMAttributeSchema complexDefinition = SCIMSchemaDefinitions.SCIMRoleSchemaDefinition.ROLE_V2_PERMISSIONS;
        SCIMAttributeSchema valueDefinition = SCIMSchemaDefinitions.SCIMRoleSchemaDefinition.PERMISSIONS_VALUE;
        SCIMAttributeSchema displayDefinition = SCIMSchemaDefinitions.SCIMRoleSchemaDefinition.PERMISSIONS_DISPLAY;
        SCIMAttributeSchema refDefinition = SCIMSchemaDefinitions.SCIMRoleSchemaDefinition.PERMISSIONS_REF;
        return this.getMultivaluedComplexType(complexDefinition, valueDefinition, displayDefinition, null, null, refDefinition).orElse(Collections.emptyList());
    }

    public void setPermissions(List<MultiValuedComplexType> permissionsList) {
        SCIMAttributeSchema complexDefinition = SCIMSchemaDefinitions.SCIMRoleSchemaDefinition.ROLE_V2_PERMISSIONS;
        SCIMAttributeSchema valueDefinition = SCIMSchemaDefinitions.SCIMRoleSchemaDefinition.PERMISSIONS_VALUE;
        SCIMAttributeSchema displayDefinition = SCIMSchemaDefinitions.SCIMRoleSchemaDefinition.PERMISSIONS_DISPLAY;
        SCIMAttributeSchema refDefinition = SCIMSchemaDefinitions.SCIMRoleSchemaDefinition.PERMISSIONS_REF;
        this.addMultivaluedComplexAtribute(permissionsList, complexDefinition, valueDefinition, displayDefinition, null, null, refDefinition);
    }

    public List<String> getAssociatedApplicationValues() {
        return this.getSubAttributeValuesListInMultiValuedComplexAttribute("associatedApplications", "value");
    }

    public List<String> getAssociatedApplicationDisplayNames() {
        return this.getSubAttributeValuesListInMultiValuedComplexAttribute("associatedApplications", "display");
    }

    public List<MultiValuedComplexType> getAssociatedApplications() {
        SCIMAttributeSchema complexDefinition = SCIMSchemaDefinitions.SCIMRoleSchemaDefinition.ASSOCIATED_APPLICATIONS;
        SCIMAttributeSchema valueDefinition = SCIMSchemaDefinitions.SCIMRoleSchemaDefinition.ASC_APPLICATIONS_VALUE;
        SCIMAttributeSchema displayDefinition = SCIMSchemaDefinitions.SCIMRoleSchemaDefinition.ASC_APPLICATIONS_DISPLAY;
        SCIMAttributeSchema refDefinition = SCIMSchemaDefinitions.SCIMRoleSchemaDefinition.ASC_APPLICATIONS_REF;
        return this.getMultivaluedComplexType(complexDefinition, valueDefinition, displayDefinition, null, null, refDefinition).orElse(Collections.emptyList());
    }

    public void setAssociatedApplications(List<MultiValuedComplexType> associatedApplicationsList) {
        SCIMAttributeSchema complexDefinition = SCIMSchemaDefinitions.SCIMRoleSchemaDefinition.ASSOCIATED_APPLICATIONS;
        SCIMAttributeSchema valueDefinition = SCIMSchemaDefinitions.SCIMRoleSchemaDefinition.ASC_APPLICATIONS_VALUE;
        SCIMAttributeSchema displayDefinition = SCIMSchemaDefinitions.SCIMRoleSchemaDefinition.ASC_APPLICATIONS_DISPLAY;
        SCIMAttributeSchema refDefinition = SCIMSchemaDefinitions.SCIMRoleSchemaDefinition.ASC_APPLICATIONS_REF;
        this.addMultivaluedComplexAtribute(associatedApplicationsList, complexDefinition, valueDefinition, displayDefinition, null, null, refDefinition);
    }

    public void setRoleProperties(List<MultiValuedComplexType> rolePropertiesList) {
        SCIMAttributeSchema complexDefinition = SCIMSchemaDefinitions.SCIMRoleSchemaDefinition.ROLE_V2_PROPERTIES;
        SCIMAttributeSchema valueDefinition = SCIMSchemaDefinitions.SCIMRoleSchemaDefinition.ROLE_V2_PROPERTY_VALUE;
        SCIMAttributeSchema displayDefinition = SCIMSchemaDefinitions.SCIMRoleSchemaDefinition.ROLE_V2_PROPERTY_NAME;
        this.addMultivaluedComplexAtribute(rolePropertiesList, complexDefinition, valueDefinition, displayDefinition, null, null, null);
    }

    public List<MultiValuedComplexType> getRoleProperties() {
        SCIMAttributeSchema complexDefinition = SCIMSchemaDefinitions.SCIMRoleSchemaDefinition.ROLE_V2_PROPERTIES;
        SCIMAttributeSchema valueDefinition = SCIMSchemaDefinitions.SCIMRoleSchemaDefinition.ROLE_V2_PROPERTY_VALUE;
        SCIMAttributeSchema displayDefinition = SCIMSchemaDefinitions.SCIMRoleSchemaDefinition.ROLE_V2_PROPERTY_NAME;
        return this.getMultivaluedComplexType(complexDefinition, valueDefinition, displayDefinition, null, null, null).orElse(Collections.emptyList());
    }

    public ComplexAttribute getAudience() {
        if (!this.isAudienceAttributeExist()) {
            return null;
        }
        return (ComplexAttribute)this.attributeList.get("audience");
    }

    public String getAudienceValue() {
        return this.getSubAttributeOfComplexAttribute(SCIMSchemaDefinitions.SCIMRoleSchemaDefinition.AUDIENCE, SCIMSchemaDefinitions.SCIMRoleSchemaDefinition.AUDIENCE_VALUE);
    }

    public String getAudienceDisplayName() {
        return this.getSubAttributeOfComplexAttribute(SCIMSchemaDefinitions.SCIMRoleSchemaDefinition.AUDIENCE, SCIMSchemaDefinitions.SCIMRoleSchemaDefinition.AUDIENCE_DISPLAY);
    }

    public String getAudienceType() {
        return this.getSubAttributeOfComplexAttribute(SCIMSchemaDefinitions.SCIMRoleSchemaDefinition.AUDIENCE, SCIMSchemaDefinitions.SCIMRoleSchemaDefinition.AUDIENCE_TYPE);
    }

    public void setAudience(String audienceValue, String audienceDisplay, String audienceType) throws BadRequestException, CharonException {
        ComplexAttribute audienceAttribute = (ComplexAttribute)DefaultAttributeFactory.createAttribute(SCIMSchemaDefinitions.SCIMRoleSchemaDefinition.AUDIENCE, new ComplexAttribute("audience"));
        if (this.isAudienceAttributeExist()) {
            return;
        }
        this.attributeList.put("audience", audienceAttribute);
        SimpleAttribute audienceValueAttribute = (SimpleAttribute)DefaultAttributeFactory.createAttribute(SCIMSchemaDefinitions.SCIMRoleSchemaDefinition.AUDIENCE_VALUE, new SimpleAttribute("value", audienceValue));
        SimpleAttribute audienceDisplayAttribute = (SimpleAttribute)DefaultAttributeFactory.createAttribute(SCIMSchemaDefinitions.SCIMRoleSchemaDefinition.AUDIENCE_DISPLAY, new SimpleAttribute("display", audienceDisplay));
        SimpleAttribute audienceTypeAttribute = (SimpleAttribute)DefaultAttributeFactory.createAttribute(SCIMSchemaDefinitions.SCIMRoleSchemaDefinition.AUDIENCE_TYPE, new SimpleAttribute("type", audienceType));
        this.getAudience().setSubAttribute(audienceValueAttribute);
        this.getAudience().setSubAttribute(audienceDisplayAttribute);
        this.getAudience().setSubAttribute(audienceTypeAttribute);
    }

    protected boolean isAudienceAttributeExist() {
        return this.attributeList.containsKey("audience");
    }

    public void setSystemRole(boolean isSystemRole) throws CharonException, BadRequestException {
        SimpleAttribute systemRoleAttribute = (SimpleAttribute)DefaultAttributeFactory.createAttribute(SCIMSchemaDefinitions.SYSTEM_ROLE, new SimpleAttribute("systemRole", isSystemRole));
        if (this.getMetaAttribute() != null) {
            ComplexAttribute metaAttribute = this.getMetaAttribute();
            if (metaAttribute.isSubAttributeExist(systemRoleAttribute.getName())) {
                String error = "Tried to modify a read only attribute.";
                throw new CharonException(error);
            }
            metaAttribute.setSubAttribute(systemRoleAttribute);
        } else {
            this.createMetaAttribute();
            this.getMetaAttribute().setSubAttribute(systemRoleAttribute);
        }
    }

    private List<String> getSubAttributeValuesListInMultiValuedComplexAttribute(String multiValuedAttributeName, String subAttributeName) {
        if (!this.isAttributeExist(multiValuedAttributeName)) {
            return Collections.emptyList();
        }
        MultiValuedAttribute multiValuedAttribute = (MultiValuedAttribute)this.attributeList.get(multiValuedAttributeName);
        List<Attribute> subValuesList = multiValuedAttribute.getAttributeValues();
        if (subValuesList == null) {
            return Collections.emptyList();
        }
        return this.getSubAttributeValues(subAttributeName, subValuesList);
    }

    private List<String> getSubAttributeValues(String subAttributeName, List<Attribute> subValuesList) {
        ArrayList<String> subAttributeValues = new ArrayList<String>();
        for (Attribute subValue : subValuesList) {
            ComplexAttribute complexAttribute = (ComplexAttribute)subValue;
            Map<String, Attribute> subAttributesList = complexAttribute.getSubAttributesList();
            if (subAttributesList == null || !subAttributesList.containsKey(subAttributeName)) continue;
            subAttributeValues.add((String)((SimpleAttribute)subAttributesList.get(subAttributeName)).getValue());
        }
        return subAttributeValues;
    }

    private String getSubAttributeOfComplexAttribute(SCIMAttributeSchema complexAttributeSchema, SCIMAttributeSchema subAttributeSchema) {
        return this.getComplexAttribute(complexAttributeSchema).map(complexAttribute -> this.getSimpleAttribute(subAttributeSchema, (ComplexAttribute)complexAttribute).map(LambdaExceptionUtils.rethrowFunction(SimpleAttribute::getStringValue)).orElse(null)).orElse(null);
    }
}

