/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.charon3.core.protocol;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.wso2.charon3.core.exceptions.BadRequestException;
import org.wso2.charon3.core.extensions.RoleManager;
import org.wso2.charon3.core.extensions.RoleV2Manager;
import org.wso2.charon3.core.extensions.UserManager;
import org.wso2.charon3.core.objects.bulk.BulkRequestContent;
import org.wso2.charon3.core.objects.bulk.BulkRequestData;
import org.wso2.charon3.core.objects.bulk.BulkResponseContent;
import org.wso2.charon3.core.objects.bulk.BulkResponseData;
import org.wso2.charon3.core.protocol.SCIMResponse;
import org.wso2.charon3.core.protocol.endpoints.GroupResourceManager;
import org.wso2.charon3.core.protocol.endpoints.ResourceManager;
import org.wso2.charon3.core.protocol.endpoints.RoleResourceManager;
import org.wso2.charon3.core.protocol.endpoints.RoleResourceV2Manager;
import org.wso2.charon3.core.protocol.endpoints.UserResourceManager;

public class BulkRequestProcessor {
    private UserResourceManager userResourceManager = new UserResourceManager();
    private GroupResourceManager groupResourceManager = new GroupResourceManager();
    private RoleResourceManager roleResourceManager = new RoleResourceManager();
    private RoleResourceV2Manager roleResourceV2Manager = new RoleResourceV2Manager();
    private int failOnError = 0;
    private int errors = 0;
    private UserManager userManager = null;
    private RoleManager roleManager = null;
    private RoleV2Manager roleV2Manager;

    public UserResourceManager getUserResourceManager() {
        return this.userResourceManager;
    }

    public void setUserResourceManager(UserResourceManager userResourceManager) {
        this.userResourceManager = userResourceManager;
    }

    public GroupResourceManager getGroupResourceManager() {
        return this.groupResourceManager;
    }

    public void setGroupResourceManager(GroupResourceManager groupResourceManager) {
        this.groupResourceManager = groupResourceManager;
    }

    public RoleResourceManager getRoleResourceManager() {
        return this.roleResourceManager;
    }

    public void setRoleResourceManager(RoleResourceManager roleResourceManager) {
        this.roleResourceManager = roleResourceManager;
    }

    public RoleResourceV2Manager getRoleResourceV2Manager() {
        return this.roleResourceV2Manager;
    }

    public void setRoleResourceV2Manager(RoleResourceV2Manager roleResourceV2Manager) {
        this.roleResourceV2Manager = roleResourceV2Manager;
    }

    public int getFailOnError() {
        return this.failOnError;
    }

    public void setFailOnError(int failOnError) {
        this.failOnError = failOnError;
    }

    public int getErrors() {
        return this.errors;
    }

    public void setErrors(int errors) {
        this.errors = errors;
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public RoleManager getRoleManager() {
        return this.roleManager;
    }

    public void setRoleManager(RoleManager roleManager) {
        this.roleManager = roleManager;
    }

    public RoleV2Manager getRoleV2Manager() {
        return this.roleV2Manager;
    }

    public void setRoleV2Manager(RoleV2Manager roleV2Manager) {
        this.roleV2Manager = roleV2Manager;
    }

    public BulkResponseData processBulkRequests(BulkRequestData bulkRequestData) throws BadRequestException {
        BulkResponseData bulkResponseData = new BulkResponseData();
        for (BulkRequestContent bulkRequestContent : bulkRequestData.getUserOperationRequests()) {
            if (this.failOnError == 0) {
                bulkResponseData.addUserOperation(this.getBulkResponseContent(bulkRequestContent, this.userResourceManager));
                continue;
            }
            if (this.errors >= this.failOnError) continue;
            bulkResponseData.addUserOperation(this.getBulkResponseContent(bulkRequestContent, this.userResourceManager));
        }
        Map<String, String> userIdMappings = BulkRequestProcessor.getUserIdBulkIdMapping(bulkResponseData.getUserOperationResponse());
        for (BulkRequestContent bulkRequestContent : bulkRequestData.getGroupOperationRequests()) {
            if (this.failOnError == 0) {
                bulkResponseData.addGroupOperation(this.getBulkResponseContent(bulkRequestContent, userIdMappings, this.groupResourceManager));
                continue;
            }
            if (this.errors >= this.failOnError) continue;
            bulkResponseData.addGroupOperation(this.getBulkResponseContent(bulkRequestContent, userIdMappings, this.groupResourceManager));
        }
        for (BulkRequestContent bulkRequestContent : bulkRequestData.getRoleOperationRequests()) {
            if (this.failOnError == 0) {
                bulkResponseData.addRoleOperation(this.getBulkResponseContent(bulkRequestContent, userIdMappings, this.roleResourceManager));
                continue;
            }
            if (this.errors >= this.failOnError) continue;
            bulkResponseData.addRoleOperation(this.getBulkResponseContent(bulkRequestContent, userIdMappings, this.roleResourceManager));
        }
        for (BulkRequestContent bulkRequestContent : bulkRequestData.getRoleV2OperationRequests()) {
            if (this.failOnError == 0) {
                bulkResponseData.addRoleOperation(this.getBulkResponseContent(bulkRequestContent, userIdMappings, this.roleResourceV2Manager));
                continue;
            }
            if (this.errors >= this.failOnError) continue;
            bulkResponseData.addRoleOperation(this.getBulkResponseContent(bulkRequestContent, userIdMappings, this.roleResourceV2Manager));
        }
        bulkResponseData.setSchema("urn:ietf:params:scim:api:messages:2.0:BulkResponse");
        return bulkResponseData;
    }

    private BulkResponseContent getBulkResponseContent(BulkRequestContent bulkRequestContent, ResourceManager resourceManager) throws BadRequestException {
        return this.getBulkResponseContent(bulkRequestContent, null, resourceManager);
    }

    private BulkResponseContent getBulkResponseContent(BulkRequestContent bulkRequestContent, Map<String, String> userIdMappings, ResourceManager resourceManager) throws BadRequestException {
        BulkResponseContent bulkResponseContent = null;
        this.processBulkRequestContent(bulkRequestContent, userIdMappings, bulkRequestContent.getMethod());
        switch (bulkRequestContent.getMethod()) {
            case "POST": {
                SCIMResponse response = bulkRequestContent.getPath().contains("/v2/Roles") ? resourceManager.createRole(bulkRequestContent.getData(), this.roleV2Manager) : (bulkRequestContent.getPath().contains("/Roles") ? resourceManager.createRole(bulkRequestContent.getData(), this.roleManager) : resourceManager.create(bulkRequestContent.getData(), this.userManager, null, null));
                bulkResponseContent = this.createBulkResponseContent(response, "POST", bulkRequestContent);
                this.errorsCheck(response);
                break;
            }
            case "PUT": {
                SCIMResponse response;
                String resourceId = this.extractIDFromPath(bulkRequestContent.getPath());
                if (bulkRequestContent.getPath().contains("/v2/Roles")) {
                    resourceId = this.extractIDFromV2Path(bulkRequestContent.getPath());
                    response = resourceManager.updateWithPUTRole(resourceId, bulkRequestContent.getData(), this.roleV2Manager);
                } else {
                    response = bulkRequestContent.getPath().contains("/Roles") ? resourceManager.updateWithPUTRole(resourceId, bulkRequestContent.getData(), this.roleManager) : resourceManager.updateWithPUT(resourceId, bulkRequestContent.getData(), this.userManager, null, null);
                }
                bulkResponseContent = this.createBulkResponseContent(response, "PUT", bulkRequestContent);
                this.errorsCheck(response);
                break;
            }
            case "PATCH": {
                SCIMResponse response;
                String resourceId = this.extractIDFromPath(bulkRequestContent.getPath());
                if (bulkRequestContent.getPath().contains("/v2/Roles")) {
                    resourceId = this.extractIDFromV2Path(bulkRequestContent.getPath());
                    response = resourceManager.updateWithPATCHRole(resourceId, bulkRequestContent.getData(), this.roleV2Manager);
                } else {
                    response = bulkRequestContent.getPath().contains("/Roles") ? resourceManager.updateWithPATCHRole(resourceId, bulkRequestContent.getData(), this.roleManager) : resourceManager.updateWithPATCH(resourceId, bulkRequestContent.getData(), this.userManager, null, null);
                }
                bulkResponseContent = this.createBulkResponseContent(response, "PATCH", bulkRequestContent);
                this.errorsCheck(response);
                break;
            }
            case "DELETE": {
                SCIMResponse response;
                String resourceId = this.extractIDFromPath(bulkRequestContent.getPath());
                if (bulkRequestContent.getPath().contains("/v2/Roles")) {
                    resourceId = this.extractIDFromV2Path(bulkRequestContent.getPath());
                    response = resourceManager.deleteRole(resourceId, this.roleV2Manager);
                } else {
                    response = bulkRequestContent.getPath().contains("/Roles") ? resourceManager.deleteRole(resourceId, this.roleManager) : resourceManager.delete(resourceId, this.userManager);
                }
                bulkResponseContent = this.createBulkResponseContent(response, "DELETE", bulkRequestContent);
                this.errorsCheck(response);
                break;
            }
            case "GET": {
                SCIMResponse response;
                String resourceId = this.extractIDFromPath(bulkRequestContent.getPath());
                String attributes = this.getAttributesFromData(bulkRequestContent.getData());
                String excludeAttributes = this.getExcludedAttributesFromData(bulkRequestContent.getData());
                if (bulkRequestContent.getPath().contains("/v2/Roles")) {
                    resourceId = this.extractIDFromV2Path(bulkRequestContent.getPath());
                    response = resourceManager.getRole(resourceId, this.roleV2Manager, attributes, excludeAttributes);
                } else {
                    response = bulkRequestContent.getPath().contains("/Roles") ? resourceManager.getRole(resourceId, this.roleManager, attributes, excludeAttributes) : resourceManager.get(resourceId, this.userManager, attributes, excludeAttributes);
                }
                bulkResponseContent = this.createBulkResponseContent(response, "GET", bulkRequestContent);
                this.errorsCheck(response);
                break;
            }
        }
        return bulkResponseContent;
    }

    private String getExcludedAttributesFromData(String data) throws BadRequestException {
        String excludedAttributes = null;
        try {
            JSONObject dataJson = new JSONObject(data);
            if (dataJson.has("excludedAttributes")) {
                excludedAttributes = dataJson.getString("excludedAttributes");
            }
        }
        catch (JSONException e) {
            throw new BadRequestException("Error while parsing the data field of the bulk request content", "invalidSyntax");
        }
        return excludedAttributes;
    }

    private String getAttributesFromData(String data) throws BadRequestException {
        String attributes = null;
        try {
            JSONObject dataJson = new JSONObject(data);
            if (dataJson.has("attributes")) {
                attributes = dataJson.getString("attributes");
            }
        }
        catch (JSONException e) {
            throw new BadRequestException("Error while parsing the data field of the bulk request content", "invalidSyntax");
        }
        return attributes;
    }

    private String extractIDFromPath(String path) throws BadRequestException {
        String[] parts = path.split("[/]");
        if (parts[2] != null) {
            return parts[2];
        }
        throw new BadRequestException("No resource Id is provided in path", "invalidValue");
    }

    private String extractIDFromV2Path(String path) throws BadRequestException {
        String[] parts = path.split("[/]");
        if (parts[3] != null) {
            return parts[3];
        }
        throw new BadRequestException("No resource Id is provided in path", "invalidValue");
    }

    private BulkResponseContent createBulkResponseContent(SCIMResponse response, String method, BulkRequestContent requestContent) {
        BulkResponseContent bulkResponseContent = new BulkResponseContent();
        bulkResponseContent.setScimResponse(response);
        bulkResponseContent.setMethod(method);
        if (response.getHeaderParamMap() != null) {
            bulkResponseContent.setLocation(response.getHeaderParamMap().get("Location"));
        }
        bulkResponseContent.setBulkID(requestContent.getBulkID());
        bulkResponseContent.setVersion(requestContent.getVersion());
        return bulkResponseContent;
    }

    private void errorsCheck(SCIMResponse response) {
        if (response.getResponseStatus() != 200 && response.getResponseStatus() != 201 && response.getResponseStatus() != 204) {
            ++this.errors;
        }
    }

    private void processBulkRequestContent(BulkRequestContent bulkRequestContent, Map<String, String> userIDMappings, String method) throws BadRequestException {
        try {
            String usersOrMembersKey;
            if (userIDMappings == null || userIDMappings.isEmpty() || "DELETE".equals(method)) {
                return;
            }
            JSONObject dataJson = new JSONObject(bulkRequestContent.getData());
            JSONArray usersArray = this.getUserArray(dataJson, method, usersOrMembersKey = this.getUsersOrMembersKey(bulkRequestContent.getPath()));
            if (usersArray != null) {
                String bulkIdPrefix = "bulkId:";
                for (int i = 0; i < usersArray.length(); ++i) {
                    String userBulkId;
                    String userId;
                    JSONObject user = usersArray.getJSONObject(i);
                    String userValue = user.getString("value");
                    if (!userValue.startsWith(bulkIdPrefix) || !StringUtils.isNotBlank((String)(userId = userIDMappings.get(userBulkId = userValue.substring(bulkIdPrefix.length()))))) continue;
                    user.put("value", (Object)userId);
                }
            }
            bulkRequestContent.setData(dataJson.toString());
        }
        catch (JSONException e) {
            throw new BadRequestException("Error while parsing the data field of the bulk request content", "invalidSyntax");
        }
    }

    private String getUsersOrMembersKey(String path) {
        return path.contains("/Roles") ? "users" : "members";
    }

    private JSONArray getUserArray(JSONObject dataJson, String method, String usersOrMembersKey) throws JSONException {
        if ("PATCH".equals(method)) {
            return this.getUserArrayForPatch(dataJson, usersOrMembersKey);
        }
        return dataJson.optJSONArray(usersOrMembersKey);
    }

    private JSONArray getUserArrayForPatch(JSONObject dataJson, String usersOrMembersKey) throws JSONException {
        JSONArray operations = dataJson.optJSONArray("Operations");
        if (operations == null) {
            return null;
        }
        for (int i = 0; i < operations.length(); ++i) {
            JSONObject operation = operations.getJSONObject(i);
            if (!this.isValidOperation(operation, usersOrMembersKey)) continue;
            if (operation.has("path")) {
                return operation.optJSONArray("value");
            }
            JSONObject valueObject = operation.optJSONObject("value");
            if (valueObject == null) continue;
            return valueObject.optJSONArray(usersOrMembersKey);
        }
        return null;
    }

    private boolean isValidOperation(JSONObject operation, String path) throws JSONException {
        String operationType = operation.optString("op");
        String operationPath = operation.optString("path", "");
        return !(!"add".equalsIgnoreCase(operationType) && !"replace".equalsIgnoreCase(operationType) || !operationPath.equals(path) && !operationPath.isEmpty());
    }

    private static Map<String, String> getUserIdBulkIdMapping(List<BulkResponseContent> bulkUserOperationResponse) {
        HashMap<String, String> userIdMappings = new HashMap<String, String>();
        for (BulkResponseContent bulkResponse : bulkUserOperationResponse) {
            String locationHeader;
            String bulkId = bulkResponse.getBulkID();
            SCIMResponse response = bulkResponse.getScimResponse();
            if (response.getResponseStatus() != 201 || (locationHeader = response.getHeaderParamMap().get("Location")) == null) continue;
            String[] locationHeaderParts = locationHeader.split("/");
            String userId = locationHeaderParts[locationHeaderParts.length - 1];
            userIdMappings.put(bulkId, userId);
        }
        return userIdMappings;
    }
}

