/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.charon3.core.protocol.endpoints;

import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.charon3.core.config.CharonConfiguration;
import org.wso2.charon3.core.encoder.JSONDecoder;
import org.wso2.charon3.core.encoder.JSONEncoder;
import org.wso2.charon3.core.exceptions.BadRequestException;
import org.wso2.charon3.core.exceptions.CharonException;
import org.wso2.charon3.core.exceptions.InternalErrorException;
import org.wso2.charon3.core.exceptions.PayloadTooLargeException;
import org.wso2.charon3.core.extensions.RoleManager;
import org.wso2.charon3.core.extensions.RoleV2Manager;
import org.wso2.charon3.core.extensions.UserManager;
import org.wso2.charon3.core.objects.bulk.BulkRequestData;
import org.wso2.charon3.core.objects.bulk.BulkResponseData;
import org.wso2.charon3.core.protocol.BulkRequestProcessor;
import org.wso2.charon3.core.protocol.SCIMResponse;
import org.wso2.charon3.core.protocol.endpoints.AbstractResourceManager;

public class BulkResourceManager
extends AbstractResourceManager {
    private static final Log logger = LogFactory.getLog(BulkResourceManager.class);
    private JSONEncoder encoder;
    private JSONDecoder decoder;
    private BulkRequestProcessor bulkRequestProcessor = new BulkRequestProcessor();

    public SCIMResponse processBulkData(String data, UserManager userManager, RoleManager roleManager, RoleV2Manager roleV2Manager) {
        this.bulkRequestProcessor.setRoleManager(roleManager);
        this.bulkRequestProcessor.setRoleV2Manager(roleV2Manager);
        return this.processBulkData(data, userManager);
    }

    public SCIMResponse processBulkData(String data, UserManager userManager, RoleManager roleManager) {
        this.bulkRequestProcessor.setRoleManager(roleManager);
        return this.processBulkData(data, userManager);
    }

    public SCIMResponse processBulkData(String data, UserManager userManager) {
        try {
            this.encoder = BulkResourceManager.getEncoder();
            this.decoder = BulkResourceManager.getDecoder();
            BulkRequestData bulkRequestDataObject = this.decoder.decodeBulkData(data);
            this.bulkRequestProcessor.setFailOnError(bulkRequestDataObject.getFailOnErrors());
            this.bulkRequestProcessor.setUserManager(userManager);
            int maxOperationCount = (Integer)CharonConfiguration.getInstance().getConfig().get("maxOperations");
            int totalOperationCount = bulkRequestDataObject.getUserOperationRequests().size() + bulkRequestDataObject.getGroupOperationRequests().size() + bulkRequestDataObject.getRoleOperationRequests().size() + bulkRequestDataObject.getRoleV2OperationRequests().size();
            if (totalOperationCount > maxOperationCount) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)String.format("The number of operations in the bulk request: %d exceeds the maximum total number of operations count: %d.", totalOperationCount, maxOperationCount));
                }
                throw new PayloadTooLargeException(String.format("The number of operations in the bulk request: %d exceeds the maximum total number of operations count: %d.", totalOperationCount, maxOperationCount));
            }
            BulkResponseData bulkResponseData = this.bulkRequestProcessor.processBulkRequests(bulkRequestDataObject);
            String finalEncodedResponse = this.encoder.encodeBulkResponseData(bulkResponseData);
            HashMap<String, String> responseHeaders = new HashMap<String, String>();
            responseHeaders.put("Content-Type", "application/scim+json");
            return new SCIMResponse(200, finalEncodedResponse, responseHeaders);
        }
        catch (BadRequestException | CharonException | InternalErrorException | PayloadTooLargeException e) {
            return AbstractResourceManager.encodeSCIMException(e);
        }
    }

    @Override
    public SCIMResponse get(String id, UserManager userManager, String attributes, String excludeAttributes) {
        return null;
    }

    @Override
    public SCIMResponse create(String scimObjectString, UserManager userManager, String attributes, String excludeAttributes) {
        return null;
    }

    @Override
    public SCIMResponse delete(String id, UserManager userManager) {
        return null;
    }

    @Override
    public SCIMResponse listWithGET(UserManager userManager, String filter, int startIndex, int count, String sortBy, String sortOrder, String domainName, String attributes, String excludeAttributes) {
        return null;
    }

    @Override
    public SCIMResponse listWithPOST(String resourceString, UserManager userManager) {
        return null;
    }

    @Override
    public SCIMResponse updateWithPUT(String existingId, String scimObjectString, UserManager userManager, String attributes, String excludeAttributes) {
        return null;
    }

    @Override
    public SCIMResponse updateWithPATCH(String existingId, String scimObjectString, UserManager userManager, String attributes, String excludeAttributes) {
        return null;
    }
}

