/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.charon3.core.protocol.endpoints;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.charon3.core.attributes.Attribute;
import org.wso2.charon3.core.attributes.ComplexAttribute;
import org.wso2.charon3.core.attributes.MultiValuedAttribute;
import org.wso2.charon3.core.attributes.SimpleAttribute;
import org.wso2.charon3.core.encoder.JSONDecoder;
import org.wso2.charon3.core.encoder.JSONEncoder;
import org.wso2.charon3.core.exceptions.BadRequestException;
import org.wso2.charon3.core.exceptions.CharonException;
import org.wso2.charon3.core.exceptions.ConflictException;
import org.wso2.charon3.core.exceptions.ForbiddenException;
import org.wso2.charon3.core.exceptions.InternalErrorException;
import org.wso2.charon3.core.exceptions.NotFoundException;
import org.wso2.charon3.core.exceptions.NotImplementedException;
import org.wso2.charon3.core.extensions.RoleV2Manager;
import org.wso2.charon3.core.extensions.UserManager;
import org.wso2.charon3.core.objects.AbstractSCIMObject;
import org.wso2.charon3.core.objects.ListedResource;
import org.wso2.charon3.core.objects.RoleV2;
import org.wso2.charon3.core.objects.plainobjects.RolesV2GetResponse;
import org.wso2.charon3.core.protocol.SCIMResponse;
import org.wso2.charon3.core.protocol.endpoints.AbstractResourceManager;
import org.wso2.charon3.core.schema.AttributeSchema;
import org.wso2.charon3.core.schema.SCIMResourceSchemaManager;
import org.wso2.charon3.core.schema.SCIMResourceTypeSchema;
import org.wso2.charon3.core.schema.SCIMSchemaDefinitions;
import org.wso2.charon3.core.schema.ServerSideValidator;
import org.wso2.charon3.core.utils.CopyUtil;
import org.wso2.charon3.core.utils.PatchOperationUtil;
import org.wso2.charon3.core.utils.ResourceManagerUtil;
import org.wso2.charon3.core.utils.codeutils.FilterTreeManager;
import org.wso2.charon3.core.utils.codeutils.Node;
import org.wso2.charon3.core.utils.codeutils.PatchOperation;
import org.wso2.charon3.core.utils.codeutils.SearchRequest;

public class RoleResourceV2Manager
extends AbstractResourceManager {
    private static final Logger LOG = LoggerFactory.getLogger(RoleResourceV2Manager.class);

    @Override
    public SCIMResponse getRole(String id, RoleV2Manager roleManager, String attributes, String excludeAttributes) {
        try {
            if (roleManager == null) {
                String error = "Provided role manager is null.";
                throw new InternalErrorException(error);
            }
            JSONEncoder encoder = RoleResourceV2Manager.getEncoder();
            SCIMResourceTypeSchema schema = SCIMResourceSchemaManager.getInstance().getRoleResourceV2Schema();
            Map<String, Boolean> requiredAttributes = ResourceManagerUtil.getOnlyRequiredAttributesURIs((SCIMResourceTypeSchema)CopyUtil.deepCopy(schema), attributes, excludeAttributes);
            RoleV2 role = roleManager.getRole(id, requiredAttributes);
            if (role == null) {
                String message = "Role id: " + id + " not found in the system.";
                throw new NotFoundException(message);
            }
            ServerSideValidator.validateRetrievedSCIMObject(role, schema, attributes, excludeAttributes);
            ServerSideValidator.validateRetrievedSCIMRoleV2Object(role, attributes, excludeAttributes);
            String encodedRole = encoder.encodeSCIMObject(role);
            HashMap<String, String> httpHeaders = new HashMap<String, String>();
            httpHeaders.put("Content-Type", "application/scim+json");
            return new SCIMResponse(200, encodedRole, httpHeaders);
        }
        catch (BadRequestException | CharonException | InternalErrorException | NotFoundException | NotImplementedException e) {
            return RoleResourceV2Manager.encodeSCIMException(e);
        }
    }

    @Override
    public SCIMResponse createRole(String postRequest, RoleV2Manager roleManager) {
        try {
            if (roleManager == null) {
                String error = "Provided role manager is null.";
                throw new InternalErrorException(error);
            }
            JSONEncoder encoder = RoleResourceV2Manager.getEncoder();
            JSONDecoder decoder = RoleResourceV2Manager.getDecoder();
            SCIMResourceTypeSchema schema = SCIMResourceSchemaManager.getInstance().getRoleResourceV2Schema();
            RoleV2 role = decoder.decodeResource(postRequest, schema, new RoleV2());
            ServerSideValidator.validateCreatedSCIMObject(role, SCIMSchemaDefinitions.SCIM_ROLE_V2_SCHEMA);
            RoleV2 createdRole = roleManager.createRole(role);
            HashMap<String, String> httpHeaders = new HashMap<String, String>();
            if (createdRole == null) {
                String message = "Newly created Role resource is null.";
                throw new InternalErrorException(message);
            }
            String encodedRole = encoder.encodeSCIMObject(createdRole);
            httpHeaders.put("Location", RoleResourceV2Manager.getResourceEndpointURL("/v2/Roles") + "/" + createdRole.getId());
            httpHeaders.put("Content-Type", "application/scim+json");
            return new SCIMResponse(201, encodedRole, httpHeaders);
        }
        catch (BadRequestException | CharonException | ConflictException | InternalErrorException | NotFoundException | NotImplementedException e) {
            return RoleResourceV2Manager.encodeSCIMException(e);
        }
    }

    @Override
    public SCIMResponse deleteRole(String id, RoleV2Manager roleManager) {
        try {
            if (roleManager == null) {
                String error = "Provided role manager is null.";
                throw new InternalErrorException(error);
            }
            roleManager.deleteRole(id);
            return new SCIMResponse(204, null, null);
        }
        catch (BadRequestException | CharonException | InternalErrorException | NotFoundException | NotImplementedException e) {
            return RoleResourceV2Manager.encodeSCIMException(e);
        }
    }

    @Override
    public SCIMResponse listWithGETRole(RoleV2Manager roleManager, String filter, Integer startIndexInt, Integer countInt, String sortBy, String sortOrder, String attributes, String excludeAttributes) {
        try {
            if (roleManager == null) {
                String error = "Provided role manager is null.";
                throw new InternalErrorException(error);
            }
            Integer count = ResourceManagerUtil.processCount(countInt);
            Integer startIndex = ResourceManagerUtil.processStartIndex(startIndexInt);
            sortOrder = this.resolveSortOrder(sortOrder, sortBy);
            SCIMResourceTypeSchema schema = SCIMResourceSchemaManager.getInstance().getRoleResourceV2Schema();
            Node rootNode = this.buildNode(filter, schema);
            JSONEncoder encoder = RoleResourceV2Manager.getEncoder();
            List<String> requestedAttributes = this.getRequestedAttributes((SCIMResourceTypeSchema)CopyUtil.deepCopy(schema), attributes, excludeAttributes);
            RolesV2GetResponse rolesResponse = roleManager.listRolesWithGET(rootNode, startIndex, count, sortBy, sortOrder, requestedAttributes);
            return this.processRoleList(rolesResponse, encoder, startIndex, attributes, excludeAttributes);
        }
        catch (BadRequestException | CharonException | InternalErrorException | NotImplementedException e) {
            return RoleResourceV2Manager.encodeSCIMException(e);
        }
        catch (IOException e) {
            String error = "Error in tokenization of the input filter.";
            CharonException charonException = new CharonException(error);
            return AbstractResourceManager.encodeSCIMException(charonException);
        }
    }

    private List<String> getRequestedAttributes(SCIMResourceTypeSchema schema, String requestedAttributes, String requestedExcludingAttributes) throws CharonException {
        ArrayList<AttributeSchema> requestedAttributeSchemas = ResourceManagerUtil.getOnlyRequiredAttributes((SCIMResourceTypeSchema)CopyUtil.deepCopy(schema), requestedAttributes, requestedExcludingAttributes);
        ArrayList<String> requestedAttributesList = new ArrayList<String>();
        for (AttributeSchema attributeSchema : requestedAttributeSchemas) {
            requestedAttributesList.add(attributeSchema.getName());
        }
        return requestedAttributesList;
    }

    @Override
    public SCIMResponse listWithPOSTRole(String searchRequest, RoleV2Manager roleManager) {
        try {
            if (roleManager == null) {
                String error = "Provided role manager is null.";
                throw new InternalErrorException(error);
            }
            JSONEncoder encoder = RoleResourceV2Manager.getEncoder();
            JSONDecoder decoder = RoleResourceV2Manager.getDecoder();
            SCIMResourceTypeSchema schema = SCIMResourceSchemaManager.getInstance().getRoleResourceV2Schema();
            SearchRequest searchRequestObject = decoder.decodeSearchRequestBody(searchRequest, schema);
            searchRequestObject.setCount(ResourceManagerUtil.processCount(searchRequestObject.getCountStr()));
            searchRequestObject.setStartIndex(ResourceManagerUtil.processStartIndex(searchRequestObject.getStartIndexStr()));
            if (searchRequestObject.getSchema() != null && !searchRequestObject.getSchema().equals("urn:ietf:params:scim:api:messages:2.0:SearchRequest")) {
                throw new BadRequestException("Provided schema is invalid.", "invalidValue");
            }
            if (searchRequestObject.getSortOder() != null && !searchRequestObject.getSortOder().equalsIgnoreCase("ascending") && !searchRequestObject.getSortOder().equalsIgnoreCase("descending")) {
                String error = " Invalid sortOrder value is specified";
                throw new BadRequestException(error, "invalidValue");
            }
            if (searchRequestObject.getSortOder() == null && searchRequestObject.getSortBy() != null) {
                searchRequestObject.setSortOder("ascending");
            }
            String attributes = searchRequestObject.getAttributesAsString();
            String excludeAttributes = searchRequestObject.getExcludedAttributesAsString();
            List<String> requestedAttributes = this.getRequestedAttributes((SCIMResourceTypeSchema)CopyUtil.deepCopy(schema), attributes, excludeAttributes);
            RolesV2GetResponse rolesResponse = roleManager.listRolesWithPost(searchRequestObject, requestedAttributes);
            for (RoleV2 role : rolesResponse.getRoles()) {
                ServerSideValidator.validateRetrievedSCIMObjectInList(role, schema, searchRequestObject.getAttributesAsString(), searchRequestObject.getExcludedAttributesAsString());
            }
            ListedResource listedResource = this.createListedResource(rolesResponse, searchRequestObject.getStartIndex());
            String encodedListedResource = encoder.encodeSCIMObject(listedResource);
            HashMap<String, String> responseHeaders = new HashMap<String, String>();
            responseHeaders.put("Content-Type", "application/scim+json");
            return new SCIMResponse(200, encodedListedResource, responseHeaders);
        }
        catch (BadRequestException | CharonException | InternalErrorException | NotImplementedException e) {
            return AbstractResourceManager.encodeSCIMException(e);
        }
    }

    @Override
    public SCIMResponse updateWithPUTRole(String id, String putRequest, RoleV2Manager roleManager) {
        try {
            if (roleManager == null) {
                String error = "Provided role manager is null.";
                throw new InternalErrorException(error);
            }
            JSONEncoder encoder = RoleResourceV2Manager.getEncoder();
            JSONDecoder decoder = RoleResourceV2Manager.getDecoder();
            SCIMResourceTypeSchema schema = SCIMResourceSchemaManager.getInstance().getRoleResourceV2Schema();
            Map<String, Boolean> requestAttributes = ResourceManagerUtil.getAllAttributeURIs(schema);
            RoleV2 role = decoder.decodeResource(putRequest, schema, new RoleV2());
            RoleV2 oldRole = roleManager.getRole(id, requestAttributes);
            if (oldRole == null) {
                String error = "No role exists with the given id: " + id;
                throw new NotFoundException(error);
            }
            RoleV2 newRole = (RoleV2)ServerSideValidator.validateUpdatedSCIMObject(oldRole, role, schema);
            RoleV2 updatedRole = roleManager.updateRole(oldRole, newRole);
            return this.getScimResponse(encoder, updatedRole);
        }
        catch (BadRequestException | CharonException | ConflictException | InternalErrorException | NotFoundException | NotImplementedException e) {
            return RoleResourceV2Manager.encodeSCIMException(e);
        }
    }

    @Override
    public SCIMResponse updateWithPATCHRole(String id, String patchRequest, RoleV2Manager roleManager) {
        try {
            if (roleManager == null) {
                String error = "Provided role manager handler is null.";
                throw new InternalErrorException(error);
            }
            JSONEncoder encoder = RoleResourceV2Manager.getEncoder();
            SCIMResourceTypeSchema schema = SCIMResourceSchemaManager.getInstance().getRoleResourceV2Schema();
            Map<String, Boolean> requestAttributes = ResourceManagerUtil.getAllAttributeURIs(schema);
            ArrayList<PatchOperation> opList = RoleResourceV2Manager.getDecoder().decodeRequest(patchRequest);
            if (!this.isUpdateAllUsersOperationFound(opList)) {
                return this.updateWithPatchOperations(id, opList, roleManager, schema, encoder);
            }
            RoleV2 oldRole = roleManager.getRole(id, requestAttributes);
            if (oldRole == null) {
                throw new NotFoundException("No role with the id : " + id + " exists in the system.");
            }
            RoleV2 originalRole = (RoleV2)CopyUtil.deepCopy(oldRole);
            RoleV2 patchedRole = this.doPatchRole(oldRole, schema, patchRequest);
            RoleV2 updatedRole = roleManager.updateRole(originalRole, patchedRole);
            return this.getScimResponse(encoder, updatedRole);
        }
        catch (BadRequestException | CharonException | ConflictException | InternalErrorException | NotFoundException | NotImplementedException e) {
            return AbstractResourceManager.encodeSCIMException(e);
        }
        catch (RuntimeException e) {
            CharonException ex = new CharonException("Error in performing the patch operation on role resource.", e);
            return AbstractResourceManager.encodeSCIMException(ex);
        }
    }

    @Override
    public SCIMResponse get(String id, UserManager userManager, String attributes, String excludeAttributes) {
        return new SCIMResponse(501, "Service provider does not support the request operation.", Collections.emptyMap());
    }

    @Override
    public SCIMResponse create(String scimObjectString, UserManager userManager, String attributes, String excludeAttributes) {
        return new SCIMResponse(501, "Service provider does not support the request operation.", Collections.emptyMap());
    }

    @Override
    public SCIMResponse delete(String id, UserManager userManager) {
        return new SCIMResponse(501, "Service provider does not support the request operation.", Collections.emptyMap());
    }

    @Override
    public SCIMResponse listWithGET(UserManager userManager, String filter, int startIndex, int count, String sortBy, String sortOrder, String domainName, String attributes, String excludeAttributes) {
        return new SCIMResponse(501, "Service provider does not support the request operation.", Collections.emptyMap());
    }

    @Override
    public SCIMResponse listWithPOST(String resourceString, UserManager userManager) {
        return new SCIMResponse(501, "Service provider does not support the request operation.", Collections.emptyMap());
    }

    @Override
    public SCIMResponse updateWithPUT(String existingId, String scimObjectString, UserManager userManager, String attributes, String excludeAttributes) {
        return new SCIMResponse(501, "Service provider does not support the request operation.", Collections.emptyMap());
    }

    @Override
    public SCIMResponse updateWithPATCH(String existingId, String scimObjectString, UserManager userManager, String attributes, String excludeAttributes) {
        return new SCIMResponse(501, "Service provider does not support the request operation.", Collections.emptyMap());
    }

    private String resolveSortOrder(String sortOrder, String sortBy) throws BadRequestException {
        if (sortOrder != null) {
            if (!"ascending".equalsIgnoreCase(sortOrder) && !"descending".equalsIgnoreCase(sortOrder)) {
                String error = "Invalid sortOrder value is specified.";
                throw new BadRequestException(error, "invalidValue");
            }
        } else if (sortBy != null) {
            sortOrder = "ascending";
        }
        return sortOrder;
    }

    private Node buildNode(String filter, SCIMResourceTypeSchema schema) throws BadRequestException, IOException {
        if (filter != null) {
            FilterTreeManager filterTreeManager = new FilterTreeManager(filter, schema);
            return filterTreeManager.buildTree();
        }
        return null;
    }

    private SCIMResponse processRoleList(RolesV2GetResponse rolesResponse, JSONEncoder encoder, int startIndex, String attributes, String excludeAttributes) throws CharonException, BadRequestException {
        if (rolesResponse == null) {
            rolesResponse = new RolesV2GetResponse(0, Collections.emptyList());
        }
        if (rolesResponse.getRoles() == null) {
            rolesResponse.setRoles(Collections.emptyList());
        }
        for (RoleV2 role : rolesResponse.getRoles()) {
            ServerSideValidator.validateRetrievedSCIMObject(role, SCIMSchemaDefinitions.SCIM_ROLE_V2_SCHEMA, attributes, excludeAttributes);
        }
        ListedResource listedResource = this.createListedResource(rolesResponse, startIndex);
        String encodedListedResource = encoder.encodeSCIMObject(listedResource);
        HashMap<String, String> responseHeaders = new HashMap<String, String>();
        responseHeaders.put("Content-Type", "application/scim+json");
        return new SCIMResponse(200, encodedListedResource, responseHeaders);
    }

    protected ListedResource createListedResource(RolesV2GetResponse rolesResponse, int startIndex) {
        ListedResource listedResource = new ListedResource();
        listedResource.setSchema("urn:ietf:params:scim:api:messages:2.0:ListResponse");
        listedResource.setTotalResults(rolesResponse.getTotalRoles());
        listedResource.setStartIndex(startIndex);
        listedResource.setItemsPerPage(rolesResponse.getRoles().size());
        for (RoleV2 role : rolesResponse.getRoles()) {
            Map<String, Attribute> userAttributes = role.getAttributeList();
            listedResource.setResources(userAttributes);
        }
        return listedResource;
    }

    private SCIMResponse getScimResponse(JSONEncoder encoder, RoleV2 updatedRole) throws CharonException, NotFoundException, InternalErrorException {
        HashMap<String, String> httpHeaders = new HashMap<String, String>();
        if (updatedRole == null) {
            String error = "Updated Role resource is null.";
            throw new InternalErrorException(error);
        }
        RoleV2 copiedRole = (RoleV2)CopyUtil.deepCopy(updatedRole);
        String encodedRole = encoder.encodeSCIMObject(copiedRole);
        httpHeaders.put("Location", RoleResourceV2Manager.getResourceEndpointURL("/v2/Roles") + "/" + updatedRole.getId());
        httpHeaders.put("Content-Type", "application/scim+json");
        return new SCIMResponse(200, encodedRole, httpHeaders);
    }

    private boolean isUpdateAllUsersOperationFound(List<PatchOperation> patchOperations) throws JSONException {
        for (PatchOperation patchOperation : patchOperations) {
            String operation = patchOperation.getOperation();
            String path = patchOperation.getPath();
            JSONObject valuesJson = null;
            if (StringUtils.isBlank((String)path)) {
                valuesJson = (JSONObject)patchOperation.getValues();
            }
            if ("replace".equals(operation) && ("users".equals(path) || valuesJson != null && valuesJson.has("users"))) {
                return true;
            }
            if (!"remove".equals(operation) || !"users".equals(path)) continue;
            return true;
        }
        return false;
    }

    private SCIMResponse updateWithPatchOperations(String existingRoleId, List<PatchOperation> opList, RoleV2Manager roleManager, SCIMResourceTypeSchema schema, JSONEncoder encoder) {
        try {
            HashMap<String, List<PatchOperation>> patchOperations = new HashMap<String, List<PatchOperation>>();
            patchOperations.put("add", new ArrayList());
            patchOperations.put("remove", new ArrayList());
            patchOperations.put("replace", new ArrayList());
            block12: for (PatchOperation patchOperation : opList) {
                switch (patchOperation.getOperation()) {
                    case "add": {
                        ((List)patchOperations.get("add")).add(patchOperation);
                        continue block12;
                    }
                    case "remove": {
                        ((List)patchOperations.get("remove")).add(patchOperation);
                        continue block12;
                    }
                    case "replace": {
                        ((List)patchOperations.get("replace")).add(patchOperation);
                        continue block12;
                    }
                }
                throw new BadRequestException("Unknown operation: " + patchOperation.getOperation(), "invalidSyntax");
            }
            this.processRolePatchOperations(patchOperations, schema);
            RoleV2 updatedRole = roleManager.patchRole(existingRoleId, patchOperations);
            return this.getScimResponse(encoder, updatedRole);
        }
        catch (BadRequestException | CharonException | ConflictException | ForbiddenException | InternalErrorException | NotFoundException | NotImplementedException e) {
            return AbstractResourceManager.encodeSCIMException(e);
        }
    }

    private void processRolePatchOperations(Map<String, List<PatchOperation>> patchOperations, SCIMResourceTypeSchema schema) throws CharonException, BadRequestException, NotImplementedException, JSONException {
        for (PatchOperation patchOperation : patchOperations.get("replace")) {
            this.processPatchOperation(schema, patchOperation);
        }
        for (PatchOperation patchOperation : patchOperations.get("add")) {
            this.processPatchOperation(schema, patchOperation);
        }
        for (PatchOperation patchOperation : patchOperations.get("remove")) {
            RoleResourceV2Manager.processRemovePatchOperation(patchOperation);
        }
    }

    private RoleV2 doPatchRole(RoleV2 oldRole, SCIMResourceTypeSchema roleSchema, String patchRequest) throws CharonException, BadRequestException, NotImplementedException, InternalErrorException {
        RoleV2 originalRole = (RoleV2)CopyUtil.deepCopy(oldRole);
        RoleV2 copyOfOldRole = (RoleV2)CopyUtil.deepCopy(oldRole);
        RoleV2 patchedRole = null;
        ArrayList<PatchOperation> opList = RoleResourceV2Manager.getDecoder().decodeRequest(patchRequest);
        block10: for (PatchOperation operation : opList) {
            switch (operation.getOperation()) {
                case "add": {
                    patchedRole = patchedRole == null ? (RoleV2)PatchOperationUtil.doPatchAdd(operation, RoleResourceV2Manager.getDecoder(), oldRole, copyOfOldRole, roleSchema) : (RoleV2)PatchOperationUtil.doPatchAdd(operation, RoleResourceV2Manager.getDecoder(), patchedRole, copyOfOldRole, roleSchema);
                    copyOfOldRole = (RoleV2)CopyUtil.deepCopy(patchedRole);
                    continue block10;
                }
                case "remove": {
                    patchedRole = patchedRole == null ? (RoleV2)PatchOperationUtil.doPatchRemove(operation, oldRole, copyOfOldRole, roleSchema) : (RoleV2)PatchOperationUtil.doPatchRemove(operation, patchedRole, copyOfOldRole, roleSchema);
                    copyOfOldRole = (RoleV2)CopyUtil.deepCopy(patchedRole);
                    continue block10;
                }
                case "replace": {
                    patchedRole = patchedRole == null ? (RoleV2)PatchOperationUtil.doPatchReplace(operation, RoleResourceV2Manager.getDecoder(), oldRole, copyOfOldRole, roleSchema) : (RoleV2)PatchOperationUtil.doPatchReplace(operation, RoleResourceV2Manager.getDecoder(), patchedRole, copyOfOldRole, roleSchema);
                    copyOfOldRole = (RoleV2)CopyUtil.deepCopy(patchedRole);
                    continue block10;
                }
            }
            throw new BadRequestException("Unknown operation.", "invalidSyntax");
        }
        return (RoleV2)ServerSideValidator.validateUpdatedSCIMObject(originalRole, patchedRole, roleSchema);
    }

    private void processPatchOperation(SCIMResourceTypeSchema schema, PatchOperation patchOperation) throws BadRequestException, CharonException {
        if (patchOperation.getValues() == null) {
            throw new BadRequestException("The value is not provided to perform patch " + patchOperation.getOperation() + " operation.", "invalidSyntax");
        }
        if (patchOperation.getPath() != null) {
            switch (patchOperation.getPath()) {
                case "displayName": {
                    String valuesProperty = (String)patchOperation.getValues();
                    JSONObject attributePrefixedJson = new JSONObject();
                    attributePrefixedJson.put("displayName", (Object)valuesProperty);
                    patchOperation.setValues(attributePrefixedJson);
                    break;
                }
                case "users": {
                    RoleResourceV2Manager.setPatchOperationValue(patchOperation, "users");
                    break;
                }
                case "groups": {
                    RoleResourceV2Manager.setPatchOperationValue(patchOperation, "groups");
                    break;
                }
                case "permissions": {
                    RoleResourceV2Manager.setPatchOperationValue(patchOperation, "permissions");
                    break;
                }
                default: {
                    throw new BadRequestException("Not a valid attribute.", "invalidSyntax");
                }
            }
            patchOperation.setPath(null);
        }
        this.processValueAttributeOfOperation(schema, patchOperation);
    }

    private static void processRemovePatchOperation(PatchOperation patchOperation) throws NotImplementedException, BadRequestException {
        if ("displayName".equalsIgnoreCase(patchOperation.getPath())) {
            throw new BadRequestException("Can not remove a required attribute");
        }
        if (patchOperation.getPath() == null) {
            throw new BadRequestException("No path value specified for remove operation", "noTarget");
        }
        String path = patchOperation.getPath();
        Object[] parts = path.split("[\\[\\]]");
        if (ArrayUtils.isEmpty((Object[])parts) || !"users".equalsIgnoreCase((String)parts[0]) && !"groups".equalsIgnoreCase((String)parts[0]) && !"permissions".equalsIgnoreCase((String)parts[0])) {
            throw new BadRequestException((String)parts[0] + " is not a valid attribute.", "invalidSyntax");
        }
        if ("users".equalsIgnoreCase((String)parts[0])) {
            patchOperation.setAttributeName("users");
        } else if ("groups".equalsIgnoreCase((String)parts[0])) {
            patchOperation.setAttributeName("groups");
        } else {
            patchOperation.setAttributeName("permissions");
        }
        if (parts.length != 1) {
            HashMap<String, String> patchObject = new HashMap<String, String>();
            patchObject.put("display", null);
            patchObject.put("value", null);
            String[] filterParts = ((String)parts[1]).split(" ");
            if (filterParts.length != 3 || !patchObject.containsKey(filterParts[0])) {
                throw new BadRequestException("Invalid filter", "invalidSyntax");
            }
            if (!filterParts[1].equalsIgnoreCase(" eq ".trim())) {
                throw new NotImplementedException("Only Eq filter is supported");
            }
            filterParts[2] = filterParts[2].replaceAll("^\"|\"$", "");
            patchObject.put(filterParts[0], filterParts[2]);
            patchOperation.setValues(patchObject);
        }
    }

    private static void setPatchOperationValue(PatchOperation patchOperation, String permissions) {
        JSONArray valuesPropertyJson = (JSONArray)patchOperation.getValues();
        JSONObject attributePrefixedJson = new JSONObject();
        attributePrefixedJson.put(permissions, (Object)valuesPropertyJson);
        patchOperation.setValues(attributePrefixedJson);
    }

    private void processValueAttributeOfOperation(SCIMResourceTypeSchema schema, PatchOperation patchOperation) throws CharonException, BadRequestException {
        AbstractSCIMObject attributeHoldingSCIMObject = RoleResourceV2Manager.getDecoder().decode(patchOperation.getValues().toString(), schema);
        if (attributeHoldingSCIMObject == null) {
            throw new BadRequestException("Not a valid attribute.", "invalidSyntax");
        }
        Map<String, Attribute> attributeList = attributeHoldingSCIMObject.getAttributeList();
        if (attributeList.isEmpty()) {
            throw new BadRequestException("Request is unparsable, syntactically incorrect, or violates schema.", "invalidSyntax");
        }
        if (attributeList.containsKey("displayName")) {
            patchOperation.setAttributeName("displayName");
            patchOperation.setValues(((SimpleAttribute)attributeList.get("displayName")).getStringValue());
        } else if (attributeList.containsKey("users")) {
            patchOperation.setAttributeName("users");
            patchOperation.setValues(this.transformAttributeToMap((MultiValuedAttribute)attributeList.get("users")));
        } else if (attributeList.containsKey("groups")) {
            patchOperation.setAttributeName("groups");
            patchOperation.setValues(this.transformAttributeToMap((MultiValuedAttribute)attributeList.get("groups")));
        } else if (attributeList.containsKey("permissions")) {
            patchOperation.setAttributeName("permissions");
            patchOperation.setValues(this.transformAttributeToMap((MultiValuedAttribute)attributeList.get("permissions")));
        }
    }

    private List<Map<String, String>> transformAttributeToMap(MultiValuedAttribute multiValuedAttribute) throws CharonException {
        ArrayList<Map<String, String>> memberList = new ArrayList<Map<String, String>>();
        List<Attribute> subValuesList = multiValuedAttribute.getAttributeValues();
        for (Attribute subValue : subValuesList) {
            ComplexAttribute complexAttribute = (ComplexAttribute)subValue;
            Map<String, Attribute> subAttributesList = complexAttribute.getSubAttributesList();
            HashMap<String, String> member = new HashMap<String, String>();
            if (subAttributesList.get("value") != null) {
                member.put("value", ((SimpleAttribute)subAttributesList.get("value")).getStringValue());
            }
            if (subAttributesList.get("display") != null) {
                member.put("display", ((SimpleAttribute)subAttributesList.get("display")).getStringValue());
            }
            memberList.add(member);
        }
        return memberList;
    }
}

