/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.charon3.core.schema;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.wso2.charon3.core.exceptions.CharonException;
import org.wso2.charon3.core.schema.AttributeSchema;
import org.wso2.charon3.core.schema.SCIMDefinitions;
import org.wso2.charon3.core.utils.CopyUtil;

public class SCIMAttributeSchema
implements AttributeSchema,
Serializable {
    private static final long serialVersionUID = 6106269076155338045L;
    private String uri;
    private String name;
    private SCIMDefinitions.DataType type;
    private Boolean multiValued;
    private String description;
    private Boolean required;
    private Boolean caseExact;
    private SCIMDefinitions.Mutability mutability;
    private SCIMDefinitions.Returned returned;
    private SCIMDefinitions.Uniqueness uniqueness;
    private ArrayList<AttributeSchema> subAttributes;
    private ArrayList<String> canonicalValues;
    private ArrayList<SCIMDefinitions.ReferenceType> referenceTypes;

    private SCIMAttributeSchema(String uri, String name, SCIMDefinitions.DataType type, Boolean multiValued, String description, Boolean required, Boolean caseExact, SCIMDefinitions.Mutability mutability, SCIMDefinitions.Returned returned, SCIMDefinitions.Uniqueness uniqueness, ArrayList<String> canonicalValues, ArrayList<SCIMDefinitions.ReferenceType> referenceTypes, ArrayList<AttributeSchema> subAttributes) {
        this.uri = uri;
        this.name = name;
        this.type = type;
        this.multiValued = multiValued;
        this.description = description;
        this.required = required;
        this.caseExact = caseExact;
        this.mutability = mutability;
        this.returned = returned;
        this.uniqueness = uniqueness;
        this.subAttributes = subAttributes;
        this.canonicalValues = canonicalValues;
        this.referenceTypes = referenceTypes;
    }

    public static SCIMAttributeSchema createSCIMAttributeSchema(String uri, String name, SCIMDefinitions.DataType type, Boolean multiValued, String description, Boolean required, Boolean caseExact, SCIMDefinitions.Mutability mutability, SCIMDefinitions.Returned returned, SCIMDefinitions.Uniqueness uniqueness, ArrayList<String> canonicalValues, ArrayList<SCIMDefinitions.ReferenceType> referenceTypes, ArrayList<AttributeSchema> subAttributes) {
        return new SCIMAttributeSchema(uri, name, type, multiValued, description, required, caseExact, mutability, returned, uniqueness, canonicalValues, referenceTypes, subAttributes);
    }

    @Override
    public void setURI(String uri) {
        this.uri = uri;
    }

    @Override
    public String getURI() {
        return this.uri;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public SCIMDefinitions.DataType getType() {
        return this.type;
    }

    @Override
    public void setType(SCIMDefinitions.DataType type) {
        this.type = type;
    }

    @Override
    public boolean getMultiValued() {
        return this.multiValued;
    }

    @Override
    public void setMultiValued(boolean isMultiValued) {
        this.multiValued = isMultiValued;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public boolean getRequired() {
        return this.required;
    }

    @Override
    public void setRequired(boolean isRequired) {
        this.required = isRequired;
    }

    @Override
    public boolean getCaseExact() {
        return this.caseExact;
    }

    @Override
    public void setCaseExact(boolean isCaseExact) {
        this.caseExact = isCaseExact;
    }

    @Override
    public SCIMDefinitions.Mutability getMutability() {
        return this.mutability;
    }

    @Override
    public void setMutability(SCIMDefinitions.Mutability mutability) {
        this.mutability = mutability;
    }

    @Override
    public SCIMDefinitions.Returned getReturned() {
        return this.returned;
    }

    @Override
    public void setReturned(SCIMDefinitions.Returned returned) {
        this.returned = returned;
    }

    @Override
    public SCIMDefinitions.Uniqueness getUniqueness() {
        return this.uniqueness;
    }

    @Override
    public void setUniqueness(SCIMDefinitions.Uniqueness uniqueness) {
        this.uniqueness = uniqueness;
    }

    @Override
    public List<AttributeSchema> getSubAttributeSchemas() {
        return this.subAttributes;
    }

    @Override
    public AttributeSchema getSubAttributeSchema(String subAttribute) {
        for (AttributeSchema subAttributeSchema : this.subAttributes) {
            if (!subAttributeSchema.getName().equals(subAttribute)) continue;
            return subAttributeSchema;
        }
        return null;
    }

    @Override
    public void removeSubAttribute(String subAttributeName) throws CharonException {
        ArrayList tempSubAttributes = (ArrayList)CopyUtil.deepCopy(this.subAttributes);
        int count = 0;
        for (AttributeSchema subAttributeSchema : tempSubAttributes) {
            if (subAttributeSchema.getName().equals(subAttributeName)) {
                this.subAttributes.remove(count);
                return;
            }
            ++count;
        }
    }

    public void setSubAttributes(ArrayList<AttributeSchema> subAttributes) {
        this.subAttributes = subAttributes;
    }

    @Override
    public List<String> getCanonicalValues() {
        return this.canonicalValues;
    }

    @Override
    public void setCanonicalValues(ArrayList<String> canonicalValues) {
        this.canonicalValues = canonicalValues;
    }

    public ArrayList<SCIMDefinitions.ReferenceType> getReferenceTypes() {
        return this.referenceTypes;
    }

    public void setReferenceTypes(ArrayList<SCIMDefinitions.ReferenceType> referenceTypes) {
        this.referenceTypes = referenceTypes;
    }
}

