/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.charon3.core.utils.codeutils;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.wso2.charon3.core.exceptions.BadRequestException;
import org.wso2.charon3.core.schema.SCIMResourceTypeSchema;
import org.wso2.charon3.core.utils.AttributeUtil;
import org.wso2.charon3.core.utils.codeutils.ExpressionNode;
import org.wso2.charon3.core.utils.codeutils.Node;
import org.wso2.charon3.core.utils.codeutils.OperationNode;

public class FilterTreeManager {
    private StreamTokenizer input;
    protected List<String> tokenList = null;
    private String symbol;
    private Node root;
    private SCIMResourceTypeSchema schema;

    public FilterTreeManager(String filterString, SCIMResourceTypeSchema schema) throws IOException {
        String encodedString = URLEncoder.encode(filterString, "UTF-8");
        String modifiedEncodedString = encodedString.replaceAll("\\+", " ");
        this.schema = schema;
        this.input = new StreamTokenizer(new StringReader(modifiedEncodedString));
        this.input.resetSyntax();
        this.input.wordChars(97, 122);
        this.input.wordChars(65, 90);
        this.input.wordChars(160, 255);
        this.input.whitespaceChars(0, 32);
        this.input.commentChar(47);
        this.input.quoteChar(34);
        this.input.quoteChar(39);
        this.input.wordChars(64, 64);
        this.input.wordChars(58, 58);
        this.input.wordChars(95, 95);
        this.input.wordChars(48, 57);
        this.input.wordChars(45, 45);
        this.input.wordChars(43, 43);
        this.input.wordChars(46, 46);
        this.input.wordChars(42, 42);
        this.input.wordChars(47, 47);
        this.input.wordChars(37, 37);
        ArrayList<String> tempTokenList = new ArrayList<String>();
        String concatenatedString = "";
        while (this.input.nextToken() != -1) {
            if (this.input.ttype == -3) {
                String decodedValue = URLDecoder.decode(this.input.sval, "UTF-8");
                if (!(decodedValue.equalsIgnoreCase("and") || decodedValue.equalsIgnoreCase("or") || decodedValue.equalsIgnoreCase("not"))) {
                    if (decodedValue.startsWith("(")) {
                        tempTokenList.add("(");
                        decodedValue = decodedValue.substring(1);
                    }
                    if (decodedValue.endsWith(")")) {
                        decodedValue = decodedValue.substring(0, decodedValue.length() - 1);
                        decodedValue = this.removeStartingAndEndingQuotes(decodedValue);
                        concatenatedString = concatenatedString + " " + decodedValue;
                        concatenatedString = concatenatedString.trim();
                        tempTokenList.add(concatenatedString);
                        concatenatedString = "";
                        tempTokenList.add(")");
                        continue;
                    }
                    decodedValue = this.removeStartingAndEndingQuotes(decodedValue);
                    concatenatedString = concatenatedString + " " + decodedValue;
                    continue;
                }
                if (!(concatenatedString = concatenatedString.trim()).equals("")) {
                    tempTokenList.add(concatenatedString);
                    concatenatedString = "";
                }
                tempTokenList.add(decodedValue.toLowerCase(Locale.ENGLISH));
                continue;
            }
            if (this.input.ttype != 34 && this.input.ttype != 39) continue;
            concatenatedString = concatenatedString + " " + this.input.sval;
        }
        if (!concatenatedString.equals("")) {
            tempTokenList.add(concatenatedString);
        }
        this.tokenList = new ArrayList<String>();
        Boolean stringsConcatenated = false;
        for (int token = 0; token < tempTokenList.size(); ++token) {
            String updatedString = ((String)tempTokenList.get(token)).trim();
            String[] splitedToken = updatedString.split("\\s+");
            if (stringsConcatenated.booleanValue()) {
                stringsConcatenated = false;
                continue;
            }
            if (splitedToken.length == 2 && !splitedToken[1].equalsIgnoreCase(" pr") && token + 1 < tempTokenList.size() && (((String)tempTokenList.get(token + 1)).equalsIgnoreCase("and") || ((String)tempTokenList.get(token + 1)).equalsIgnoreCase("or") || ((String)tempTokenList.get(token + 1)).equalsIgnoreCase("not"))) {
                updatedString = updatedString + " " + (String)tempTokenList.get(token + 1);
                stringsConcatenated = true;
            }
            this.tokenList.add(updatedString);
        }
    }

    public Node buildTree() throws BadRequestException {
        this.expression();
        return this.root;
    }

    private void expression() throws BadRequestException {
        this.term();
        while (this.symbol.equals(String.valueOf("or"))) {
            OperationNode or = new OperationNode("or");
            or.setLeftNode(this.root);
            this.term();
            or.setRightNode(this.root);
            this.root = or;
        }
    }

    private void term() throws BadRequestException {
        this.factor();
        while (this.symbol.equals(String.valueOf("and"))) {
            OperationNode and = new OperationNode("and");
            and.setLeftNode(this.root);
            this.factor();
            and.setRightNode(this.root);
            this.root = and;
        }
    }

    private void factor() throws BadRequestException {
        this.symbol = this.nextSymbol();
        if (this.symbol.equals(String.valueOf("not"))) {
            OperationNode not = new OperationNode("not");
            this.factor();
            not.setRightNode(this.root);
            this.root = not;
        } else if (this.symbol.equals(String.valueOf("("))) {
            this.expression();
            this.symbol = this.nextSymbol();
        } else if (!this.symbol.equals(String.valueOf(")"))) {
            ExpressionNode expressionNode = new ExpressionNode();
            this.validateAndBuildFilterExpression(this.symbol, expressionNode);
            this.root = expressionNode;
            this.symbol = this.nextSymbol();
        }
    }

    private void validateAndBuildFilterExpression(String filterString, ExpressionNode expressionNode) throws BadRequestException {
        if (!(Pattern.compile(Pattern.quote(" eq "), 2).matcher(filterString).find() || Pattern.compile(Pattern.quote(" ne "), 2).matcher(filterString).find() || Pattern.compile(Pattern.quote(" co "), 2).matcher(filterString).find() || Pattern.compile(Pattern.quote(" sw "), 2).matcher(filterString).find() || Pattern.compile(Pattern.quote(" ew "), 2).matcher(filterString).find() || Pattern.compile(Pattern.quote(" pr"), 2).matcher(filterString).find() || Pattern.compile(Pattern.quote(" gt "), 2).matcher(filterString).find() || Pattern.compile(Pattern.quote(" ge "), 2).matcher(filterString).find() || Pattern.compile(Pattern.quote(" lt "), 2).matcher(filterString).find() || Pattern.compile(Pattern.quote(" le "), 2).matcher(filterString).find())) {
            String message = "Given filter operator is not supported.";
            throw new BadRequestException(message, "InvalidFilter");
        }
        String trimmedFilter = filterString.trim();
        String[] filterParts = null;
        if (Pattern.compile(Pattern.quote(" eq "), 2).matcher(filterString).find()) {
            filterParts = trimmedFilter.split(" eq | EQ | eQ | Eq ");
            this.setExpressionNodeValues(filterParts[0], " eq ", filterParts[1], expressionNode);
        } else if (Pattern.compile(Pattern.quote(" ne "), 2).matcher(filterString).find()) {
            filterParts = trimmedFilter.split(" ne | NE | nE | Ne ");
            this.setExpressionNodeValues(filterParts[0], " ne ", filterParts[1], expressionNode);
        } else if (Pattern.compile(Pattern.quote(" co "), 2).matcher(filterString).find()) {
            filterParts = trimmedFilter.split(" co | CO | cO | Co ");
            this.setExpressionNodeValues(filterParts[0], " co ", filterParts[1], expressionNode);
        } else if (Pattern.compile(Pattern.quote(" sw "), 2).matcher(filterString).find()) {
            filterParts = trimmedFilter.split(" sw | SW | sW | Sw ");
            this.setExpressionNodeValues(filterParts[0], " sw ", filterParts[1], expressionNode);
        } else if (Pattern.compile(Pattern.quote(" ew "), 2).matcher(filterString).find()) {
            filterParts = trimmedFilter.split(" ew | EW | eW | Ew ");
            this.setExpressionNodeValues(filterParts[0], " ew ", filterParts[1], expressionNode);
        } else if (Pattern.compile(Pattern.quote(" pr"), 2).matcher(filterString).find()) {
            filterParts = trimmedFilter.split(" pr| PR| pR| Pr");
            this.setExpressionNodeValues(filterParts[0], " pr", null, expressionNode);
        } else if (Pattern.compile(Pattern.quote(" gt "), 2).matcher(filterString).find()) {
            filterParts = trimmedFilter.split(" gt | GT | gT | Gt ");
            this.setExpressionNodeValues(filterParts[0], " gt ", filterParts[1], expressionNode);
        } else if (Pattern.compile(Pattern.quote(" ge "), 2).matcher(filterString).find()) {
            filterParts = trimmedFilter.split(" ge | GE | gE | Ge ");
            this.setExpressionNodeValues(filterParts[0], " ge ", filterParts[1], expressionNode);
        } else if (Pattern.compile(Pattern.quote(" lt "), 2).matcher(filterString).find()) {
            filterParts = trimmedFilter.split(" lt | LT | lT | Lt ");
            this.setExpressionNodeValues(filterParts[0], " lt ", filterParts[1], expressionNode);
        } else if (Pattern.compile(Pattern.quote(" le "), 2).matcher(filterString).find()) {
            filterParts = trimmedFilter.split(" le | LE | lE | Le ");
            this.setExpressionNodeValues(filterParts[0], " le ", filterParts[1], expressionNode);
        } else {
            throw new BadRequestException("InvalidFilter");
        }
    }

    private void setExpressionNodeValues(String attributeValue, String operation, String value, ExpressionNode expressionNode) throws BadRequestException {
        expressionNode.setAttributeValue(AttributeUtil.getAttributeURI(attributeValue.trim(), this.schema));
        expressionNode.setOperation(operation.trim());
        if (value != null) {
            expressionNode.setValue(value.trim());
        }
    }

    public String nextSymbol() {
        if (this.tokenList.size() == 0) {
            return String.valueOf(-1);
        }
        String value = this.tokenList.get(0);
        this.tokenList.remove(0);
        return value;
    }

    private String removeStartingAndEndingQuotes(String decodedValue) {
        if (decodedValue.startsWith("\"") && decodedValue.endsWith("\"")) {
            decodedValue = decodedValue.replaceFirst("\"", "").replaceAll("\"$", "");
        } else if (decodedValue.startsWith("'") && decodedValue.endsWith("'")) {
            decodedValue = decodedValue.replaceFirst("'", "").replaceAll("'$", "");
        }
        return decodedValue;
    }
}

