/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.charon3.impl.provider.resources;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Contact;
import io.swagger.annotations.Info;
import io.swagger.annotations.License;
import io.swagger.annotations.SwaggerDefinition;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.wso2.charon3.core.exceptions.CharonException;
import org.wso2.charon3.core.exceptions.FormatNotSupportedException;
import org.wso2.charon3.core.extensions.UserManager;
import org.wso2.charon3.core.protocol.SCIMResponse;
import org.wso2.charon3.core.protocol.endpoints.UserResourceManager;
import org.wso2.charon3.impl.provider.resources.AbstractResource;
import org.wso2.charon3.utils.DefaultCharonManager;

@Api(value="scim/v2/Users")
@SwaggerDefinition(info=@Info(title="/Users Endpoint Swagger Definition", version="1.0", description="SCIM 2.0 /Users endpoint", license=@License(name="Apache 2.0", url="http://www.apache.org/licenses/LICENSE-2.0"), contact=@Contact(name="WSO2 Identity Server Team", email="vindula@wso2.com", url="http://wso2.com")))
@Path(value="/scim/v2/Users")
public class UserResource
extends AbstractResource {
    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json", "application/scim+json"})
    @ApiOperation(value="Return the user with the given id", notes="Returns HTTP 200 if the user is found.")
    @ApiResponses(value={@ApiResponse(code=200, message="Valid user is found"), @ApiResponse(code=404, message="Valid user is not found")})
    public Response getUser(@ApiParam(value="Unique id of the resource type.", required=true) @PathParam(value="id") String id, @ApiParam(value="SCIM defined attributes parameter.", required=false) @QueryParam(value="attributes") String attribute, @ApiParam(value="SCIM defined excludedAttribute parameter.", required=false) @QueryParam(value="excludedAttributes") String excludedAttributes) throws FormatNotSupportedException, CharonException {
        try {
            UserManager userManager = DefaultCharonManager.getInstance().getUserManager();
            UserResourceManager userResourceManager = new UserResourceManager();
            SCIMResponse scimResponse = userResourceManager.get(id, userManager, attribute, excludedAttributes);
            return this.buildResponse(scimResponse);
        }
        catch (CharonException e) {
            throw new CharonException(e.getDetail(), (Throwable)e);
        }
    }

    @ApiOperation(value="Return the user which was created", notes="Returns HTTP 201 if the user is successfully created.")
    @POST
    @Produces(value={"application/json", "application/scim+json"})
    @Consumes(value={"application/scim+json"})
    @ApiResponses(value={@ApiResponse(code=201, message="Valid user is created"), @ApiResponse(code=404, message="User is not found")})
    public Response createUser(@ApiParam(value="SCIM defined attributes parameter.", required=false) @QueryParam(value="attributes") String attribute, @ApiParam(value="SCIM defined excludedAttribute parameter.", required=false) @QueryParam(value="excludedAttributes") String excludedAttributes, String resourceString) throws CharonException, FormatNotSupportedException {
        try {
            UserManager userManager = DefaultCharonManager.getInstance().getUserManager();
            UserResourceManager userResourceManager = new UserResourceManager();
            SCIMResponse response = userResourceManager.create(resourceString, userManager, attribute, excludedAttributes);
            return this.buildResponse(response);
        }
        catch (CharonException e) {
            throw new CharonException(e.getDetail(), (Throwable)e);
        }
    }

    @DELETE
    @Path(value="/{id}")
    @Produces(value={"application/json", "application/scim+json"})
    @ApiOperation(value="Delete the user with the given id", notes="Returns HTTP 204 if the user is successfully deleted.")
    @ApiResponses(value={@ApiResponse(code=204, message="User is deleted"), @ApiResponse(code=404, message="Valid user is not found")})
    public Response deleteUser(@ApiParam(value="Unique id of the resource type.", required=true) @PathParam(value="id") String id) throws FormatNotSupportedException, CharonException {
        try {
            UserManager userManager = DefaultCharonManager.getInstance().getUserManager();
            UserResourceManager userResourceManager = new UserResourceManager();
            SCIMResponse scimResponse = userResourceManager.delete(id, userManager);
            return this.buildResponse(scimResponse);
        }
        catch (CharonException e) {
            throw new CharonException(e.getDetail(), (Throwable)e);
        }
    }

    @GET
    @Produces(value={"application/json", "application/scim+json"})
    @ApiOperation(value="Return users according to the filter, sort and pagination parameters", notes="Returns HTTP 404 if the users are not found.")
    @ApiResponses(value={@ApiResponse(code=200, message="Valid users are found"), @ApiResponse(code=404, message="Valid users are not found")})
    public Response getUser(@ApiParam(value="SCIM defined attributes parameter.", required=false) @QueryParam(value="attributes") String attribute, @ApiParam(value="SCIM defined excludedAttribute parameter.", required=false) @QueryParam(value="excludedAttributes") String excludedAttributes, @ApiParam(value="Filter expression for filtering", required=false) @QueryParam(value="filter") String filter, @ApiParam(value="The 1-based index of the first query result", required=false) @QueryParam(value="startIndex") int startIndex, @ApiParam(value="Specifies the desired maximum number of query results per page.", required=false) @QueryParam(value="count") int count, @ApiParam(value="Specifies the attribute whose value\nSHALL be used to order the returned responses", required=false) @QueryParam(value="sortBy") String sortBy, @ApiParam(value="The order in which the \"sortBy\" parameter is applied.", required=false) @QueryParam(value="sortOder") String sortOrder) throws FormatNotSupportedException, CharonException {
        try {
            UserManager userManager = DefaultCharonManager.getInstance().getUserManager();
            UserResourceManager userResourceManager = new UserResourceManager();
            SCIMResponse scimResponse = userResourceManager.listWithGET(userManager, filter, startIndex, count, sortBy, sortOrder, attribute, excludedAttributes);
            return this.buildResponse(scimResponse);
        }
        catch (CharonException e) {
            throw new CharonException(e.getDetail(), (Throwable)e);
        }
    }

    @POST
    @Path(value="/.search")
    @Produces(value={"application/json", "application/scim+json"})
    @Consumes(value={"application/scim+json"})
    @ApiOperation(value="Return users according to the filter, sort and pagination parameters", notes="Returns HTTP 404 if the users are not found.")
    @ApiResponses(value={@ApiResponse(code=200, message="Valid users are found"), @ApiResponse(code=404, message="Valid users are not found")})
    public Response getUsersByPost(String resourceString) throws FormatNotSupportedException, CharonException {
        try {
            UserManager userManager = DefaultCharonManager.getInstance().getUserManager();
            UserResourceManager userResourceManager = new UserResourceManager();
            SCIMResponse scimResponse = userResourceManager.listWithPOST(resourceString, userManager);
            return this.buildResponse(scimResponse);
        }
        catch (CharonException e) {
            throw new CharonException(e.getDetail(), (Throwable)e);
        }
    }

    @PUT
    @Path(value="{id}")
    @Produces(value={"application/json", "application/scim+json"})
    @Consumes(value={"application/scim+json"})
    @ApiOperation(value="Return the updated user", notes="Returns HTTP 404 if the user is not found.")
    @ApiResponses(value={@ApiResponse(code=200, message="User is updated"), @ApiResponse(code=404, message="Valid user is not found")})
    public Response updateUser(@ApiParam(value="Unique id of the resource type.", required=true) @PathParam(value="id") String id, @ApiParam(value="SCIM defined attributes parameter.", required=false) @QueryParam(value="attributes") String attribute, @ApiParam(value="SCIM defined excludedAttribute parameter.", required=false) @QueryParam(value="excludedAttributes") String excludedAttributes, String resourceString) throws FormatNotSupportedException, CharonException {
        try {
            UserManager userManager = DefaultCharonManager.getInstance().getUserManager();
            UserResourceManager userResourceManager = new UserResourceManager();
            SCIMResponse response = userResourceManager.updateWithPUT(id, resourceString, userManager, attribute, excludedAttributes);
            return this.buildResponse(response);
        }
        catch (CharonException e) {
            throw new CharonException(e.getDetail(), (Throwable)e);
        }
    }
}

