/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.charon3.impl.provider.resources;

import java.util.Map;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.charon3.core.encoder.JSONEncoder;
import org.wso2.charon3.core.exceptions.AbstractCharonException;
import org.wso2.charon3.core.exceptions.CharonException;
import org.wso2.charon3.core.exceptions.FormatNotSupportedException;
import org.wso2.charon3.core.protocol.SCIMResponse;
import org.wso2.charon3.core.protocol.endpoints.AbstractResourceManager;
import org.wso2.msf4j.Microservice;

public class AbstractResource
implements Microservice {
    private static Logger logger = LoggerFactory.getLogger(AbstractResource.class);

    public boolean isValidOutputFormat(String format) {
        return format == null || "*/*".equals(format) || format.equalsIgnoreCase("application/json") || format.equalsIgnoreCase("application/scim+json");
    }

    public boolean isValidInputFormat(String format) {
        if (format == null) {
            return true;
        }
        String mediaType = format.split(";")[0];
        return "*/*".equals(mediaType) || mediaType.equalsIgnoreCase("application/json") || mediaType.equalsIgnoreCase("application/scim+json");
    }

    protected Response handleCharonException(CharonException e, JSONEncoder encoder) {
        if (logger.isDebugEnabled()) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
        return this.buildResponse(AbstractResourceManager.encodeSCIMException((AbstractCharonException)e));
    }

    protected Response handleFormatNotSupportedException(FormatNotSupportedException e) {
        if (logger.isDebugEnabled()) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
        return this.buildResponse(AbstractResourceManager.encodeSCIMException((AbstractCharonException)e));
    }

    public Response buildResponse(SCIMResponse scimResponse) {
        Response.ResponseBuilder responseBuilder = Response.status((int)scimResponse.getResponseStatus());
        Map httpHeaders = scimResponse.getHeaderParamMap();
        if (httpHeaders != null && !httpHeaders.isEmpty()) {
            for (Map.Entry entry : httpHeaders.entrySet()) {
                responseBuilder.header((String)entry.getKey(), entry.getValue());
            }
        }
        if (scimResponse.getResponseMessage() != null) {
            responseBuilder.entity((Object)scimResponse.getResponseMessage());
        }
        return responseBuilder.build();
    }
}

