/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.charon3.samples.group.sample01;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import org.apache.log4j.BasicConfigurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateGroupSample {
    private static final Logger logger = LoggerFactory.getLogger(CreateGroupSample.class);
    private static String createRequestBody = "{\n     \"schemas\": [\"urn:ietf:params:scim:schemas:core:2.0:Group\"],\n     \"displayName\": \"Doctors\",\n     \"members\": [\n       {\n         \"value\": \"e01b5773-c8f3-446d-8958-31c603b65660\",\n         \"$ref\":\n   \"https://example.com/v2/Users/2819c223-7f76-453a-919d-413861904646\",\n         \"display\": \"Babs Jensen\"\n       },\n       {\n         \"value\": \"902c246b-6245-4190-8e05-00816be7344a\",\n         \"$ref\":\n   \"https://example.com/v2/Users/902c246b-6245-4190-8e05-00816be7344a\",\n         \"display\": \"Mandy Pepperidge\"\n       }\n     ]\n     }";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        BasicConfigurator.configure();
        try {
            String inputLine;
            String url = "http://localhost:8080/scim/v2/Groups";
            URL obj = new URL(url);
            HttpURLConnection con = (HttpURLConnection)obj.openConnection();
            con.setRequestMethod("POST");
            con.setRequestProperty("Content-Type", "application/scim+json");
            con.setDoOutput(true);
            try (FilterOutputStream wr = null;){
                wr = new DataOutputStream(con.getOutputStream());
                ((DataOutputStream)wr).writeBytes(createRequestBody);
                ((DataOutputStream)wr).flush();
                wr.close();
            }
            int responseCode = con.getResponseCode();
            BufferedReader in = responseCode == 201 ? new BufferedReader(new InputStreamReader(con.getInputStream(), "UTF-8")) : new BufferedReader(new InputStreamReader(con.getErrorStream(), "UTF-8"));
            StringBuffer response = new StringBuffer();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
            logger.info("Response Code : " + responseCode);
            logger.info("Response Message : " + con.getResponseMessage());
            logger.info("Response Content : " + response.toString());
        }
        catch (ProtocolException e) {
            logger.error(e.getMessage());
        }
        catch (MalformedURLException e) {
            logger.error(e.getMessage());
        }
        catch (IOException e) {
            logger.error(e.getMessage());
        }
    }
}

