/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.charon3.utils;

import java.util.HashMap;
import java.util.Map;
import org.wso2.charon3.core.encoder.JSONDecoder;
import org.wso2.charon3.core.encoder.JSONEncoder;
import org.wso2.charon3.core.exceptions.CharonException;
import org.wso2.charon3.core.exceptions.FormatNotSupportedException;
import org.wso2.charon3.core.extensions.UserManager;
import org.wso2.charon3.core.protocol.endpoints.AbstractResourceManager;
import org.wso2.charon3.utils.usermanager.InMemoryUserManager;

public class DefaultCharonManager {
    private static volatile DefaultCharonManager defaultCharonManager;
    private static Map<String, String> endpointURLs;
    private static UserManager userManager;
    private static JSONDecoder jsonDecoder;
    private static JSONEncoder jsonEncoder;
    private static final String USERS_URL = "http://localhost:8080/scim/Users";
    private static final String GROUPS_URL = "http://localhost:8080/scim/Groups";

    private void init() throws CharonException {
        endpointURLs.put("/Users", USERS_URL);
        endpointURLs.put("/Groups", GROUPS_URL);
        this.registerEndpointURLs();
    }

    private DefaultCharonManager() throws CharonException {
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DefaultCharonManager getInstance() throws CharonException {
        if (defaultCharonManager == null) {
            Class<DefaultCharonManager> clazz = DefaultCharonManager.class;
            synchronized (DefaultCharonManager.class) {
                if (defaultCharonManager == null) {
                    defaultCharonManager = new DefaultCharonManager();
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return defaultCharonManager;
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return defaultCharonManager;
            }
        }
        return defaultCharonManager;
    }

    public JSONDecoder getDecoder() throws FormatNotSupportedException {
        return jsonDecoder;
    }

    public JSONEncoder getEncoder() throws FormatNotSupportedException {
        return jsonEncoder;
    }

    public UserManager getUserManager() throws CharonException {
        return userManager;
    }

    private void registerEndpointURLs() {
        if (endpointURLs != null && endpointURLs.size() != 0) {
            AbstractResourceManager.setEndpointURLMap(endpointURLs);
        }
    }

    static {
        endpointURLs = new HashMap<String, String>();
        userManager = new InMemoryUserManager();
        jsonDecoder = new JSONDecoder();
        jsonEncoder = new JSONEncoder();
    }
}

