/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.charon3.utils.usermanager;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.charon3.core.exceptions.BadRequestException;
import org.wso2.charon3.core.exceptions.CharonException;
import org.wso2.charon3.core.exceptions.ConflictException;
import org.wso2.charon3.core.exceptions.NotFoundException;
import org.wso2.charon3.core.exceptions.NotImplementedException;
import org.wso2.charon3.core.extensions.UserManager;
import org.wso2.charon3.core.objects.Group;
import org.wso2.charon3.core.objects.User;
import org.wso2.charon3.core.objects.plainobjects.GroupsGetResponse;
import org.wso2.charon3.core.objects.plainobjects.UsersGetResponse;
import org.wso2.charon3.core.utils.CopyUtil;
import org.wso2.charon3.core.utils.codeutils.Node;
import org.wso2.charon3.core.utils.codeutils.SearchRequest;

public class InMemoryUserManager
implements UserManager {
    private static final Logger logger = LoggerFactory.getLogger(InMemoryUserManager.class);
    ConcurrentHashMap<String, User> inMemoryUserList = new ConcurrentHashMap();
    ConcurrentHashMap<String, Group> inMemoryGroupList = new ConcurrentHashMap();

    public User createUser(User user, Map<String, Boolean> map) throws CharonException, ConflictException, BadRequestException {
        if (this.inMemoryUserList.get(user.getId()) != null) {
            throw new ConflictException("User with the id : " + user.getId() + "already exists");
        }
        this.inMemoryUserList.put(user.getId(), user);
        return (User)CopyUtil.deepCopy((Object)user);
    }

    public User getUser(String id, Map<String, Boolean> map) throws CharonException, BadRequestException, NotFoundException {
        if (this.inMemoryUserList.get(id) != null) {
            return (User)CopyUtil.deepCopy((Object)this.inMemoryUserList.get(id));
        }
        throw new NotFoundException("No user with the id : " + id);
    }

    public void deleteUser(String id) throws NotFoundException, CharonException, NotImplementedException, BadRequestException {
        if (this.inMemoryUserList.get(id) == null) {
            throw new NotFoundException("No user with the id : " + id);
        }
        this.inMemoryUserList.remove(id);
    }

    public UsersGetResponse listUsersWithGET(Node rootNode, int startIndex, int count, String sortBy, String sortOrder, String domainName, Map<String, Boolean> requiredAttributes) throws CharonException, NotImplementedException, BadRequestException {
        if (sortBy != null || sortOrder != null) {
            throw new NotImplementedException("Sorting is not supported");
        }
        if (startIndex != 1) {
            throw new NotImplementedException("Pagination is not supported");
        }
        if (rootNode != null) {
            throw new NotImplementedException("Filtering is not supported");
        }
        return this.listUsers(requiredAttributes);
    }

    private UsersGetResponse listUsers(Map<String, Boolean> requiredAttributes) throws CharonException {
        ArrayList<User> userList = new ArrayList<User>();
        for (Map.Entry<String, User> entry : this.inMemoryUserList.entrySet()) {
            userList.add(entry.getValue());
        }
        return new UsersGetResponse(userList.size(), userList);
    }

    public UsersGetResponse listUsersWithPost(SearchRequest searchRequest, Map<String, Boolean> requiredAttributes) throws CharonException, NotImplementedException, BadRequestException {
        return this.listUsersWithGET(searchRequest.getFilter(), searchRequest.getStartIndex(), searchRequest.getCount(), searchRequest.getSortBy(), searchRequest.getSortOder(), searchRequest.getDomainName(), requiredAttributes);
    }

    public User updateUser(User user, Map<String, Boolean> map) throws NotImplementedException, CharonException, BadRequestException, NotFoundException {
        if (user.getId() != null) {
            this.inMemoryUserList.replace(user.getId(), user);
            return (User)CopyUtil.deepCopy((Object)user);
        }
        throw new NotFoundException("No user with the id : " + user.getId());
    }

    public User updateUser(User user, Map<String, Boolean> requiredAttributes, List<String> allSimpleMultiValuedAttributes) throws CharonException, BadRequestException, NotFoundException {
        if (StringUtils.isEmpty((String)user.getId())) {
            throw new NotFoundException("No user found. User id is empty.");
        }
        this.inMemoryUserList.replace(user.getId(), user);
        return (User)CopyUtil.deepCopy((Object)user);
    }

    public User getMe(String s, Map<String, Boolean> map) throws CharonException, BadRequestException, NotFoundException {
        return null;
    }

    public User createMe(User user, Map<String, Boolean> map) throws CharonException, ConflictException, BadRequestException {
        return null;
    }

    public void deleteMe(String s) throws NotFoundException, CharonException, NotImplementedException, BadRequestException {
    }

    public User updateMe(User user, Map<String, Boolean> map) throws NotImplementedException, CharonException, BadRequestException, NotFoundException {
        return null;
    }

    public Group createGroup(Group group, Map<String, Boolean> map) throws CharonException, ConflictException, NotImplementedException, BadRequestException {
        this.inMemoryGroupList.put(group.getId(), group);
        return (Group)CopyUtil.deepCopy((Object)group);
    }

    public Group getGroup(String id, Map<String, Boolean> map) throws NotImplementedException, BadRequestException, CharonException, NotFoundException {
        if (this.inMemoryGroupList.get(id) != null) {
            return (Group)CopyUtil.deepCopy((Object)this.inMemoryGroupList.get(id));
        }
        throw new NotFoundException("No user with the id : " + id);
    }

    public void deleteGroup(String id) throws NotFoundException, CharonException, NotImplementedException, BadRequestException {
        if (this.inMemoryGroupList.get(id) == null) {
            throw new NotFoundException("No user with the id : " + id);
        }
        this.inMemoryGroupList.remove(id);
    }

    public GroupsGetResponse listGroupsWithGET(Node rootNode, int startIndex, int count, String sortBy, String sortOrder, String domainName, Map<String, Boolean> requiredAttributes) throws CharonException, NotImplementedException, BadRequestException {
        if (sortBy != null || sortOrder != null) {
            throw new NotImplementedException("Sorting is not supported");
        }
        if (startIndex != 1) {
            throw new NotImplementedException("Pagination is not supported");
        }
        if (rootNode != null) {
            throw new NotImplementedException("Filtering is not supported");
        }
        return this.listGroups(requiredAttributes);
    }

    private GroupsGetResponse listGroups(Map<String, Boolean> requiredAttributes) {
        ArrayList<Group> groupList = new ArrayList<Group>();
        for (Group group : this.inMemoryGroupList.values()) {
            groupList.add(group);
        }
        return new GroupsGetResponse(groupList.size(), groupList);
    }

    public Group updateGroup(Group group, Group group1, Map<String, Boolean> map) throws NotImplementedException, BadRequestException, CharonException, NotFoundException {
        if (group.getId() != null) {
            this.inMemoryGroupList.replace(group.getId(), group);
            return (Group)CopyUtil.deepCopy((Object)group);
        }
        throw new NotFoundException("No user with the id : " + group.getId());
    }

    public GroupsGetResponse listGroupsWithPost(SearchRequest searchRequest, Map<String, Boolean> requiredAttributes) throws NotImplementedException, BadRequestException, CharonException {
        return this.listGroupsWithGET(searchRequest.getFilter(), searchRequest.getStartIndex(), searchRequest.getCount(), searchRequest.getSortBy(), searchRequest.getSortOder(), searchRequest.getDomainName(), requiredAttributes);
    }
}

