/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ciphertool;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.crypto.Cipher;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.ciphertool.exception.CipherToolException;
import org.wso2.ciphertool.utils.KeyStoreUtil;
import org.wso2.ciphertool.utils.Utils;
import org.xml.sax.SAXException;

public class CipherTool {
    private static Map<String, String> configFileXpathMap = new HashMap<String, String>();
    private static Map<String, String> aliasPasswordMap = new HashMap<String, String>();

    public static void main(String[] args) {
        CipherTool.initialize(args);
        Cipher cipher = KeyStoreUtil.initializeCipher();
        if (System.getProperty("configure") != null && System.getProperty("configure").equals("true")) {
            File deploymentTomlFile = new File(Utils.getDeploymentFilePath());
            if (deploymentTomlFile.exists()) {
                Map<String, String> secretMap = Utils.getSecreteFromConfiguration(Utils.getDeploymentFilePath());
                for (Map.Entry<String, String> entry : secretMap.entrySet()) {
                    String key = entry.getKey();
                    String value = Utils.getUnEncryptedValue(entry.getValue());
                    if (!StringUtils.isNotEmpty((CharSequence)value)) continue;
                    String encryptedValue = Utils.doEncryption(cipher, value);
                    secretMap.replace(key, encryptedValue);
                }
                CipherTool.updateDeploymentConfigurationWithEncryptedKeys(secretMap);
            } else {
                CipherTool.loadXpathValuesAndPasswordDetails();
                CipherTool.secureVaultConfigTokens();
                CipherTool.encryptCipherTextFile(cipher);
            }
            Utils.writeToSecureConfPropertyFile();
        } else if (System.getProperty("change") != null && System.getProperty("change").equals("true")) {
            CipherTool.changePassword(cipher);
        } else {
            CipherTool.encryptedValue(cipher);
        }
    }

    private static void initialize(String[] args) {
        for (String arg : args) {
            String propertyName;
            if (arg.equals("-help")) {
                CipherTool.printHelp();
                System.exit(0);
                continue;
            }
            if (!arg.substring(0, 2).equals("-D")) continue;
            String property = propertyName = arg.substring(2);
            String value = null;
            int index = property.indexOf("=");
            if (index != -1) {
                propertyName = property.substring(0, index);
                value = property.substring(index + 1);
            }
            if ("configure".equals(propertyName)) {
                System.setProperty(property, "true");
                continue;
            }
            if ("change".equals(propertyName)) {
                System.setProperty(property, "true");
                continue;
            }
            if ("org.wso2.CipherTransformation".equals(propertyName)) {
                if (!StringUtils.isBlank((CharSequence)value)) {
                    System.setProperty("org.wso2.CipherTransformation", value);
                    continue;
                }
                System.out.println("Invalid transformation algorithm provided. The default transformation algorithm (RSA) will be used");
                continue;
            }
            if (propertyName.length() >= 8 && "password".equals(propertyName.substring(0, 8))) {
                System.setProperty("keystore.password", property.substring(9));
                continue;
            }
            System.out.println("This option is not defined!");
            System.exit(-1);
        }
        Utils.setSystemProperties();
    }

    private static void printHelp() {
        System.out.println("\n---------Cipher Tool Help---------\n");
        System.out.println("By default, CipherTool can be used for creating encrypted value for given plain text using RSA algorithm\n");
        System.out.println("Options :\n");
        System.out.println("\t-Dconfigure\t\t This option would allow user to secure plain text passwords in carbon configuration files. CipherTool will replace all the passwords listed in cipher-text.properties file with encrypted values and modify related password elements in the configuration files with secret alias names. Also secret-conf.properties file is modified with the default configuration data");
        System.out.println("\t-Dchange\t\t This option would allow user to change the specific password which has been secured\n");
        System.out.println("\t-Dpassword=<password>\t This option would allow user to provide the password as a command line argument. NOTE: Providing the password in command line arguments list is not recommended.\n");
        System.out.println("\t-Dorg.wso2.CipherTransformation=<Transformation algorithm>\t This option would allow user to encrypt plain text using the given transformation algorithm. Ex: -Dorg.wso2.CipherTransformation=RSA/ECB/OAEPwithSHA1andMGF1Padding\n");
    }

    private static void encryptedValue(Cipher cipher) {
        String firstPassword = Utils.getValueFromConsole("Enter Plain Text Value : ", true);
        String secondPassword = Utils.getValueFromConsole("Please Enter Value Again : ", true);
        if (firstPassword.isEmpty() || !firstPassword.equals(secondPassword)) {
            throw new CipherToolException("Error : Password does not match");
        }
        String encryptedText = Utils.doEncryption(cipher, firstPassword);
        System.out.println("\nEncrypted value is : \n" + encryptedText + "\n");
    }

    private static void loadXpathValuesAndPasswordDetails() {
        Properties cipherToolProperties = Utils.loadProperties(System.getProperty("cipher.tool.properties.file"));
        for (Object key : cipherToolProperties.keySet()) {
            String passwordAlias = (String)key;
            configFileXpathMap.put(passwordAlias, cipherToolProperties.getProperty(passwordAlias));
        }
        Properties cipherTextProperties = Utils.loadProperties(System.getProperty("cipher.text.properties.file"));
        for (Object key : cipherTextProperties.keySet()) {
            String passwordAlias = (String)key;
            aliasPasswordMap.put(passwordAlias, cipherTextProperties.getProperty(passwordAlias));
        }
    }

    private static void secureVaultConfigTokens() {
        for (Map.Entry<String, String> entry : configFileXpathMap.entrySet()) {
            String XPath;
            String unprocessedXpath = entry.getValue();
            String encryptParamKey = "";
            int endofFilePath = unprocessedXpath.indexOf("//");
            if (endofFilePath < 0) {
                throw new CipherToolException("XPath is not defined for " + entry.getKey());
            }
            String fileName = unprocessedXpath.substring(0, endofFilePath);
            if (unprocessedXpath.indexOf(",") > 0) {
                if (unprocessedXpath.substring(unprocessedXpath.indexOf(",") + 1).trim().equals("true") && unprocessedXpath.charAt(unprocessedXpath.indexOf(",") - 1) == ']') {
                    encryptParamKey = unprocessedXpath.substring(unprocessedXpath.lastIndexOf(91) + 2, unprocessedXpath.indexOf(",") - 1);
                }
                XPath = unprocessedXpath.substring(endofFilePath, unprocessedXpath.indexOf(","));
            } else {
                XPath = unprocessedXpath.substring(endofFilePath);
            }
            CipherTool.tokenToConfigFile(fileName, XPath, entry.getKey(), encryptParamKey);
        }
    }

    private static void tokenToConfigFile(String fileName, String xPath, String secretAlias, String encryptParamKey) {
        if (xPath != null && !xPath.equals("") && secretAlias != null && !secretAlias.equals("")) {
            String filePath = Utils.getConfigFilePath(fileName);
            try {
                DocumentBuilder docBuilder = Utils.getSecuredDocumentBuilder(false);
                Document doc = docBuilder.parse(filePath);
                Element rootNode = doc.getDocumentElement();
                Attr secretNamespaceNode = doc.createAttribute("xmlns:svns");
                secretNamespaceNode.setTextContent("http://org.wso2.securevault/configuration");
                rootNode.getAttributes().setNamedItem(secretNamespaceNode);
                Attr secretProviderNode = doc.createAttribute("provider");
                secretProviderNode.setTextContent("org.wso2.securevault.secret.handler.SecretManagerSecretCallbackHandler");
                XPathFactory xpf = XPathFactory.newInstance();
                XPath xp = xpf.newXPath();
                XPathExpression xpathEx = xp.compile(xPath);
                NodeList securedNodes = (NodeList)xpathEx.evaluate(doc.getDocumentElement(), XPathConstants.NODESET);
                if (securedNodes != null && securedNodes.getLength() > 0) {
                    for (int i = 0; i < securedNodes.getLength(); ++i) {
                        Attr secretAliasNode = doc.createAttribute("svns:secretAlias");
                        secretAliasNode.setTextContent(secretAlias);
                        Node node = securedNodes.item(i);
                        if (node == null) continue;
                        if (!encryptParamKey.isEmpty()) {
                            node.getAttributes().getNamedItem(encryptParamKey).setNodeValue("password");
                        } else {
                            node.setTextContent("password");
                        }
                        node.getAttributes().setNamedItem(secretAliasNode);
                    }
                } else {
                    throw new CipherToolException("Element for secret alias '" + secretAlias + "' can not be found in " + fileName + " file or You have entered invalid Xpath value");
                }
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                Transformer transformer = transformerFactory.newTransformer();
                DOMSource source = new DOMSource(doc);
                StreamResult result = new StreamResult(new File(filePath));
                transformer.transform(source, result);
            }
            catch (ParserConfigurationException e) {
                throw new CipherToolException("Error writing protected token [" + secretAlias + "] to " + fileName + " file ", e);
            }
            catch (XPathExpressionException e) {
                throw new CipherToolException("Error writing protected token  [" + secretAlias + "] to " + fileName + " file ", e);
            }
            catch (TransformerException e) {
                throw new CipherToolException("Error writing protected token [" + secretAlias + "] to " + fileName + " file ", e);
            }
            catch (SAXException e) {
                throw new CipherToolException("Error writing protected token  [" + secretAlias + "] to " + fileName + " file ", e);
            }
            catch (IOException e) {
                throw new CipherToolException("Error writing protected token  [" + secretAlias + "] to " + fileName + " file ", e);
            }
            System.out.println("Protected Token [" + secretAlias + "] is updated in " + fileName + " successfully\n");
        }
    }

    private static void encryptCipherTextFile(Cipher cipher) {
        Properties properties = new Properties();
        for (Map.Entry<String, String> entry : aliasPasswordMap.entrySet()) {
            String value = entry.getValue();
            if (value != null && !value.equals("")) {
                if (value.contains("[") && value.indexOf("]") > 0) {
                    value = value.substring(value.indexOf("[") + 1, value.indexOf("]"));
                    value = Utils.doEncryption(cipher, value);
                }
            } else {
                value = CipherTool.getPasswordFromConsole(entry.getKey(), cipher);
            }
            properties.setProperty(entry.getKey(), value);
        }
        Utils.writeToPropertyFile(properties, System.getProperty("cipher.text.properties.file"));
    }

    private static String getPasswordFromConsole(String key, Cipher cipher) {
        String firstPassword = Utils.getValueFromConsole("Enter Password of Secret Alias - '" + key + "' : ", true);
        String secondPassword = Utils.getValueFromConsole("Please Enter Password Again : ", true);
        if (!firstPassword.isEmpty() && firstPassword.equals(secondPassword)) {
            String encryptedValue = Utils.doEncryption(cipher, firstPassword);
            aliasPasswordMap.put(key, encryptedValue);
            return encryptedValue;
        }
        throw new CipherToolException("Error : Password does not match");
    }

    private static void changePassword(Cipher cipher) {
        String value;
        Properties cipherTextProperties = Utils.loadProperties(System.getProperty("cipher.text.properties.file"));
        ArrayList<String> keyValueList = new ArrayList<String>();
        int i = 1;
        for (Object key : cipherTextProperties.keySet()) {
            String passwordAlias = (String)key;
            aliasPasswordMap.put(passwordAlias, cipherTextProperties.getProperty(passwordAlias));
            keyValueList.add(passwordAlias);
            System.out.println("[" + i++ + "] " + passwordAlias);
        }
        boolean isModified = false;
        while (!(value = Utils.getValueFromConsole("Please enter the Number which is corresponding to the Password that is needed be changed [Press Enter to Skip] : ", false)).isEmpty()) {
            if (value.trim().equals("")) continue;
            String selectedPasswordAlias = (String)keyValueList.get(Integer.parseInt(value.trim()) - 1);
            String newEncryptedValue = CipherTool.getPasswordFromConsole(selectedPasswordAlias, cipher);
            aliasPasswordMap.put(selectedPasswordAlias, newEncryptedValue);
            isModified = true;
        }
        if (isModified) {
            cipherTextProperties.putAll(aliasPasswordMap);
            Utils.writeToPropertyFile(cipherTextProperties, System.getProperty("cipher.text.properties.file"));
            File deploymentTomlFile = new File(Utils.getDeploymentFilePath());
            if (deploymentTomlFile.exists()) {
                Map<String, String> secretMap = Utils.getSecreteFromConfiguration(Utils.getDeploymentFilePath());
                for (Map.Entry<String, String> entry : secretMap.entrySet()) {
                    String encryptedValue = cipherTextProperties.getProperty(entry.getKey());
                    String key = entry.getKey();
                    if (!StringUtils.isNotEmpty((CharSequence)encryptedValue)) continue;
                    secretMap.replace(key, encryptedValue);
                }
                CipherTool.updateDeploymentConfigurationWithEncryptedKeys(secretMap);
            }
        }
    }

    private static void updateDeploymentConfigurationWithEncryptedKeys(Map<String, String> encryptedKeyMap) throws CipherToolException {
        try {
            List<String> lines = Files.readAllLines(Paths.get(Utils.getDeploymentFilePath(), new String[0]));
            try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(Utils.getDeploymentFilePath()), StandardCharsets.UTF_8));){
                boolean found = false;
                for (String line : lines) {
                    if (found) {
                        if (line.matches("\\[.+\\]")) {
                            found = false;
                        } else {
                            StringTokenizer stringTokenizer = new StringTokenizer(line, "=");
                            if (stringTokenizer.hasMoreTokens()) {
                                String key = stringTokenizer.nextToken();
                                String value = encryptedKeyMap.get(key.trim());
                                line = key.concat(" = \"").concat(value).concat("\"");
                            }
                        }
                    } else if ("[secrets]".equals(line.trim())) {
                        found = true;
                    }
                    bufferedWriter.write(line);
                    bufferedWriter.newLine();
                }
                bufferedWriter.flush();
            }
        }
        catch (IOException e) {
            throw new CipherToolException("Error while writing encrypted values into deployment file", e);
        }
    }
}

