/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ciphertool.utils;

import java.io.Console;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.xml.bind.DatatypeConverter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.consensys.cava.toml.Toml;
import net.consensys.cava.toml.TomlParseResult;
import net.consensys.cava.toml.TomlTable;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.wso2.ciphertool.exception.CipherToolException;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Utils {
    private static boolean primaryKeyStore = true;

    public static String getValueFromConsole(String msg, boolean isPassword) {
        Console console = System.console();
        if (console != null) {
            if (isPassword) {
                char[] password = console.readPassword("[%s]", msg);
                if (password != null) {
                    return String.valueOf(password);
                }
            } else {
                String value = console.readLine("[%s]", msg);
                if (value != null) {
                    return value;
                }
            }
        }
        throw new CipherToolException("String cannot be null");
    }

    public static Properties loadProperties(String filePath) {
        Properties properties = new Properties();
        File file = new File(filePath);
        if (!file.exists()) {
            return properties;
        }
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            properties.load(inputStream);
        }
        catch (IOException e) {
            String msg = "Error loading properties from a file at :" + filePath;
            throw new CipherToolException(msg + " Error : " + e.getMessage());
        }
        finally {
            if (inputStream != null) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (IOException e) {
                    System.err.println("Error while closing input stream");
                }
            }
        }
        return properties;
    }

    public static String getConfigFilePath(String fileName) {
        Path filePath;
        String homeFolder = System.getProperty("home.folder");
        if (fileName.startsWith(homeFolder)) {
            fileName = fileName.substring(homeFolder.length(), fileName.length());
        }
        if (!Files.exists(filePath = Paths.get(homeFolder, fileName), new LinkOption[0]) && !Files.exists(filePath = Paths.get(fileName, new String[0]), new LinkOption[0])) {
            throw new CipherToolException("Cannot find file : " + fileName);
        }
        return filePath.toAbsolutePath().toString();
    }

    public static void writeToPropertyFile(Properties properties, String filePath) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(filePath);
            properties.store(fileOutputStream, null);
        }
        catch (IOException e) {
            String msg = "Error loading properties from a file at : " + filePath;
            throw new CipherToolException(msg + " Error : " + e.getMessage());
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException e) {
                System.err.println("Error while closing output stream");
            }
        }
    }

    public static String getValueFromXPath(Element element, String xPath) {
        String nodeValue = null;
        try {
            XPathFactory xpf = XPathFactory.newInstance();
            XPath xp = xpf.newXPath();
            XPathExpression xPathExpression = xp.compile(xPath);
            Node text = (Node)xPathExpression.evaluate(element, XPathConstants.NODE);
            if (text != null) {
                nodeValue = text.getTextContent();
            }
        }
        catch (XPathExpressionException e) {
            throw new CipherToolException("Error reading primary key Store details from carbon.xml file ", e);
        }
        return nodeValue;
    }

    public static void writeToSecureConfPropertyFile() {
        Properties properties = new Properties();
        String keyStoreFile = System.getProperty("primary.key.location");
        String keyType = System.getProperty("primary.key.type");
        String aliasName = System.getProperty("primary.key.alias");
        String enable = System.getProperty("secVault.enabled", "true");
        properties.setProperty("secVault.enabled", enable);
        properties.setProperty("carbon.secretProvider", "org.wso2.securevault.secret.handler.SecretManagerSecretCallbackHandler");
        properties.setProperty("secretRepositories", "file");
        properties.setProperty("secretRepositories.file.provider", "org.wso2.securevault.secret.repository.FileBaseSecretRepositoryProvider");
        properties.setProperty("secretRepositories.file.location", System.getProperty("secretRepositories.file.location"));
        properties.setProperty("keystore.identity.location", keyStoreFile);
        properties.setProperty("keystore.identity.type", keyType);
        properties.setProperty("keystore.identity.alias", aliasName);
        properties.setProperty("keystore.identity.store.password", "identity.store.password");
        properties.setProperty("keystore.identity.store.secretProvider", "org.wso2.carbon.securevault.DefaultSecretCallbackHandler");
        properties.setProperty("keystore.identity.key.password", "identity.key.password");
        properties.setProperty("keystore.identity.key.secretProvider", "org.wso2.carbon.securevault.DefaultSecretCallbackHandler");
        properties.setProperty("secretRepositories.file.algorithm", System.getProperty("org.wso2.CipherTransformation"));
        Utils.writeToPropertyFile(properties, System.getProperty("secret.conf.properties.file"));
        System.out.println("\nSecret Configurations are written to the property file successfully\n");
    }

    public static void setSystemProperties() {
        String cipherToolPropFile;
        String cipherTextPropFile;
        String secretConfFile;
        String keyAlias;
        String keyType;
        String keyStoreFile;
        String homeFolder = System.getProperty("carbon.home");
        Path path = Paths.get(homeFolder, "repository", "conf", "carbon.xml");
        boolean hasConfigInRepository = true;
        if (!Files.exists(path, new LinkOption[0])) {
            path = Paths.get(homeFolder, "conf", "carbon.xml");
            hasConfigInRepository = false;
        }
        if (Files.exists(path, new LinkOption[0])) {
            try {
                DocumentBuilder docBuilder = Utils.getSecuredDocumentBuilder(false);
                Document document = docBuilder.parse(path.toAbsolutePath().toString());
                keyStoreFile = Utils.getValueFromXPath(document.getDocumentElement(), "//Server/Security/InternalKeyStore/Location");
                if (keyStoreFile != null) {
                    keyType = Utils.getValueFromXPath(document.getDocumentElement(), "//Server/Security/InternalKeyStore/Type");
                    keyAlias = Utils.getValueFromXPath(document.getDocumentElement(), "//Server/Security/InternalKeyStore/KeyAlias");
                    primaryKeyStore = false;
                } else {
                    keyStoreFile = Utils.getValueFromXPath(document.getDocumentElement(), "//Server/Security/KeyStore/Location");
                    keyType = Utils.getValueFromXPath(document.getDocumentElement(), "//Server/Security/KeyStore/Type");
                    keyAlias = Utils.getValueFromXPath(document.getDocumentElement(), "//Server/Security/KeyStore/KeyAlias");
                }
                keyStoreFile = Utils.resolveKeyStorePath(keyStoreFile, homeFolder);
                System.setProperty("primary.key.location", keyStoreFile);
                String keyStoreName = Utils.isPrimaryKeyStore() ? "Primary" : "Internal";
                System.out.println("\nEncrypting using " + keyStoreName + " KeyStore.");
                System.out.println("{type: " + keyType + ", alias: " + keyAlias + ", path: " + keyStoreFile + "}\n");
                if (hasConfigInRepository) {
                    secretConfFile = "repository" + File.separator + "conf" + File.separator + "security" + File.separator + "secret-conf.properties";
                    cipherTextPropFile = "repository" + File.separator + "conf" + File.separator + "security" + File.separator + "cipher-text.properties";
                    cipherToolPropFile = "repository" + File.separator + "conf" + File.separator + "security" + File.separator + "cipher-tool.properties";
                } else {
                    secretConfFile = "conf" + File.separator + "security" + File.separator + "secret-conf.properties";
                    cipherTextPropFile = "conf" + File.separator + "security" + File.separator + "cipher-text.properties";
                    cipherToolPropFile = "conf" + File.separator + "security" + File.separator + "cipher-tool.properties";
                }
                secretConfFile = Paths.get(homeFolder, secretConfFile).toString();
            }
            catch (ParserConfigurationException e) {
                throw new CipherToolException("Error reading primary key Store details from carbon.xml file ", e);
            }
            catch (SAXException e) {
                throw new CipherToolException("Error reading primary key Store details from carbon.xml file ", e);
            }
            catch (IOException e) {
                throw new CipherToolException("Error reading primary key Store details from carbon.xml file ", e);
            }
        } else {
            Path standaloneConfigPath = Paths.get(homeFolder, "conf", "cipher-standalone-config.properties");
            if (!Files.exists(standaloneConfigPath, new LinkOption[0])) {
                throw new CipherToolException("File, " + standaloneConfigPath + " does not exist.");
            }
            Properties standaloneConfigProp = Utils.loadProperties(standaloneConfigPath.toAbsolutePath().toString());
            if (standaloneConfigProp.size() <= 0) {
                throw new CipherToolException("File, cipher-standalone-config.properties cannot be empty");
            }
            keyStoreFile = standaloneConfigProp.getProperty("primary.key.location");
            keyType = standaloneConfigProp.getProperty("primary.key.type");
            keyAlias = standaloneConfigProp.getProperty("primary.key.alias");
            secretConfFile = standaloneConfigProp.getProperty("secret.conf.properties.file");
            cipherTextPropFile = standaloneConfigProp.getProperty("cipher.text.properties.file");
            cipherToolPropFile = standaloneConfigProp.getProperty("cipher.tool.properties.file");
            if (!Paths.get(secretConfFile, new String[0]).isAbsolute()) {
                secretConfFile = Paths.get(homeFolder, standaloneConfigProp.getProperty("secret.conf.properties.file")).toString();
            }
        }
        if (keyStoreFile.trim().isEmpty()) {
            throw new CipherToolException("KeyStore file path cannot be empty");
        }
        if (keyAlias == null || keyAlias.trim().isEmpty()) {
            throw new CipherToolException("Key alias cannot be empty");
        }
        System.setProperty("home.folder", homeFolder);
        System.setProperty("primary.key.location", Utils.getConfigFilePath(keyStoreFile));
        System.setProperty("primary.key.type", keyType);
        System.setProperty("primary.key.alias", keyAlias);
        System.setProperty("secret.conf.properties.file", secretConfFile);
        System.setProperty("secretRepositories.file.location", cipherTextPropFile);
        System.setProperty("cipher.text.properties.file", Utils.getConfigFilePath(cipherTextPropFile));
        System.setProperty("cipher.tool.properties.file", Utils.getConfigFilePath(cipherToolPropFile));
    }

    public static boolean isPrimaryKeyStore() {
        return primaryKeyStore;
    }

    public static String resolveKeyStorePath(String keyStorePath, String homeFolder) {
        if (keyStorePath.contains("}")) {
            keyStorePath = Utils.getAbsolutePathWithCarbonHome(keyStorePath, homeFolder);
        }
        return keyStorePath;
    }

    private static String getAbsolutePathWithCarbonHome(String keyStorePath, String homeFolder) {
        return homeFolder + keyStorePath.substring(keyStorePath.indexOf(125) + 1);
    }

    public static String getDeploymentFilePath() {
        String configFilePath = System.getProperty("deployment.config.file.path");
        if (StringUtils.isEmpty((String)configFilePath)) {
            configFilePath = Paths.get(System.getProperty("carbon.config.dir.path"), "deployment.toml").toString();
        }
        return configFilePath;
    }

    public static String doEncryption(Cipher cipher, String plainTextPwd) {
        String encodedValue;
        try {
            byte[] encryptedPassword = cipher.doFinal(plainTextPwd.getBytes(Charset.forName("UTF-8")));
            encodedValue = DatatypeConverter.printBase64Binary((byte[])encryptedPassword);
        }
        catch (BadPaddingException e) {
            throw new CipherToolException("Error encrypting password ", e);
        }
        catch (IllegalBlockSizeException e) {
            throw new CipherToolException("Error encrypting password ", e);
        }
        System.out.println("\nEncryption is done Successfully\n");
        return encodedValue;
    }

    public static Map<String, String> getSecreteFromConfiguration(String configFilePath) {
        LinkedHashMap<String, String> context = new LinkedHashMap<String, String>();
        try {
            TomlParseResult result = Toml.parse((Path)Paths.get(configFilePath, new String[0]));
            if (result.hasErrors()) {
                throw new CipherToolException("Error while parsing TOML config file");
            }
            TomlTable table = result.getTable("secrets");
            if (table != null) {
                table.dottedKeySet().forEach(key -> context.put((String)key, table.getString(key)));
            }
        }
        catch (IOException e) {
            System.out.println("Error parsing file " + configFilePath + e.toString());
            return context;
        }
        return context;
    }

    public static String getUnEncryptedValue(String value) {
        String[] unEncryptedRefs = StringUtils.substringsBetween((String)value, (String)"[", (String)"]");
        if (unEncryptedRefs != null && unEncryptedRefs.length == 1) {
            return unEncryptedRefs[0];
        }
        return null;
    }

    public static DocumentBuilder getSecuredDocumentBuilder(boolean setIgnoreComments) throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setIgnoringComments(setIgnoreComments);
        documentBuilderFactory.setNamespaceAware(false);
        documentBuilderFactory.setExpandEntityReferences(false);
        documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        documentBuilder.setEntityResolver(new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                throw new SAXException("Possible XML External Entity (XXE) attack. Skip resolving entity");
            }
        });
        return documentBuilder;
    }
}

