/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ciphertool.utils;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import org.wso2.ciphertool.exception.CipherToolException;
import org.wso2.ciphertool.utils.Utils;

public class KeyStoreUtil {
    public static Cipher initializeCipher() {
        Cipher cipher;
        String keyStoreName = Utils.isPrimaryKeyStore() ? "Primary" : "Internal";
        String keyStoreFile = System.getProperty("primary.key.location");
        String keyType = System.getProperty("primary.key.type");
        String keyAlias = System.getProperty("primary.key.alias");
        String password = System.getProperty("keystore.password") != null && System.getProperty("keystore.password").length() > 0 ? System.getProperty("keystore.password") : Utils.getValueFromConsole("Please Enter " + keyStoreName + " KeyStore Password of Carbon Server : ", true);
        if (password == null) {
            throw new CipherToolException("KeyStore password can not be null");
        }
        KeyStore primaryKeyStore = KeyStoreUtil.getKeyStore(keyStoreFile, password, keyType);
        try {
            Certificate certs = primaryKeyStore.getCertificate(keyAlias);
            String cipherTransformation = System.getProperty("org.wso2.CipherTransformation");
            cipher = cipherTransformation != null ? Cipher.getInstance(cipherTransformation) : Cipher.getInstance("RSA");
            cipher.init(1, certs);
        }
        catch (KeyStoreException e) {
            throw new CipherToolException("Error initializing Cipher ", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CipherToolException("Error initializing Cipher ", e);
        }
        catch (NoSuchPaddingException e) {
            throw new CipherToolException("Error initializing Cipher ", e);
        }
        catch (InvalidKeyException e) {
            throw new CipherToolException("Error initializing Cipher ", e);
        }
        System.out.println("\n" + keyStoreName + " KeyStore of Carbon Server is initialized Successfully\n");
        return cipher;
    }

    private static KeyStore getKeyStore(String location, String storePassword, String storeType) {
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(location));
            KeyStore keyStore = KeyStore.getInstance(storeType);
            keyStore.load(bufferedInputStream, storePassword.toCharArray());
            KeyStore keyStore2 = keyStore;
            return keyStore2;
        }
        catch (KeyStoreException e) {
            throw new CipherToolException("Error loading keyStore from ' " + location + " ' ", e);
        }
        catch (IOException e) {
            throw new CipherToolException("Error loading keyStore from ' " + location + " ' ", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CipherToolException("Error loading keyStore from ' " + location + " ' ", e);
        }
        catch (CertificateException e) {
            throw new CipherToolException("Error loading keyStore from ' " + location + " ' ", e);
        }
        finally {
            if (bufferedInputStream != null) {
                try {
                    bufferedInputStream.close();
                }
                catch (IOException e) {
                    System.err.println("Error while closing input stream");
                }
            }
        }
    }
}

