/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ciphertool.userstore;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import javax.crypto.Cipher;
import org.apache.axiom.om.util.Base64;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.wso2.ciphertool.userstore.CipherHolder;
import org.wso2.ciphertool.userstore.CryptoContext;

public class Encryptor {
    private static final char[] HEX_CHARACTERS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    public static final String CRYPTO_PROVIDER_BC = "BC";
    private static final String DEFAULT_CRYPTO_ALGORITHM = "RSA";
    private static final String DIGEST_ALGORITHM = "SHA-1";

    public String encrypt(String cleartext, CryptoContext cryptoContext) throws Exception {
        Security.insertProviderAt((Provider)new BouncyCastleProvider(), 1);
        byte[] cleartextBytes = cleartext.getBytes("UTF-8");
        String cipherTransformation = cryptoContext.getAlgorithm();
        Certificate certificate = this.getCertificate(cryptoContext);
        Cipher cipher = cipherTransformation != null ? Cipher.getInstance(cipherTransformation, CRYPTO_PROVIDER_BC) : Cipher.getInstance(DEFAULT_CRYPTO_ALGORITHM, CRYPTO_PROVIDER_BC);
        cipher.init(1, certificate.getPublicKey());
        byte[] cipherText = cipher.doFinal(cleartextBytes);
        if (cipherTransformation != null) {
            cipherText = this.createSelfContainedCiphertext(cipherText, cipherTransformation, certificate);
        }
        return Base64.encode((byte[])cipherText);
    }

    private byte[] createSelfContainedCiphertext(byte[] originalCipher, String transformation, Certificate certificate) throws CertificateEncodingException, NoSuchAlgorithmException {
        CipherHolder cipherHolder = new CipherHolder();
        cipherHolder.setCipherText(Base64.encode((byte[])originalCipher));
        cipherHolder.setTransformation(transformation);
        cipherHolder.setThumbPrint(this.calculateThumbprint(certificate, DIGEST_ALGORITHM), DIGEST_ALGORITHM);
        String cipherWithMetadataStr = new Gson().toJson((Object)cipherHolder);
        return cipherWithMetadataStr.getBytes(Charset.defaultCharset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Certificate getCertificate(CryptoContext cryptoContext) throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        String filePath = cryptoContext.getKeyStorePath();
        String keyStoreType = cryptoContext.getKeyStoreType();
        String password = cryptoContext.getKeyStorePassword();
        String keyAlias = cryptoContext.getKeyAlias();
        InputStream inputStream = null;
        try {
            inputStream = new FileInputStream(new File(filePath).getAbsolutePath());
            KeyStore store = KeyStore.getInstance(keyStoreType);
            store.load(inputStream, password.toCharArray());
            Certificate certificate = store.getCertificateChain(keyAlias)[0];
            return certificate;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    private String calculateThumbprint(Certificate certificate, String digest) throws NoSuchAlgorithmException, CertificateEncodingException {
        MessageDigest messageDigest = MessageDigest.getInstance(digest);
        messageDigest.update(certificate.getEncoded());
        byte[] digestByteArray = messageDigest.digest();
        StringBuffer strBuffer = new StringBuffer();
        for (int i = 0; i < digestByteArray.length; ++i) {
            int leftNibble = (digestByteArray[i] & 0xF0) >> 4;
            int rightNibble = digestByteArray[i] & 0xF;
            strBuffer.append(HEX_CHARACTERS[leftNibble]).append(HEX_CHARACTERS[rightNibble]);
        }
        return strBuffer.toString();
    }
}

