/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ciphertool.userstore;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.wso2.ciphertool.userstore.CryptoContext;
import org.wso2.ciphertool.userstore.Encryptor;
import org.wso2.ciphertool.userstore.PasswordProcessor;

public class CryptoTool {
    public static void main(String[] args) {
        Options options = CryptoTool.buildOptions();
        if (args.length == 0) {
            CryptoTool.printHelpMessageAndExit(options);
        } else {
            CryptoTool.processInput(args, options);
        }
    }

    private static void processInput(String[] args, Options options) {
        DefaultParser parser = new DefaultParser();
        try {
            CommandLine line = parser.parse(options, args);
            String operation = line.getOptionValue("operation");
            if ("encrypt".equals(operation)) {
                String cipherText = CryptoTool.encrypt(line);
                CryptoTool.outputText(cipherText);
            } else if ("extract-password".equals(operation)) {
                String password = CryptoTool.extractPassword(line);
                CryptoTool.outputText(password);
            } else if ("replace-password".equals(operation)) {
                CryptoTool.replacePassword(line);
            } else {
                CryptoTool.printErrorAndExit(String.format("'%s' is not a valid operation type", operation));
            }
        }
        catch (Exception e) {
            CryptoTool.printErrorAndExit("An error occurred.", e);
        }
    }

    private static void replacePassword(CommandLine line) throws Exception {
        String filePath = line.getOptionValue("file");
        CryptoTool.failIfArgumentIsEmpty(filePath, "file");
        String passwordPattern = line.getOptionValue("password-pattern");
        CryptoTool.failIfArgumentIsEmpty(passwordPattern, "password-pattern");
        String newPassword = line.getOptionValue("new-password");
        CryptoTool.failIfArgumentIsEmpty(newPassword, "new-password");
        new PasswordProcessor().replacePassword(filePath, passwordPattern, newPassword);
    }

    private static String extractPassword(CommandLine line) throws Exception {
        String filePath = line.getOptionValue("file");
        CryptoTool.failIfArgumentIsEmpty(filePath, "file");
        String passwordPattern = line.getOptionValue("password-pattern");
        CryptoTool.failIfArgumentIsEmpty(passwordPattern, "password-pattern");
        String regexGroup = line.getOptionValue("regex-group");
        CryptoTool.failIfArgumentIsEmpty(regexGroup, "regex-group");
        int regexGroupNumber = Integer.parseInt(regexGroup);
        return new PasswordProcessor().getPassword(filePath, passwordPattern, regexGroupNumber);
    }

    private static String encrypt(CommandLine line) throws Exception {
        String cleartext = line.getOptionValue("cleartext");
        CryptoTool.failIfArgumentIsEmpty(cleartext, "cleartext");
        CryptoContext cryptoContext = new CryptoContext();
        String keyStorePath = line.getOptionValue("keystore");
        CryptoTool.failIfArgumentIsEmpty(keyStorePath, "keystore");
        cryptoContext.setKeyStorePath(keyStorePath);
        String keyStoreType = line.getOptionValue("keystore-type");
        CryptoTool.failIfArgumentIsEmpty(keyStoreType, "keystore-type");
        cryptoContext.setKeyStoreType(keyStoreType);
        String keyAlias = line.getOptionValue("key-alias");
        CryptoTool.failIfArgumentIsEmpty(keyAlias, "key-alias");
        cryptoContext.setKeyAlias(keyAlias);
        String keyStorePassword = line.getOptionValue("keystore-password");
        CryptoTool.failIfArgumentIsEmpty(keyStorePassword, "keystore-password");
        cryptoContext.setKeyStorePassword(keyStorePassword);
        String algorithm = line.getOptionValue("crypto-algorithm");
        CryptoTool.failIfArgumentIsEmpty(algorithm, "crypto-algorithm");
        cryptoContext.setAlgorithm(algorithm);
        String cipherText = new Encryptor().encrypt(cleartext, cryptoContext);
        return cipherText;
    }

    private static void failIfArgumentIsEmpty(String argument, String argumentName) {
        if (argument == null || argument.length() == 0) {
            throw new IllegalArgumentException(String.format("The argument '%s' can't be empty", argumentName));
        }
    }

    private static void printErrorAndExit(String errorMessage) {
        CryptoTool.printErrorAndExit(errorMessage, null);
    }

    private static void outputText(String text) {
        System.out.println(text);
    }

    private static void printErrorAndExit(String errorMessage, Exception e) {
        System.err.println(errorMessage);
        if (e != null) {
            e.printStackTrace(System.err);
        }
        System.exit(1);
    }

    private static Options buildOptions() {
        Options options = new Options();
        Option operation = Option.builder().longOpt("operation").desc("Name of the operation. (encrypt, get-password)").hasArg().argName("operation").build();
        options.addOption(operation);
        Option cleartextOption = Option.builder().longOpt("cleartext").desc("Cleartext to be encrypted").hasArg().argName("cleartext").build();
        options.addOption(cleartextOption);
        Option keyStoreFileOption = Option.builder().longOpt("keystore").desc("Path of the keystore").hasArg().argName("keystore").build();
        options.addOption(keyStoreFileOption);
        Option keyStoreTypeOption = Option.builder().longOpt("keystore-type").desc("Path of the keystore").hasArg().argName("keystore-type").build();
        options.addOption(keyStoreTypeOption);
        Option keyAliasOption = Option.builder().longOpt("key-alias").desc("Alias of the key").hasArg().argName("key-alias").build();
        options.addOption(keyAliasOption);
        Option keyStorePasswordOption = Option.builder().longOpt("keystore-password").desc("Password of the keystore").hasArg().argName("keystore-password").build();
        options.addOption(keyStorePasswordOption);
        Option cryptoAlgorithmOption = Option.builder().longOpt("crypto-algorithm").desc("Crypto algorithm").hasArg().argName("crypto-algorithm").build();
        options.addOption(cryptoAlgorithmOption);
        Option filePathOption = Option.builder().longOpt("file").desc("File path to be extracted the password from.").hasArg().argName("file").build();
        options.addOption(filePathOption);
        Option passwordPatternOption = Option.builder().longOpt("password-pattern").desc("Pattern of the password in the given file.").hasArg().argName("password-pattern").build();
        options.addOption(passwordPatternOption);
        Option regexGroupOption = Option.builder().longOpt("regex-group").desc("Regex group of the password").hasArg().argName("regex-group").build();
        options.addOption(regexGroupOption);
        Option newPasswordOption = Option.builder().longOpt("new-password").desc("New password (encrypted) to be replaced with.").hasArg().argName("new-password").build();
        options.addOption(newPasswordOption);
        return options;
    }

    private static void printHelpMessageAndExit(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("Usage", options);
        System.exit(0);
    }
}

