/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ei.b7a.jms;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.ballerinalang.compiler.plugins.SupportedResourceParamTypes;
import org.ballerinalang.model.tree.AnnotationAttachmentNode;
import org.ballerinalang.model.tree.FunctionNode;
import org.ballerinalang.model.tree.ServiceNode;
import org.ballerinalang.util.diagnostic.Diagnostic;
import org.ballerinalang.util.diagnostic.DiagnosticLog;
import org.wso2.ballerinalang.compiler.tree.BLangFunction;
import org.wso2.ballerinalang.compiler.tree.BLangSimpleVariable;
import org.wso2.ballerinalang.util.AbstractTransportCompilerPlugin;

@SupportedResourceParamTypes(expectedListenerType=@SupportedResourceParamTypes.Type(orgName="wso2", packageName="jms", name="MessageListener"), paramTypes={@SupportedResourceParamTypes.Type(orgName="wso2", packageName="jms", name="Message")})
public class ServiceCompilerPlugin
extends AbstractTransportCompilerPlugin {
    private static final String PACKAGE_NAME = "wso2/jms";
    private static final String VERSION = "0.6.3";
    private static final String PACKAGE_NAME_WITH_VERSION = "wso2/jms:0.6.3";
    private static final String MESSAGE_NAME = "Message";
    private static final String TEXT_MESSAGE_NAME = "TextMessage";
    private static final String MAP_MESSAGE_NAME = "MapMessage";
    private static final String STREAM_MESSAGE_NAME = "StreamMessage";
    private static final String BYTES_MESSAGE_NAME = "BytesMessage";
    private static final String RESOURCE_NAME_ON_MESSAGE = "onMessage";
    private static final String RESOURCE_NAME_ON_TEXT_MESSAGE = "onTextMessage";
    private static final String RESOURCE_NAME_ON_MAP_MESSAGE = "onMapMessage";
    private static final String RESOURCE_NAME_ON_BYTES_MESSAGE = "onBytesMessage";
    private static final String RESOURCE_NAME_ON_STREAM_MESSAGE = "onStreamMessage";
    private static final String RESOURCE_NAME_ON_OTHER_MESSAGE = "onOtherMessage";
    private static final Set<String> SPECIFIC_FUNCTION_SET = new HashSet<String>(){
        {
            this.add(ServiceCompilerPlugin.RESOURCE_NAME_ON_TEXT_MESSAGE);
            this.add(ServiceCompilerPlugin.RESOURCE_NAME_ON_MAP_MESSAGE);
            this.add(ServiceCompilerPlugin.RESOURCE_NAME_ON_BYTES_MESSAGE);
            this.add(ServiceCompilerPlugin.RESOURCE_NAME_ON_STREAM_MESSAGE);
        }
    };
    private static final String MESSAGE_FULL_NAME = "wso2/jms:0.6.3:Message";
    private static final String TEXT_MESSAGE_FULL_NAME = "wso2/jms:0.6.3:TextMessage";
    private static final String MAP_MESSAGE_FULL_NAME = "wso2/jms:0.6.3:MapMessage";
    private static final String BYTES_MESSAGE_FULL_NAME = "wso2/jms:0.6.3:BytesMessage";
    private static final String STREAM_MESSAGE_FULL_NAME = "wso2/jms:0.6.3:StreamMessage";
    private static final String INVALID_RESOURCE_SIGNATURE_FOR = "Invalid resource signature for ";
    private DiagnosticLog dlog = null;

    public void init(DiagnosticLog diagnosticLog) {
        this.dlog = diagnosticLog;
    }

    public void process(ServiceNode serviceNode, List<AnnotationAttachmentNode> annotations) {
        List resources;
        if (!annotations.isEmpty()) {
            this.dlog.logDiagnostic(Diagnostic.Kind.ERROR, serviceNode.getPosition(), (CharSequence)"The JMS service does not have a service annotation");
        }
        if ((resources = serviceNode.getResources()).isEmpty()) {
            this.dlog.logDiagnostic(Diagnostic.Kind.ERROR, serviceNode.getPosition(), (CharSequence)"service: at least on resource is expected.");
        }
        if (resources.size() == 1) {
            BLangFunction resource = (BLangFunction)resources.get(0);
            if (!RESOURCE_NAME_ON_MESSAGE.equals(resource.name.value)) {
                this.dlog.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)resource.pos, (CharSequence)"resource: Expected resource name is [onMessage] or one or more of message specific resources with [onOtherMessage] resource.");
            }
        } else {
            boolean otherFunctionFound = false;
            for (BLangFunction resource : resources) {
                if (!this.isResourceReturnsErrorOrNil((FunctionNode)resource)) {
                    this.dlog.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)resource.pos, (CharSequence)"Invalid return type: expected error?");
                }
                if (!otherFunctionFound && RESOURCE_NAME_ON_OTHER_MESSAGE.equals(resource.getName().getValue())) {
                    this.validateParameter(resource, MESSAGE_FULL_NAME);
                    otherFunctionFound = true;
                    continue;
                }
                this.validateSpecificFunction(resource);
            }
            if (!otherFunctionFound) {
                this.dlog.logDiagnostic(Diagnostic.Kind.ERROR, serviceNode.getPosition(), (CharSequence)"resource: Expected resource name [onOtherMessage] not specified.");
            }
        }
    }

    private void validateSpecificFunction(BLangFunction resource) {
        String resourceName = resource.getName().getValue();
        if (RESOURCE_NAME_ON_MESSAGE.equals(resourceName)) {
            this.dlog.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)resource.pos, (CharSequence)"resource: [onMessage] cannot be used with message type specific resources and [onOtherMessage] resource.");
        }
        if (RESOURCE_NAME_ON_TEXT_MESSAGE.equals(resourceName)) {
            this.validateParameter(resource, TEXT_MESSAGE_FULL_NAME);
        } else if (RESOURCE_NAME_ON_BYTES_MESSAGE.equals(resourceName)) {
            this.validateParameter(resource, BYTES_MESSAGE_FULL_NAME);
        } else if (RESOURCE_NAME_ON_MAP_MESSAGE.equals(resourceName)) {
            this.validateParameter(resource, MAP_MESSAGE_FULL_NAME);
        } else if (RESOURCE_NAME_ON_STREAM_MESSAGE.equals(resourceName)) {
            this.validateParameter(resource, STREAM_MESSAGE_FULL_NAME);
        } else {
            this.dlog.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)resource.pos, (CharSequence)("resource: Unknown resource name [" + resourceName + "]"));
        }
    }

    private void validateParameter(BLangFunction resource, String messageFullName) {
        List paramDetails = resource.getParameters();
        if (paramDetails == null || paramDetails.size() != 1) {
            this.dlog.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)resource.pos, (CharSequence)(INVALID_RESOURCE_SIGNATURE_FOR + resource.getName().getValue() + " Expected " + messageFullName + " parameter only."));
        } else if (!messageFullName.equals(((BLangSimpleVariable)paramDetails.get((int)0)).type.toString())) {
            this.dlog.logDiagnostic(Diagnostic.Kind.ERROR, (Diagnostic.DiagnosticPosition)resource.pos, (CharSequence)(INVALID_RESOURCE_SIGNATURE_FOR + resource.getName().getValue() + " Parameter should be " + messageFullName + " found: " + ((BLangSimpleVariable)paramDetails.get((int)0)).type.toString()));
        }
    }
}

