/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.extension.siddhi.execution.geo;

import com.google.code.geocoder.Geocoder;
import com.google.code.geocoder.GeocoderRequestBuilder;
import com.google.code.geocoder.model.GeocodeResponse;
import com.google.code.geocoder.model.GeocoderRequest;
import com.google.code.geocoder.model.GeocoderStatus;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.wso2.siddhi.annotation.Example;
import org.wso2.siddhi.annotation.Extension;
import org.wso2.siddhi.annotation.Parameter;
import org.wso2.siddhi.annotation.ReturnAttribute;
import org.wso2.siddhi.annotation.util.DataType;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.exception.SiddhiAppCreationException;
import org.wso2.siddhi.core.exception.SiddhiAppRuntimeException;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.query.processor.stream.function.StreamFunctionProcessor;
import org.wso2.siddhi.core.util.config.ConfigReader;
import org.wso2.siddhi.query.api.definition.AbstractDefinition;
import org.wso2.siddhi.query.api.definition.Attribute;

@Extension(name="geocode", namespace="geo", description="The geo code stream function uses basic details relating to a location (e.g., street name, number,etc.) as the input and returns the longitude, latitude, and the address of that location. ", parameters={@Parameter(name="location", description="The basic location details. For example the Street name, number etc..", type={DataType.STRING})}, returnAttributes={@ReturnAttribute(name="longitude", description="The longitude of the location.", type={DataType.DOUBLE}), @ReturnAttribute(name="latitude", description="The latitude of the location.", type={DataType.DOUBLE}), @ReturnAttribute(name="address", description="The location details including the longitude and the latitude of the location.", type={DataType.STRING})}, examples={@Example(syntax="geocode(\"5 Avenue Anatole France, 75007 Paris, France\")", description="This query returns the longitude and latitude of the given location with the location details. The expected results are 48.8588871d, 2.2944861d, \"5 Avenue Anatole France, 75007 Paris, France\".")})
public class GeocodeStreamFunctionProcessor
extends StreamFunctionProcessor {
    private static final Logger LOGGER = Logger.getLogger(GeocodeStreamFunctionProcessor.class);
    private final Geocoder geocoder = new Geocoder();
    private boolean debugModeOn;

    protected Object[] process(Object[] data) {
        return this.process(data[0]);
    }

    protected Object[] process(Object data) {
        String formattedAddress;
        double longitude;
        double latitude;
        String location = data.toString();
        GeocoderRequest geocoderRequest = new GeocoderRequestBuilder().setAddress(location).setLanguage("en").getGeocoderRequest();
        try {
            GeocodeResponse geocoderResponse = this.geocoder.geocode(geocoderRequest);
            GeocoderStatus status = geocoderResponse.getStatus();
            if (status == GeocoderStatus.OK && !geocoderResponse.getResults().isEmpty()) {
                latitude = geocoderResponse.getResults().get(0).getGeometry().getLocation().getLat().doubleValue();
                longitude = geocoderResponse.getResults().get(0).getGeometry().getLocation().getLng().doubleValue();
                formattedAddress = geocoderResponse.getResults().get(0).getFormattedAddress();
            } else {
                latitude = -1.0;
                longitude = -1.0;
                formattedAddress = "N/A";
                LOGGER.error((Object)("Geocoder request failed with a response of: " + status.value()));
            }
        }
        catch (IOException e) {
            throw new SiddhiAppRuntimeException("Error in connection to Google Maps API.", (Throwable)e);
        }
        if (this.debugModeOn) {
            LOGGER.debug((Object)("Formatted address: " + formattedAddress + ", Location coordinates: (" + latitude + ", " + longitude + ")"));
        }
        return new Object[]{formattedAddress, latitude, longitude};
    }

    protected List<Attribute> init(AbstractDefinition inputDefinition, ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiAppContext executionPlanContext) {
        this.debugModeOn = LOGGER.isDebugEnabled();
        if (attributeExpressionExecutors[0].getReturnType() != Attribute.Type.STRING) {
            throw new SiddhiAppCreationException("First parameter should be of type string");
        }
        ArrayList<Attribute> attributes = new ArrayList<Attribute>(6);
        attributes.add(new Attribute("formattedAddress", Attribute.Type.STRING));
        attributes.add(new Attribute("latitude", Attribute.Type.DOUBLE));
        attributes.add(new Attribute("longitude", Attribute.Type.DOUBLE));
        return attributes;
    }

    public void start() {
    }

    public void stop() {
    }

    public Map<String, Object> currentState() {
        return new HashMap<String, Object>();
    }

    public void restoreState(Map<String, Object> state) {
    }
}

