/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.extension.siddhi.execution.geo;

import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.extension.siddhi.execution.geo.api.GeoLocationResolver;
import org.wso2.extension.siddhi.execution.geo.api.Location;
import org.wso2.extension.siddhi.execution.geo.internal.LRUCacheStore;
import org.wso2.extension.siddhi.execution.geo.internal.exception.GeoLocationResolverException;
import org.wso2.siddhi.annotation.Example;
import org.wso2.siddhi.annotation.Extension;
import org.wso2.siddhi.annotation.Parameter;
import org.wso2.siddhi.annotation.ReturnAttribute;
import org.wso2.siddhi.annotation.util.DataType;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.function.FunctionExecutor;
import org.wso2.siddhi.core.util.config.ConfigReader;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.exception.SiddhiAppValidationException;

@Extension(name="findCountryFromIP", namespace="geo", description="This function returns the country that is related to the given IP address.", parameters={@Parameter(name="ip", description="The IP address of which the related country needs to be fetched.", type={DataType.STRING})}, returnAttributes={@ReturnAttribute(description="The country related to the IP address provided.", type={DataType.STRING})}, examples={@Example(syntax="define stream IpStream(ip string);\nfrom IpStream\nselect geo:getCountry(ip) as country \ninsert into OutputStream;", description="This query returns the country corresponding to the given IP address.")})
public class GetCountryResolverFunction
extends FunctionExecutor {
    private static final Log log = LogFactory.getLog(GetCountryResolverFunction.class);
    private static final String CACHE_SIZE_KEY = "cacheSize";
    private static final String IS_CACHE_ENABLED = "isCacheEnabled";
    private static final int DEFAULT_CACHE_SIZE = 10000;
    private static final String DEFAULT_GEOLOCATION_RESOLVER_CLASSNAME = "org.wso2.extension.siddhi.execution.geo.internal.impl.DefaultDBBasedGeoLocationResolver";
    private static GeoLocationResolver geoLocationResolverImpl;
    private static LRUCacheStore lruCacheStore;
    private static boolean isCacheEnabled;
    private static int cacheSize;
    private static AtomicBoolean isExtensionConfigInitialized;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init(ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiAppContext siddhiAppContext) {
        if (attributeExpressionExecutors.length != 1) {
            throw new SiddhiAppValidationException("Invalid no of arguments passed to geo:getCountry() function, required 1, but found " + attributeExpressionExecutors.length);
        }
        Attribute.Type attributeType = attributeExpressionExecutors[0].getReturnType();
        if (attributeType != Attribute.Type.STRING) {
            throw new SiddhiAppValidationException("Invalid parameter type found for first argument 'ip' of geo:getCountry() function, required " + Attribute.Type.STRING + ", but found " + attributeType.toString());
        }
        AtomicBoolean atomicBoolean = isExtensionConfigInitialized;
        synchronized (atomicBoolean) {
            if (!isExtensionConfigInitialized.get()) {
                this.initializeExtensionConfigs(configReader);
            }
        }
    }

    protected Object execute(Object[] data) {
        return null;
    }

    protected Object execute(Object data) {
        Location location = null;
        String ip = data.toString();
        if (isCacheEnabled) {
            location = lruCacheStore.getInstance().get(ip);
        }
        if (location == null) {
            location = geoLocationResolverImpl.getGeoLocationInfo(ip);
            if (location != null) {
                lruCacheStore.getInstance().put(ip, location);
            } else {
                lruCacheStore.getInstance().put(ip, new Location("", "", ip));
            }
        }
        return location != null ? location.getCountry() : "";
    }

    public Attribute.Type getReturnType() {
        return Attribute.Type.STRING;
    }

    public Map<String, Object> currentState() {
        return null;
    }

    public void restoreState(Map<String, Object> state) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeExtensionConfigs(ConfigReader configReader) throws SiddhiAppValidationException {
        String geoResolverImplClassName = configReader.readConfig("geoLocationResolverClass", DEFAULT_GEOLOCATION_RESOLVER_CLASSNAME);
        isCacheEnabled = Boolean.parseBoolean(configReader.readConfig(IS_CACHE_ENABLED, "true"));
        String configCacheValue = configReader.readConfig(CACHE_SIZE_KEY, String.valueOf(cacheSize));
        if (isCacheEnabled) {
            try {
                cacheSize = Integer.parseInt(configCacheValue);
            }
            catch (NumberFormatException e) {
                cacheSize = 10000;
                log.warn((Object)("The config '" + configCacheValue + "' provided in 'cacheSize' is not a valid integer. Hence using the default cache size '" + 10000 + "'"));
            }
            finally {
                LRUCacheStore.init(cacheSize);
            }
        }
        try {
            geoLocationResolverImpl = (GeoLocationResolver)Class.forName(geoResolverImplClassName).newInstance();
            geoLocationResolverImpl.init(configReader);
            isExtensionConfigInitialized.set(true);
        }
        catch (InstantiationException e) {
            throw new SiddhiAppValidationException("Cannot instantiate GeoLocationResolver implementation class '" + geoResolverImplClassName + "' given in the configuration", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new SiddhiAppValidationException("Cannot access GeoLocationResolver implementation class '" + geoResolverImplClassName + "' given in the configuration", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new SiddhiAppValidationException("Cannot find GeoLocationResolver implementation class '" + geoResolverImplClassName + "' given in the configuration", (Throwable)e);
        }
        catch (ClassCastException e) {
            throw new SiddhiAppValidationException("Cannot cast GeoLocationResolver implementation class '" + geoResolverImplClassName + "' to 'GeoLocationResolver'", (Throwable)e);
        }
        catch (GeoLocationResolverException e) {
            throw new SiddhiAppValidationException("Cannot initialize GeoLocationResolver implementation class '" + geoResolverImplClassName + "' given in the configuration", (Throwable)e);
        }
    }

    static {
        isCacheEnabled = true;
        cacheSize = 10000;
        isExtensionConfigInitialized = new AtomicBoolean(false);
    }
}

