/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.extension.siddhi.execution.geo;

import com.google.code.geocoder.Geocoder;
import com.google.code.geocoder.GeocoderRequestBuilder;
import com.google.code.geocoder.model.GeocodeResponse;
import com.google.code.geocoder.model.GeocoderAddressComponent;
import com.google.code.geocoder.model.GeocoderRequest;
import com.google.code.geocoder.model.GeocoderStatus;
import com.google.code.geocoder.model.LatLng;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.wso2.siddhi.annotation.Example;
import org.wso2.siddhi.annotation.Extension;
import org.wso2.siddhi.annotation.Parameter;
import org.wso2.siddhi.annotation.util.DataType;
import org.wso2.siddhi.core.config.SiddhiAppContext;
import org.wso2.siddhi.core.exception.SiddhiAppCreationException;
import org.wso2.siddhi.core.exception.SiddhiAppRuntimeException;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.query.processor.stream.function.StreamFunctionProcessor;
import org.wso2.siddhi.core.util.config.ConfigReader;
import org.wso2.siddhi.query.api.definition.AbstractDefinition;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.exception.SiddhiAppValidationException;

@Extension(name="reversegeocode", namespace="geo", description="This extension transforms pairs of latitude and longitude coordinates into precise address information. The output contains string properties including the 'streetNumber', 'neighborhood', 'route', 'administrativeAreaLevelTwo', 'administrativeAreaLevelOne', 'country', 'countryCode', 'postalCode', and the 'formattedAddress' in the given order. However, this information is not available for all the geo coordinates. For example, if the latitude and longitude represent a place in a forest, only the high level information such as the country is returned. In such scenarios, \"N/A\" is returned as the value for return attributes of which the values cannot be derived.", parameters={@Parameter(name="longitude", description="The longitude value required in order to derive at the location.", type={DataType.DOUBLE}), @Parameter(name="latitude", description="The latitude value required in order to derive at the location.", type={DataType.DOUBLE})}, examples={@Example(syntax="reversegeocode(6.909785, 79.852603)", description="This query returns the precise address information of the given location. In this example, it returns the following value:\n \"27\", \"N/A\", \"Palm Grove\", \"Colombo\", \"Western Province\", \"Sri Lanka\", \"LK\", \"00300\", \"27 Palm Grove, Colombo 00300, Sri Lanka\".")})
public class ReverseGeocodeStreamFunctionProcessor
extends StreamFunctionProcessor {
    private static final Logger LOGGER = Logger.getLogger(ReverseGeocodeStreamFunctionProcessor.class);
    private final Geocoder geocoder = new Geocoder();
    private boolean debugModeOn;

    protected Object[] process(Object[] data) {
        if (data[0] == null) {
            throw new SiddhiAppRuntimeException("Invalid input given to geo:reversegeocode() function. The first argument cannot be null");
        }
        if (data[1] == null) {
            throw new SiddhiAppRuntimeException("Invalid input given to geo:reversegeocode() function. The second argument cannot be null");
        }
        BigDecimal latitude = new BigDecimal((Double)data[0]);
        BigDecimal longitude = new BigDecimal((Double)data[1]);
        LatLng coordinate = new LatLng(latitude, longitude);
        GeocoderRequest geocoderRequest = new GeocoderRequestBuilder().setLocation(coordinate).setLanguage("en").getGeocoderRequest();
        String streetNumber = "N/A";
        String neighborhood = "N/A";
        String route = "N/A";
        String administrativeAreaLevelTwo = "N/A";
        String administrativeAreaLevelOne = "N/A";
        String country = "N/A";
        String countryCode = "N/A";
        String postalCode = "N/A";
        String formattedAddress = "N/A";
        try {
            GeocodeResponse geocoderResponse = this.geocoder.geocode(geocoderRequest);
            GeocoderStatus status = geocoderResponse.getStatus();
            if (status == GeocoderStatus.OK && !geocoderResponse.getResults().isEmpty()) {
                formattedAddress = geocoderResponse.getResults().get(0).getFormattedAddress();
                List<GeocoderAddressComponent> addressComponents = geocoderResponse.getResults().get(0).getAddressComponents();
                for (GeocoderAddressComponent component : addressComponents) {
                    List<String> types = component.getTypes();
                    if (types.contains("street_number")) {
                        streetNumber = component.getLongName();
                        continue;
                    }
                    if (types.contains("neighborhood")) {
                        neighborhood = component.getLongName();
                        continue;
                    }
                    if (types.contains("route")) {
                        route = component.getLongName();
                        continue;
                    }
                    if (types.contains("administrative_area_level_2")) {
                        administrativeAreaLevelTwo = component.getLongName();
                        continue;
                    }
                    if (types.contains("administrative_area_level_1")) {
                        administrativeAreaLevelOne = component.getLongName();
                        continue;
                    }
                    if (types.contains("country")) {
                        country = component.getLongName();
                        countryCode = component.getShortName();
                        continue;
                    }
                    if (!types.contains("postal_code")) continue;
                    postalCode = component.getLongName();
                }
            } else {
                LOGGER.error((Object)("Geocoder request failed with a response of: " + status.value()));
            }
        }
        catch (IOException e) {
            throw new SiddhiAppRuntimeException("Error in connection to Google Maps API.", (Throwable)e);
        }
        if (this.debugModeOn) {
            String message = String.format("Street Number: %s, Neighborhood: %s, Route: %s, Administrative Area Level 2: %s, Administrative Area Level 1: %s, Country: %s, ISO Country code: %s, Postal code: %s, Formatted address: %s", streetNumber, neighborhood, route, administrativeAreaLevelTwo, administrativeAreaLevelOne, country, countryCode, postalCode, formattedAddress);
            LOGGER.debug((Object)message);
        }
        return new Object[]{streetNumber, neighborhood, route, administrativeAreaLevelTwo, administrativeAreaLevelOne, country, countryCode, postalCode, formattedAddress};
    }

    protected Object[] process(Object data) {
        throw new RuntimeException("");
    }

    protected List<Attribute> init(AbstractDefinition inputDefinition, ExpressionExecutor[] attributeExpressionExecutors, ConfigReader configReader, SiddhiAppContext executionPlanContext) {
        this.debugModeOn = LOGGER.isDebugEnabled();
        if (attributeExpressionExecutors.length != 2) {
            throw new SiddhiAppValidationException("Invalid no of arguments passed to geo:reversegeocode() function, required 1, but found " + attributeExpressionExecutors.length);
        }
        if (attributeExpressionExecutors[0].getReturnType() != Attribute.Type.DOUBLE || attributeExpressionExecutors[1].getReturnType() != Attribute.Type.DOUBLE) {
            throw new SiddhiAppCreationException("Both input parameters should be of type double");
        }
        ArrayList<Attribute> attributes = new ArrayList<Attribute>(9);
        attributes.add(new Attribute("streetNumber", Attribute.Type.STRING));
        attributes.add(new Attribute("neighborhood", Attribute.Type.STRING));
        attributes.add(new Attribute("route", Attribute.Type.STRING));
        attributes.add(new Attribute("administrativeAreaLevelTwo", Attribute.Type.STRING));
        attributes.add(new Attribute("administrativeAreaLevelOne", Attribute.Type.STRING));
        attributes.add(new Attribute("country", Attribute.Type.STRING));
        attributes.add(new Attribute("countryCode", Attribute.Type.STRING));
        attributes.add(new Attribute("postalCode", Attribute.Type.STRING));
        attributes.add(new Attribute("formattedAddress", Attribute.Type.STRING));
        return attributes;
    }

    public void start() {
    }

    public void stop() {
    }

    public Map<String, Object> currentState() {
        return new HashMap<String, Object>();
    }

    public void restoreState(Map<String, Object> state) {
    }
}

