/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.extension.siddhi.execution.geo.internal.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.apache.log4j.Logger;
import org.wso2.carbon.utils.StringUtils;
import org.wso2.extension.siddhi.execution.geo.api.GeoCoordinate;
import org.wso2.extension.siddhi.execution.geo.api.GeoCoordinateResolver;
import org.wso2.extension.siddhi.execution.geo.internal.exception.GeoLocationResolverException;
import org.wso2.extension.siddhi.execution.geo.internal.utils.Utilities;
import org.wso2.siddhi.core.exception.SiddhiAppRuntimeException;
import org.wso2.siddhi.core.util.config.ConfigReader;

public class APIBasedGeoCoordinateResolver
implements GeoCoordinateResolver {
    private static final Logger LOGGER = Logger.getLogger(APIBasedGeoCoordinateResolver.class);
    private String apikey;
    private URL url;
    private String[] locationDetails;

    @Override
    public void init(ConfigReader configReader) throws GeoLocationResolverException {
        this.apikey = configReader.readConfig("apiurl", "");
        if (StringUtils.isNullOrEmpty((String)this.apikey)) {
            throw new GeoLocationResolverException("Error in reading the configuration of apiurl");
        }
    }

    @Override
    public GeoCoordinate getGeoCoordinateInfo(String ip) {
        double longitude;
        double latitude;
        ip = ip.trim();
        try {
            if (Utilities.isIpAddress(ip)) {
                this.url = new URL(this.apikey + ip);
            } else {
                LOGGER.error((Object)("The ip address : " + ip + " is invalid"));
            }
        }
        catch (MalformedURLException e) {
            throw new SiddhiAppRuntimeException("Error in connecting to the API with the given key value of the API");
        }
        try (InputStreamReader inputStreamReader = new InputStreamReader(this.url.openStream(), StandardCharsets.UTF_8);
             BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
            String ipInformation;
            while ((ipInformation = bufferedReader.readLine()) != null) {
                this.locationDetails = ipInformation.split(";");
            }
            latitude = Double.parseDouble(this.locationDetails[8]);
            longitude = Double.parseDouble(this.locationDetails[9]);
        }
        catch (IOException e) {
            throw new SiddhiAppRuntimeException("Cannot retrieve longitute and latitude due to error in connecting to the API", (Throwable)e);
        }
        return new GeoCoordinate(latitude, longitude);
    }
}

