/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.extension.siddhi.execution.geo.internal.impl;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.extension.siddhi.execution.geo.api.Location;
import org.wso2.extension.siddhi.execution.geo.internal.LRUCache;
import org.wso2.extension.siddhi.execution.geo.internal.exception.GeoLocationResolverException;
import org.wso2.extension.siddhi.execution.geo.internal.utils.DatabaseUtils;
import org.wso2.siddhi.core.util.config.ConfigReader;

public class RDBMSGeoLocationResolver {
    private static final Log log = LogFactory.getLog(RDBMSGeoLocationResolver.class);
    private static final RDBMSGeoLocationResolver instance = new RDBMSGeoLocationResolver();
    private static final String CONFIG_KEY_CACHE_SIZE = "cacheSize";
    private static final String CONFIG_KEY_ISPERSIST_IN_DATABASE = "isPersistInDatabase";
    private static final String CONFIG_KEY_DATASOURCE = "datasource";
    private static final String DEFAULT_DATASOURCE_NAME = "GEO_LOCATION_DATA";
    private static final String CITY_NAME = "city_name";
    private static final String COUNTRY_NAME = "country_name";
    private static final String SUBDIVISION_1_NAME = "subdivision_1_name";
    private static final int DEFAULT_CACHE_SIZE = 10000;
    private AtomicBoolean isInitialized = new AtomicBoolean(false);
    private DatabaseUtils dbUtils;
    private boolean isPersistInDatabase;
    private LRUCache<String, Long> ipToLongCache;
    private static final String SQL_SELECT_LOCATION_FROM_IP = "SELECT country_name, city_name FROM IP_LOCATION WHERE ip = ?";
    private static final String SQL_INSERT_LOCATION_INTO_TABLE = "INSERT INTO IP_LOCATION (ip,country_name,city_name) VALUES (?,?,?)";
    private static final String SQL_SELECT_LOCATION_FROM_LONG_VALUE_OF_IP = "SELECT loc.country_name,loc.subdivision_1_name FROM BLOCKS block , LOCATION loc WHERE block.network_blocks = ? AND ? BETWEEN block.network AND block.broadcast AND block.geoname_id=loc.geoname_id";
    private static final String SQL_SELECT_LOCATION_FROM_CIDR_OF_IP = "SELECT loc.country_name,loc.subdivision_1_name FROM BLOCKS block , LOCATION loc WHERE block.network_cidr = ? AND block.geoname_id=loc.geoname_id";

    public static RDBMSGeoLocationResolver getInstance() {
        return instance;
    }

    public void init(ConfigReader configReader) throws GeoLocationResolverException {
        int cacheSize;
        if (this.isInitialized.get()) {
            return;
        }
        String configCacheValue = configReader.readConfig(CONFIG_KEY_CACHE_SIZE, String.valueOf(10000));
        try {
            cacheSize = Integer.parseInt(configCacheValue);
        }
        catch (NumberFormatException e) {
            cacheSize = 10000;
            log.warn((Object)("The config '" + configCacheValue + "' provided in 'cacheSize' is not a valid integer. Hence using the default cache size '" + 10000 + "'"));
        }
        this.isPersistInDatabase = Boolean.parseBoolean(configReader.readConfig(CONFIG_KEY_ISPERSIST_IN_DATABASE, "true"));
        this.ipToLongCache = new LRUCache(cacheSize);
        this.dbUtils = DatabaseUtils.getInstance();
        this.dbUtils.initialize(configReader.readConfig(CONFIG_KEY_DATASOURCE, DEFAULT_DATASOURCE_NAME));
        this.isInitialized.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Location getLocation(String ipAddress) throws GeoLocationResolverException {
        Location location;
        block18: {
            location = null;
            Connection connection = null;
            try {
                connection = this.dbUtils.getConnection();
                if (this.isPersistInDatabase) {
                    location = this.loadLocation(ipAddress, connection);
                }
                if (location != null) break block18;
                if (!this.isCIDR(ipAddress)) {
                    InetAddress address = InetAddress.getByName(ipAddress);
                    if (address instanceof Inet6Address) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Found IPv6 address which can not be resolved to location. IP Address = " + ipAddress));
                        }
                        location = this.getLocationFromIPv6((Inet6Address)address, connection);
                    } else if (address instanceof Inet4Address) {
                        location = this.getLocationFromLongValueOfIp(address.getHostAddress(), connection);
                    }
                } else {
                    location = this.getLocationFromCIDR(ipAddress, connection);
                }
                if (location == null || !this.isPersistInDatabase) break block18;
                boolean autoCommitMode = connection.getAutoCommit();
                try {
                    connection.setAutoCommit(false);
                    Location updatedLocation = this.loadLocation(location.getIp(), connection);
                    if (updatedLocation != null) {
                        this.saveLocation(location, connection);
                    }
                }
                finally {
                    connection.setAutoCommit(autoCommitMode);
                }
            }
            catch (UnknownHostException e) {
                log.error((Object)("Cannot parse the IP address : " + ipAddress), (Throwable)e);
            }
            catch (SQLException e) {
                log.error((Object)"Cannot retrieve the location from database", (Throwable)e);
            }
            finally {
                this.dbUtils.closeAllConnections(null, connection, null);
            }
        }
        return location;
    }

    private Location getLocationFromLongValueOfIp(String ipAddress, Connection connection) throws GeoLocationResolverException {
        Location location = null;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.prepareStatement(SQL_SELECT_LOCATION_FROM_LONG_VALUE_OF_IP);
            if (ipAddress != null && ipAddress.split("\\.").length >= 4) {
                statement.setString(1, ipAddress.substring(0, ipAddress.substring(0, ipAddress.lastIndexOf(".")).lastIndexOf(".")));
                statement.setLong(2, this.getIpV4ToLong(ipAddress));
                resultSet = statement.executeQuery();
                if (resultSet.next()) {
                    location = new Location(resultSet.getString(COUNTRY_NAME), resultSet.getString(SUBDIVISION_1_NAME), ipAddress);
                }
            }
        }
        catch (SQLException e) {
            throw new GeoLocationResolverException("Cannot get the location from database", e);
        }
        finally {
            this.dbUtils.closeAllConnections(statement, null, resultSet);
        }
        return location;
    }

    private Location getLocationFromCIDR(String ipAddress, Connection connection) throws GeoLocationResolverException {
        Location location = null;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.prepareStatement(SQL_SELECT_LOCATION_FROM_CIDR_OF_IP);
            statement.setString(1, ipAddress);
            resultSet = statement.executeQuery();
            if (resultSet.next()) {
                location = new Location(resultSet.getString(COUNTRY_NAME), resultSet.getString(SUBDIVISION_1_NAME), ipAddress);
            }
            this.dbUtils.closeAllConnections(statement, null, resultSet);
        }
        catch (SQLException e) {
            try {
                throw new GeoLocationResolverException("Cannot get the location from database", e);
            }
            catch (Throwable throwable) {
                this.dbUtils.closeAllConnections(statement, null, resultSet);
                throw throwable;
            }
        }
        return location;
    }

    private Location getLocationFromIPv6(Inet6Address address, Connection connection) throws SQLException, GeoLocationResolverException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Location loadLocation(String ipAddress, Connection connection) throws SQLException {
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        Location location = null;
        try {
            if (this.isPersistInDatabase) {
                statement = connection.prepareStatement(SQL_SELECT_LOCATION_FROM_IP);
                statement.setString(1, ipAddress);
                resultSet = statement.executeQuery();
            }
            if (resultSet != null && resultSet.next()) {
                location = new Location(resultSet.getString(COUNTRY_NAME), resultSet.getString(CITY_NAME), ipAddress);
            }
        }
        finally {
            this.dbUtils.closeAllConnections(statement, null, resultSet);
        }
        return location;
    }

    private void saveLocation(Location location, Connection connection) throws GeoLocationResolverException {
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(SQL_INSERT_LOCATION_INTO_TABLE);
            statement.setString(1, location.getIp());
            statement.setString(2, location.getCountry());
            statement.setString(3, location.getCity());
            statement.execute();
            connection.commit();
        }
        catch (SQLException e) {
            throw new GeoLocationResolverException("Cannot save the location to database", e);
        }
        finally {
            DatabaseUtils.getInstance().closeAllConnections(statement, null, null);
        }
    }

    private long getIpV4ToLong(String ipAddress) {
        Long ipToLong = this.ipToLongCache.get(ipAddress);
        if (ipToLong == null) {
            String[] ipAddressInArray = ipAddress.split("\\.");
            long longValueOfIp = 0L;
            int i = 0;
            for (String ipChunk : ipAddressInArray) {
                int power = 3 - i;
                int ip = Integer.parseInt(ipChunk);
                longValueOfIp = (long)((double)longValueOfIp + (double)ip * Math.pow(256.0, power));
                ++i;
            }
            this.ipToLongCache.put(ipAddress, longValueOfIp);
            ipToLong = longValueOfIp;
        }
        return ipToLong;
    }

    private boolean isCIDR(String ipAddress) {
        return ipAddress.split("\\.").length == 4 && ipAddress.indexOf("/") >= 1;
    }
}

